/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.BIH;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.user.ClientGeocodeResponse;
import com.mapinfo.mapmarker.user.GeocodeConstraints;
import com.mapinfo.mapmarker.user.MMJEngine;
import com.mapinfo.mapmarker.user.MapMarkerException;
import com.mapinfo.mapmarker.user.MapMarkerFatalException;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MMClient2 {
    static final Logger logger = LoggerFactory.getLogger(MMClient2.class);
    public static String areaStreet = "";

    public static void main(String[] args) throws CGGEInternalException, DataFetchException, IOException, DataNotInitialisedException, MapMarkerException, MapMarkerFatalException {
        MMJEngine mm_api = new MMJEngine();
        GeocodeConstraints constraints = new GeocodeConstraints();
        ArrayList addressList = new ArrayList();
        int nonGeocodedAddresses = 0;
        int geocodedAddresses = 0;
        String[] addresses = new String[]{"Jezero Banovi\u0107i Tuzlanski 75290"};
        long initTime = System.currentTimeMillis();
        boolean matchedPOI = false;
        boolean unmatchedPOI = false;
        int totalPOICand = 0;
        for (int i = 0; i < addresses.length; ++i) {
            Address inputAddress = MMClient2.setupAddress(null, addresses[i], null, null, null, null, null, "BIH");
            inputAddress.setCountry("BIH");
            inputAddress.setMainAddress("Jezero");
            inputAddress.setAreaName3("Banovi\u0107i");
            inputAddress.setPostCode1("75290");
            long initTime1 = System.currentTimeMillis();
            ClientGeocodeResponse m_result = mm_api.geocode(0, inputAddress, (IGeocodeConstraints)constraints);
            if (0 < m_result.candidateCount()) {
                String address;
                CandidateAddress cand = m_result.candidateAt(0);
                if (cand.isCloseMatch()) {
                    logger.debug(cand.toString());
                    logger.debug(m_result.candidateAt(1).toString());
                    address = inputAddress.getMainAddress() + ";" + cand.getFormattedStreetAddress() + ";" + cand.getFormattedLocationAddress() + ";" + cand.getPrecisionCode() + ";TRUE";
                    logger.debug(address);
                    ++geocodedAddresses;
                    continue;
                }
                address = inputAddress.getMainAddress() + ";" + cand.getFormattedStreetAddress() + ";" + cand.getFormattedLocationAddress() + ";" + cand.getPrecisionCode() + ";FALSE";
                logger.debug(address);
                continue;
            }
            String address = inputAddress.getMainAddress();
            logger.debug(address);
            ++nonGeocodedAddresses;
        }
        logger.debug("Total POI Candidates: " + totalPOICand);
        logger.debug("Time Taken: " + (System.currentTimeMillis() - initTime));
        logger.debug("Geocoded Address: " + geocodedAddresses);
        logger.debug("Non Geocoded Address: " + nonGeocodedAddresses);
    }

    public static Address setupAddress(String housenumber, String mainAddress, String an4, String an3, String an2, String an1, String pc1, String Country) {
        AddressImpl inpAddr = new AddressImpl();
        inpAddr.setCountry(Country);
        if (housenumber != null) {
            inpAddr.setAddressNumber(housenumber);
        }
        if (mainAddress != null) {
            inpAddr.setMainAddress(mainAddress);
        }
        if (an4 != null) {
            inpAddr.setAreaName4(an4);
        }
        if (an3 != null) {
            inpAddr.setAreaName3(an3);
        }
        if (an2 != null) {
            inpAddr.setAreaName2(an2);
        }
        if (an1 != null) {
            inpAddr.setAreaName1(an1);
        }
        if (pc1 != null) {
            inpAddr.setPostCode1(pc1);
        }
        return inpAddr;
    }
}

