/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHN;

import com.mapinfo.mapmarker.CHN.parser.CHN_ZH_Parser;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.WordAlternate;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CHN_Utils {
    public static final int SEPARATE_ZH_AN1 = 0;
    public static final int SEPARATE_ZH_AN4_FROMTREET = 1;
    public static final char SPECIAL_SPACE = '\u3000';
    private static final List<String> AREA_DESCRIPTORS = new ArrayList<String>();
    private static final Map<FieldType, String[]> AREA_DESCRIPTORS_MAP = new HashMap<FieldType, String[]>(4);

    public static int indexOfLastThoroughfareTypeWord(AddressWord[] words) {
        for (int i = words.length - 1; i >= 0; --i) {
            if (!CodedWord.isThoroughfareTypeWord(words[i].getAttributes())) continue;
            return i;
        }
        return -1;
    }

    public static int indexOfAreaDescriptorWord(AddressWord[] words, FieldType type) {
        for (int i = words.length - 1; i >= 0; --i) {
            if (!CHN_Utils.isAreaDescriptorWord(words[i], type)) continue;
            return i;
        }
        return -1;
    }

    public static boolean isAreaDescriptorWord(AddressWord word) {
        if (CHN_Utils.isAreaDescriptorWord(word.getWord())) {
            return true;
        }
        if (word.hasAlternates()) {
            for (WordAlternate alt : word.getAlternates()) {
                if (alt.getAltType() != WordAlternate.ALT_TYPE.SINGLE_WORD_ABBREVIATION || !CHN_Utils.isAreaDescriptorWord(alt.getAltWord().getWord())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAreaDescriptorWord(AddressWord word, FieldType type) {
        if (CHN_Utils.isAreaDescriptorWord(word.getWord(), type)) {
            return true;
        }
        if (word.hasAlternates()) {
            for (WordAlternate alt : word.getAlternates()) {
                if (alt.getAltType() != WordAlternate.ALT_TYPE.SINGLE_WORD_ABBREVIATION || !CHN_Utils.isAreaDescriptorWord(alt.getAltWord().getWord(), type)) continue;
                return true;
            }
        }
        return false;
    }

    public static int determinePossibleWrdToSplitByAN(AddressWord[] wordsToSearch, int howToSplit) {
        if (wordsToSearch == null || wordsToSearch.length == 0) {
            return -1;
        }
        int cnt = wordsToSearch.length;
        int idx = -1;
        boolean done = false;
        block0: for (int i = 0; i < cnt && !done; ++i) {
            String theWord = wordsToSearch[i].getWord();
            if (howToSplit == 0 && theWord.length() > 3 && CHN_ZH_Parser.AREA_IDENTIFIERS.contains(Character.valueOf(theWord.charAt(theWord.length() - 1)))) {
                idx = i;
                done = true;
                continue;
            }
            if (howToSplit != 1) continue;
            Iterator<Character> itr = CHN_ZH_Parser.AREA_IDENTIFIERS.iterator();
            for (char ch : CHN_ZH_Parser.AREA_IDENTIFIERS) {
                int pos1 = theWord.indexOf(ch);
                if (pos1 <= 0) continue;
                idx = i;
                done = true;
                continue block0;
            }
        }
        return idx;
    }

    public static String zhTrim(String str) {
        int idx;
        if (StringUtilities.isEmpty((String)str)) {
            return str;
        }
        int len = str.length();
        int idx2 = len - 1;
        for (idx = 0; idx < len && str.charAt(idx) == '\u3000'; ++idx) {
        }
        while (idx2 > 0 && str.charAt(idx2) == '\u3000') {
            --idx2;
        }
        String retString = str;
        try {
            retString = str.substring(idx, idx2 + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retString;
    }

    public static IntArray addToArray(IntArray array, int n) {
        if (array == null) {
            array = new IntArray(1);
        }
        array.add(n);
        return array;
    }

    private static boolean isAreaDescriptorWord(String str, FieldType type) {
        Object[] ads = AREA_DESCRIPTORS_MAP.get(type);
        return ads != null && Arrays.binarySearch(ads, str) > -1;
    }

    private static boolean isAreaDescriptorWord(String str) {
        return Collections.binarySearch(AREA_DESCRIPTORS, str) > -1;
    }

    static {
        AREA_DESCRIPTORS_MAP.put(FieldType.AREA_NAME_1_FIELD_TYPE, new String[0]);
        AREA_DESCRIPTORS_MAP.put(FieldType.AREA_NAME_2_FIELD_TYPE, new String[0]);
        AREA_DESCRIPTORS_MAP.put(FieldType.AREA_NAME_3_FIELD_TYPE, new String[]{"CITY", "SHI", "COUNTY", "XIAN"});
        AREA_DESCRIPTORS_MAP.put(FieldType.AREA_NAME_4_FIELD_TYPE, new String[]{"DISTRICT", "QU"});
        for (Object[] objectArray : AREA_DESCRIPTORS_MAP.values()) {
            Arrays.sort(objectArray);
            AREA_DESCRIPTORS.addAll(Arrays.asList(objectArray));
        }
        Collections.sort(AREA_DESCRIPTORS);
    }
}

