/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHN.matcher;

import com.mapinfo.mapmarker.CHN.CHN_Utils;
import com.mapinfo.mapmarker.CHN.parser.CHN_ZH_Parser;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.IntArray;

public class CHN_ZH_Matcher
extends CGGEMatcher1 {
    @Override
    protected FieldScore scoreAddressWords(AddressWord[] parserWords, InternalFieldValue fieldValue, FieldType type, FieldScore score, ICGGEScorer scorer) {
        score = super.scoreAddressWords(parserWords, fieldValue, type, score, scorer);
        this.adjustAreaFieldScoreZH(score, type);
        return score;
    }

    protected void adjustAreaFieldScoreZH(FieldScore score, FieldType type) {
        double scorevalue;
        if (score != null && (type == FieldType.AREA_NAME_4_FIELD_TYPE || type == FieldType.AREA_NAME_3_FIELD_TYPE) && (scorevalue = score.m_value) > 0.7 && scorevalue < 1.0) {
            this.checkDescriptorMatchZH(score, type);
        }
    }

    private void checkDescriptorMatchZH(FieldScore score, FieldType type) {
        AddressWord[] candWords = score.getCandidateWords();
        AddressWord[] inputWords = score.getInputWords();
        int lastWordNdx = -1;
        int lastInpWordNdx = -1;
        IntArray matchedCandWordNdx = score.m_matchedCandWords;
        IntArray matchedInputWordNdx = score.m_matchedInputWords;
        if (matchedCandWordNdx.size() <= 0 || matchedInputWordNdx.size() <= 0) {
            return;
        }
        lastWordNdx = matchedCandWordNdx.getLast();
        lastInpWordNdx = matchedInputWordNdx.getLast();
        if (lastWordNdx >= 0 && !score.m_matched) {
            AddressWord lastAddressWord = candWords[lastWordNdx];
            String lastAddressWordInputStr = inputWords[lastInpWordNdx].getWord();
            String lastCandWordStr = lastAddressWord.getWord();
            if (this.shouldAdjust_ZH_AreaScoreOther(lastCandWordStr, lastAddressWordInputStr) || Math.abs(lastAddressWordInputStr.length() - lastCandWordStr.length()) == 1 && this.shouldAdjust_ZH_AreaScoreForDescriptor(lastCandWordStr, lastAddressWordInputStr)) {
                score.m_value = Math.max(1.0, score.m_value + (double)lastAddressWord.m_weight * 0.001);
                score.m_matched = score.m_value == 1.0;
                matchedCandWordNdx.add(lastWordNdx);
                score.m_perfectCandWords = CHN_Utils.addToArray(score.m_perfectCandWords, lastWordNdx);
            }
        }
    }

    private boolean shouldAdjust_ZH_AreaScoreForDescriptor(String candLastword, String InputLastWord) {
        if (candLastword.length() > InputLastWord.length() && InputLastWord.equals(candLastword.substring(0, candLastword.length() - 1)) && CHN_ZH_Parser.AREA_IDENTIFIERS.contains(Character.valueOf(candLastword.charAt(candLastword.length() - 1)))) {
            return true;
        }
        return InputLastWord.length() > candLastword.length() && candLastword.equals(InputLastWord.substring(0, InputLastWord.length() - 1)) && CHN_ZH_Parser.AREA_IDENTIFIERS.contains(Character.valueOf(InputLastWord.charAt(InputLastWord.length() - 1)));
    }

    private boolean shouldAdjust_ZH_AreaScoreOther(String candLastword, String InputLastWord) {
        int diff = InputLastWord.length() - candLastword.length();
        return diff > 0 && InputLastWord.substring(diff).equals(candLastword);
    }
}

