/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHN.parser;

import com.mapinfo.mapmarker.CHN.CHN_Utils;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.WordAlternate;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParserTerms;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CHN_Parser
extends CGGEParser1 {
    private static final Pattern KNOWN_STREET_WORDS_PAT = Pattern.compile("(SHENGDAO|XIANGDAO|XIANDAO|HUTONG|DAYUAN|GUODAO|HUTONG|CUNDAO|DADAO|XIANG|ZHONG|SHENG|DONG|QIAO|GONG|XIN|DAO|HAO|NAN|BEI|NEI|WAI|NAN|DA|AN|XI)$", 2);
    private static int MAX_WORD_CONSIDERED_FOR_SPLITTING = 3;
    private static int MIN_CHARACTERS_FOR_SPLITTING = 2;
    private static char[] VOWELS = new char[]{'A', 'E', 'I', 'O', 'U'};
    private static Set<Character> PUNCTPLUS_SET = new HashSet<Character>();

    @Override
    public AddressWord[] splitIntoWeightedWords(String str, FieldType type) {
        AddressWord[] words = super.splitIntoWeightedWords(str, type);
        if (words != null) {
            int removedWeight = 0;
            List<AddressWord> typeWords = this.getThroughfareTypeWords(words);
            for (int wordNdx = typeWords.size() - 2; wordNdx >= 0; --wordNdx) {
                removedWeight = this.adjustTypeFlagForNonLastWord(typeWords.get(wordNdx));
            }
            if (removedWeight > 0) {
                this.redistributeWeight(words, removedWeight);
            }
        }
        return words;
    }

    private List<AddressWord> getThroughfareTypeWords(AddressWord[] words) {
        ArrayList<AddressWord> typeWordList = new ArrayList<AddressWord>(words.length);
        for (AddressWord word : words) {
            if (!CodedWord.isThoroughfareTypeWord(word.getAttributes()) && word.m_wordType != FieldType.POST_THOROUGHFARE_FIELD_TYPE && !this.getThoroughfareTypeHandler().isThoroughfareType(word.getWord())) continue;
            typeWordList.add(word);
        }
        return typeWordList;
    }

    private void redistributeWeight(AddressWord[] words, int additionalWeight) {
        ArrayList<AddressWord> adjustWeightWords = new ArrayList<AddressWord>();
        for (AddressWord word : words) {
            if (!AddressWord.isSignificantWord(word)) continue;
            adjustWeightWords.add(word);
        }
        if (adjustWeightWords.isEmpty()) {
            for (AddressWord word : words) {
                if (word.m_weight <= 0 || CodedWord.isArticleWord(word.getAttributes()) || CodedWord.isThoroughfareTypeWord(word.getAttributes())) continue;
                adjustWeightWords.add(word);
            }
        }
        if (adjustWeightWords.isEmpty()) {
            for (AddressWord word : words) {
                if (word.m_weight <= 0) continue;
                adjustWeightWords.add(word);
            }
        }
        this.adjustWeightsAcrossWord(adjustWeightWords, additionalWeight);
    }

    private void adjustWeightsAcrossWord(List<AddressWord> adjustWeightWords, int additionalWeight) {
        int weightIncPerWord = additionalWeight / adjustWeightWords.size();
        for (AddressWord word : adjustWeightWords) {
            word.m_weight = (byte)(word.m_weight + weightIncPerWord);
        }
        int remaining = additionalWeight % adjustWeightWords.size();
        if (remaining > 0) {
            adjustWeightWords.get((int)0).m_weight = (byte)(adjustWeightWords.get((int)0).m_weight + remaining);
        }
    }

    private int adjustTypeFlagForNonLastWord(AddressWord word) {
        byte commonWordWeight = this.getParserTerms().getCommonWordWeight();
        word.m_wordType = FieldType.STREET_NAME_FIELD_TYPE;
        word.setAttribute((short)(word.getAttributes() | 0x100));
        byte currWeight = word.m_weight;
        if (currWeight > commonWordWeight) {
            int adjusted = Math.max(0, word.m_weight - commonWordWeight);
            word.m_weight = commonWordWeight;
            return adjusted;
        }
        return 0;
    }

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        ParsedAddress[] parsedAddrArray = super.parse(inputAddress, scorer);
        this.addSplitStreetWordAlternates(parsedAddrArray[0]);
        return parsedAddrArray;
    }

    @Override
    protected String cleanString(String str) {
        ICGGEParserTerms parserTerms = this.getParserTerms();
        if ((str = this.getUpperCase(str)) != null && !parserTerms.isDelimiter(str)) {
            String str1 = str.trim();
            char[] originalCharacters = CHN_Utils.zhTrim(str1).toCharArray();
            char[] newCharacters = new char[originalCharacters.length];
            int insertNdx = -1;
            for (int i = 0; i < originalCharacters.length; ++i) {
                ++insertNdx;
                if (!(!Character.isWhitespace(originalCharacters[i]) || (Character.isLetterOrDigit(originalCharacters[i - 1]) || PUNCTPLUS_SET.contains(Character.valueOf(originalCharacters[i - 1]))) && Character.isLetterOrDigit(originalCharacters[i + 1]) || Character.isWhitespace(originalCharacters[i - 1]) || '&' == originalCharacters[i - 1])) {
                    --insertNdx;
                    continue;
                }
                newCharacters[insertNdx] = originalCharacters[i];
            }
            return new String(newCharacters).trim();
        }
        return null;
    }

    private void addSplitStreetWordAlternates(ParsedAddress parsedAddress) {
        AddressWord[] words = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (words != null) {
            this.createSplitAlternates(words);
        }
    }

    void createSplitAlternates(AddressWord[] words) {
        int typeNdx = CHN_Utils.indexOfLastThoroughfareTypeWord(words);
        if (typeNdx > 0) {
            int startAt;
            for (int i = startAt = Math.max(0, typeNdx - MAX_WORD_CONSIDERED_FOR_SPLITTING); i < typeNdx; ++i) {
                AddressWord addrWord = words[i];
                if (!AddressWord.isSignificantWord(addrWord) || addrWord.hasAlternates()) continue;
                ArrayList<List<String>> splitWordAlts = new ArrayList<List<String>>();
                this.splitAndAddAlts(addrWord.getWord(), splitWordAlts);
                if (splitWordAlts.isEmpty()) continue;
                addrWord.setAlternates(this.convertToAddressWordAlt(splitWordAlts));
            }
        }
    }

    private List<WordAlternate> convertToAddressWordAlt(List<List<String>> altList) {
        ICGGESoundex soundex = this.getSoundex();
        ArrayList<WordAlternate> addrWordAltList = new ArrayList<WordAlternate>(altList.size());
        for (List<String> strList : altList) {
            ArrayList<AddressWord> addrWordList = new ArrayList<AddressWord>(strList.size());
            for (String str : strList) {
                addrWordList.add(this.convertToAddressWord(str, soundex));
            }
            addrWordAltList.add(new WordAlternate(addrWordList.toArray(new AddressWord[addrWordList.size()])));
        }
        return addrWordAltList;
    }

    private void splitAndAddAlts(String word, List<List<String>> splitWordAlts) {
        this.splitAndAddFirstSyllable(word, splitWordAlts);
        List<Object> currSplit = Collections.emptyList();
        do {
            List<String> splitWords;
            if ((splitWords = this.split(word)) != null) {
                if (!currSplit.isEmpty()) {
                    splitWords.addAll(currSplit.subList(1, currSplit.size()));
                }
                currSplit = splitWords;
                splitWordAlts.add(currSplit);
                word = (String)currSplit.get(0);
                continue;
            }
            currSplit = Collections.emptyList();
        } while (!currSplit.isEmpty());
    }

    private void splitAndAddFirstSyllable(String word, List<List<String>> splitWordAlts) {
        int len = word.length();
        char[] chars = word.toCharArray();
        int pos = 1;
        while (pos > 0) {
            if ((pos = this.nextSyllableStartPos(chars, pos + 1)) <= -1 || pos >= len - 1) continue;
            List<String> splitWords = Arrays.asList(word.substring(0, pos), word.substring(pos));
            splitWordAlts.add(splitWords);
        }
    }

    private List<String> split(String word) {
        int splitPos = this.splitWithKnownWord(word);
        if (splitPos < MIN_CHARACTERS_FOR_SPLITTING) {
            splitPos = this.splitLastSyllable(word);
        }
        if (splitPos >= MIN_CHARACTERS_FOR_SPLITTING) {
            ArrayList<String> alt = new ArrayList<String>();
            alt.add(word.substring(0, splitPos));
            alt.add(word.substring(splitPos));
            return alt;
        }
        return null;
    }

    private int splitWithKnownWord(String word) {
        Matcher m = KNOWN_STREET_WORDS_PAT.matcher(word);
        if (m.find()) {
            return m.start();
        }
        return -1;
    }

    private int nextSyllableStartPos(char[] chars, int start) {
        int len = chars.length;
        for (int curr = start; curr < len; ++curr) {
            if (this.isVowel(chars[curr])) continue;
            return curr;
        }
        return -1;
    }

    private boolean isVowel(char ch) {
        return Arrays.binarySearch(VOWELS, ch) > -1;
    }

    private int splitLastSyllable(String word) {
        int curr;
        int len = word.length();
        char[] chars = word.toCharArray();
        for (curr = len - 1; curr > 0 && !this.isVowel(chars[curr]); --curr) {
        }
        if (curr > 1) {
            while (curr > 0 && this.isVowel(chars[curr])) {
                --curr;
            }
        }
        return curr > 1 ? curr : -1;
    }

    static {
        char[] puncts = new char[]{'`', '.', ',', '-', '(', ')', '\uff09', '\uff08', '\'', '\u00b7', '/'};
        for (int i = 0; i < puncts.length; ++i) {
            PUNCTPLUS_SET.add(Character.valueOf(puncts[i]));
        }
        PUNCTPLUS_SET = Collections.unmodifiableSet(PUNCTPLUS_SET);
    }
}

