/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CHN.scorer;

import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.scorer.CGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import java.util.HashSet;

public class CHN_Scorer
extends CGGEScorer {
    @Override
    protected int compareExpandedInputAltScores(FieldScore expandedInputScore, FieldScore originalScore) {
        int c = super.compareExpandedInputAltScores(expandedInputScore, originalScore);
        if (c > 0) {
            this.adjustForUnmatchedExpandedWords(expandedInputScore);
            c = expandedInputScore.compareTo(originalScore);
        }
        return c;
    }

    void adjustForUnmatchedExpandedWords(FieldScore score) {
        if (score.m_value > 0.7) {
            IntArray matchedInputWordNdxs = score.m_matchedInputWords;
            AddressWord[] inputWords = score.getInputWords();
            int matchedWordCount = IntArray.size(matchedInputWordNdxs);
            if (matchedWordCount > 0) {
                HashSet<Integer> checkedBaseWords = new HashSet<Integer>(5);
                for (int matchedNdx = 0; matchedNdx < matchedWordCount; ++matchedNdx) {
                    int baseWordNdx = this.getBaseWordNdx(inputWords[matchedInputWordNdxs.get(matchedNdx)]);
                    if (baseWordNdx <= -1 || checkedBaseWords.contains(baseWordNdx)) continue;
                    double unmatchedSplitWordWeight = this.calculateUnMatchedWeight(inputWords, matchedInputWordNdxs, baseWordNdx);
                    if (unmatchedSplitWordWeight > 0.0) {
                        this.reduceScoreForWord(score, matchedNdx, unmatchedSplitWordWeight);
                    }
                    checkedBaseWords.add(baseWordNdx);
                }
            }
        }
    }

    private void reduceScoreForWord(FieldScore score, int matchedNdx, double unmatchedSplitWordWeight) {
        if (IntArray.size(score.m_matchedCandWords) >= matchedNdx) {
            double candWordWeight = (double)score.getCandidateWords()[score.m_matchedCandWords.get((int)matchedNdx)].m_weight * 0.01;
            score.m_value -= candWordWeight * unmatchedSplitWordWeight;
        } else {
            score.m_value -= score.m_value * unmatchedSplitWordWeight;
        }
    }

    private double calculateUnMatchedWeight(AddressWord[] inputWords, IntArray matchedInputWordNdxs, int baseWordNdx) {
        int splitWords = 0;
        int unmatchedWords = 0;
        int unmatchedCommonWord = 0;
        for (int wordNdx = inputWords.length - 1; wordNdx >= 0; --wordNdx) {
            AddressWord inputWord = inputWords[wordNdx];
            if (!this.isSplitFromBaseWord(inputWord, baseWordNdx)) continue;
            ++splitWords;
            if (matchedInputWordNdxs.contains(wordNdx)) continue;
            ++unmatchedWords;
            if (AddressWord.isSignificantWord(inputWord)) continue;
            ++unmatchedCommonWord;
        }
        if (splitWords > 1 && unmatchedWords > 0) {
            if (unmatchedCommonWord == 1) {
                splitWords += 3;
            }
        } else {
            return 0.0;
        }
        return unmatchedWords > 0 && splitWords > 1 ? (double)unmatchedWords / (double)splitWords : 0.0;
    }

    private int getBaseWordNdx(AddressWord word) {
        Object data = word.getData();
        if (data instanceof Integer) {
            return (Integer)data;
        }
        return -1;
    }

    private boolean isSplitFromBaseWord(AddressWord word, int baseWordNdx) {
        return this.getBaseWordNdx(word) == baseWordNdx;
    }
}

