/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.COL.convertor;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.convertor.CGGECandidateConvertor;
import com.mapinfo.mapmarker.cgge.convertor.CGGEFormatter;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParserTerms;
import com.mapinfo.mapmarker.cgge.utils.IntArray;

public class COL_CandidateConvertor
extends CGGECandidateConvertor {
    public static final String PARSED_HAS_DIR = "PARSED_HAS_DIR";
    public static final String CAND_HAS_DIR = "CAND_HAS_DIR";

    @Override
    protected void copyMatchFlags(CandidateAddress candAddr, InternalScoringAddress scoringAddr, boolean isIntersection) {
        FieldType secondaryFieldType = new FieldType(30, FieldType.FieldLevel.LEVEL_STREET, "secondary_street");
        FieldScore secStreetScore = scoringAddr.getFieldScore(secondaryFieldType);
        FieldScore primaryStreetScore = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        boolean isClose = scoringAddr.isCloseMatch();
        if (primaryStreetScore != null) {
            AddressWord[] secondaryCandidateWordArr;
            AddressWord[] secondaryinputWordArr;
            boolean secondaryStreetMatched = true;
            if (!isClose && null != secStreetScore && secStreetScore.m_value != 0.0 && secStreetScore.m_value < 1.0) {
                secondaryStreetMatched = false;
            } else if (isClose && null != secStreetScore && secStreetScore.m_value == 1.0 && !this.isEqualWord(secondaryinputWordArr = secStreetScore.m_inputWords, secondaryCandidateWordArr = secStreetScore.m_candWords)) {
                secondaryStreetMatched = false;
            }
            primaryStreetScore.m_nonNumericCombinedWordScoreUsed = secondaryStreetMatched;
        }
        String dirParsed = (String)scoringAddr.getAdditionalInfo(PARSED_HAS_DIR);
        String dirCand = (String)scoringAddr.getAdditionalInfo(CAND_HAS_DIR);
        if (dirParsed != null) {
            candAddr.getAdditionalFields().put(PARSED_HAS_DIR, dirParsed);
        }
        if (dirCand != null) {
            candAddr.getAdditionalFields().put(CAND_HAS_DIR, dirCand);
        }
        super.copyMatchFlags(candAddr, scoringAddr, isIntersection);
        candAddr.getAdditionalFields().remove(PARSED_HAS_DIR);
        candAddr.getAdditionalFields().remove(CAND_HAS_DIR);
    }

    @Override
    protected void handleStreetNameMatchFlags(FieldScore score, CandidateAddress candAddr, boolean isIntersection) {
        boolean nPrecisionMatchFlag = true;
        if (score != null) {
            nPrecisionMatchFlag = score.m_nonNumericCombinedWordScoreUsed;
            AddressWord[] primaryInputWordArr = score.m_inputWords;
            AddressWord[] primaryCandidateWordArr = score.m_candWords;
            if (!candAddr.isCloseMatch() && !this.isEqualWord(primaryInputWordArr, primaryCandidateWordArr)) {
                nPrecisionMatchFlag = false;
            }
        }
        if (score != null) {
            if (score.m_matched && !isIntersection) {
                if (nPrecisionMatchFlag) {
                    candAddr.setStreetNameMatched();
                    candAddr.setStreetPrefixAndSuffixMatched();
                }
                candAddr.setPostDirectionalMatched();
                candAddr.setPreDirectionalMatched();
                candAddr.setThoroughfareTypeMatched();
            } else {
                AddressWord[] streetWords = score.m_candWords;
                int wordCount = streetWords == null ? 0 : streetWords.length;
                IntArray perfectMatches = score.m_perfectCandWords;
                ICGGEParserTerms parserTerms = this.getParser().getParserTerms();
                boolean streetNameMatched = true;
                boolean preDirectionalMatched = true;
                boolean postDirectionalMatched = true;
                boolean tftFound = false;
                boolean foundDir = false;
                if (perfectMatches != null && perfectMatches.size() > 0) {
                    for (int i = 0; i < wordCount; ++i) {
                        AddressWord word = streetWords[i];
                        if (CodedWord.isDelimiter(word.getAttributes())) continue;
                        boolean wordMatched = perfectMatches.contains(i);
                        if (word.m_wordType == FieldType.POST_THOROUGHFARE_FIELD_TYPE) {
                            if (wordMatched) {
                                candAddr.setThoroughfareTypeMatched();
                            }
                            tftFound = true;
                            continue;
                        }
                        if (i == 0 && parserTerms.isDirectionalWord(word.getWord())) {
                            if (wordMatched) continue;
                            preDirectionalMatched = false;
                            continue;
                        }
                        if (i == wordCount - 1 && parserTerms.isDirectionalWord(word.getWord())) {
                            if (wordMatched) continue;
                            postDirectionalMatched = false;
                            continue;
                        }
                        if (wordMatched || word.m_weight <= 0) continue;
                        streetNameMatched = false;
                    }
                    String parsedDir = candAddr.getAdditionalFieldForKey(PARSED_HAS_DIR);
                    String candDir = candAddr.getAdditionalFieldForKey(CAND_HAS_DIR);
                    if ((parsedDir != null && candDir == null || parsedDir == null && candDir != null) && postDirectionalMatched) {
                        postDirectionalMatched = false;
                    } else if (!postDirectionalMatched && parsedDir != null && candDir != null && parsedDir.equals(candDir)) {
                        postDirectionalMatched = true;
                    }
                    if (streetNameMatched && !isIntersection && nPrecisionMatchFlag) {
                        candAddr.setStreetNameMatched();
                        candAddr.setStreetPrefixAndSuffixMatched();
                    }
                    if (preDirectionalMatched) {
                        candAddr.setPreDirectionalMatched();
                    }
                    if (postDirectionalMatched) {
                        candAddr.setPostDirectionalMatched();
                    }
                }
            }
        }
    }

    @Override
    protected void copyAddressFields(CandidateAddress candAddr, InternalScoringAddress scoringAddr, CGGEFormatter formatter, IDataManager dataManager, boolean intersection) throws DataFetchException, CGGEInternalException {
        super.copyAddressFields(candAddr, scoringAddr, formatter, dataManager, intersection);
        String formattedStreet = candAddr.getFormattedStreetAddress();
        if (formattedStreet != null) {
            candAddr.setFormattedStreetAddress(formattedStreet.replace("  ", " "));
        }
    }

    private boolean isEqualWord(AddressWord[] addressWord1, AddressWord[] addressWord2) {
        return this.combineAddressWord(addressWord1).equals(this.combineAddressWord(addressWord2));
    }

    private String combineAddressWord(AddressWord[] addressWord) {
        StringBuilder addressWordString = new StringBuilder();
        for (int i = 0; i < addressWord.length; ++i) {
            if (CodedWord.isThoroughfareTypeWord(addressWord[i].getAttributes()) || CodedWord.isDirectionalWord(addressWord[i].getAttributes()) || CodedWord.isArticleWord(addressWord[i].getAttributes())) continue;
            addressWordString.append(addressWord[i].getWord());
        }
        return addressWordString.toString();
    }
}

