/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.COL.helper;

import com.mapinfo.mapmarker.COL.utils.COL_Utils;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEStreetGeocodingHelper;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class COLStreetGeocodingHelper
extends CGGEStreetGeocodingHelper {
    private static final AddressWord[] EMPTY_ADDRESSWORD_ARRAY = new AddressWord[0];
    private boolean isFirstCase = true;
    private boolean isMainAndSecondaryStreetType = false;
    private ParsedAddress savedParsedAddr;
    private AddressWord[] altStreetSearchWords = null;
    private AddressWord[] nonStreetWords = null;
    private AddressWord[] secondaryStreetWords = null;
    private List<DictionaryAreaTermItem> stateLevelSACList = null;
    private boolean stateSacFetched = false;
    private double localStateLevelMinQuality = 0.85;
    private Pattern alphaNumPattern = Pattern.compile("\\d+[a-zA-Z\\d]*");

    @Override
    protected List<DictionaryAddressWord> getSearchableWords(AddressWord[] searchWords, FieldType type, IDataManager dataManager, double minQuality, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        if (searchWords == null) {
            return null;
        }
        searchWords = this.isMainAndSecondaryStreetType ? this.checkMainStreetSearchWords(searchWords) : this.filterWordsMatchedWithAreaName(searchWords);
        List<DictionaryAddressWord> dictAddressWords = super.getSearchableWords(searchWords, type, dataManager, minQuality, options);
        if (minQuality < 1.0 && dictAddressWords != null) {
            this.removeUnMatchedNonSignificantWords(dictAddressWords);
        }
        return dictAddressWords;
    }

    @Override
    protected AddressWord[] filterSearchWords(AddressWord[] words, boolean includeNormalWords, boolean combineAlphaNumeric, boolean noMultipleStreetTypeFiltering, int includeMask) {
        AddressWord[] searchWords = super.filterSearchWords(words, includeNormalWords, combineAlphaNumeric, noMultipleStreetTypeFiltering, includeMask);
        if (this.altStreetSearchWords != null) {
            searchWords = AddressWordArray.combineArrays(searchWords == null ? EMPTY_ADDRESSWORD_ARRAY : searchWords, this.altStreetSearchWords);
        }
        return searchWords;
    }

    AddressWord[] checkMainStreetSearchWords(AddressWord[] searchWords) {
        if (searchWords != null) {
            AddressWord[] searchWordsClone = AddressWordArray.clone(searchWords);
            if (this.hasNonThoroughfareTypeMainWord()) {
                int wordCount = searchWordsClone.length;
                boolean wordRemoved = false;
                for (int i = 0; i < wordCount; ++i) {
                    if (!CodedWord.isThoroughfareTypeWord(searchWordsClone[i].getAttributes())) continue;
                    searchWordsClone[i] = null;
                    wordRemoved = true;
                }
                if (wordRemoved) {
                    searchWords = this.removeNullWords(searchWordsClone);
                }
            }
        }
        return searchWords;
    }

    boolean hasNonThoroughfareTypeMainWord() {
        AddressWord[] mainStreetWords;
        if (this.savedParsedAddr != null && this.isMainAndSecondaryStreetType && (mainStreetWords = (AddressWord[])this.savedParsedAddr.getField(FieldType.STREET_NAME_FIELD_TYPE)) != null) {
            for (AddressWord mainStreetWord : mainStreetWords) {
                if (CodedWord.isThoroughfareTypeWord(mainStreetWord.getAttributes())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public InternalCandidateList searchNextCase(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList curCandList) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        if (this.isFirstCase) {
            this.isFirstCase = false;
            this.savedParsedAddr = parsedAddress;
            this.isMainAndSecondaryStreetType = !parsedAddress.isEmpty(FieldType.GENERIC_FIELD_3_FIELD_TYPE);
            this.altStreetSearchWords = (AddressWord[])parsedAddress.getField(FieldType.GENERIC_FIELD_2_FIELD_TYPE);
            this.nonStreetWords = (AddressWord[])parsedAddress.getField(FieldType.GENERIC_FIELD_1_FIELD_TYPE);
            this.secondaryStreetWords = (AddressWord[])parsedAddress.getField(FieldType.GENERIC_FIELD_3_FIELD_TYPE);
        }
        return super.searchNextCase(dataManager, parsedAddress, options, curCandList);
    }

    private void removeUnMatchedNonSignificantWords(List<DictionaryAddressWord> dictAddressWords) {
        Iterator<DictionaryAddressWord> it = dictAddressWords.iterator();
        while (it.hasNext()) {
            AddressWord searchWord;
            DictionaryAddressWord dictAddrWord = it.next();
            if (!(dictAddrWord.getMatchQuality() < 1.0) || COL_Utils.hasSameStartingDigits(searchWord = dictAddrWord.getSearchWord(), dictAddrWord.getAddressWord()) || AddressWord.isSignificantWord(searchWord) && searchWord.getWordLength() >= 4) continue;
            it.remove();
        }
    }

    private AddressWord[] filterWordsMatchedWithAreaName(AddressWord[] searchWords) {
        int length = searchWords.length;
        boolean wordsRemoved = false;
        if (length > 0) {
            List<AddressWord> searchAreaWords = this.getAreaSearchedWords();
            block0: for (int i = 0; i < length; ++i) {
                for (AddressWord searchAreaWord : searchAreaWords) {
                    if (!this.isSameInputWord(searchAreaWord, searchWords[i])) continue;
                    searchWords[i] = null;
                    wordsRemoved = true;
                    continue block0;
                }
            }
        }
        return wordsRemoved ? this.removeNullWords(searchWords) : searchWords;
    }

    private List<AddressWord> getAreaSearchedWords() {
        List<DictionaryAreaTermItem> dictAreaList = this.getSearchAreaList();
        if (dictAreaList != null) {
            ArrayList<AddressWord> searchedAreaWords = new ArrayList<AddressWord>();
            for (DictionaryAreaTermItem dictAT : dictAreaList) {
                DictionaryAddressWord[] matchedWords = dictAT.getMatchedWords();
                if (matchedWords == null) continue;
                for (DictionaryAddressWord daw : matchedWords) {
                    if (daw == null) continue;
                    searchedAreaWords.add(daw.getSearchWord());
                }
            }
            return searchedAreaWords;
        }
        return Collections.emptyList();
    }

    private AddressWord[] removeNullWords(AddressWord[] words) {
        AddressWord[] newWordArray = new AddressWord[words.length];
        int added = 0;
        for (AddressWord word : words) {
            if (word == null) continue;
            newWordArray[added++] = word;
        }
        return Arrays.copyOf(newWordArray, added);
    }

    @Override
    protected boolean containsSameSearchWord(DictionaryAreaTermItem areaItem, DictionaryAddressWord addrWord) {
        DictionaryAddressWord[] areaDictMatchedWords = areaItem.getMatchedWords();
        if (areaDictMatchedWords == null) {
            return false;
        }
        AddressWord streetSearchWord = addrWord.getSearchWord();
        for (DictionaryAddressWord areaDictMatchedWord : areaDictMatchedWords) {
            if (areaDictMatchedWord == null || !this.isSameInputWord(streetSearchWord, areaDictMatchedWord.getSearchWord())) continue;
            return true;
        }
        return false;
    }

    private boolean isSameInputWord(AddressWord word1, AddressWord word2) {
        return word1 == word2 || word1.getWordChars() == word2.getWordChars();
    }

    @Override
    protected List<DictionaryAreaTermItem> findAreaList(AddressWord[] searchWords, FieldType areaType, double minQuality, IDataManager dataManager, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        if (this.nonStreetWords != null) {
            searchWords = AddressWordArray.combineArrays(searchWords == null ? EMPTY_ADDRESSWORD_ARRAY : searchWords, this.nonStreetWords);
        }
        return super.findAreaList(searchWords, areaType, minQuality, dataManager, options);
    }

    @Override
    protected InternalCandidateList retrieveCandidates(IDataManager dataManager, ParsedAddress parsedAddress, List<DictionaryAreaTermItem> areaList, List<DictionaryAddressWord> searchWordList, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        InternalCandidateList internalCandidateList = super.retrieveCandidates(dataManager, parsedAddress, areaList, searchWordList, options);
        InternalCandidateList retainedCandidateList = new InternalCandidateList();
        if (internalCandidateList != null) {
            AddressWord[] parsedAddressSecondaryStreetField = (AddressWord[])parsedAddress.getField(FieldType.GENERIC_FIELD_3_FIELD_TYPE);
            AddressWord[] parsedAddressStreetNameField = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
            int streetWordSize = AddressWordArray.size(parsedAddressStreetNameField);
            FieldType secondaryFieldType = new FieldType(30, FieldType.FieldLevel.LEVEL_STREET, "secondary_street");
            List<InternalScoringAddress> candidateList = internalCandidateList.getCandidateList();
            int candidateListSize = candidateList.size();
            for (int index = 0; index < candidateListSize; ++index) {
                InternalScoringAddress internalScoringAddress = candidateList.get(index);
                Map fields = internalScoringAddress.getFields();
                if (streetWordSize > 0 && fields.containsKey(FieldType.STREET_NAME_FIELD_TYPE)) {
                    InternalFieldValue streetNameField = (InternalFieldValue)fields.get(FieldType.STREET_NAME_FIELD_TYPE);
                    if (!this.retainCandidate(parsedAddressStreetNameField, (AddressWord[])streetNameField.getFieldValue())) continue;
                    int secondaryStreetFieldSize = AddressWordArray.size(parsedAddressSecondaryStreetField);
                    if (secondaryStreetFieldSize > 0 && fields.containsKey(secondaryFieldType)) {
                        InternalFieldValue secondaryFieldValue = (InternalFieldValue)fields.get(secondaryFieldType);
                        if (!this.retainCandidate(parsedAddressSecondaryStreetField, (AddressWord[])secondaryFieldValue.getFieldValue())) continue;
                        retainedCandidateList.addCandidate(internalScoringAddress);
                        continue;
                    }
                    if (secondaryStreetFieldSize != 0 || fields.containsKey(secondaryFieldType)) continue;
                    retainedCandidateList.addCandidate(internalScoringAddress);
                    continue;
                }
                if (streetWordSize != 0) continue;
                retainedCandidateList.addCandidate(internalScoringAddress);
            }
        }
        return retainedCandidateList;
    }

    @Override
    protected boolean generateAreaSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        boolean flag = super.generateAreaSubTries(dataManager, parsedAddress, options, candidateList);
        List<DictionaryAreaTermItem> areaList = this.getSearchAreaList();
        if (flag) {
            this.initializeStateLevelSacList(dataManager, parsedAddress, options);
            if (this.stateLevelSACList != null && this.stateLevelSACList.size() > 0 && areaList != null && areaList.size() > 0) {
                areaList.addAll(this.stateLevelSACList);
                this.m_areaSacIntersectionFieldList.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                for (DictionaryAreaTermItem areaTermItem : areaList) {
                    if (areaTermItem.getFieldType().equals(FieldType.AREA_NAME_3_FIELD_TYPE)) {
                        this.m_areaSacIntersectionFieldList.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                        continue;
                    }
                    if (!areaTermItem.getFieldType().equals(FieldType.AREA_NAME_4_FIELD_TYPE)) continue;
                    this.m_areaSacIntersectionFieldList.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                }
                ListUtils.removeDuplicates(this.m_areaSacIntersectionFieldList);
            }
        }
        this.setSearchAreaList(areaList);
        return flag;
    }

    List<DictionaryAreaTermItem> initializeStateLevelSacList(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        if (!this.stateSacFetched) {
            this.stateSacFetched = true;
            AddressWord[] lookUpAreaWords = null;
            lookUpAreaWords = parsedAddress.isSeparateAreaFields() ? (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE) : super.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
            this.stateLevelSACList = this.findAreaList(this.filterStateAddressWords(lookUpAreaWords), FieldType.AREA_NAME_1_FIELD_TYPE, this.localStateLevelMinQuality, dataManager, options);
        }
        return this.stateLevelSACList;
    }

    AddressWord[] filterStateAddressWords(AddressWord[] lookUpAreaWrds) {
        if (AddressWordArray.size(lookUpAreaWrds) == 0) {
            return lookUpAreaWrds;
        }
        AddressWord[] clonedLookUpAreaWords = AddressWordArray.clone(lookUpAreaWrds);
        if (this.m_areaList != null) {
            ArrayList<String> areaListWords = new ArrayList<String>();
            for (DictionaryAreaTermItem dictionaryAreaTermItem : this.m_areaList) {
                DictionaryAddressWord[] matchedWords;
                for (DictionaryAddressWord matchedWord : matchedWords = dictionaryAreaTermItem.getMatchedWords()) {
                    if (matchedWord == null) continue;
                    areaListWords.add(matchedWord.getSearchWord().getWord());
                }
            }
            boolean addressWordsRemoved = false;
            if (areaListWords.size() == 1) {
                for (int i = 0; i < clonedLookUpAreaWords.length; ++i) {
                    if (!areaListWords.contains(clonedLookUpAreaWords[i].getWord())) continue;
                    addressWordsRemoved = true;
                    clonedLookUpAreaWords[i] = null;
                }
            }
            if (addressWordsRemoved) {
                clonedLookUpAreaWords = this.removeNullWords(clonedLookUpAreaWords);
            }
        }
        return clonedLookUpAreaWords;
    }

    @Override
    protected List<DictionaryAddressWord> filterSearchWords(List<DictionaryAddressWord> searchWordList, boolean perfectMatches, int filterMask) {
        if (searchWordList != null && !searchWordList.isEmpty()) {
            ArrayList<DictionaryAddressWord> localFilterList = new ArrayList<DictionaryAddressWord>();
            ArrayList<DictionaryAddressWord> filterList = new ArrayList<DictionaryAddressWord>();
            for (DictionaryAddressWord dictAddrWord : searchWordList) {
                if (COL_Utils.hasSameStartingDigits(dictAddrWord.getSearchWord(), dictAddrWord.getAddressWord())) {
                    localFilterList.add(dictAddrWord);
                    continue;
                }
                filterList.add(dictAddrWord);
            }
            return ListUtils.addToList(localFilterList, super.filterSearchWords(filterList, perfectMatches, filterMask));
        }
        return null;
    }

    @Override
    protected void setSacSearchFields(List<FieldType> sacSearchFields) {
        if (sacSearchFields != null) {
            sacSearchFields.remove(FieldType.AREA_NAME_1_FIELD_TYPE);
        }
        super.setSacSearchFields(sacSearchFields);
    }

    public boolean isStateSacFetched() {
        return this.stateSacFetched;
    }

    public void setStateSacFetched(boolean stateSacFetched) {
        this.stateSacFetched = stateSacFetched;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean compareArrays(AddressWord[] addressWords1, AddressWord[] addressWords2) {
        if (AddressWordArray.size(addressWords1) == 0) return false;
        if (AddressWordArray.size(addressWords2) == 0) {
            return false;
        }
        int index1 = 0;
        int index2 = 0;
        boolean isThoroughFarePresentInWord1 = false;
        boolean isThoroughFarePresentInWord2 = false;
        if (CodedWord.isThoroughfareTypeWord(addressWords1[index1].getAttributes())) {
            ++index1;
            isThoroughFarePresentInWord1 = true;
        }
        if (CodedWord.isThoroughfareTypeWord(addressWords2[index2].getAttributes())) {
            ++index2;
            isThoroughFarePresentInWord2 = true;
        }
        if (index1 == addressWords1.length) return false;
        if (index2 == addressWords2.length) {
            return false;
        }
        int addressWords1Length = addressWords1.length - index1;
        int addressWords2Length = addressWords2.length - index2;
        boolean word1ContainsDigits = this.isAlphanumeric(addressWords1[index1].getWord());
        boolean word2ContainsDigits = this.isAlphanumeric(addressWords2[index2].getWord());
        if (!word1ContainsDigits && !word2ContainsDigits) {
            while (true) {
                String word2;
                String word1;
                if (!isThoroughFarePresentInWord1 || index1 > addressWords1Length) {
                    if (index1 >= addressWords1Length) return true;
                }
                if (!isThoroughFarePresentInWord2 || index2 > addressWords2Length) {
                    if (index2 >= addressWords2Length) return true;
                }
                if (!(word1 = addressWords1[index1].getWord()).equals(word2 = addressWords2[index2].getWord())) {
                    return false;
                }
                ++index1;
                ++index2;
            }
        }
        boolean isEqual = true;
        while (true) {
            if (!isThoroughFarePresentInWord1 || index1 > addressWords1Length) {
                if (index1 >= addressWords1Length) return isEqual;
            }
            if (!isThoroughFarePresentInWord2 || index2 > addressWords2Length) {
                if (index2 >= addressWords2Length) return isEqual;
            }
            String word1 = addressWords1[index1].getWord();
            String word2 = addressWords2[index2].getWord();
            if (!this.isAlphanumeric(word1)) {
                if (!this.isAlphanumeric(word2)) return false;
            }
            if (!word1.equals(word2)) {
                int num2;
                int num1;
                if (CodedWord.isNumber(addressWords1[index1].getAttributes())) {
                    if (CodedWord.isNumber(addressWords2[index2].getAttributes())) return false;
                }
                if ((num1 = COL_Utils.getNumericValueOnly(word1)) != (num2 = COL_Utils.getNumericValueOnly(word2))) {
                    return false;
                }
            }
            ++index1;
            ++index2;
        }
    }

    protected boolean retainCandidate(AddressWord[] parsedSt, AddressWord[] candWords) {
        String numPattern = "\\d+";
        Pattern numPat = Pattern.compile(numPattern);
        Matcher numMatcher = null;
        Matcher numMatcherCand = null;
        boolean numFound = false;
        boolean numFoundCand = false;
        boolean parsedHasNumber = false;
        boolean candHasNumber = false;
        int parsedidx = 0;
        int candidx = 0;
        for (AddressWord word : parsedSt) {
            if (Character.isDigit(word.getWord().charAt(0))) {
                parsedHasNumber = true;
                break;
            }
            ++parsedidx;
        }
        for (AddressWord word : candWords) {
            if (Character.isDigit(word.getWord().charAt(0))) {
                candHasNumber = true;
                break;
            }
            ++candidx;
        }
        if (parsedHasNumber) {
            numMatcher = numPat.matcher(parsedSt[parsedidx].getWord());
            numFound = numMatcher.find();
        }
        if (candHasNumber) {
            numMatcherCand = numPat.matcher(candWords[candidx].getWord());
            numFoundCand = numMatcherCand.find();
        }
        return numFound == numFoundCand && (!numFound || numMatcher.group(0).equals(numMatcherCand.group(0)));
    }

    private boolean isAlphanumeric(String str) {
        return this.alphaNumPattern.matcher(str).matches();
    }
}

