/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.COL.matcher;

import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.matcher.CGGEInternalScoringAddressComparator;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;

public class COLInternalScoringAddressComparator
extends CGGEInternalScoringAddressComparator {
    @Override
    public int compare(InternalScoringAddress c1, InternalScoringAddress c2) {
        if (c1.isCloseMatch() == c2.isCloseMatch()) {
            int comp = COLInternalScoringAddressComparator.compareAddressScore(c1, c2);
            if (comp == 0 || !this.isUDDictionaryConfigured(c1, c2)) {
                int c2MatchedCount;
                int c1MatchedCount;
                if (comp == 0 && (comp = COLInternalScoringAddressComparator.comparePostAddress(c1, c2)) == 0 && (comp = COLInternalScoringAddressComparator.compareStreetAddress(c1, c2)) == 0 && (comp = COLInternalScoringAddressComparator.compareRangeScores(c1, c2)) == 0 && (comp = (c1MatchedCount = c1.getMatchedFieldCount()) - (c2MatchedCount = c2.getMatchedFieldCount())) == 0 && (comp = COLInternalScoringAddressComparator.compareMatchedWordsCount(c1, c2)) == 0 && (comp = COLInternalScoringAddressComparator.compareWeightsOfMatchedFields(c1, c2)) == 0 && (comp = COLInternalScoringAddressComparator.compareAddressNumber(c1, c2)) == 0 && (comp = this.compareMatchedInOrder(c1, c2)) == 0) {
                    int c2FieldCount;
                    int c1FieldCount = c1.getFields() != null ? c1.getFields().size() : 0;
                    comp = -(c1FieldCount - (c2FieldCount = c2.getFields() != null ? c2.getFields().size() : 0));
                    if ((comp == 1 || comp == -1) && c1.getDictionaryUsagePriority() != c2.getDictionaryUsagePriority() && c1.getFields().containsKey(FieldType.POST_CODE_FIELD_TYPE) != c2.getFields().containsKey(FieldType.POST_CODE_FIELD_TYPE)) {
                        comp = 0;
                    }
                    if (comp == 0 && comp == 0 && (comp = -(COLInternalScoringAddressComparator.getAltWordMatchCount(c1) - COLInternalScoringAddressComparator.getAltWordMatchCount(c2))) == 0 && (comp = -(c1.getDictionaryUsagePriority() - c2.getDictionaryUsagePriority())) == 0) {
                        if (!MMUtils.usingNonNumericCombinedWordScore(c1.getFieldScores()) && MMUtils.usingNonNumericCombinedWordScore(c2.getFieldScores())) {
                            comp = 1;
                        } else if (!MMUtils.usingNonNumericCombinedWordScore(c2.getFieldScores()) && MMUtils.usingNonNumericCombinedWordScore(c1.getFieldScores())) {
                            comp = -1;
                        }
                    }
                }
            } else {
                comp = -(c1.getDictionaryUsagePriority() - c2.getDictionaryUsagePriority());
            }
            return comp;
        }
        if (c1.isCloseMatch()) {
            return 1;
        }
        return -1;
    }

    protected int checkMatchOrder(FieldScore f1, FieldScore f2) {
        boolean match2;
        boolean match1;
        if (f1 != null && f2 != null && (match1 = f1.inputWordsMatchedInOrderforComparison()) != (match2 = f2.inputWordsMatchedInOrderforComparison())) {
            if (match1) {
                return 1;
            }
            return -1;
        }
        return 0;
    }

    private int compareMatchedInOrder(InternalScoringAddress addr1, InternalScoringAddress addr2) {
        FieldScore f2;
        FieldScore f1 = addr1.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        int d = this.checkMatchOrder(f1, f2 = addr2.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE));
        if (d == 0) {
            f1 = addr1.getFieldScore(FieldType.PLACE_NAME_FIELD_TYPE);
            f2 = addr2.getFieldScore(FieldType.PLACE_NAME_FIELD_TYPE);
            if (f1 == null && f2 == null && addr1.getRangeCount() > 0 && addr2.getRangeCount() > 0) {
                f1 = addr1.getRangeAt(0).getFieldScore(FieldType.RANGE_PLACE_NAME_FIELD_TYPE);
                f2 = addr2.getRangeAt(0).getFieldScore(FieldType.RANGE_PLACE_NAME_FIELD_TYPE);
            }
            if ((d = this.checkMatchOrder(f1, f2)) == 0 && (d = this.checkMatchOrder(f1 = addr1.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE), f2 = addr2.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE))) == 0) {
                f1 = addr1.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE);
                f2 = addr2.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE);
                d = this.checkMatchOrder(f1, f2);
            }
        }
        return d;
    }

    private static int getAltWordMatchCount(InternalScoringAddress cand) {
        int altWordMatches = 0;
        Collection<FieldScore> scores = cand.getFieldScoreList();
        if (scores != null) {
            for (FieldScore score : scores) {
                if (score == null) continue;
                altWordMatches += score.m_altMatchedCount;
            }
        }
        return altWordMatches;
    }

    private boolean isUDDictionaryConfigured(InternalScoringAddress address1, InternalScoringAddress address2) {
        boolean isUDConfigured = false;
        if (address1.getDataSetInfo() != null && address2.getDataSetInfo() != null) {
            boolean isFirstCandidateFromUD = address1.getDataSetInfo().getMetaData().isUserDictionary();
            boolean isSecondCandidateFromUD = address2.getDataSetInfo().getMetaData().isUserDictionary();
            isUDConfigured = isFirstCandidateFromUD ^ isSecondCandidateFromUD;
        }
        return isUDConfigured;
    }

    private static int compareWeightsOfMatchedFields(InternalScoringAddress c1, InternalScoringAddress c2) {
        Comparator<FieldScore> comparator = MMUtils.getReverseComparator(new Comparator<FieldScore>(){

            @Override
            public int compare(FieldScore fs1, FieldScore fs2) {
                if (fs1 != null && fs2 != null) {
                    if (fs1.m_fieldWeight > fs2.m_fieldWeight) {
                        return 1;
                    }
                    if (fs1.m_fieldWeight < fs2.m_fieldWeight) {
                        return -1;
                    }
                    return 0;
                }
                if (fs1 != null) {
                    return 1;
                }
                if (fs2 != null) {
                    return -1;
                }
                return 0;
            }
        });
        Collection<FieldScore> s1 = c1.getFieldScoreList();
        Collection<FieldScore> s2 = c2.getFieldScoreList();
        if (s1 != null && s2 != null) {
            ArrayList<FieldScore> scores1 = new ArrayList<FieldScore>(s1);
            ArrayList<FieldScore> scores2 = new ArrayList<FieldScore>(s2);
            Collections.sort(scores1, comparator);
            Collections.sort(scores2, comparator);
            int size1 = scores1.size();
            int size2 = scores2.size();
            boolean j = false;
            for (int i = 0; i < size1 && i < size2; ++i) {
                FieldScore score1 = (FieldScore)scores1.get(i);
                FieldScore score2 = (FieldScore)scores2.get(i);
                if (score1 == null || score2 == null) continue;
                if (score1.m_fieldWeight > score2.m_fieldWeight) {
                    return 1;
                }
                if (!(score1.m_fieldWeight < score2.m_fieldWeight)) continue;
                return -1;
            }
        } else {
            if (s1 != null) {
                return 1;
            }
            if (s2 != null) {
                return -1;
            }
        }
        return 0;
    }

    private static int compareAddressScore(InternalScoringAddress c1, InternalScoringAddress c2) {
        double diff = c1.getCombinedScore() - c2.getCombinedScore();
        if (c1.getDictionaryUsagePriority() != c2.getDictionaryUsagePriority() && Math.abs(diff) < 0.005) {
            diff = 0.0;
        }
        if (diff > 0.0) {
            return 1;
        }
        if (diff < 0.0) {
            return -1;
        }
        return 0;
    }

    private static int comparePostAddress(InternalScoringAddress c1, InternalScoringAddress c2) {
        double diff = c1.getCombinedPostalScore() - c2.getCombinedPostalScore();
        if (c1.getDictionaryUsagePriority() != c2.getDictionaryUsagePriority() && Math.abs(diff) < 0.005) {
            diff = 0.0;
        }
        if (diff != 0.0) {
            return diff > 0.0 ? 1 : -1;
        }
        int d = COLInternalScoringAddressComparator.compareFieldScores(c1.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE), c2.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE));
        if (d == 0) {
            d = COLInternalScoringAddressComparator.compareFieldScores(c1.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE), c2.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE));
        }
        if (d == 0) {
            d = COLInternalScoringAddressComparator.compareFieldScores(c1.getFieldScore(FieldType.POST_CODE_FIELD_TYPE), c2.getFieldScore(FieldType.POST_CODE_FIELD_TYPE));
        }
        if (d == 0) {
            d = COLInternalScoringAddressComparator.compareFieldScores(c1.getFieldScore(FieldType.POST_CODE_FIELD_TYPE), c2.getFieldScore(FieldType.POST_CODE_FIELD_TYPE));
        }
        return d;
    }

    private static int compareFieldScores(FieldScore s1, FieldScore s2) {
        if (s1 != null && s2 != null) {
            int d = s1.compare(s1, s2);
            if (d == 0) {
                int m1 = s1.m_perfectCandWords == null ? 0 : s1.m_perfectCandWords.size();
                int m2 = s2.m_perfectCandWords == null ? 0 : s2.m_perfectCandWords.size();
                return m1 - m2;
            }
            return d;
        }
        return 0;
    }

    private static int compareStreetAddress(InternalScoringAddress c1, InternalScoringAddress c2) {
        double diff = c1.getCombinedStreetScore() - c2.getCombinedStreetScore();
        if (diff > 0.0) {
            return 1;
        }
        if (diff < 0.0) {
            return -1;
        }
        return 0;
    }

    private static int compareAddressNumber(InternalScoringAddress c1, InternalScoringAddress c2) {
        int rangeSize1 = c1.getRangeCount();
        int rangeSize2 = c2.getRangeCount();
        if (rangeSize1 > 0 && rangeSize2 > 0) {
            AddressNumberScore score1 = (AddressNumberScore)c1.getRangeAt(0).getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
            AddressNumberScore score2 = (AddressNumberScore)c2.getRangeAt(0).getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
            if (score1 != null && score2 != null) {
                return score1.compare(score1, score2);
            }
        }
        return 0;
    }

    private static int compareMatchedWordsCount(InternalScoringAddress addr1, InternalScoringAddress addr2) {
        return 0;
    }

    private static int compareRangeScores(InternalScoringAddress c1, InternalScoringAddress c2) {
        int rangeSize1 = c1.getRangeCount();
        int rangeSize2 = c2.getRangeCount();
        if (rangeSize1 > 0 && rangeSize2 > 0) {
            double combScore2;
            double combScore1 = c1.getRangeAt(0).getCombinedScore();
            if (combScore1 != (combScore2 = c2.getRangeAt(0).getCombinedScore())) {
                if (combScore1 > combScore2) {
                    return 1;
                }
                return -1;
            }
        } else {
            if (rangeSize1 > 0 && c1.getRangeAt(0).getCombinedScore() > 0.0) {
                return 1;
            }
            if (rangeSize2 > 0 && c2.getRangeAt(0).getCombinedScore() > 0.0) {
                return -1;
            }
        }
        return 0;
    }
}

