/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.COL.parser;

import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParserTerms;
import com.mapinfo.mapmarker.cgge.parser.ICGGEThoroughfareTypeHandler;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class COL_Parser
extends CGGEParser1 {
    private static final FieldType secondaryStreetField = FieldType.GENERIC_FIELD_3_FIELD_TYPE;
    private static final int mainStreetGroup;
    private static final int secondaryStreetGroup;
    private static final int addrNumberGroup;
    private static final Pattern streetNumPat;
    private static final Pattern addrNumPat;
    private static final Pattern fullStreetPat;
    private static final Pattern noForPoundPat;
    private Pattern streetNumWithTypePat;
    private Pattern nonNumericStreetPat;
    private static Pattern noTypeStreetPat1;
    private static Pattern noTypeStreetPat2;
    private static final String streetNumPatStr = "(\\d{1,4}\\s?([A-Z]{1,2}\\d*)?(BIS[A-Z]{0,2}|NOROESTE|SUROESTE|SUDOESTE|NORESTE|SURESTE|SUDESTE|SUD|SUR|OESTE|NORTE|ESTE|NE|NO|SE|SO|N|E|S|O|\\s)*\\b)";
    private static final String addressNumPatStr = "(\\d+[A-Z]?\\b)";
    private static final String noForPoundPatStr = "(NO\\.?\\s*)(\\d+)";
    private static String noTypeStreetPat1String;
    private static String noTypeStreetPat2String;
    private static final List<FieldType> locFields;

    @Override
    public boolean init(String country, String language) {
        boolean b = super.init(country, language);
        this.initialiseLocalPatterns();
        return b;
    }

    private void initialiseLocalPatterns() {
        String tftPatStr = this.getThorougfareTypePatternString();
        if (tftPatStr != null) {
            StringBuilder sb = new StringBuilder();
            sb.append(tftPatStr);
            sb.append("\\s*");
            sb.append(streetNumPatStr);
            this.streetNumWithTypePat = Pattern.compile(sb.toString());
            sb = new StringBuilder();
            sb.append(tftPatStr);
            sb.append("\\s*");
            sb.append("(\\p{L}|\\s)*");
            this.nonNumericStreetPat = Pattern.compile(sb.toString());
        }
    }

    private String getThorougfareTypePatternString() {
        List<String> typeList = this.getThoroughfareTypeHandler().getAllThoroughfareTypes();
        if (typeList != null && !typeList.isEmpty()) {
            typeList = new ArrayList<String>(typeList);
            Collections.sort(typeList, new Comparator<String>(){

                @Override
                public int compare(String o1, String o2) {
                    int c = o2.length() - o1.length();
                    return c == 0 ? o1.compareTo(o2) : c;
                }
            });
            StringBuilder sb = new StringBuilder();
            sb.append("\\b(");
            for (String type : typeList) {
                sb.append(type);
                sb.append("|");
            }
            sb.deleteCharAt(sb.length() - 1);
            sb.append(")\\b");
            return sb.toString();
        }
        return null;
    }

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        ParsedAddress[] parsedAddrs = super.parse(inputAddress, scorer);
        if (parsedAddrs.length > 0 && parsedAddrs[0].getProbableAddressNumbers() != null) {
            parsedAddrs[0].setProbableAddressNumbers(null);
        }
        this.fillStreetElementsInParsedAddress(inputAddress, parsedAddrs[0]);
        this.createAlphaNumericAlternates(parsedAddrs[0]);
        return parsedAddrs;
    }

    void fillStreetElementsInParsedAddress(InputAddress inputAddress, ParsedAddress parsedAddress) {
        String nonStreetElements;
        InputAddress cleanedInputAddress = this.getCleanedInputAddress(inputAddress);
        String secondaryStreet = (String)cleanedInputAddress.getField(secondaryStreetField);
        if (secondaryStreet != null) {
            parsedAddress.setField(secondaryStreetField, this.getAddressWords(secondaryStreet));
        }
        if ((nonStreetElements = (String)cleanedInputAddress.getField(FieldType.GENERIC_FIELD_1_FIELD_TYPE)) != null) {
            parsedAddress.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, this.getAddressWords(nonStreetElements));
        }
    }

    void createAlphaNumericAlternates(ParsedAddress parsedAddress) {
        AddressWord[] mainStreetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        ArrayList<AddressWord> alts = new ArrayList<AddressWord>();
        ICGGESoundex soundex = this.getSoundex();
        if (mainStreetWords != null) {
            StringBuilder sb = new StringBuilder();
            for (AddressWord word : mainStreetWords) {
                if (CodedWord.isNumber(word.getAttributes())) {
                    sb.setLength(0);
                    sb.append(word.getWordChars());
                    alts.add(this.convertToAddressWord(sb.toString(), soundex));
                    continue;
                }
                if (Character.isDigit(word.getWord().charAt(0))) {
                    int i = 0;
                    char[] chars = word.getWordChars();
                    sb.setLength(0);
                    while (Character.isDigit(chars[i])) {
                        sb.append(chars[i]);
                        ++i;
                    }
                    alts.add(this.convertToAddressWord(sb.toString(), soundex));
                    continue;
                }
                if (sb.length() <= 0) continue;
                StringBuilder sb2 = new StringBuilder(sb);
                String str = word.getWord().trim();
                sb.append(str);
                alts.add(this.convertToAddressWord(sb.toString(), soundex));
                if (str.length() <= 2 || !this.getParserTerms().isDirectionalWord(str)) continue;
                sb2.append(str.charAt(0));
                alts.add(this.convertToAddressWord(sb2.toString(), soundex));
            }
        }
        if (!alts.isEmpty()) {
            parsedAddress.setField(FieldType.GENERIC_FIELD_2_FIELD_TYPE, alts.toArray(new AddressWord[alts.size()]));
        }
    }

    @Override
    protected InputAddress getCleanedInputAddress(InputAddress inAddr) {
        this.replaceDoubleSpeledOutDirs(inAddr);
        inAddr = super.getCleanedInputAddress(inAddr);
        this.replaceNOBeforeNmber(inAddr);
        this.replaceDotsAndCommas(inAddr);
        this.separateStreetElements(inAddr);
        return inAddr;
    }

    private String replaceSUR_PatternFromString(String inputString) {
        if (!StringUtilities.isEmpty((String)inputString)) {
            inputString = inputString.toUpperCase().replaceAll("\\b SUR\\b\\s+SUR\\b", " SUR");
            inputString = inputString.toUpperCase().replaceAll("\\b SUR\\b", "S");
        }
        return inputString;
    }

    private void replaceDotsAndCommas(InputAddress inAddr) {
        String str = (String)inAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (!StringUtilities.isEmpty((String)str)) {
            str = str.replaceAll("\\.|,", " ");
        }
        inAddr.setField(FieldType.STREET_NAME_FIELD_TYPE, str);
    }

    private void replaceNOBeforeNmber(InputAddress inAddr) {
        Matcher m;
        String str = (String)inAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (!StringUtilities.isEmpty((String)str) && (m = noForPoundPat.matcher(str)).find()) {
            String repl = "#" + m.group(2);
            str = str.replaceAll("NO\\.?\\s*\\d+", repl);
            inAddr.setField(FieldType.STREET_NAME_FIELD_TYPE, str);
        }
    }

    private void replaceDoubleSpeledOutDirs(InputAddress inAddr) {
        String str = (String)inAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (!StringUtilities.isEmpty((String)str)) {
            str = str.toUpperCase().replaceAll("\\b SUD\\b\\s+SUR\\b", " SUD");
            str = str.toUpperCase().replaceAll("\\b SUR\\b\\s+SUR\\b", " SUR");
            str = str.toUpperCase().replaceAll("\\b NORTE\\b\\s+NORTE\\b", " NORTE");
            str = str.toUpperCase().replaceAll("\\b ESTE\\b\\s+ESTE\\b", " ESTE");
            str = str.toUpperCase().replaceAll("\\b OESTE\\b\\s+OESTE\\b", " OESTE");
            inAddr.setField(FieldType.STREET_NAME_FIELD_TYPE, str);
        }
    }

    void separateStreetElements(InputAddress inAddr) {
        if (inAddr != null && !inAddr.isEmpty(FieldType.STREET_NAME_FIELD_TYPE)) {
            String street = (String)inAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
            int streetEnd = this.separateStreetElements(inAddr, street);
            if (streetEnd < 0) {
                streetEnd = this.doAlternateSeprateStreetElements(inAddr, street);
            }
            if (streetEnd < 0) {
                streetEnd = this.doNoKnownTypeSeparateStreetElements(inAddr, street);
            }
            if (streetEnd > -1) {
                this.splitNonStreetElements(street, streetEnd, inAddr);
            }
        }
    }

    private int doAlternateSeprateStreetElements(InputAddress inAddr, String street) {
        int lastMatchedChar = -1;
        Matcher m = this.nonNumericStreetPat.matcher(street);
        boolean patternFound = m.find();
        Matcher m1 = this.streetNumWithTypePat.matcher(street);
        boolean patternFound1 = m1.find();
        if (patternFound && patternFound1) {
            if (m1.start() <= m.start()) {
                m = m1;
            }
        } else if (patternFound1) {
            patternFound = patternFound1;
            m = m1;
        }
        if (patternFound) {
            inAddr.setField(FieldType.STREET_NAME_FIELD_TYPE, m.group().trim());
            lastMatchedChar = m.end();
            int fullStreetEnd = this.findSecondaryStreetAndHNR(inAddr, street, lastMatchedChar);
            if (fullStreetEnd > lastMatchedChar) {
                lastMatchedChar = fullStreetEnd;
            }
        }
        return lastMatchedChar;
    }

    private int findSecondaryStreetAndHNR(InputAddress inAddr, String street, int startFrom) {
        Matcher m = this.streetNumWithTypePat.matcher(street.substring(startFrom));
        boolean patternFound = m.find();
        int lastMatchedChar = -1;
        if (!patternFound) {
            m = addrNumPat.matcher(street.substring(startFrom));
            patternFound = m.find();
        }
        if (patternFound) {
            inAddr.setField(secondaryStreetField, m.group().trim());
            lastMatchedChar = startFrom + m.end();
            if (inAddr.isEmpty(FieldType.ADDRESS_NUMBER_FIELD_TYPE) && (m = addrNumPat.matcher(street.substring(lastMatchedChar))).find() && (m.start() == 0 || this.areSeparators(street, lastMatchedChar, lastMatchedChar + m.start()))) {
                inAddr.setField(FieldType.ADDRESS_NUMBER_FIELD_TYPE, m.group(0));
                lastMatchedChar += m.end();
            }
        }
        return lastMatchedChar;
    }

    private boolean areSeparators(String str, int start, int end) {
        ICGGEParserTerms pt = this.getParserTerms();
        for (int charNdx = start; charNdx < end; ++charNdx) {
            if (pt.isDelimiter(str.charAt(charNdx))) continue;
            return false;
        }
        return true;
    }

    private int findFirstThoroughfareTypeStartPosition(String street) {
        int charsChecked = 0;
        ICGGEThoroughfareTypeHandler tth = this.getThoroughfareTypeHandler();
        String[] words = MMUtils.splitString(street, this.getParserTerms().getDelimiters(), true);
        if (words != null) {
            for (String word : words) {
                if (tth.isThoroughfareType(word)) {
                    return charsChecked;
                }
                charsChecked += word.length();
            }
        }
        return -1;
    }

    int separateStreetElements(InputAddress inAddr, String str) {
        Matcher m;
        if (!MMUtils.isEmpty(str) && (m = fullStreetPat.matcher(str)).find() && this.findFirstThoroughfareTypeStartPosition(str) == m.start()) {
            inAddr.setField(FieldType.STREET_NAME_FIELD_TYPE, m.group(mainStreetGroup));
            inAddr.setField(secondaryStreetField, m.group(secondaryStreetGroup));
            if (inAddr.isEmpty(FieldType.ADDRESS_NUMBER_FIELD_TYPE)) {
                inAddr.setField(FieldType.ADDRESS_NUMBER_FIELD_TYPE, m.group(addrNumberGroup));
            }
            return m.end();
        }
        return -1;
    }

    protected int doNoKnownTypeSeparateStreetElements(InputAddress inAddr, String str) {
        if (!MMUtils.isEmpty(str)) {
            Matcher m = noTypeStreetPat1.matcher(str);
            int secondaryStGroupNum = 3;
            int houseGroupNum = 4;
            int LLPat = 5;
            boolean matched = m.find();
            boolean usingPat1 = true;
            if (!matched && (matched = (m = noTypeStreetPat2.matcher(str)).find())) {
                usingPat1 = false;
                LLPat = 4;
            }
            if (matched) {
                if (m.end() == str.length()) {
                    String street = str.substring(0, m.start());
                    inAddr.setField(FieldType.STREET_NAME_FIELD_TYPE, street);
                    inAddr.setField(secondaryStreetField, m.group(secondaryStGroupNum));
                    if (inAddr.isEmpty(FieldType.ADDRESS_NUMBER_FIELD_TYPE) && usingPat1) {
                        inAddr.setField(FieldType.ADDRESS_NUMBER_FIELD_TYPE, m.group(houseGroupNum));
                    }
                }
                if (usingPat1 && m.group(LLPat) == null) {
                    if (m.group(houseGroupNum) != null) {
                        return m.end(houseGroupNum);
                    }
                    return m.end(secondaryStGroupNum);
                }
                if (!usingPat1 && m.group(LLPat) == null) {
                    return m.end(secondaryStGroupNum);
                }
                return m.start(LLPat);
            }
        }
        return -1;
    }

    void splitNonStreetElements(String str, int splitAt, InputAddress inAddr) {
        if (splitAt < str.length()) {
            String nonStreetElements = str.substring(splitAt).trim();
            if (this.isSingleLineInput(inAddr)) {
                nonStreetElements = this.checkWhetherPostAddressContainsHouseNumAndSecondaryStreet(inAddr, nonStreetElements);
                inAddr.setField(FieldType.POST_ADDRESS_FIELD_TYPE, nonStreetElements);
            } else {
                inAddr.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, nonStreetElements);
            }
        }
    }

    String checkWhetherPostAddressContainsHouseNumAndSecondaryStreet(InputAddress inAddr, String nonStreetElements) {
        Pattern postAddressPattern;
        Matcher postAddressMatcher;
        if (null != inAddr && (postAddressMatcher = (postAddressPattern = Pattern.compile("(([A-Z])\\s*[A-Z]*\\s*)-\\s*(\\d+)", 2)).matcher(nonStreetElements)).find()) {
            nonStreetElements = nonStreetElements.substring(postAddressMatcher.end()).trim();
            inAddr.setField(secondaryStreetField, postAddressMatcher.group(1));
            inAddr.setField(FieldType.ADDRESS_NUMBER_FIELD_TYPE, postAddressMatcher.group(3));
        }
        return nonStreetElements;
    }

    boolean isSingleLineInput(InputAddress inAddr) {
        if (inAddr != null) {
            for (FieldType locField : locFields) {
                if (inAddr.isEmpty(locField)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    static {
        noTypeStreetPat1String = "((#?\\s*)(\\d+[A-Z]*)(\\s+\\d+|\\s*-\\s*\\d+)(\\s+[A-Z]{3,})?)$";
        noTypeStreetPat2String = "((#?\\s*)(\\d+[A-Z]*)(\\s+[A-Z]{3,})?)$";
        locFields = Arrays.asList(FieldType.POST_CODE_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.POST_ADDRESS_FIELD_TYPE);
        noTypeStreetPat1 = Pattern.compile(noTypeStreetPat1String, 2);
        noTypeStreetPat2 = Pattern.compile(noTypeStreetPat2String, 2);
        streetNumPat = Pattern.compile(streetNumPatStr);
        addrNumPat = Pattern.compile(addressNumPatStr);
        fullStreetPat = Pattern.compile("((\\p{L}+\\s)(\\d{1,4}\\s?([A-Z]{1,2}\\d*)?(BIS[A-Z]{0,2}|NOROESTE|SUROESTE|SUDOESTE|NORESTE|SURESTE|SUDESTE|SUD|SUR|OESTE|NORTE|ESTE|NE|NO|SE|SO|N|E|S|O|\\s)*\\b))(NO|N\u00ba|N|#|$|\\s|-)*(\\d{1,4}\\s?([A-Z]{1,2}\\d*)?(BIS[A-Z]{0,2}|NOROESTE|SUROESTE|SUDOESTE|NORESTE|SURESTE|SUDESTE|SUD|SUR|OESTE|NORTE|ESTE|NE|NO|SE|SO|N|E|S|O|\\s)*\\b)(\\s|-)*(\\d+[A-Z]?\\b)?", 2);
        mainStreetGroup = 1;
        secondaryStreetGroup = 7;
        addrNumberGroup = 11;
        noForPoundPat = Pattern.compile(noForPoundPatStr);
    }
}

