/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CZE.convertor;

import com.mapinfo.mapmarker.CZE.address.CZE_AddressNumber;
import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.convertor.CGGECandidateConvertor;
import com.mapinfo.mapmarker.cgge.convertor.CGGEFormatter;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;

public class CZE_CandidateConverter
extends CGGECandidateConvertor {
    @Override
    protected CandidateAddress convertCandidate(InternalScoringAddress scoringAddress, IDataManager dataManager, CGGEFormatter formatter, IConstraints constraints) throws Exception {
        AddressNumber addrNum;
        CandidateAddress candAddr = super.convertCandidate(scoringAddress, dataManager, formatter, constraints);
        if (candAddr.fromUserDictionary() && candAddr.getCountry().equalsIgnoreCase("CZE")) {
            candAddr.setGenericField1(null);
        }
        if (scoringAddress.getRangeCount() > 0 && scoringAddress.getRangeAt(0) != null && (AddressNumberScore)scoringAddress.getRangeAt(0).getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE) != null && (addrNum = ((AddressNumberScore)scoringAddress.getRangeAt(0).getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE)).getInputAddressNumber()) != null && addrNum instanceof CZE_AddressNumber) {
            CZE_AddressNumber czeAddressNumber = (CZE_AddressNumber)addrNum;
            if (czeAddressNumber.isCISORExactlyMatched()) {
                candAddr.addKeyValueToAdditionalFields("CIS_OR", String.valueOf(addrNum.getHnrNumber2()));
                if (czeAddressNumber.isPISORExactlyMatched()) {
                    candAddr.addKeyValueToAdditionalFields("PIS_OR", addrNum.getHnrSuffix2());
                }
            }
            if (czeAddressNumber.isCISDOMExactlyMatched()) {
                candAddr.addKeyValueToAdditionalFields("CIS_DOM", String.valueOf(addrNum.getHnrNumber1()));
            }
            candAddr.setPlaceName(null);
        }
        return candAddr;
    }
}

