/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CZE.matcher;

import com.mapinfo.mapmarker.CZE.address.CZE_AddressNumber;
import com.mapinfo.mapmarker.CZE.address.CZE_ParsedAddress;
import com.mapinfo.mapmarker.CZE.parser.CZE_Parser;
import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.CGGEHandler;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.InternalUnitAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.matcher.CGGEInternalScoringAddressComparator;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CZE_Matcher1
extends CGGEMatcher1 {
    @Override
    protected void calculateCombinedPostAddressScore(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, MatchingOptions matchOptions) {
        double scorePossible = 0.0;
        double postScore = 0.0;
        int inputFieldsAvailable = 0;
        int inputFieldsMatched = 0;
        int candFieldsAvailable = this.weightedFieldWeightsAtLevel(scoringAddr, FieldType.FieldLevel.LEVEL_POSTAL, matchOptions);
        int candFieldsScored = 0;
        double totalScoredFieldWeight = 0.0;
        int parsedFieldCount = parsedAddr.getFields() == null ? 0 : parsedAddr.getFields().size();
        ArrayList<AddressWord[]> matchedInputWords = new ArrayList<AddressWord[]>(parsedFieldCount);
        boolean hasSeperatePostalFields = this.hasSeperateAreaFields(parsedAddr);
        double missingFieldsWeight = 0.0;
        Map<FieldType, FieldScore> fieldScores = scoringAddr.getFieldScores();
        if (fieldScores != null && fieldScores.size() > 0) {
            for (Map.Entry<FieldType, FieldScore> entry : fieldScores.entrySet()) {
                FieldType type = entry.getKey();
                FieldScore fieldScore = entry.getValue();
                if (type == FieldType.POST_ADDRESS_FIELD_TYPE) {
                    if (matchedInputWords.contains(fieldScore.m_inputWords)) continue;
                    matchedInputWords.add(fieldScore.m_inputWords);
                    ++inputFieldsAvailable;
                    continue;
                }
                if (fieldScore == null || type.getLevel() != FieldType.FieldLevel.LEVEL_POSTAL) continue;
                ++candFieldsScored;
                double fieldWeight = matchOptions.getFieldWeight(type);
                if (!(fieldWeight > 0.0)) continue;
                boolean acceptScore = CZE_Matcher1.acceptScore(fieldScore, type, matchOptions);
                if (acceptScore || this.inputFieldPresent(fieldScore)) {
                    totalScoredFieldWeight += fieldWeight;
                    if (acceptScore) {
                        scorePossible += fieldWeight;
                        postScore += fieldScore.m_value * fieldWeight;
                    } else if (!matchOptions.isOptionalField(type) && FieldType.GENERIC_FIELD_1_FIELD_TYPE != type) {
                        missingFieldsWeight += fieldWeight;
                    }
                    if (hasSeperatePostalFields) {
                        ++inputFieldsAvailable;
                        if (fieldScore.m_matched && this.areNonPerfectWordsIgnorable(fieldScore)) {
                            ++inputFieldsMatched;
                        }
                    }
                }
                if (fieldScore.m_inputWords == null || matchedInputWords.contains(fieldScore.m_inputWords)) continue;
                matchedInputWords.add(fieldScore.m_inputWords);
            }
        }
        int[] matchWordStats = this.getInputWordMatchStats(matchedInputWords, scoringAddr);
        int inputWordCount = matchWordStats[0];
        int matchedWordCount = matchWordStats[1];
        if (missingFieldsWeight > 0.0) {
            scorePossible = !hasSeperatePostalFields && matchedWordCount < inputWordCount && !this.areNonMatchedWordsIgnorable(matchedInputWords, scoringAddr) ? (scorePossible += missingFieldsWeight * 0.25) : (scorePossible += missingFieldsWeight * 0.1);
        } else if (candFieldsAvailable > candFieldsScored && !hasSeperatePostalFields) {
            double missingWeight = this.combineFieldWeightsAtLevel(scoringAddr, FieldType.FieldLevel.LEVEL_POSTAL, matchOptions);
            if ((missingWeight -= totalScoredFieldWeight) > 0.0) {
                scorePossible *= 1.0 + missingWeight * 0.2;
            }
        }
        if (inputFieldsAvailable > 0 && inputFieldsMatched < inputFieldsAvailable) {
            double maxWeight = Math.min(matchOptions.getMatchedFieldWeight() * (double)inputFieldsAvailable, 0.15);
            scorePossible += maxWeight;
            postScore += (double)inputFieldsMatched / (double)inputFieldsAvailable * maxWeight;
        }
        if (inputWordCount > 0 && matchedWordCount < inputWordCount) {
            double maxWeight = Math.min(matchOptions.getMatchedWordWeight() * (double)inputWordCount, 0.1);
            scorePossible += maxWeight;
            postScore += (double)matchedWordCount / (double)inputWordCount * maxWeight;
        }
        if (scoringAddr.getDataSetInfo().getMetaData().isUserDictionary() && inputWordCount > 0 && matchedWordCount == inputWordCount && parsedAddr.isSeperatePostAddressFields() && parsedAddr.getField(FieldType.POST_CODE_FIELD_TYPE) != null && !parsedAddr.isIntersectionCase()) {
            double maxWeight = Math.min(matchOptions.getMatchedWordWeight() * (double)inputWordCount, 0.1);
            scorePossible += maxWeight;
            postScore += 0.5 * maxWeight;
        }
        if (candFieldsScored == 0) {
            double missingWeight = this.combineFieldWeightsAtLevel(scoringAddr, FieldType.FieldLevel.LEVEL_POSTAL, matchOptions);
            if (missingWeight <= 1.0E-6) {
                scoringAddr.setCombinedPostalScore(1.0);
            }
        } else if (scorePossible > 0.0) {
            scoringAddr.setCombinedPostalScore(postScore / scorePossible);
        } else {
            scoringAddr.setCombinedPostalScore(0.0);
        }
    }

    private String getCIS_ORValue(AddressWord[] words) {
        int wordLen = words == null ? 0 : words.length;
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < wordLen; ++i) {
            AddressWord word = words[i];
            builder.append(word.getWord());
        }
        return builder.toString();
    }

    @Override
    protected void scoreRangeAddressNumber(InternalScoringAddress scoringAddr, InternalScoringRange scoringRange, ParsedAddress pAddrress, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        CZE_ParsedAddress pAddr = null;
        if (pAddrress instanceof CZE_ParsedAddress) {
            pAddr = (CZE_ParsedAddress)pAddrress;
        }
        AddressNumberScore addrNumScore = new AddressNumberScore();
        InternalRangeAddress internalRange = scoringRange.getRange();
        if (pAddr != null && internalRange.getDataSetInfo().getMetaData().isUserDictionary() && (pAddr.isCISDOMPresent() || pAddr.isCISORPresent()) && (internalRange.getFrom() != null || internalRange.getTo() != null)) {
            double cis_dom_Score = 0.0;
            double cis_or_Score = 0.0;
            boolean isScoringAddressANumericStreet = false;
            CZE_Parser parser = (CZE_Parser)CGGEHandler.getInstance(this.getDataSetInfo(), pAddrress.getCountry(), pAddrress.getLanguage()).getParser();
            String candidateStreetName = "";
            InternalFieldValue streetNameValue = (InternalFieldValue)scoringAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
            if (streetNameValue != null) {
                candidateStreetName = parser.reconstructFieldValue((AddressWord[])streetNameValue.getFieldValue());
            }
            if (StringUtilities.hasNumeric((String)candidateStreetName)) {
                isScoringAddressANumericStreet = true;
            }
            CZE_AddressNumber hnr = new CZE_AddressNumber();
            String CIS_Dom = pAddr.getProbableCISDOM();
            String CIS_or = pAddr.getProbableCISOR();
            String pis_or = pAddr.getProbablePISOR();
            double baseScore = 0.0;
            double score = 0.0;
            if (pAddr.isCISDOMPresent() && !pAddr.isCISORPresent()) {
                baseScore += 1.0;
                double bestscore = score = (cis_dom_Score = this.scoreCIS_DOM(scorer, internalRange, CIS_Dom, hnr));
                if (score < 1.0) {
                    score = cis_or_Score = this.scoreCIS_OR(scorer, internalRange, CIS_Dom, hnr);
                }
                if (bestscore > score) {
                    score = bestscore;
                    cis_or_Score = 0.0;
                } else {
                    cis_dom_Score = 0.0;
                }
            } else {
                if (!StringUtilities.isEmpty((String)CIS_Dom)) {
                    baseScore += 1.0;
                    cis_dom_Score = score = this.scoreCIS_DOM(scorer, internalRange, CIS_Dom, hnr);
                }
                if (!StringUtilities.isEmpty((String)CIS_or)) {
                    baseScore += 1.0;
                    cis_or_Score = this.scoreCIS_OR(scorer, internalRange, CIS_or, hnr);
                    score += cis_or_Score;
                }
                if (!StringUtilities.isEmpty((String)pis_or) && internalRange.getUnits() != null && internalRange.getUnits().get(0) != null) {
                    baseScore += 1.0;
                    InternalUnitAddress unitAddres = internalRange.getUnits().get(0);
                    for (FieldType type : unitAddres.getFields().keySet()) {
                        InternalFieldValue fieldvalue = (InternalFieldValue)unitAddres.getField(type);
                        if (!"unit_place_name".equalsIgnoreCase(type.getName()) || fieldvalue == null) continue;
                        String value = this.getCIS_ORValue((AddressWord[])fieldvalue.getFieldValue());
                        if (!StringUtilities.isEmpty((String)value) && pis_or.equalsIgnoreCase(value)) {
                            hnr.setPISORExactlyMatched(true);
                            score += 1.0;
                        }
                        hnr.setHnrSuffix2(pis_or);
                    }
                }
            }
            addrNumScore.m_inputFieldPresent = true;
            double finalScore = score / baseScore;
            if (finalScore == 1.0) {
                addrNumScore.setNumber1Matched(true);
                addrNumScore.setMatched(true);
                addrNumScore.setTypeMatch(true);
            } else if (isScoringAddressANumericStreet) {
                double newScore = 0.0;
                if (cis_dom_Score < 1.0 && cis_dom_Score > 0.0 && !StringUtilities.isEmpty((String)CIS_Dom) && candidateStreetName.indexOf(CIS_Dom) > -1) {
                    baseScore -= 1.0;
                    newScore = score - cis_dom_Score;
                }
                if (cis_or_Score < 1.0 && cis_or_Score > 0.0 && !StringUtilities.isEmpty((String)CIS_or) && candidateStreetName.indexOf(CIS_or) > -1) {
                    baseScore -= 1.0;
                    newScore = score - cis_or_Score;
                }
                if ((finalScore = newScore / baseScore) == 1.0) {
                    addrNumScore.setNumber1Matched(true);
                    addrNumScore.setMatched(true);
                    addrNumScore.setTypeMatch(true);
                }
            }
            addrNumScore.setInputAddressNumber(hnr);
            this.calculateOffSet(hnr, scoringRange, addrNumScore);
            if (hnr.getHnrNumber1() == 0 && !StringUtilities.isEmpty((String)CIS_or)) {
                hnr.setHnrNumber1(Integer.valueOf(CIS_or));
            }
            scoringRange.setFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE, addrNumScore);
        } else {
            super.scoreRangeAddressNumber(scoringAddr, scoringRange, pAddrress, matchingOptions, scorer);
        }
    }

    private double scoreCIS_OR(ICGGEScorer scorer, InternalRangeAddress internalRange, String CIS_or, CZE_AddressNumber addressNumber) {
        double score = 0.0;
        if ((score += scorer.scoreNumber(Integer.valueOf(CIS_or), this.getCISORValue(internalRange))) == 1.0) {
            addressNumber.setCISORExactlyMatched(true);
        }
        addressNumber.setHnrNumber2(Integer.valueOf(CIS_or));
        return score;
    }

    private int getCISORValue(InternalRangeAddress internalRange) {
        int cis_or = 0;
        Iterator<FieldType> iter = internalRange.getFields().keySet().iterator();
        double score = 0.0;
        while (iter.hasNext()) {
            String value;
            FieldType type = iter.next();
            InternalFieldValue fieldvalue = (InternalFieldValue)internalRange.getField(type);
            if (!"range_place_name".equalsIgnoreCase(type.getName()) || fieldvalue == null || StringUtilities.isEmpty((String)(value = this.getCIS_ORValue((AddressWord[])fieldvalue.getFieldValue())))) continue;
            cis_or = Integer.valueOf(value);
        }
        return cis_or;
    }

    private double scoreCIS_DOM(ICGGEScorer scorer, InternalRangeAddress internalRange, String CIS_Dom, CZE_AddressNumber addressNumber) {
        double score = scorer.scoreNumber(Integer.valueOf(CIS_Dom), internalRange.getFrom().getHnrNumber1());
        if (score == 1.0) {
            addressNumber.setCISDOMExactlyMatched(true);
        }
        addressNumber.setHnrNumber1(Integer.valueOf(CIS_Dom));
        return score;
    }

    private AddressNumber getCISDomAndCISOrCombinationHouseNumber(List<AddressNumber> list) {
        AddressNumber addrNum = null;
        for (AddressNumber addressNumber : list) {
            if (addressNumber.getHnrNumber1() <= 0 || addressNumber.getHnrNumber2() <= 0) continue;
            addrNum = addressNumber;
            break;
        }
        return addrNum;
    }

    private void calculateOffSet(AddressNumber inputNumber, InternalScoringRange range, AddressNumberScore addrNumScore) {
        int num1 = inputNumber.getHnrNumber1();
        int num2 = inputNumber.getHnrNumber2();
        AddressNumber fromNumber = range.getFrom();
        int from = fromNumber.getHnrNumber1();
        int to = this.getCISORValue(range.getRange());
        boolean isCIS_DOMMatched = ((CZE_AddressNumber)inputNumber).isCISDOMExactlyMatched();
        boolean isCIS_ORMatched = ((CZE_AddressNumber)inputNumber).isCISORExactlyMatched();
        if (isCIS_DOMMatched || isCIS_ORMatched) {
            addrNumScore.setOffset(0);
        } else {
            int offset1 = 0;
            int offset2 = 0;
            if (from > 0 && num1 > 0) {
                offset1 = Math.abs(num1 - from);
            } else if (num2 > 0) {
                offset2 = Math.abs(num2 - to);
            }
            if (offset1 > 0 && offset2 > 0) {
                addrNumScore.setOffset(Math.min(offset1, offset2));
            } else if (offset1 > 0) {
                addrNumScore.setOffset(offset1);
            } else if (offset2 > 0) {
                addrNumScore.setOffset(offset2);
            }
        }
        addrNumScore.setOffsetPosition(1);
    }

    @Override
    protected void calculateCombinedRangeScore(InternalScoringRange scoringRange, ParsedAddress parsedAddr, MatchingOptions matchingOptions) {
        AddressNumberScore addrScore = (AddressNumberScore)scoringRange.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        CZE_ParsedAddress pAddr = null;
        if (parsedAddr instanceof CZE_ParsedAddress) {
            pAddr = (CZE_ParsedAddress)parsedAddr;
        }
        double scorePossible = 0.0;
        double rangeScore = 0.0;
        if (pAddr != null && scoringRange.getDataSetInfo().getMetaData().isUserDictionary() && (pAddr.isCISDOMPresent() || pAddr.isCISORPresent())) {
            double addrNumWeight = matchingOptions.getFieldWeight(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
            if (addrScore != null && addrScore.m_inputFieldPresent && addrNumWeight > 0.0) {
                scorePossible = addrNumWeight;
                double hnrScore = 0.0;
                if (addrScore.isMatched() || addrScore.getOffset() == 0) {
                    hnrScore = pAddr.isPISORPresent() ? (((CZE_AddressNumber)addrScore.getInputAddressNumber()).isPISORExactlyMatched() ? 1.0 : 0.99) : 1.0;
                } else {
                    double maxOffsetAllowed;
                    int offset = addrScore.getOffset();
                    if (addrScore.isTypeMatch()) {
                        hnrScore += 0.46;
                    }
                    if (offset > 0 && (maxOffsetAllowed = (double)matchingOptions.getMaxAddressNumberOffsetAllowed()) > 0.0 && (double)offset < maxOffsetAllowed) {
                        double d = (maxOffsetAllowed - (double)addrScore.getOffset()) / maxOffsetAllowed;
                        hnrScore += d * 0.45;
                    }
                }
                rangeScore = hnrScore * addrNumWeight;
            }
            if (scorePossible > 0.0) {
                scoringRange.setCombinedScore(rangeScore / scorePossible);
            } else {
                scoringRange.setCombinedScore(0.0);
            }
        } else {
            super.calculateCombinedRangeScore(scoringRange, parsedAddr, matchingOptions);
        }
    }

    @Override
    public void mergeCandidates(InternalCandidateList candList1, InternalCandidateList candList2) {
        int candCount1 = candList1.getCandidateCount();
        int candCount2 = candList2.getCandidateCount();
        int closeMatchCount = 0;
        if (candCount1 == 0) {
            List<InternalScoringAddress> internalList2 = candList2.getCandidateList();
            LinkedList<InternalScoringAddress> tempCombinedList = new LinkedList<InternalScoringAddress>();
            int ndx = 0;
            for (int i = 0; i < candCount2; ++i) {
                InternalScoringAddress scoringAddr = internalList2.get(i);
                List<InternalScoringAddress> addressList = this.getInternalScoringAddressList(scoringAddr);
                for (InternalScoringAddress internalScoringAddress : addressList) {
                    tempCombinedList.add(ndx, internalScoringAddress);
                    if (internalScoringAddress.isCloseMatch()) {
                        ++closeMatchCount;
                    }
                    ++ndx;
                }
            }
            candList1.setCandidateList(tempCombinedList);
            candList1.setNumberOfCloseMatches(closeMatchCount);
        } else if (candCount2 > 0) {
            List<InternalScoringAddress> internalList1 = candList1.getCandidateList();
            List<InternalScoringAddress> internalList2 = candList2.getCandidateList();
            LinkedList<InternalScoringAddress> tempCombinedList = new LinkedList<InternalScoringAddress>(internalList1);
            Comparator<InternalScoringAddress> reverseComparator = MMUtils.getReverseComparator(new CGGEInternalScoringAddressComparator());
            for (int i = 0; i < candCount2; ++i) {
                InternalScoringAddress scoringAddr = internalList2.get(i);
                int ndx = MMUtils.nextInsertPosition(tempCombinedList, scoringAddr, reverseComparator);
                List<InternalScoringAddress> addressList = this.getInternalScoringAddressList(scoringAddr);
                for (InternalScoringAddress internalScoringAddress : addressList) {
                    tempCombinedList.add(ndx, internalScoringAddress);
                    ++ndx;
                    if (!internalScoringAddress.isCloseMatch()) continue;
                    ++closeMatchCount;
                }
            }
            internalList1.clear();
            internalList1.addAll(tempCombinedList);
            candList1.setNumberOfCloseMatches(candList1.getNumberOfCloseMatches() + closeMatchCount);
        }
    }

    private List<InternalScoringAddress> getInternalScoringAddressList(InternalScoringAddress scoringAddr) {
        ArrayList<InternalScoringAddress> listOfAddress = new ArrayList<InternalScoringAddress>();
        InternalScoringRange[] scoringRangeArray = scoringAddr.getRanges();
        if (scoringAddr.getInternalAddress() != null && !scoringAddr.getInternalAddress().getDataSetInfo().getMetaData().isUserDictionary()) {
            listOfAddress.add(scoringAddr);
            return listOfAddress;
        }
        if (scoringRangeArray == null || scoringRangeArray.length < 1) {
            listOfAddress.add(scoringAddr);
        } else {
            InternalScoringRange firstRange = scoringAddr.getRangeAt(0);
            double firstRangeScore = firstRange.getCombinedScore();
            ArrayList notMatchingRangelist = new ArrayList();
            for (InternalScoringRange internalScoringRange : scoringRangeArray) {
                ArrayList<InternalScoringRange> rangelist = new ArrayList<InternalScoringRange>();
                if (firstRangeScore != internalScoringRange.getCombinedScore()) continue;
                rangelist.add(internalScoringRange);
                InternalScoringAddress scoringAddress = this.getNewScoringAddress(scoringAddr);
                scoringAddress.setRanges(rangelist.toArray(new InternalScoringRange[0]));
                listOfAddress.add(scoringAddress);
            }
            if (listOfAddress.size() == 1) {
                listOfAddress.clear();
                listOfAddress.add(scoringAddr);
            }
        }
        return listOfAddress;
    }

    public InternalScoringAddress getNewScoringAddress(InternalScoringAddress scoringAddress) {
        InternalScoringAddress newScoringAddress = new InternalScoringAddress(scoringAddress.getInternalStreetAddress());
        newScoringAddress.setCombinedPostalScore(scoringAddress.getCombinedPostalScore());
        newScoringAddress.setCombinedStreetScore(scoringAddress.getCombinedStreetScore());
        newScoringAddress.setDictionaryUsagePriority(scoringAddress.getDictionaryUsagePriority());
        newScoringAddress.setRanges(scoringAddress.getRanges());
        newScoringAddress.setSecondaryStreetAddress(scoringAddress.getSecondaryStreetAddress());
        newScoringAddress.setCloseMatch(scoringAddress.isCloseMatch());
        newScoringAddress.setCombinedScore(scoringAddress.getCombinedScore());
        newScoringAddress.setFieldScores(scoringAddress.getFieldScores());
        List<AddressWord> addressWords = scoringAddress.getSearchWords();
        if (addressWords != null) {
            for (AddressWord addressWord : addressWords) {
                newScoringAddress.addSearchWord(addressWord);
            }
        }
        return newScoringAddress;
    }

    @Override
    protected void calculateCombinedStreetScore(InternalScoringAddress scoringAddr, ParsedAddress parsedAddress, MatchingOptions options) {
        FieldScore streetScore = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        FieldScore genericFieldScore = scoringAddr.getFieldScore(FieldType.GENERIC_FIELD_1_FIELD_TYPE);
        super.calculateCombinedStreetScore(scoringAddr, parsedAddress, options);
        if (scoringAddr.getCombinedStreetScore() == 1.0) {
            double missingWeight = this.combineFieldWeightsAtLevel(scoringAddr, FieldType.FieldLevel.LEVEL_STREET, options);
            streetScore = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
            genericFieldScore = scoringAddr.getFieldScore(FieldType.GENERIC_FIELD_1_FIELD_TYPE);
            if (missingWeight == 0.0 && (streetScore == null && genericFieldScore == null || streetScore != null && streetScore.m_value == 0.0 && genericFieldScore != null && genericFieldScore.m_value == 0.0)) {
                scoringAddr.setCombinedStreetScore(0.0);
            }
        }
    }

    @Override
    public void scoreCandidate(ParsedAddress parsedAddr, InternalScoringAddress addr, MatchingOptions matchingOptions, ICGGEScorer scorer, IDataManager dataManager) throws CGGEInternalException {
        CZE_ParsedAddress pAddr = null;
        if (parsedAddr instanceof CZE_ParsedAddress) {
            pAddr = (CZE_ParsedAddress)parsedAddr;
        }
        boolean shouldScoreCandidate = true;
        if (!(pAddr == null || pAddr.isCISDOMPresent() || pAddr.isCISORPresent() || pAddr.isPISORPresent())) {
            List<AddressWord> searchWordList = addr.getSearchWords();
            for (AddressWord addressWord : searchWordList) {
                if (!FieldType.GENERIC_FIELD_1_FIELD_TYPE.equals(addressWord.m_wordType)) continue;
                shouldScoreCandidate = false;
                break;
            }
        }
        if (shouldScoreCandidate) {
            super.scoreCandidate(parsedAddr, addr, matchingOptions, scorer, dataManager);
        }
    }
}

