/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.CZE.parser;

import com.mapinfo.mapmarker.CZE.address.CZE_ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CZE_Parser
extends CGGEParser {
    private static final Pattern POST_CODE_PATTERN = Pattern.compile("\\b(\\d{5})\\b", 2);
    private static final Pattern CIS_PIS_DOM_OR_PATTERN = Pattern.compile("((\\d+)(\\p{Punct}|\\s*)([A-Z]{1}(\\s*|\\p{Punct})*)?(\\d+)((\\s*)([A-Z]))?\\b)|(((\\b[A-Z]{1})(\\s*))?(\\d+)((\\s*)([A-Z]))?(\\p{Punct}|\\s*)(\\d+))|(\\b((([A-Z]{1})(\\s*))?(\\d+)((\\s*)([A-Z]{1}))?)\\b)", 2);

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        ParsedAddress[] pAddrArray = super.parse(inputAddress, scorer);
        if (pAddrArray != null && pAddrArray.length > 0) {
            CZE_ParsedAddress czeParsedAddress = new CZE_ParsedAddress(pAddrArray[0].getCountry(), pAddrArray[0].getLanguage());
            czeParsedAddress.copy(pAddrArray[0]);
            if (pAddrArray[0].isSeparateAreaFields() && !pAddrArray[0].isIntersectionCase()) {
                czeParsedAddress.setField(FieldType.GENERIC_FIELD_1_FIELD_TYPE, pAddrArray[0].getField(FieldType.STREET_NAME_FIELD_TYPE));
            }
            if (czeParsedAddress.getAddressNumber() != null) {
                this.extractAlternateHouseNumber(czeParsedAddress, pAddrArray[0].getAddressNumber());
                if (StringUtilities.isEmpty((String)czeParsedAddress.getProbableCISDOM()) && StringUtilities.isEmpty((String)czeParsedAddress.getProbableCISOR())) {
                    if (czeParsedAddress.getAddressNumber().getHnrNumber1() > 0 && czeParsedAddress.getAddressNumber().getHnrSuffix1() != null) {
                        czeParsedAddress.setProbablePISOR(czeParsedAddress.getAddressNumber().getHnrSuffix1());
                        czeParsedAddress.setProbableCISOR(String.valueOf(czeParsedAddress.getAddressNumber().getHnrNumber1()));
                    } else {
                        czeParsedAddress.setProbableCISDOM(String.valueOf(czeParsedAddress.getAddressNumber().getHnrNumber1()));
                    }
                }
            } else {
                this.populateAlternateAddressNumbers(czeParsedAddress);
            }
            pAddrArray[0] = czeParsedAddress;
        }
        return pAddrArray;
    }

    public List<AddressNumber> findProbableAddressNumbers(CZE_ParsedAddress parsedAddress) {
        String matchedString;
        Matcher match;
        String mainAddress = this.reconstructFieldValue((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE));
        StringBuilder mainStr = new StringBuilder();
        if (!StringUtilities.isEmpty((String)mainAddress)) {
            mainStr.append(mainAddress);
        }
        if ((match = POST_CODE_PATTERN.matcher(mainStr.toString())).find() && !StringUtilities.isEmpty((String)(matchedString = match.group()))) {
            mainStr.delete(match.start(), match.end());
        }
        AddressWord[] words = this.getAddressWords(mainStr.toString());
        return super.findProbableAddressNumbers(words, null);
    }

    private void extractAlternateHouseNumber(CZE_ParsedAddress parsedAddress, AddressNumber addressNumber) {
        if (addressNumber.getHnrNumber1() > 0 && addressNumber.getHnrNumber2() > 0) {
            if (addressNumber.getHnrSuffix2() != null) {
                parsedAddress.setProbableCISDOM(String.valueOf(addressNumber.getHnrNumber1()));
                parsedAddress.setProbableCISOR(String.valueOf(addressNumber.getHnrNumber2()));
                parsedAddress.setProbablePISOR(addressNumber.getHnrSuffix2());
            } else if (addressNumber.getHnrSuffix1() != null) {
                parsedAddress.setProbableCISDOM(String.valueOf(addressNumber.getHnrNumber2()));
                parsedAddress.setProbableCISOR(String.valueOf(addressNumber.getHnrNumber1()));
                parsedAddress.setProbablePISOR(addressNumber.getHnrSuffix1());
            } else {
                parsedAddress.setProbableCISDOM(String.valueOf(addressNumber.getHnrNumber1()));
                if (addressNumber.getHnrNumber2() > 0) {
                    parsedAddress.setProbableCISOR(String.valueOf(addressNumber.getHnrNumber2()));
                }
            }
        }
    }

    private String cleanAddressBeforeIdentifingAddressNumber(CZE_ParsedAddress parsedAddress) {
        String matchedString;
        Matcher match;
        String mainAddress = this.reconstructFieldValue((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE));
        StringBuilder mainStr = new StringBuilder();
        if (!StringUtilities.isEmpty((String)mainAddress)) {
            mainStr.append(mainAddress);
        }
        if ((match = POST_CODE_PATTERN.matcher(mainStr.toString())).find() && !StringUtilities.isEmpty((String)(matchedString = match.group()))) {
            mainStr.delete(match.start(), match.end());
        }
        return mainStr.toString();
    }

    private void populateAlternateAddressNumbers(CZE_ParsedAddress parsedAddress) {
        String[] valueArray = new String[3];
        String value = this.cleanAddressBeforeIdentifingAddressNumber(parsedAddress);
        Matcher match = CIS_PIS_DOM_OR_PATTERN.matcher(value);
        if (match.find()) {
            String matchedString = match.group();
            StringTokenizer tokenizer = new StringTokenizer(matchedString, this.getParserTerms().getDelimiters().replaceAll(" ", ""));
            switch (tokenizer.countTokens()) {
                case 1: {
                    String token_value = tokenizer.nextToken();
                    if (StringUtilities.isNumeric((String)token_value)) {
                        valueArray[2] = token_value;
                        break;
                    }
                    String[] splittedValue = this.splittedValue(matchedString, " ", false);
                    valueArray = splittedValue;
                    break;
                }
                case 2: {
                    String firstToken = tokenizer.nextToken();
                    String secondToken = tokenizer.nextToken();
                    if (StringUtilities.isNumeric((String)firstToken) && StringUtilities.isNumeric((String)secondToken)) {
                        valueArray[0] = secondToken;
                        valueArray[1] = null;
                        valueArray[2] = firstToken;
                        break;
                    }
                    if (StringUtilities.isNumeric((String)firstToken)) {
                        String[] splittedValue = this.splittedValue(secondToken, " ", false);
                        if (StringUtilities.isEmpty((String)splittedValue[0])) {
                            if (StringUtilities.isEmpty((String)splittedValue[1])) break;
                            valueArray = splittedValue;
                            valueArray[0] = firstToken;
                            break;
                        }
                        valueArray = splittedValue;
                        valueArray[2] = firstToken;
                        break;
                    }
                    String[] splittedValue = this.splittedValue(firstToken, " ", false);
                    if (StringUtilities.isEmpty((String)splittedValue[0])) {
                        if (StringUtilities.isEmpty((String)splittedValue[1])) break;
                        valueArray[0] = firstToken;
                        valueArray[1] = splittedValue[1];
                        valueArray[2] = null;
                        break;
                    }
                    valueArray[0] = splittedValue[0];
                    valueArray[1] = splittedValue[1];
                    valueArray[2] = secondToken;
                }
            }
        }
        parsedAddress.setProbableCISDOM(valueArray[2]);
        parsedAddress.setProbableCISOR(valueArray[0]);
        parsedAddress.setProbablePISOR(valueArray[1]);
    }

    private String[] splittedValue(String value, String delimiters, boolean includedelim) {
        StringTokenizer tokenizer = new StringTokenizer(value, delimiters, includedelim);
        String[] valueArray = new String[3];
        switch (tokenizer.countTokens()) {
            case 1: {
                String newToken = tokenizer.nextToken();
                if (newToken.length() == 1 && Character.isLetter(newToken.toCharArray()[0])) {
                    valueArray[1] = newToken;
                    return valueArray;
                }
                StringBuilder builder = new StringBuilder();
                char[] ch = value.toCharArray();
                for (int i = 0; i < ch.length; ++i) {
                    if (!Character.isLetter(ch[i])) {
                        builder.append(String.valueOf(ch[i]));
                        continue;
                    }
                    valueArray[1] = String.valueOf(ch[i]);
                }
                valueArray[0] = builder.toString();
                return valueArray;
            }
            case 2: {
                return this.handleCase2ForSplittedValue(tokenizer, valueArray);
            }
        }
        return this.handleCase3ForSplittedValue(value, delimiters, includedelim, valueArray);
    }

    private String[] handleCase3ForSplittedValue(String value, String delimiters, boolean includedelim, String[] valueArray) {
        StringTokenizer tokenizer = new StringTokenizer(value, delimiters, includedelim);
        while (tokenizer.hasMoreTokens()) {
            String firstToken = tokenizer.nextToken();
            String secondToken = tokenizer.nextToken();
            String thirdToken = tokenizer.nextToken();
            if (StringUtilities.isNumeric((String)firstToken) && StringUtilities.isNumeric((String)secondToken)) {
                valueArray[0] = secondToken;
                valueArray[2] = firstToken;
                valueArray[1] = thirdToken;
                continue;
            }
            if (firstToken.length() == 1) {
                if (Character.isLetter(firstToken.toCharArray()[0])) {
                    valueArray[1] = firstToken;
                    valueArray[0] = secondToken;
                    valueArray[2] = thirdToken;
                } else {
                    valueArray[0] = firstToken;
                    valueArray[1] = secondToken;
                    valueArray[2] = thirdToken;
                }
            }
            if (secondToken.length() != 1 || !Character.isLetter(secondToken.toCharArray()[0])) continue;
            valueArray[1] = secondToken;
            valueArray[0] = thirdToken;
            valueArray[2] = firstToken;
        }
        return valueArray;
    }

    private String[] handleCase2ForSplittedValue(StringTokenizer tokenizer, String[] valueArray) {
        String firstToken = tokenizer.nextToken();
        String secondToken = tokenizer.nextToken();
        if (StringUtilities.isNumeric((String)firstToken) && StringUtilities.isNumeric((String)secondToken)) {
            valueArray[0] = secondToken;
            valueArray[2] = firstToken;
        } else if (firstToken.length() == 1) {
            if (Character.isLetter(firstToken.toCharArray()[0])) {
                valueArray[1] = firstToken;
                valueArray[0] = secondToken;
            } else {
                valueArray[0] = firstToken;
                valueArray[1] = secondToken;
            }
        } else {
            valueArray[0] = firstToken;
            valueArray[1] = secondToken;
        }
        return valueArray;
    }
}

