/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.ESP.parser;

import com.mapinfo.mapmarker.ESP.address.ESP_ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ESP_Parser
extends CGGEParser1 {
    private static HashMap<String, String> shortTermMap;
    private Pattern fiveDigitPattern = Pattern.compile("\\d{5}");
    private Pattern fourDigitPattern = Pattern.compile("\\d{4}");
    public static final String SHORT_TOWN_NAME = "shortAN3";

    @Override
    public boolean init(String country, String language) {
        boolean flag = super.init(country, language);
        if (shortTermMap == null) {
            Properties prop = this.getConfiguration(country, null, "_ShortTerm", null, null);
            ESP_Parser.loadShortTerms(prop);
        }
        return flag;
    }

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        ParsedAddress[] pAddrArray = super.parse(inputAddress, scorer);
        if (pAddrArray != null && pAddrArray.length > 0) {
            String fullTerm;
            ESP_ParsedAddress espParsedAddress = new ESP_ParsedAddress(pAddrArray[0].getCountry(), pAddrArray[0].getLanguage());
            espParsedAddress.copy(pAddrArray[0]);
            pAddrArray[0] = espParsedAddress;
            this.setTwoDigitPostcode(inputAddress, pAddrArray[0]);
            if (!StringUtilities.isEmpty((String)((String)pAddrArray[0].getInputAddress().getField(FieldType.AREA_NAME_3_FIELD_TYPE))) && StringUtilities.isEmpty((String)((String)pAddrArray[0].getInputAddress().getField(FieldType.POST_CODE_FIELD_TYPE))) && !StringUtilities.isEmpty((String)(fullTerm = ESP_Parser.shortTermLookup((String)pAddrArray[0].getInputAddress().getField(FieldType.AREA_NAME_3_FIELD_TYPE))))) {
                pAddrArray[0].setField(new FieldType(29, FieldType.FieldLevel.LEVEL_POSTAL, SHORT_TOWN_NAME), this.getAddressWords(fullTerm));
            }
        }
        return pAddrArray;
    }

    private void setTwoDigitPostcode(InputAddress inputAddress, ParsedAddress parsedAddress) {
        char[] chars;
        AddressWord postCodeAddressWord;
        AddressWord[] postCodes;
        String postCode = null;
        ESP_ParsedAddress espPa = (ESP_ParsedAddress)parsedAddress;
        if (parsedAddress != null && parsedAddress.getFields() != null && (postCodes = (AddressWord[])parsedAddress.getFields().get(FieldType.POST_CODE_FIELD_TYPE)) != null && postCodes.length > 0 && (postCodeAddressWord = postCodes[0]) != null && postCodeAddressWord.getCodedWord() != null && (chars = postCodeAddressWord.getCodedWord().getChars()) != null) {
            postCode = String.valueOf(chars);
            espPa.setTwoDigitPostcode(this.subString2DigitPostcode(postCode));
            return;
        }
        if (parsedAddress.isSeperatePostAddressFields()) {
            String postAddr = (String)inputAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
            espPa.setTwoDigitPostcode(this.subString2DigitPostcode(this.getPostCode(postAddr)));
        } else {
            String strAddr = (String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
            espPa.setTwoDigitPostcode(this.subString2DigitPostcode(this.getPostCode(strAddr)));
        }
    }

    private String subString2DigitPostcode(String postcode) {
        String subStrPostCode = null;
        if (!StringUtilities.isEmpty((String)postcode) && postcode.length() >= 2) {
            if (postcode.length() == 4) {
                postcode = "0" + postcode;
            }
            subStrPostCode = postcode.substring(0, 2);
        }
        return subStrPostCode;
    }

    private String getPostCode(String addr) {
        String postCode = null;
        if (addr == null || addr.length() == 0) {
            return null;
        }
        Matcher m = this.fiveDigitPattern.matcher(addr);
        if (m.find()) {
            postCode = m.group();
        }
        if (postCode == null && (m = this.fourDigitPattern.matcher(addr)).find()) {
            postCode = m.group();
        }
        return postCode;
    }

    private static void loadShortTerms(Properties prop) {
        Enumeration<?> e = prop.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            String value = prop.getProperty(key);
            if (value == null || value.trim().length() <= 0) continue;
            if (shortTermMap == null) {
                shortTermMap = new HashMap();
            }
            StringTokenizer tokenizedAreaNames = new StringTokenizer(value, ",");
            int n = tokenizedAreaNames.countTokens();
            String[] aliases = new String[n];
            for (int i = 0; i < n; ++i) {
                aliases[i] = tokenizedAreaNames.nextToken().trim().toUpperCase();
            }
            shortTermMap.put(aliases[1], aliases[0]);
        }
    }

    private static String shortTermLookup(String longTerm) {
        String value;
        String result = null;
        if (shortTermMap != null && !StringUtilities.isEmpty((String)(value = shortTermMap.get(longTerm.toUpperCase())))) {
            result = value;
        }
        return result;
    }
}

