/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR;

import com.mapinfo.mapmarker.GBR.GBRCandidateOrderAdjuster;
import com.mapinfo.mapmarker.GBR.GBRFilterRules;
import com.mapinfo.mapmarker.GBR.GBR_Utils;
import com.mapinfo.mapmarker.GBR.ICGGECloseMatchFilterRule;
import com.mapinfo.mapmarker.cgge.CGGECandidateFilter;
import com.mapinfo.mapmarker.cgge.CGGEDataIntializationException;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataManager;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.matcher.CGGEInternalScoringAddressComparator;
import com.mapinfo.mapmarker.cgge.utils.CandidateS3Determinator;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class GBRCandidateFilter
extends CGGECandidateFilter {
    @Override
    public void filterMultipleCloseCandidates(InternalCandidateList internalCandList, ParsedAddress addr, GeocodeOptions options) throws CGGERuntimeException, CGGEInternalException {
        boolean isStreetCand = options.getGeocodeType() == 1;
        try {
            boolean filtered;
            boolean bl = filtered = isStreetCand ? this.doLocalPreStreetFiltering(internalCandList) : false;
            if (!filtered) {
                super.filterMultipleCloseCandidates(internalCandList, addr, options);
                if (isStreetCand) {
                    this.filterCloseStreetCandidates(internalCandList);
                }
            }
            this.doLocalPostFiltering(internalCandList);
        }
        catch (Exception e) {
            throw new CGGEInternalException(e);
        }
    }

    private boolean doLocalPreStreetFiltering(InternalCandidateList internalCandList) throws DataFetchException, CGGEDataIntializationException {
        GBRCandidateOrderAdjuster candOrderAdjuster = new GBRCandidateOrderAdjuster(internalCandList);
        boolean filtered = candOrderAdjuster.adjustS3CandidateRank();
        if (!filtered) {
            filtered = candOrderAdjuster.adjustS8OverS5();
        }
        return filtered;
    }

    private void doLocalPostFiltering(InternalCandidateList internalCandList) {
        this.degradePartialPCMatches(internalCandList);
    }

    private void degradePartialPCMatches(InternalCandidateList internalCandList) {
        int closeMatchCount = internalCandList.getNumberOfCloseMatches();
        if (closeMatchCount > 1 && GBR_Utils.hasFullPostCode(internalCandList.getIndexedCandidate(0).getInternalAddress())) {
            int closeCandNdx;
            for (closeCandNdx = 1; closeCandNdx < closeMatchCount && GBR_Utils.hasFullPostCode(internalCandList.getIndexedCandidate(closeCandNdx).getInternalAddress()); ++closeCandNdx) {
            }
            if (closeCandNdx != closeMatchCount) {
                internalCandList.setNumberOfCloseMatches(closeCandNdx);
                while (closeCandNdx < closeMatchCount) {
                    internalCandList.getIndexedCandidate(closeCandNdx).setCloseMatch(false);
                    ++closeCandNdx;
                }
            }
        }
    }

    protected void filterCloseStreetCandidates(InternalCandidateList internalCandList) throws CGGEInternalException, DataFetchException, CGGEDataIntializationException {
        int closeMatchCount;
        int n = closeMatchCount = internalCandList == null ? 0 : internalCandList.getNumberOfCloseMatches();
        if (closeMatchCount < 2) {
            return;
        }
        int origCnt = closeMatchCount;
        List<InternalScoringAddress> candList = internalCandList.getCandidateList();
        Iterator<InternalScoringAddress> bestCandidateIterator = candList.iterator();
        boolean resort = false;
        ICGGECloseMatchFilterRule[] filterRules = GBRFilterRules.getInstance().getFilterRules();
        IDataManager dm = DataManager.getInstance("GBR");
        while (bestCandidateIterator.hasNext()) {
            boolean bGetNextBestCandidate = false;
            boolean bGetNextOtherCandidate = true;
            InternalScoringAddress best = bestCandidateIterator.next();
            InternalScoringAddress other = null;
            if (dm != null && !best.getS3CheckedStatus()) {
                best.setIsS3(CandidateS3Determinator.isS3(dm, best));
            }
            if (!best.isCloseMatch()) continue;
            Iterator<InternalScoringAddress> otherIterator = candList.iterator();
            while (otherIterator.hasNext() && bGetNextOtherCandidate) {
                other = otherIterator.next();
                if (other != best) continue;
                bGetNextOtherCandidate = false;
            }
            while (otherIterator.hasNext() && !bGetNextBestCandidate) {
                other = otherIterator.next();
                if (!other.isCloseMatch()) continue;
                if (dm != null && !other.getS3CheckedStatus()) {
                    other.setIsS3(CandidateS3Determinator.isS3(dm, other));
                }
                boolean bGetNextCandidate = false;
                for (int i = 0; i < filterRules.length && !bGetNextCandidate; ++i) {
                    if (filterRules[i].demoteOther(best, other)) {
                        other.setCloseMatch(false);
                        resort = true;
                        bGetNextCandidate = true;
                        --closeMatchCount;
                        continue;
                    }
                    if (!filterRules[i].demoteOther(other, best)) continue;
                    best.setCloseMatch(false);
                    resort = true;
                    bGetNextBestCandidate = true;
                    bGetNextCandidate = true;
                    --closeMatchCount;
                }
            }
        }
        if (resort) {
            LinkedList<InternalScoringAddress> sortedCands = new LinkedList<InternalScoringAddress>();
            Comparator<InternalScoringAddress> reverseComparator = MMUtils.getReverseComparator(new CGGEInternalScoringAddressComparator());
            for (int i = 0; i < candList.size(); ++i) {
                InternalScoringAddress scoringAddr = candList.get(i);
                int ndx = MMUtils.nextInsertPosition(sortedCands, scoringAddr, reverseComparator);
                sortedCands.add(ndx, scoringAddr);
            }
            candList.clear();
            internalCandList.setCandidateList(sortedCands);
            internalCandList.setBestFetchedCandidate(sortedCands.get(0));
            internalCandList.setNumberOfCloseMatches(closeMatchCount);
        }
    }
}

