/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR;

import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.AdditionalFields;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalAddress;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.cgge.utils.CandidateS3Determinator;
import java.util.HashMap;
import java.util.Map;

public class GBR_Utils {
    public static boolean hasFullPostCode(AddressWord[] words) {
        return words.length > 1 && GBR_Utils.hasFullPostUnit(words[1]);
    }

    public static boolean hasFullPostUnit(AddressWord addressWord) {
        return addressWord.getWordLength() == 3;
    }

    public static boolean hasFullPostCode(InternalAddress addr) {
        InternalFieldValue fv = (InternalFieldValue)addr.getField(FieldType.POST_CODE_EX_FIELD_TYPE);
        if (fv != null) {
            AddressWord[] pcUnit = (AddressWord[])fv.getFieldValue();
            if (AddressWordArray.size(pcUnit) == 1) {
                return GBR_Utils.hasFullPostUnit(pcUnit[0]);
            }
        } else {
            fv = (InternalFieldValue)addr.getField(FieldType.POST_CODE_FIELD_TYPE);
            if (fv != null) {
                return GBR_Utils.hasFullPostCode((AddressWord[])fv.getFieldValue());
            }
        }
        return false;
    }

    public static boolean hasCloseMatchingField(InternalScoringAddress cand, FieldType type) {
        FieldScore score = cand.getFieldScore(type);
        return score != null && score.m_matched;
    }

    public static boolean doesAllRangesHasSameUPRN(InternalScoringAddress candAddress, IDataManager manager) throws DataFetchException {
        InternalRangeAddress range = candAddress.getRangeAt(0).getRange();
        int rangeCount = candAddress.getRangeCount();
        if (range.getPoints().size() == 0) {
            return false;
        }
        if (rangeCount > 1) {
            String bestRangeUPRN = GBR_Utils.getAdditionalFieldUPRN(candAddress, candAddress.getRangeAt(0), manager);
            for (int i = 1; i < rangeCount; ++i) {
                String otherRangeUPRN = GBR_Utils.getAdditionalFieldUPRN(candAddress, candAddress.getRangeAt(i), manager);
                if (bestRangeUPRN == null || otherRangeUPRN == null || bestRangeUPRN.equalsIgnoreCase(otherRangeUPRN)) continue;
                return false;
            }
        }
        return true;
    }

    private static String getAdditionalFieldUPRN(InternalScoringAddress candAddress, InternalScoringRange scoringRange, IDataManager manager) throws DataFetchException {
        InternalAddress add = scoringRange.getInternalAddress();
        AdditionalFields addFields = manager.getAdditionalFields(add);
        if (addFields != null) {
            Map<Object, Object> field = new HashMap();
            field = addFields.getAdditionalFields();
            if (field != null) {
                FieldType UPRN = GBR_Utils.getUprnFieldType(candAddress);
                return (String)field.get(UPRN);
            }
        }
        return null;
    }

    private static FieldType getUprnFieldType(InternalScoringAddress addr) {
        return addr.getDataSetInfo().getMetaData().getFieldForName("UPRN");
    }

    public static int getPointCount(IDataManager dataManager, InternalScoringAddress cand) throws DataFetchException {
        if (cand.getRangeCount() > 0) {
            return CandidateS3Determinator.getPointCount(dataManager, cand.getRangeAt(0).getRange());
        }
        return 0;
    }

    public static boolean isStreetRangeRecord(IDataManager dataManager, InternalScoringAddress cand) throws DataFetchException {
        return GBR_Utils.getPointCount(dataManager, cand) > 1;
    }
}

