/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.dp.builder.reader;

import com.mapinfo.mapmarker.GBR.dp.builder.reader.AB_Fields;
import com.mapinfo.mapmarker.GBR.dp.builder.reader.AB_Reader;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.StandardRawDataSource;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.midev.geometry.DirectPosition;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.io.WKTWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AB_DataSource
extends StandardRawDataSource {
    static final String NO_COORDINATE_STRING = WKTWriter.toPoint((Coordinate)new Coordinate(AB_Reader.dummyCoords.getX(), AB_Reader.dummyCoords.getY()));
    public static Logger logger = LoggerFactory.getLogger(AB_DataSource.class);
    private static final String COMMA = ",";
    private static final String QUOTE = "\"";
    private Properties properties;
    private File[] dataFiles = new File[0];
    private int currentFileIndex = -1;
    private BufferedReader reader;
    private Map<String, String> nextRecord;
    private AB_Fields fieldMapping;

    @Override
    public Properties getProperties() {
        return this.properties;
    }

    @Override
    public boolean isSacFromFile() {
        return true;
    }

    @Override
    public boolean isPossiblePointData() {
        return true;
    }

    @Override
    public boolean loadData(Properties prop) throws Exception {
        this.properties = new Properties();
        this.fieldMapping = new AB_Fields();
        this.dataFiles = this.getDataFiles(prop);
        return this.dataFiles.length > 0;
    }

    private File[] getDataFiles(Properties prop) {
        String path = (String)prop.get("inputPath");
        File pathFile = new File(path);
        return pathFile.listFiles(new CSVFileNameFilter());
    }

    @Override
    public boolean loadNextFileSet() {
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                logger.warn("Error loading file " + this.dataFiles[this.currentFileIndex]);
            }
            this.reader = null;
        }
        if (++this.currentFileIndex < this.dataFiles.length) {
            try {
                this.reader = new BufferedReader(new FileReader(this.dataFiles[this.currentFileIndex]));
                this.moveNext();
                return true;
            }
            catch (Exception e) {
                logger.error("Error loading file " + this.dataFiles[this.currentFileIndex]);
            }
        }
        return false;
    }

    @Override
    public void rewind() {
        this.currentFileIndex = -1;
    }

    @Override
    public void close() {
        this.dataFiles = null;
        if (this.reader != null) {
            try {
                this.reader.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public String getCurrentFileSetName() {
        return this.dataFiles[this.currentFileIndex].getName();
    }

    @Override
    public DirectPosition[] getCoordinates() {
        return null;
    }

    @Override
    public boolean hasNext() {
        return this.nextRecord != null;
    }

    @Override
    public Map<String, String> next() {
        try {
            return this.getCurrentAndMoveNext();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Map<String, String> getCurrentAndMoveNext() throws IOException {
        Map<String, String> current = this.nextRecord;
        if (this.nextRecord != null) {
            this.moveNext();
        }
        return current;
    }

    private void moveNext() throws IOException {
        String recordLine = this.getNextRecordLine();
        if (recordLine != null) {
            String[] fields = this.splitCSVString(recordLine.toUpperCase());
            this.nextRecord = this.makeRecord(fields);
        } else {
            this.nextRecord = null;
        }
    }

    String getNextRecordLine() throws IOException {
        return this.reader.readLine();
    }

    Map<String, String> makeRecord(String[] fields) {
        HashMap<String, String> record = new HashMap<String, String>();
        for (Map.Entry<String, Integer> en : this.fieldMapping.getDataColumnMapping().entrySet()) {
            String value = AB_DataSource.getFieldValue(fields, en.getValue());
            if (value == null) continue;
            record.put(en.getKey(), value);
        }
        this.addGeometryObject(record);
        return record;
    }

    void addGeometryObject(Map<String, String> record) {
        String wktString = this.getGeometryWKT(record);
        record.put("Geometry", wktString);
    }

    protected String getGeometryWKT(Map<String, String> record) {
        String wkt = null;
        String slat = record.get("geom.latitude");
        String slong = record.get("geom.longitude");
        if (MMUtils.isEmpty(slat) || MMUtils.isEmpty(slong)) {
            return null;
        }
        try {
            double dlat = Double.parseDouble(slat);
            double dlong = Double.parseDouble(slong);
            Coordinate coordinates = new Coordinate(dlong, dlat);
            wkt = WKTWriter.toPoint((Coordinate)coordinates);
        }
        catch (Exception e) {
            logger.warn("Invalid geometry [" + slong + " , " + slat + "]");
            wkt = null;
        }
        return wkt;
    }

    private static String getFieldValue(String[] fields, int column) {
        String value;
        String string = value = fields.length <= column ? null : fields[column];
        if (value != null) {
            if ((value = value.trim()).startsWith(QUOTE)) {
                String string2 = value = value.length() > 1 ? value.substring(1) : "";
            }
            if (value.endsWith(QUOTE)) {
                value = value.length() > 1 ? value.substring(0, value.length() - 1) : "";
            }
            value = value.trim();
        }
        return value;
    }

    public final String[] splitCSVString(String str) {
        String[] fields = str.split(COMMA, -1);
        block0: for (int i = 0; i < fields.length; ++i) {
            if (!fields[i].startsWith(QUOTE)) continue;
            fields[i] = fields[i].substring(1);
            if (fields[i].endsWith(QUOTE)) {
                fields[i] = fields[i].substring(0, fields[i].length() - 1);
                continue;
            }
            for (int j = i + 1; j < fields.length; ++j) {
                if (fields[j].startsWith(QUOTE)) {
                    if (fields[j].length() != 1) continue block0;
                    fields[j] = null;
                    i = j;
                    continue block0;
                }
                if (fields[j].endsWith(QUOTE)) {
                    fields[i] = fields[i] + COMMA + fields[j].substring(0, fields[j].length() - 1);
                    fields[j] = null;
                    i = j;
                    continue block0;
                }
                fields[i] = fields[i] + COMMA + fields[j];
                fields[j] = null;
            }
        }
        int numNull = 0;
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i] != null) continue;
            ++numNull;
        }
        if (numNull > 0) {
            if (fields.length - numNull > 0) {
                String[] fieldsNew = new String[fields.length - numNull];
                int j = 0;
                for (int i = 0; i < fields.length; ++i) {
                    if (fields[i] == null) continue;
                    fieldsNew[j++] = fields[i];
                }
                return fieldsNew;
            }
            return null;
        }
        return fields;
    }

    private static final class CSVFileNameFilter
    implements FilenameFilter {
        @Override
        public boolean accept(File dir, String name) {
            return name.toUpperCase().endsWith(".CSV");
        }
    }
}

