/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.dp.builder.reader;

import com.mapinfo.mapmarker.cgge.address.AddressFieldValue;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class AddressBaseDataCleaner {
    static final FieldType POST_CODE_FIELD = FieldType.POST_CODE_FIELD_TYPE;
    static final FieldType HOUSE_NUM_FIELD = FieldType.ADDRESS_NUMBER_FROM_FIELD_TYPE;
    static final FieldType BUILDING_NAME_FIELD = FieldType.RANGE_PLACE_NAME_FIELD_TYPE;
    static FieldType SUB_BUILDING_NAME_FIELD;
    private static Pattern hnrPattern;
    private static final Set<String> UNIT_WORDS;

    public AddressBaseDataCleaner(Map<String, FieldType> map) {
        SUB_BUILDING_NAME_FIELD = map.get("sub_building_name");
    }

    private String formalizePostcode(String postcode) {
        if (MMUtils.isEmpty(postcode)) {
            return null;
        }
        char[] chars = postcode.toCharArray();
        StringBuffer buf = new StringBuffer();
        boolean lastCharWasSpace = false;
        for (int i = 0; i < chars.length; ++i) {
            char ch = chars[i];
            if (ch != ' ') {
                buf.append(ch);
                lastCharWasSpace = false;
                continue;
            }
            if (lastCharWasSpace) continue;
            buf.append(ch);
            lastCharWasSpace = true;
        }
        return buf.toString();
    }

    public final RawAddress cleanAddress(RawAddress address) {
        String pc = this.getFieldValue(address, POST_CODE_FIELD);
        String correctedPC = this.formalizePostcode(pc);
        this.setFieldValue(address, POST_CODE_FIELD, correctedPC);
        this.adjustBuildingFields(address);
        return null;
    }

    protected String getFieldValue(RawAddress address, FieldType type) {
        AddressFieldValue fv = (AddressFieldValue)address.getField(type);
        if (fv != null) {
            return (String)fv.getFieldValue();
        }
        return null;
    }

    protected void setFieldValue(RawAddress address, FieldType type, String value) {
        AddressFieldValue fv = value == null ? null : new AddressFieldValue(value);
        address.setField(type, fv);
    }

    protected boolean isHNRPattern(String str) {
        return !MMUtils.isEmpty(str) && hnrPattern.matcher(str).matches();
    }

    protected int hnrPrefixEnds(String str) {
        Matcher m = hnrPattern.matcher(str);
        if (m.find() && m.start() == 0) {
            return m.end();
        }
        return -1;
    }

    protected int hnrSuffixStarts(String str) {
        Matcher m = hnrPattern.matcher(str);
        while (m.find()) {
            if (m.end() != str.length()) continue;
            return m.start();
        }
        return -1;
    }

    protected void adjustBuildingFields(RawAddress address) {
        int hnrStartPos;
        String buildingName = this.getFieldValue(address, BUILDING_NAME_FIELD);
        if (MMUtils.isEmpty(buildingName)) {
            return;
        }
        String hnr = this.getFieldValue(address, HOUSE_NUM_FIELD);
        String subBuildingName = this.getFieldValue(address, SUB_BUILDING_NAME_FIELD);
        if (MMUtils.isEmpty(hnr)) {
            if (this.isHNRPattern(buildingName)) {
                hnr = buildingName;
                buildingName = null;
            } else {
                int hnrEndPos = this.hnrPrefixEnds(buildingName);
                if (hnrEndPos > -1) {
                    hnr = buildingName.substring(0, hnrEndPos).trim();
                    buildingName = hnrEndPos < buildingName.length() - 1 ? buildingName.substring(hnrEndPos) : null;
                }
            }
        }
        if (buildingName != null && MMUtils.isEmpty(subBuildingName) && (hnrStartPos = this.hnrSuffixStarts(buildingName)) > 0) {
            String temp = buildingName.substring(0, hnrStartPos).trim();
            String w = this.getWordBeforePos(buildingName, hnrStartPos);
            if (!this.isUnitTypeWord(w)) {
                subBuildingName = buildingName.substring(hnrStartPos);
                buildingName = temp;
            }
        }
        this.setFieldValue(address, HOUSE_NUM_FIELD, hnr);
        this.setFieldValue(address, BUILDING_NAME_FIELD, this.removeCommaAndTrim(buildingName));
        this.setFieldValue(address, SUB_BUILDING_NAME_FIELD, this.removeCommaAndTrim(subBuildingName));
    }

    protected String removeCommaAndTrim(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).startsWith(",")) {
            String string = str = str.length() > 0 ? str.substring(1).trim() : "";
        }
        if (str.endsWith(",")) {
            str = str.length() > 0 ? str.substring(0, str.length() - 1).trim() : "";
        }
        return str.length() == 0 ? null : str;
    }

    protected String getWordBeforePos(String str, int pos) {
        if (pos <= 0) {
            return null;
        }
        String temp = str.substring(0, pos).trim();
        int spacePos = temp.lastIndexOf(32);
        if (spacePos > 0) {
            return temp.substring(spacePos).trim();
        }
        return temp;
    }

    protected boolean isUnitTypeWord(String word) {
        return UNIT_WORDS.contains(word);
    }

    static {
        hnrPattern = Pattern.compile("\\b\\d+(\\s?[a-z]\\s*\\b(?!\\s*'))?(\\s*(-|&|AND|TO|\\\\\\\\|_|/)\\s*(\\d+(\\s?[a-z]\\b(?!\\s*'))?))?\\b", 2);
        UNIT_WORDS = new HashSet<String>();
        UNIT_WORDS.add("FLAT");
        UNIT_WORDS.add("ROOM");
        UNIT_WORDS.add("UNIT");
        UNIT_WORDS.add("FLOOR");
        UNIT_WORDS.add("APT");
    }
}

