/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.dp.builder.reader;

import com.mapinfo.mapmarker.GBR.dp.builder.reader.LocalityAliasHandler;
import com.mapinfo.mapmarker.GBR.dp.builder.reader.PAFDataCleaner;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.address.AddressFieldValue;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.dp.builder.InvalidFieldMappingException;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.StandardRawDataReader;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc.postgresql.PostgreSQL_DataSource;
import java.util.Collection;
import java.util.Map;
import java.util.Properties;

public class PAF_Reader
extends StandardRawDataReader {
    private LocalityAliasHandler m_localityHandler = new LocalityAliasHandler();
    private PAFDataCleaner m_cleaner;

    public PAF_Reader() throws CGGEInternalException {
        super(new NoGeometryPostgreSQL_DataSource());
    }

    @Override
    public boolean loadData(Properties props) throws Exception {
        if (super.loadData(props)) {
            this.m_localityHandler.loadData(props);
            return true;
        }
        return false;
    }

    @Override
    public RawAddress getNextRecord() {
        RawAddress address = super.getNextRecord();
        if (address != null) {
            this.postProcess(address);
        }
        return address;
    }

    @Override
    public void setAdditionalFields(Map<String, FieldType> map) throws InvalidFieldMappingException {
        super.setAdditionalFields(map);
        this.m_cleaner = new PAFDataCleaner(map);
    }

    @Override
    protected boolean isValidAddressField(String str) {
        boolean isValid = ALT_LEFT_VALUES.keySet().contains(str);
        isValid = isValid || ALT_RIGHT_VALUES.keySet().contains(str);
        boolean bl = isValid = isValid || additionalFieldNames != null && additionalFieldNames.containsKey(str);
        if (isValid || str.equals("FromLeft") || str.equals("ToLeft") || str.equals("FromRight") || str.equals("ToRight") || str.equals("Sac") || str.equals("LeftSac") || str.equals("RightSac") || str.equals("IsSacFromFile") || str.equals("Combine_Alt_Vals_Delim") || str.equals("pobox")) {
            isValid = true;
        }
        return isValid;
    }

    private void postProcess(RawAddress address) {
        String postDistrict;
        Collection<String> aliases;
        String postalCode = this.getFieldValue(address, FieldType.POST_CODE_FIELD_TYPE);
        if (postalCode == null || postalCode.trim().length() == 0) {
            return;
        }
        String[] pcParts = postalCode.split(" ");
        if (pcParts.length == 2) {
            address.setField(FieldType.POST_CODE_FIELD_TYPE, new AddressFieldValue(pcParts[0]));
            address.setField(FieldType.POST_CODE_EX_FIELD_TYPE, new AddressFieldValue(pcParts[1]));
        }
        if ((aliases = this.m_localityHandler.getLocalityAliases(postDistrict = pcParts[0] + ' ' + pcParts[1].charAt(0))) != null && !aliases.isEmpty()) {
            String[] alternates = aliases.toArray(new String[aliases.size()]);
            AddressFieldValue value = (AddressFieldValue)address.getField(FieldType.AREA_NAME_4_FIELD_TYPE);
            value.setAlternateValues(alternates);
        }
        this.m_cleaner.cleanAddress(address);
        FieldType poboxType = (FieldType)additionalFieldNames.get("pobox");
        AddressFieldValue pobox = (AddressFieldValue)address.getField(poboxType);
        if (pobox != null && !pobox.isEmpty()) {
            AddressFieldValue val = new AddressFieldValue("PO BOX");
            address.setField(FieldType.STREET_NAME_FIELD_TYPE, val);
            address.getFields().remove(poboxType);
            address.setField(FieldType.ADDRESS_NUMBER_FROM_FIELD_TYPE, pobox);
        }
    }

    private String getFieldValue(RawAddress address, FieldType type) {
        AddressFieldValue fv = (AddressFieldValue)address.getField(type);
        return fv == null ? null : (String)fv.getFieldValue();
    }

    private static class NoGeometryPostgreSQL_DataSource
    extends PostgreSQL_DataSource {
        @Override
        protected void setGeometry(Map<String, String> currentRow) {
        }
    }
}

