/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.dp.builder.reader;

import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.address.AddressFieldValue;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc.postgresql.PostgreSQL_Reader;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.Arrays;
import java.util.Properties;

public class TomTom_Data_Reader
extends PostgreSQL_Reader {
    @Override
    public boolean loadData(Properties prop) throws Exception {
        boolean b = super.loadData(prop);
        return b;
    }

    @Override
    public RawAddress getNextLeftAddress(DirectPosition[] coordinates) {
        RawAddress addr = super.getNextLeftAddress(coordinates);
        this.populateExPC(addr);
        return addr;
    }

    @Override
    public RawAddress getNextRightAddress(DirectPosition[] coordinates) {
        RawAddress addr = super.getNextRightAddress(coordinates);
        this.populateExPC(addr);
        return addr;
    }

    protected void populateExPC(RawAddress addr) {
        String currentPU = this.splitCurrentPCAndGetPU(addr);
        AddressFieldValue exPCFv = (AddressFieldValue)addr.getField(FieldType.POST_CODE_EX_FIELD_TYPE);
        if (exPCFv == null) {
            if (currentPU != null) {
                exPCFv = new AddressFieldValue(currentPU);
                addr.setField(FieldType.POST_CODE_EX_FIELD_TYPE, exPCFv);
            }
            return;
        }
        String pcEx = (String)exPCFv.getFieldValue();
        if (pcEx != null) {
            Object[] pcExs = pcEx.split("/");
            if (pcExs.length > 1) {
                Arrays.sort(pcExs);
                exPCFv.setAlternateValues(pcExs);
                exPCFv.setFieldValue(currentPU);
            }
        } else {
            exPCFv.setFieldValue(currentPU);
        }
    }

    protected String splitCurrentPCAndGetPU(RawAddress addr) {
        String pc;
        AddressFieldValue adv = (AddressFieldValue)addr.getField(FieldType.POST_CODE_FIELD_TYPE);
        if (adv != null && !MMUtils.isEmpty(pc = (String)adv.getFieldValue())) {
            String[] pcParts = pc.split(" ");
            adv.setFieldValue(pcParts[0]);
            if (pcParts.length > 1) {
                return pcParts[1];
            }
        }
        return null;
    }
}

