/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.filters;

import com.mapinfo.mapmarker.GBR.ICGGECloseMatchFilterRule;
import com.mapinfo.mapmarker.GBR.filters.FilterUtils;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.AdditionalFields;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.dp.DataManager;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class IgnorePunctuationDifferenceSameUprn
implements ICGGECloseMatchFilterRule {
    @Override
    public boolean demoteOther(InternalScoringAddress bestCand, InternalScoringAddress otherCand) {
        if (bestCand.getCombinedStreetScore() != otherCand.getCombinedStreetScore()) {
            return false;
        }
        if (bestCand.getCombinedPostalScore() != otherCand.getCombinedPostalScore()) {
            return false;
        }
        if (bestCand.getRangeCount() > 0 && otherCand.getRangeCount() > 0) {
            InternalScoringRange bestRange = bestCand.getRangeAt(0);
            InternalScoringRange otherRange = otherCand.getRangeAt(0);
            if (otherRange != null && bestRange != null) {
                int inputCt;
                int otherCt;
                String otherStreet;
                String bestUprn = FilterUtils.getAdditionalFieldsValue(this.getAdditionalFields(bestRange), "UPRN");
                String otherUprn = FilterUtils.getAdditionalFieldsValue(this.getAdditionalFields(otherRange), "UPRN");
                if (bestUprn == null || otherUprn == null || !bestUprn.equals(otherUprn)) {
                    return false;
                }
                InternalFieldValue bestValue = (InternalFieldValue)bestCand.getField(FieldType.STREET_NAME_FIELD_TYPE);
                InternalFieldValue otherValue = (InternalFieldValue)otherCand.getField(FieldType.STREET_NAME_FIELD_TYPE);
                if (bestValue == null || otherValue == null) {
                    return false;
                }
                String bestStreet = StringUtilities.stripString((String)bestValue.toString(), (String)".,' ");
                if (!bestStreet.equals(otherStreet = StringUtilities.stripString((String)otherValue.toString(), (String)".,' "))) {
                    return false;
                }
                FieldScore bestScore = bestCand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
                FieldScore otherScore = otherCand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
                if (bestScore == null || otherScore == null) {
                    return false;
                }
                int bestCt = bestScore.matchedCandidateWordCount() > 0 ? this.countSingleTokens(bestScore.getCandidateWords(), bestScore.m_matchedCandWords) : 0;
                int n = otherCt = otherScore.matchedCandidateWordCount() > 0 ? this.countSingleTokens(otherScore.getCandidateWords(), otherScore.m_matchedCandWords) : 0;
                if (bestCt == otherCt) {
                    return true;
                }
                int n2 = inputCt = IntArray.size(bestScore.m_matchedInputWords) > 0 ? this.countSingleTokens(bestScore.getInputWords(), bestScore.m_matchedInputWords) : 0;
                if (bestCt > otherCt) {
                    return inputCt >= bestCt;
                }
                return inputCt <= bestCt;
            }
        }
        return false;
    }

    int countSingleTokens(AddressWord[] words, IntArray matches) {
        int count = 0;
        for (int i = matches.getFirst() + 1; i < matches.getLast(); ++i) {
            char c;
            AddressWord word = words[i];
            if (word.getWordLength() != 1 || (c = word.getWordChars()[0]) != '.' && c != '\'' && c != ',') continue;
            ++count;
        }
        return count;
    }

    protected AdditionalFields getAdditionalFields(InternalScoringRange range) {
        try {
            return DataManager.getInstance("GBR").getAdditionalFields(range.getInternalAddress());
        }
        catch (Exception ex) {
            return null;
        }
    }
}

