/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.filters;

import com.mapinfo.mapmarker.GBR.ICGGECloseMatchFilterRule;
import com.mapinfo.mapmarker.GBR.filters.FilterUtils;
import com.mapinfo.mapmarker.cgge.CGGEDataIntializationException;
import com.mapinfo.mapmarker.cgge.address.AdditionalFields;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataManager;

public class PreferApprovedLogicalStatusCode
implements ICGGECloseMatchFilterRule {
    @Override
    public boolean demoteOther(InternalScoringAddress bestCand, InternalScoringAddress otherCand) {
        if (!FilterUtils.equalsOrBetter(bestCand, otherCand)) {
            return false;
        }
        if (bestCand.getRangeCount() > 0 && otherCand.getRangeCount() > 0) {
            InternalScoringRange bestRange = bestCand.getRangeAt(0);
            InternalScoringRange otherRange = otherCand.getRangeAt(0);
            if (otherRange != null && bestRange != null) {
                if (!FilterUtils.equalsOrBetter_addressNumber(bestRange, otherRange, bestCand.getParsedAddress())) {
                    return false;
                }
                try {
                    String bestLogicalStatus = FilterUtils.getAdditionalFieldsValue(this.getAdditionalFields(bestRange), "LOGICAL_STATUS_CODE");
                    String otherLogicalStatus = FilterUtils.getAdditionalFieldsValue(this.getAdditionalFields(otherRange), "LOGICAL_STATUS_CODE");
                    if (bestLogicalStatus != null && otherLogicalStatus != null && !bestLogicalStatus.equals(otherLogicalStatus) && "1".equals(bestLogicalStatus)) {
                        return true;
                    }
                }
                catch (DataFetchException dataFetchException) {
                }
                catch (CGGEDataIntializationException cGGEDataIntializationException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    protected AdditionalFields getAdditionalFields(InternalScoringRange range) throws DataFetchException, CGGEDataIntializationException {
        return DataManager.getInstance("GBR").getAdditionalFields(range.getInternalAddress());
    }
}

