/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.filters;

import com.mapinfo.mapmarker.GBR.ICGGECloseMatchFilterRule;
import com.mapinfo.mapmarker.GBR.filters.FilterUtils;
import com.mapinfo.mapmarker.cgge.CGGEDataIntializationException;
import com.mapinfo.mapmarker.cgge.address.AdditionalFields;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataManager;

public class PreferInUseBLPUStateCode
implements ICGGECloseMatchFilterRule {
    @Override
    public boolean demoteOther(InternalScoringAddress bestCand, InternalScoringAddress otherCand) {
        if (!FilterUtils.equalsOrBetter(bestCand, otherCand)) {
            return false;
        }
        if (bestCand.getRangeCount() > 0 && otherCand.getRangeCount() > 0) {
            InternalScoringRange bestRange = bestCand.getRangeAt(0);
            InternalScoringRange otherRange = otherCand.getRangeAt(0);
            if (otherRange != null && bestRange != null) {
                if (!FilterUtils.equalsOrBetter_addressNumber(bestRange, otherRange, bestCand.getParsedAddress())) {
                    return false;
                }
                try {
                    String bestBlpu = FilterUtils.getAdditionalFieldsValue(this.getAdditionalFields(bestRange), "BLPU_STATE_CODE");
                    String otherBlpu = FilterUtils.getAdditionalFieldsValue(this.getAdditionalFields(otherRange), "BLPU_STATE_CODE");
                    if (bestBlpu != null && otherBlpu != null && !bestBlpu.equals(otherBlpu) && "2".equals(bestBlpu)) {
                        return true;
                    }
                }
                catch (DataFetchException dataFetchException) {
                }
                catch (CGGEDataIntializationException cGGEDataIntializationException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    protected AdditionalFields getAdditionalFields(InternalScoringRange range) throws DataFetchException, CGGEDataIntializationException {
        return DataManager.getInstance("GBR").getAdditionalFields(range.getInternalAddress());
    }
}

