/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.filters;

import com.mapinfo.mapmarker.GBR.ICGGECloseMatchFilterRule;
import com.mapinfo.mapmarker.GBR.filters.FilterUtils;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import java.util.List;

public class PreferInsideRangedHouseNumber
implements ICGGECloseMatchFilterRule {
    @Override
    public boolean demoteOther(InternalScoringAddress bestCand, InternalScoringAddress otherCand) {
        if (!FilterUtils.equalsOrBetter(bestCand, otherCand)) {
            return false;
        }
        if (bestCand.getRangeCount() > 0 && otherCand.getRangeCount() > 0) {
            InternalScoringRange bestRange = bestCand.getRangeAt(0);
            InternalScoringRange otherRange = otherCand.getRangeAt(0);
            if (otherRange != null && bestRange != null) {
                if (!FilterUtils.sameOrBetterS3Status(bestCand, otherCand)) {
                    return false;
                }
                if (!FilterUtils.equalsOrBetter_addressNumber(bestRange, otherRange, bestCand.getParsedAddress())) {
                    return false;
                }
                List<AddressNumber> possibleAddressNumbers = bestCand.getParsedAddress().getProbableAddressNumbers();
                if (possibleAddressNumbers != null && !possibleAddressNumbers.isEmpty() && bestRange.getTo() == null) {
                    AddressNumber bestNumber = bestRange.getFrom();
                    AddressNumber otherNumber = otherRange.getFrom();
                    if (this.fitsAsRange(possibleAddressNumbers, bestNumber) && !this.fitsAsRange(possibleAddressNumbers, otherNumber)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    boolean fitsAsRange(List<AddressNumber> addressNumbers, AddressNumber rangeNumber) {
        if (rangeNumber == null || !rangeNumber.isRange()) {
            return false;
        }
        int start = rangeNumber.getHnrNumber1();
        int end = rangeNumber.getHnrNumber2();
        for (AddressNumber number : addressNumbers) {
            int test;
            if (number.isRange() || (test = number.getHnrNumber1()) < start || test > end) continue;
            return true;
        }
        return false;
    }
}

