/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.filters;

import com.mapinfo.mapmarker.GBR.ICGGECloseMatchFilterRule;
import com.mapinfo.mapmarker.GBR.filters.FilterUtils;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;

public class PreferNonPOBox
implements ICGGECloseMatchFilterRule {
    private static final String SUB_BUILDING_NAME = "sub_building_name";

    @Override
    public boolean demoteOther(InternalScoringAddress bestCand, InternalScoringAddress otherCand) {
        if (!FilterUtils.equalsOrBetter(bestCand, otherCand)) {
            return false;
        }
        if (bestCand.getRangeCount() > 0 && otherCand.getRangeCount() > 0) {
            InternalScoringRange bestRange = bestCand.getRangeAt(0);
            InternalScoringRange otherRange = otherCand.getRangeAt(0);
            if (otherRange != null && bestRange != null) {
                if (!FilterUtils.sameOrBetterS3Status(bestCand, otherCand)) {
                    return false;
                }
                FieldScore bestScore = bestRange.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
                FieldScore otherScore = otherRange.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
                if (bestScore != null && otherScore != null && bestScore.m_value == otherScore.m_value && bestScore.m_value == 0.0) {
                    return this.haNoPOBoxField(bestRange) && this.hasUnscoredPOBox(otherRange);
                }
            }
        }
        return false;
    }

    boolean haNoPOBoxField(InternalScoringRange item) {
        if (item.getFields() != null) {
            for (FieldType key : item.getFields().keySet()) {
                if (!key.getName().equalsIgnoreCase(SUB_BUILDING_NAME)) continue;
                return false;
            }
        }
        return true;
    }

    boolean hasUnscoredPOBox(InternalScoringRange item) {
        if (item.getFields() != null) {
            for (FieldType key : item.getFields().keySet()) {
                if (!key.getName().equalsIgnoreCase(SUB_BUILDING_NAME)) continue;
                InternalFieldValue value = (InternalFieldValue)item.getField(key);
                return item.getFieldScore(key) == null && value != null && value.toString().startsWith("PO BOX");
            }
        }
        return false;
    }
}

