/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.helper;

import com.mapinfo.mapmarker.GBR.helper.AlternateSoundexKeyGenerator;
import com.mapinfo.mapmarker.GBR.matcher.FieldMatchChecker;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaSacs;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEStreetGeocodingHelper;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GBR_StreetGeocodingHelper
extends CGGEStreetGeocodingHelper {
    private static final FieldType EXTENDED_PC_FIELD = FieldType.POST_CODE_EX_FIELD_TYPE;
    private static final int MAX_AREA_SACS_ALLOWED_FOR_SEARCHING = 25;
    private static final FieldMatchChecker fieldMatchChecker = new FieldMatchChecker();
    protected int localStreetTryCount = 0;
    protected int localAreaSubTryCount = 0;
    private ParsedAddress parsedAddress;
    private ParsedAddress originalParsedAddress;
    private AddressWord[] streetWords;
    private boolean cityAndPostCodeIntersectionSACFound = false;
    private boolean localityAndPostCodeIntersectionSACFound = false;
    private List<DictionaryAreaSacs> savedPCAreaSacs = null;
    private IDataManager dataManager;
    private GeocodeOptions geocodeOptions;
    protected boolean turnedOffIntersection = false;
    private static Pattern AwithNumberHwyPatttern = Pattern.compile("\\b(A\\d{2,})\\b", 2);
    private List<DataSetInfo> dataSetList;
    private boolean isTT;

    @Override
    protected boolean continueRetrying(ParsedAddress pAddr, InternalCandidateList currentList) {
        InternalScoringAddress cand;
        if (super.continueRetrying(pAddr, currentList)) {
            return true;
        }
        if (currentList.hasCloseCandidates() && !this.hasOtherSearchTermsThanPC(cand = currentList.getIndexedCandidate(0))) {
            return !fieldMatchChecker.hasGoodStreetLevelMatch(cand);
        }
        return false;
    }

    private boolean hasOtherSearchTermsThanPC(InternalScoringAddress cand) {
        List<AddressWord> searchWords = cand.getSearchWords();
        if (searchWords != null) {
            for (AddressWord word : searchWords) {
                if (word.m_wordType == FieldType.POST_CODE_EX_FIELD_TYPE) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected boolean generateAreaSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        switch (this.localAreaSubTryCount++) {
            case 0: {
                this.findPCAreaList(dataManager, parsedAddress, true, options);
                return true;
            }
        }
        boolean caseGenerated = true;
        while (!(!caseGenerated || (caseGenerated = super.generateAreaSubTries(dataManager, parsedAddress, options, candidateList)) && this.getSearchAreaList() != null && this.allowCoreAreaRetry())) {
        }
        return caseGenerated;
    }

    @Override
    protected boolean generateStreetSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        boolean doingPOBox;
        this.dataManager = dataManager;
        this.geocodeOptions = options;
        boolean caseGenerated = true;
        boolean bl = doingPOBox = options != null && Boolean.valueOf(options.getGeocodeConstraints().getCustomString("POBOX_MATCH_IN_PROGRESS", "false")) != false;
        if (options != null) {
            this.dataSetList = (List)options.get("allowed_datasets_list");
            if (this.dataSetList != null && this.dataSetList.size() > 0) {
                this.isTT = this.dataSetList.get(0).getName().endsWith("TT");
            }
        }
        switch (this.localStreetTryCount) {
            case 0: {
                List<DictionaryAddressWord> searchWords;
                if (this.getAddressSearchFields().contains(EXTENDED_PC_FIELD) && (searchWords = this.getSearchableWords(this.getPCExWords(parsedAddress), EXTENDED_PC_FIELD, dataManager, 1.0, options)) != null) {
                    this.setSearchWordList(searchWords);
                }
                ++this.localStreetTryCount;
                break;
            }
            case 1: {
                if (this.getAddressSearchFields().contains(EXTENDED_PC_FIELD)) {
                    List<DictionaryAddressWord> searchWords = this.getSearchableWords(this.getPCExWords(parsedAddress), EXTENDED_PC_FIELD, dataManager, 0.85, options);
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, true, 0);
                    List<DictionaryAddressWord> streetSearchWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, 1.0, options);
                    if (searchWords != null && streetSearchWords != null) {
                        searchWords.addAll(streetSearchWords);
                    }
                    if (searchWords != null) {
                        this.setSearchWordList(searchWords);
                    }
                }
                ++this.localStreetTryCount;
                break;
            }
            case 2: {
                if (super.generateStreetSubTries(dataManager, parsedAddress, options, candidateList)) break;
                ++this.localStreetTryCount;
            }
            case 3: {
                List<AddressWord> words;
                List<DictionaryAddressWord> addrSearchWords;
                ++this.localStreetTryCount;
                if (!doingPOBox && (addrSearchWords = this.localGetStreetSearchableWords(words = this.filterWordsAfterStreetType((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE)), dataManager, options)) != null) {
                    this.setSearchWordList(addrSearchWords);
                    break;
                }
            }
            case 4: {
                List<AddressWord> words;
                List<DictionaryAddressWord> addrSearchWords;
                ++this.localStreetTryCount;
                if (!doingPOBox && (addrSearchWords = this.localGetStreetSearchableWords(words = this.filterWordsBeforeStreetType((AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE)), dataManager, options)) != null) {
                    this.setSearchWordList(addrSearchWords);
                    break;
                }
            }
            case 5: {
                ArrayList<AddressWord> words;
                List<DictionaryAddressWord> addrSearchWords;
                AddressWord[] addressWords;
                ++this.localStreetTryCount;
                if (!doingPOBox && parsedAddress.isIntersectionCase() && (addressWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE)) != null && !this.containsToken(addressWords, "&") && (addrSearchWords = this.localGetStreetSearchableWords(words = new ArrayList<AddressWord>(Arrays.asList(addressWords)), dataManager, options)) != null) {
                    parsedAddress.setIntersectionAddress(false);
                    this.turnedOffIntersection = true;
                    this.setSearchWordList(addrSearchWords);
                    break;
                }
            }
            case 6: {
                ++this.localStreetTryCount;
                if (this.turnedOffIntersection) {
                    this.turnedOffIntersection = false;
                    parsedAddress.setIntersectionAddress(true);
                }
            }
            default: {
                this.localStreetTryCount = 2;
                caseGenerated = false;
            }
        }
        return caseGenerated;
    }

    protected boolean containsToken(AddressWord[] words, String token) {
        if (words == null || token == null) {
            return false;
        }
        for (AddressWord word : words) {
            if (!token.equalsIgnoreCase(word.getWord())) continue;
            return true;
        }
        return false;
    }

    private List<DictionaryAddressWord> localGetStreetSearchableWords(List<AddressWord> words, IDataManager dataManager, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        List<DictionaryAddressWord> dictWords = null;
        if (!words.isEmpty()) {
            ArrayList<AddressWord> normalWords = new ArrayList<AddressWord>();
            ArrayList<AddressWord> articleNumericWords = new ArrayList<AddressWord>();
            for (AddressWord word : words) {
                if (CodedWord.isDelimiter(word.getAttributes())) continue;
                if (word.isNumeral() || CodedWord.isArticleWord(word.getAttributes())) {
                    articleNumericWords.add(word);
                    continue;
                }
                normalWords.add(word);
            }
            if (!normalWords.isEmpty()) {
                dictWords = ListUtils.addToList(dictWords, this.getSearchableWords(normalWords.toArray(new AddressWord[normalWords.size()]), FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.getMinimumStreetSearchQuality(), options));
            }
            if (!articleNumericWords.isEmpty()) {
                dictWords = ListUtils.addToList(dictWords, this.getSearchableWords(articleNumericWords.toArray(new AddressWord[articleNumericWords.size()]), FieldType.STREET_NAME_FIELD_TYPE, dataManager, 1.0, options));
            }
        }
        return dictWords;
    }

    @Override
    protected AddressWord[] filterSearchWords(AddressWord[] words, boolean includeNormalWords, boolean combineAlphaNumeric, boolean noMultipleStreetTypeFiltering, int includeMask) {
        return (words = this.checkAndFilterStreetWords(words)) == null ? null : super.filterSearchWords(words, includeNormalWords, combineAlphaNumeric, noMultipleStreetTypeFiltering, includeMask);
    }

    @Override
    public List<DictionaryAddressWord> getSearchableWordsOnSplitInputWords(AddressWord[] words, FieldType searchType, double minQuality, IDataManager dataManager, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        return (words = this.checkAndFilterStreetWords(words)) == null ? null : super.getSearchableWordsOnSplitInputWords(words, searchType, minQuality, dataManager, options);
    }

    @Override
    public AddressWord[] getCombinedPossibles(AddressWord[] words) {
        return (words = this.checkAndFilterStreetWords(words)) == null ? null : super.getCombinedPossibles(words);
    }

    AddressWord[] checkAndFilterStreetWords(AddressWord[] words) {
        boolean isParsedStreetWords;
        if (words == null) {
            return null;
        }
        boolean bl = isParsedStreetWords = words == this.parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (this.streetWords == null || !isParsedStreetWords) {
            ArrayList<AddressWord> wordList = new ArrayList<AddressWord>(Arrays.asList(words));
            this.filterSearchWords(wordList);
            AddressWord[] addressWordArray = words = wordList.isEmpty() ? null : wordList.toArray(new AddressWord[wordList.size()]);
            if (this.streetWords == null && isParsedStreetWords) {
                this.streetWords = words;
            }
        } else {
            words = this.streetWords;
        }
        return words;
    }

    @Override
    public InternalCandidateList searchNextCase(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList curCandList) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        this.setParsedAddress(parsedAddress);
        return super.searchNextCase(dataManager, parsedAddress, options, curCandList);
    }

    @Override
    protected List<DictionaryAddressWord> getSearchableWords(AddressWord[] searchWords, FieldType type, IDataManager dataManager, double minQuality, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        double qualityToUse = minQuality;
        if (type == FieldType.STREET_NAME_FIELD_TYPE && searchWords != null && this.isTT) {
            StringBuilder sb = new StringBuilder();
            for (AddressWord word : searchWords) {
                sb.append(word);
                sb.append(" ");
            }
            Matcher matcher = AwithNumberHwyPatttern.matcher(sb.toString().trim());
            if (matcher.find()) {
                qualityToUse = 1.0;
            }
        }
        if (this.localStreetTryCount < 2 || type != EXTENDED_PC_FIELD) {
            return super.getSearchableWords(searchWords, type, dataManager, qualityToUse, options);
        }
        return null;
    }

    @Override
    protected boolean findPCAreaList(IDataManager dataManager, ParsedAddress parsedAddr, boolean bPerfectArea, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        boolean success = super.findPCAreaList(dataManager, parsedAddr, true, options);
        this.setSearchAreaList(this.getPCAreaList());
        return success;
    }

    @Override
    protected void filterSacsForAreaIntersection(List<DictionaryAreaSacs> areaSacList, List<FieldType> insersectionFieldList) {
        super.filterSacsForAreaIntersection(areaSacList, insersectionFieldList);
        if (!areaSacList.isEmpty()) {
            if (!this.cityAndPostCodeIntersectionSACFound && this.containsAll(insersectionFieldList, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.POST_CODE_FIELD_TYPE)) {
                this.cityAndPostCodeIntersectionSACFound = true;
            }
            if (!this.localityAndPostCodeIntersectionSACFound && this.containsAll(insersectionFieldList, FieldType.AREA_NAME_4_FIELD_TYPE, FieldType.POST_CODE_FIELD_TYPE)) {
                this.localityAndPostCodeIntersectionSACFound = true;
            }
        }
    }

    @Override
    protected void filterSearchedSacs(List<DictionaryAreaSacs> areaSacList, List<DictionaryAddressWord> searchWordList) {
        super.filterSearchedSacs(areaSacList, searchWordList);
        if (areaSacList == null) {
            return;
        }
        List<FieldType> areaIntersectionList = this.getAreaSacIntersectionList();
        if (areaIntersectionList == null || areaIntersectionList.isEmpty()) {
            Iterator<DictionaryAreaSacs> it = areaSacList.iterator();
            while (it.hasNext()) {
                List<DictionaryAreaSacs> pcAreaSacs;
                DictionaryAreaSacs dictAreaSacs = it.next();
                if (dictAreaSacs.m_type == FieldType.POST_CODE_FIELD_TYPE || dictAreaSacs.getAreaSac().length <= 25 || (pcAreaSacs = this.getPDAreaSacs()).isEmpty()) continue;
                this.filterAreaSacs(dictAreaSacs, pcAreaSacs);
                if (dictAreaSacs.getAreaSac() != null) continue;
                it.remove();
            }
        }
    }

    private void filterAreaSacs(DictionaryAreaSacs dictAreaSacs, List<DictionaryAreaSacs> pcAreaSacs) {
        ArrayList<DictionaryAreaSacs> dasList = new ArrayList<DictionaryAreaSacs>();
        dasList.addAll(new ArrayList<DictionaryAreaSacs>(pcAreaSacs));
        dasList.add(dictAreaSacs);
        this.filterSacsForAreaIntersection(dasList, Arrays.asList(dictAreaSacs.m_type, FieldType.POST_CODE_FIELD_TYPE));
    }

    private List<DictionaryAreaSacs> getPDAreaSacs() {
        if (this.savedPCAreaSacs == null) {
            List<DictionaryAreaTermItem> pdAreaList = this.findPartialMatchedPostDistrictAreas();
            if (!pdAreaList.isEmpty()) {
                try {
                    this.savedPCAreaSacs = this.dataManager.getSacsForAreas(1, pdAreaList, this.geocodeOptions);
                }
                catch (DataNotInitialisedException dataNotInitialisedException) {
                    // empty catch block
                }
            }
            if (this.savedPCAreaSacs == null) {
                this.savedPCAreaSacs = Collections.emptyList();
            }
        }
        return this.savedPCAreaSacs;
    }

    private boolean allowCoreAreaRetry() {
        if (this.cityAndPostCodeIntersectionSACFound || this.localityAndPostCodeIntersectionSACFound) {
            return this.m_areaSacIntersectionFieldList != null && this.m_areaSacIntersectionFieldList.size() > 1;
        }
        return true;
    }

    private boolean containsAll(List<FieldType> list, FieldType ... types) {
        for (FieldType type : types) {
            if (list.contains(type)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected List<DictionaryAreaTermItem> findAreaList(AddressWord[] searchWords, FieldType areaType, double minQuality, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        if (minQuality < 0.9999) {
            if (this.cityAndPostCodeIntersectionSACFound && areaType == FieldType.AREA_NAME_3_FIELD_TYPE) {
                return null;
            }
            if (this.localityAndPostCodeIntersectionSACFound && areaType == FieldType.AREA_NAME_4_FIELD_TYPE) {
                return null;
            }
        }
        return super.findAreaList(searchWords, areaType, minQuality, dataManager, options);
    }

    void setParsedAddress(ParsedAddress parsedAddress) {
        if (this.originalParsedAddress == null) {
            this.originalParsedAddress = new ParsedAddress("GBR", "en");
            this.originalParsedAddress.copy(parsedAddress);
        }
        this.parsedAddress = parsedAddress;
    }

    private List<AddressWord> filterWordsBeforeStreetType(AddressWord[] words) {
        ArrayList<AddressWord> wordList;
        int pos;
        if (words != null && (pos = this.indexOfThoroughfareType(wordList = new ArrayList<AddressWord>(Arrays.asList(words)))) > 0) {
            return wordList.subList(0, pos);
        }
        return Collections.emptyList();
    }

    private List<AddressWord> filterWordsAfterStreetType(AddressWord[] words) {
        if (words != null) {
            ArrayList<AddressWord> wordList = new ArrayList<AddressWord>(Arrays.asList(words));
            this.removePostCodeWords(wordList);
            int pos = this.lastIndexOfThorourghfareType(wordList);
            if (pos > -1) {
                int wordAfterTypeStart = pos + 1;
                int count = wordList.size() - wordAfterTypeStart;
                if (count > 0) {
                    return wordList.subList(wordAfterTypeStart, wordAfterTypeStart + count);
                }
            }
        }
        return Collections.emptyList();
    }

    private void filterSearchWords(List<AddressWord> wordList) {
        this.removeNonStreetWords(wordList);
        this.removePostCodeWords(wordList);
    }

    protected void removeNonStreetWords(List<AddressWord> wordList) {
        int streetEnd = this.lastIndexOfThorourghfareType(wordList);
        if (streetEnd > 0) {
            int streetEnd1;
            AddressWord endType = wordList.get(streetEnd);
            if ("ST".equalsIgnoreCase(endType.getWord()) && wordList.size() - 2 > streetEnd && !StringUtilities.hasNumeric((String)wordList.get(streetEnd + 1).getWord())) {
                return;
            }
            int streetStart = streetEnd1 = this.indexOfThoroughfareType(wordList);
            if (streetEnd1 > 0) {
                int addrNumPos = this.lastIndexOfAddressNumber(wordList, streetEnd1);
                if (addrNumPos == -1 && streetEnd != streetEnd1) {
                    addrNumPos = this.lastIndexOfAddressNumber(wordList, streetEnd - 1);
                }
                streetStart = addrNumPos == -1 ? Math.max(0, streetEnd1 - 3) : addrNumPos;
            }
            ArrayList<AddressWord> retainList = new ArrayList<AddressWord>(wordList.subList(streetStart, streetEnd + 1));
            wordList.clear();
            wordList.addAll(retainList);
        }
    }

    private List<DictionaryAreaTermItem> findPartialMatchedPostDistrictAreas() {
        List<DictionaryAreaTermItem> pdAreaTerms = null;
        AlternateSoundexKeyGenerator altSdnxGenerator = new AlternateSoundexKeyGenerator(this.getHelperSoundex());
        List<AddressWord> altPDWords = altSdnxGenerator.getAlternatePostDistrictKeyWords(this.parsedAddress);
        if (!altPDWords.isEmpty()) {
            try {
                AddressWord[] addrWordArray = altPDWords.toArray(new AddressWord[altPDWords.size()]);
                pdAreaTerms = this.findAreaList(addrWordArray, FieldType.POST_CODE_FIELD_TYPE, this.getMinimumPostCodeSearchQuality(), this.dataManager, this.geocodeOptions);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (pdAreaTerms == null) {
            pdAreaTerms = Collections.emptyList();
        }
        return pdAreaTerms;
    }

    private int lastIndexOfAddressNumber(List<AddressWord> wordList, int toIndex) {
        List<AddressNumber> probableAddrNums = this.parsedAddress.getProbableAddressNumbers();
        int lastIndex = -1;
        if (probableAddrNums != null) {
            for (AddressNumber num : probableAddrNums) {
                int[] pos = num.getPositionInInputStreet();
                int numEnds = pos[pos.length - 1];
                if (numEnds == toIndex && pos[0] + 1 < numEnds) {
                    return -1;
                }
                if (numEnds >= toIndex || numEnds <= lastIndex) continue;
                lastIndex = numEnds;
            }
        }
        return lastIndex;
    }

    protected void removePostCodeWords(List<AddressWord> wordList) {
        List<PostCode> probablePCList = this.parsedAddress.getProbablePostcodes();
        if (probablePCList != null) {
            for (PostCode pc : probablePCList) {
                this.removePostCodeWords(wordList, pc);
            }
        }
    }

    private void removePostCodeWords(List<AddressWord> wordList, PostCode pc) {
        AddressWord[] words = pc.getWords();
        Iterator<AddressWord> it = wordList.iterator();
        block0: for (AddressWord pcWord : words) {
            while (it.hasNext()) {
                if (!pcWord.equals(it.next())) continue;
                it.remove();
                continue block0;
            }
        }
    }

    private int lastIndexOfThorourghfareType(List<AddressWord> words) {
        for (int i = words.size() - 1; i >= 0; --i) {
            if (!CodedWord.isThoroughfareTypeWord(words.get(i).getAttributes())) continue;
            return i;
        }
        return -1;
    }

    private int indexOfThoroughfareType(List<AddressWord> words) {
        int len = words.size();
        for (int i = 0; i < len; ++i) {
            if (!CodedWord.isThoroughfareTypeWord(words.get(i).getAttributes())) continue;
            return i;
        }
        return -1;
    }

    private AddressWord[] getPCExWords(ParsedAddress parsedAddress) {
        List<PostCode> pcList;
        ArrayList<AddressWord> pcExWordList = new ArrayList<AddressWord>();
        if (!this.addPCExWordToList((AddressWord[])parsedAddress.getField(FieldType.POST_CODE_FIELD_TYPE), pcExWordList) && (pcList = parsedAddress.getProbablePostcodes()) != null) {
            for (PostCode pc : pcList) {
                this.addPCExWordToList(pc.getWords(), pcExWordList);
            }
        }
        if (!pcExWordList.isEmpty()) {
            return pcExWordList.toArray(new AddressWord[pcExWordList.size()]);
        }
        return new AddressWord[0];
    }

    private boolean addPCExWordToList(AddressWord[] pcWords, List<AddressWord> pcExList) {
        if (pcWords != null && pcWords.length > 1) {
            pcExList.add(pcWords[1]);
            return true;
        }
        return false;
    }

    @Override
    public AddressWord[] getSplitWords(AddressWord[] inWords) {
        if (inWords != null) {
            ICGGEParser parser = this.getHelperParser();
            ICGGESoundex soundex = this.getHelperSoundex();
            StringBuilder sb = new StringBuilder(15);
            ArrayList<AddressWord> splitWords = new ArrayList<AddressWord>(5);
            Matcher matcher = null;
            for (AddressWord addrWord : inWords) {
                boolean skipforTT;
                matcher = AwithNumberHwyPatttern.matcher(addrWord.getWord().trim());
                boolean bl = skipforTT = this.isTT && matcher.find();
                if (addrWord == null || skipforTT) continue;
                char[] ch = addrWord.getWordChars();
                int len = ch.length;
                sb.append(ch);
                for (int i = 1; i < len - 1; ++i) {
                    AddressWord splitWord2;
                    AddressWord splitWord1 = parser.convertToAddressWord(sb.substring(0, i + 1), soundex);
                    if (AddressWord.isSignificantWord(splitWord1)) {
                        splitWords.add(splitWord1);
                    }
                    if (!AddressWord.isSignificantWord(splitWord2 = parser.convertToAddressWord(sb.substring(i), soundex))) break;
                    splitWords.add(splitWord2);
                }
                sb.delete(0, len);
            }
            if (splitWords.size() > 0) {
                return splitWords.toArray(new AddressWord[splitWords.size()]);
            }
        }
        return null;
    }

    @Override
    protected InternalCandidateList retrieveCandidates(IDataManager dataManager, ParsedAddress parsedAddress, List<DictionaryAreaTermItem> areaList, List<DictionaryAddressWord> searchWordList, GeocodeOptions options) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        List dataSetList = (List)options.get("allowed_datasets_list");
        if (this.handleLondonNoPostcode(dataSetList, parsedAddress, areaList, searchWordList)) {
            InternalCandidateList candList = null;
            if (areaList != null && searchWordList != null) {
                Collection<InternalScoringAddress> cands;
                areaList = new ArrayList<DictionaryAreaTermItem>(areaList);
                searchWordList = new ArrayList<DictionaryAddressWord>(searchWordList);
                this.filterSearchedAreaItemAndSearchWord(areaList, searchWordList);
                List<DictionaryAreaSacs> areaSacList = dataManager.getSacsForAreas(1, areaList, options);
                if (areaSacList != null && this.m_areaSacIntersectionFieldList != null && this.m_areaSacIntersectionFieldList.size() > 0) {
                    this.filterSacsForAreaIntersection(areaSacList, this.m_areaSacIntersectionFieldList);
                }
                if (areaSacList != null) {
                    this.filterSearchedSacs(areaSacList, searchWordList);
                }
                if (areaSacList != null && (cands = dataManager.findCandidates(this.getGeocodeType(), areaSacList, searchWordList, options)) != null) {
                    this.removeCandsForSpecialCase(cands, searchWordList.size());
                    if (candList == null) {
                        candList = new InternalCandidateList();
                    }
                    candList.addCandidates(cands);
                }
            }
            return candList;
        }
        return super.retrieveCandidates(dataManager, parsedAddress, areaList, searchWordList, options);
    }

    private boolean isLondonCase(List<DictionaryAreaTermItem> areaList) {
        if (areaList != null && areaList.size() > 0) {
            for (DictionaryAreaTermItem item : areaList) {
                AddressWord[] awds = item.getAreaAddressWords();
                if (awds == null || awds.length != 1 || !awds[0].getWord().equalsIgnoreCase("London")) continue;
                return true;
            }
        }
        return false;
    }

    protected boolean handleLondonNoPostcode(List<DataSetInfo> list, ParsedAddress pa, List<DictionaryAreaTermItem> areaList, List<DictionaryAddressWord> searchWordList) {
        if (list != null && list.size() > 0 && pa != null && !pa.isIntersectionCase() && searchWordList != null && searchWordList.size() > 0 && areaList != null && areaList.size() > 0) {
            AddressWord[] hnWords;
            boolean inputHasHnr = pa.getField(FieldType.ADDRESS_NUMBER_FIELD_TYPE) != null || pa.getProbableAddressNumbers() != null && pa.getProbableAddressNumbers().size() > 0;
            boolean LondonCase = this.isLondonCase(areaList);
            boolean ignoreHN = false;
            if (this.dataSetList == null) {
                this.isTT = list.get(0).getName().endsWith("TT");
            }
            if (inputHasHnr && (hnWords = (AddressWord[])pa.getField(FieldType.ADDRESS_NUMBER_FIELD_TYPE)) == null) {
                List<AddressNumber> hnList = pa.getProbableAddressNumbers();
                for (AddressNumber hn : hnList) {
                    if (hn.getHnrNumber1() != 0 && hn.getHnrNumber1() < 1000000) continue;
                    ignoreHN = true;
                    break;
                }
            }
            if (this.isTT && LondonCase && (!inputHasHnr || ignoreHN) && pa.getField(FieldType.POST_CODE_FIELD_TYPE) == null && (pa.getProbablePostcodes() == null || pa.getProbablePostcodes().size() == 0)) {
                return true;
            }
        }
        return false;
    }

    protected void removeCandsForSpecialCase(Collection<InternalScoringAddress> cands, int numsearchWords) {
        InternalScoringAddress addr;
        if (cands == null) {
            return;
        }
        Iterator<InternalScoringAddress> iter = cands.iterator();
        while (iter.hasNext()) {
            addr = iter.next();
            if (((AddressWord[])((InternalFieldValue)addr.getField(FieldType.STREET_NAME_FIELD_TYPE)).getFieldValue()).length <= numsearchWords + 1) continue;
            iter.remove();
        }
        if (cands.size() >= 100) {
            iter = cands.iterator();
            while (iter.hasNext()) {
                addr = iter.next();
                if (addr.getField(FieldType.POST_CODE_EX_FIELD_TYPE) == null || ((InternalFieldValue)addr.getField(FieldType.POST_CODE_EX_FIELD_TYPE)).getAlternateValues() == null || ((AddressWord[][])((InternalFieldValue)addr.getField(FieldType.POST_CODE_EX_FIELD_TYPE)).getAlternateValues()).length <= 0) continue;
                iter.remove();
            }
        }
    }

    @Override
    public void resetRetries() {
        super.resetRetries();
        this.parsedAddress.copy(this.originalParsedAddress);
        this.localStreetTryCount = 0;
        this.localAreaSubTryCount = 0;
    }

    @Override
    public void putPOBoxInMainStreetAddress(GeocodeOptions options, ParsedAddress parsedAddress) {
        super.putPOBoxInMainStreetAddress(options, parsedAddress);
        this.setParsedAddress(parsedAddress);
    }
}

