/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.matcher;

import com.mapinfo.mapmarker.GBR.matcher.RangeScoreCalculator;
import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.matcher.CGGEInternalScoringRangeComparator;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.List;

public class GBRInternalScoringRangeComparator
extends CGGEInternalScoringRangeComparator {
    private final RangeScoreCalculator rangeScoreCalculator;

    GBRInternalScoringRangeComparator(RangeScoreCalculator rangeScoreCalculator) {
        this.rangeScoreCalculator = rangeScoreCalculator;
    }

    @Override
    public int compare(InternalScoringRange r1, InternalScoringRange r2) {
        if (r1.isCloseMatch() == r2.isCloseMatch()) {
            int c = MMUtils.compareDoubleValues(r1.getCombinedScore(), r2.getCombinedScore());
            if (c != 0) {
                return c;
            }
            c = this.compareRangeFieldScores(r1, r2);
            if (c != 0) {
                return c;
            }
            c = this.compareAddressNumberScores(r1, r2);
            if (c != 0) {
                return c;
            }
            return this.compareRangeFieldCount(r1, r2);
        }
        if (r1.isCloseMatch()) {
            return 1;
        }
        return -1;
    }

    private int compareRangeFieldCount(InternalScoringRange r1, InternalScoringRange r2) {
        int c1 = r1.getFields().size();
        int c2 = r2.getFields().size();
        if (r1.getFrom() != null) {
            ++c1;
        }
        if (r2.getFrom() != null) {
            ++c2;
        }
        return c2 - c1;
    }

    private int compareRangeFieldScores(InternalScoringRange r1, InternalScoringRange r2) {
        List<FieldScore> fieldScores1 = this.rangeScoreCalculator.getScoredRangeFieldsSortedByFieldWeight(r1);
        List<FieldScore> fieldScores2 = this.rangeScoreCalculator.getScoredRangeFieldsSortedByFieldWeight(r2);
        int c = Math.min(fieldScores1.size(), fieldScores2.size());
        for (int i = 0; i < c; ++i) {
            FieldScore score1 = fieldScores1.get(i);
            FieldScore score2 = fieldScores2.get(i);
            if (score1.m_matched != score2.m_matched) {
                if (score1.m_matched) {
                    return 1;
                }
                return -1;
            }
            if (score1.m_fieldWeight > score2.m_fieldWeight) {
                return 1;
            }
            if (!(score1.m_fieldWeight < score2.m_fieldWeight)) continue;
            return -1;
        }
        if (fieldScores1.size() > c) {
            return 1;
        }
        if (fieldScores2.size() > c) {
            return -1;
        }
        return 0;
    }

    @Override
    protected int compareAddressNumberScores(InternalScoringRange r1, InternalScoringRange r2) {
        int c = super.compareAddressNumberScores(r1, r2);
        if (c == 0) {
            AddressNumberScore n1Score = (AddressNumberScore)r1.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
            AddressNumberScore n2Score = (AddressNumberScore)r2.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
            if (this.hasComparableCandAddressNumber(n1Score) && this.hasComparableCandAddressNumber(n2Score)) {
                AddressNumber n1 = n1Score.getCandidateAddressNumber();
                AddressNumber n2 = n2Score.getCandidateAddressNumber();
                if (n1Score.isNumber2Matched() == n2Score.isNumber2Matched()) {
                    if (n1.getHnrNumber2() == 0 && n2.getHnrNumber2() > 0) {
                        return 1;
                    }
                    if (n1.getHnrNumber2() > 0 && n2.getHnrNumber2() == 0) {
                        return -1;
                    }
                }
                if (n1Score.isSuffix1Matched() == n2Score.isSuffix1Matched()) {
                    if (n1.getHnrSuffix1() == null && n2.getHnrSuffix1() != null) {
                        return 1;
                    }
                    if (n1.getHnrSuffix1() != null && n2.getHnrSuffix1() == null) {
                        return -1;
                    }
                }
            }
        }
        return c;
    }

    private boolean hasComparableCandAddressNumber(AddressNumberScore addrNumberScore) {
        return addrNumberScore != null && addrNumberScore.m_candidateFieldPresent && (addrNumberScore.m_matched || addrNumberScore.getOffset() > 0) && addrNumberScore.getCandidateAddressNumber() != null;
    }
}

