/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.matcher;

import com.mapinfo.mapmarker.GBR.GBR_Utils;
import com.mapinfo.mapmarker.GBR.matcher.FieldMatchChecker;
import com.mapinfo.mapmarker.GBR.matcher.GBRInternalScoringRangeComparator;
import com.mapinfo.mapmarker.GBR.matcher.RangeScoreCalculator;
import com.mapinfo.mapmarker.GBR.matcher.RelativeCandidateScoreAdjuster;
import com.mapinfo.mapmarker.GBR.matcher.RelativeRangeScoreAdjuster;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalRangeAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.address.ScoringItem;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.matcher.FieldScoreAdjuster;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class GBR_Matcher
extends CGGEMatcher1 {
    private static final FieldMatchChecker fieldMatchChecker = new FieldMatchChecker();
    static final String KEY_RANGE_SCORE_CALCULATOR_OBJECT = "range_score_calculator_object";
    private static final FieldType ADDRESS_NUMBER_FIELD = FieldType.ADDRESS_NUMBER_FIELD_TYPE;

    @Override
    protected void adjustScores(InternalScoringAddress cand, ParsedAddress pAddr, MatchingOptions matchingOptions) {
        if (cand.getAddressType() != 1) {
            super.adjustScores(cand, pAddr, matchingOptions);
        }
        if (fieldMatchChecker.hasPostDistrictMatch(cand) && fieldMatchChecker.hasGoodEnoughStreetMatch(cand)) {
            return;
        }
        FieldScore savedStreetScore = this.copyFieldScore(cand, FieldType.STREET_NAME_FIELD_TYPE);
        super.adjustScores(cand, pAddr, matchingOptions);
        this.reAdjustStreetScore(cand, savedStreetScore);
    }

    @Override
    public void scoreRanges(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        InternalScoringRange[] scoringRanges;
        RangeScoreCalculator rangeScoreCalculator = new RangeScoreCalculator(this, matchingOptions);
        scoringAddr.setAdditionalInfo(KEY_RANGE_SCORE_CALCULATOR_OBJECT, rangeScoreCalculator);
        for (InternalScoringRange scoringRange : scoringRanges = scoringAddr.getRanges()) {
            this.scoreRange(scoringAddr, scoringRange, parsedAddr, matchingOptions, scorer);
            rangeScoreCalculator.addScoredRange(scoringRange);
        }
        for (InternalScoringRange scoringRange : scoringRanges) {
            rangeScoreCalculator.calculateAndSetCombinedRangeScore(scoringRange);
            this.calculateRangeCloseMatch(scoringRange, parsedAddr, matchingOptions);
        }
        Arrays.sort(scoringRanges, Collections.reverseOrder(new GBRInternalScoringRangeComparator(rangeScoreCalculator)));
        this.addRangeScores(scoringAddr, scoringAddr.getRangeAt(0).getFieldScores(), scorer);
    }

    private void addRangeScores(InternalScoringAddress scoringAddr, Map<FieldType, FieldScore> rangeScores, ICGGEScorer scorer) {
        if (rangeScores != null && !rangeScores.isEmpty()) {
            for (Map.Entry<FieldType, FieldScore> scoreEn : scoringAddr.getFieldScores().entrySet()) {
                AddressWord[] inputWords;
                IntArray matchedWords;
                FieldScore newScore;
                FieldScore currScore;
                FieldType type = scoreEn.getKey();
                FieldScore originalScore = scoreEn.getValue();
                if (originalScore == null || !(originalScore.m_value > 0.5) || !this.isStreetLevelOrLowerField(type) || (currScore = rangeScores.get(type)) != null && originalScore.compareTo(currScore) <= 0 || !fieldMatchChecker.acceptableFieldMatch(newScore = super.scoreCandFieldWithIgnoredWords(originalScore.m_inputWords, matchedWords = fieldMatchChecker.getMatchedWordsNdxs(rangeScores, inputWords = originalScore.m_inputWords), scoringAddr, type, originalScore, scorer)) || currScore != null && newScore.compareTo(currScore) <= 0) continue;
                rangeScores.put(type, newScore);
            }
            scoringAddr.setFieldScores(rangeScores);
        }
    }

    private boolean isStreetLevelOrLowerField(FieldType type) {
        FieldType.FieldLevel level = type.getLevel();
        return level == FieldType.FieldLevel.LEVEL_STREET || level == FieldType.FieldLevel.LEVEL_POSTAL;
    }

    @Override
    public boolean isFirstABetterScore(FieldScore score1, FieldScore score2, FieldType inputType, FieldType candType1, FieldType candType2) {
        if (candType2 == FieldType.POST_CODE_FIELD_TYPE || candType2 == FieldType.POST_CODE_EX_FIELD_TYPE) {
            return false;
        }
        if (candType1 == FieldType.POST_CODE_FIELD_TYPE || candType1 == FieldType.POST_CODE_EX_FIELD_TYPE) {
            return true;
        }
        return super.isFirstABetterScore(score1, score2, inputType, candType1, candType2);
    }

    @Override
    public double calculateCombinedAddressScore(InternalScoringAddress scoringAddr, MatchingOptions matchOptions) {
        InternalScoringRange range;
        double scorePossible = matchOptions.getPostAddressWeight();
        scorePossible += matchOptions.getStreetAddressWeight();
        scorePossible += matchOptions.getRangeAddressWeight();
        double score = scoringAddr.getCombinedPostalScore() * matchOptions.getPostAddressWeight();
        score += scoringAddr.getCombinedStreetScore() * matchOptions.getStreetAddressWeight();
        if (scoringAddr.getRangeCount() > 0 && fieldMatchChecker.isUsableRangeMatch(range = scoringAddr.getRangeAt(0))) {
            score += range.getCombinedScore() * matchOptions.getRangeAddressWeight();
        }
        if (scorePossible > 0.0) {
            score /= scorePossible;
        }
        scoringAddr.setCombinedScore(score);
        return score;
    }

    @Override
    public boolean calculateCloseMatch(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, GeocodeOptions options, MatchingOptions matchOptions) throws CGGEInternalException {
        if (options.getGeocodeType() == 1) {
            FieldScore addrNumScore;
            InternalScoringRange range = scoringAddr.getRangeAt(0);
            if (range.isCloseMatch() && (addrNumScore = range.getFieldScore(ADDRESS_NUMBER_FIELD)) != null && addrNumScore.m_value == 0.0 && !addrNumScore.m_candidateFieldPresent) {
                addrNumScore.m_inputFieldPresent = false;
            }
            super.calculateCloseMatch(scoringAddr, parsedAddr, options, matchOptions);
            if (scoringAddr.isCloseMatch() && this.isTTFPCase(scoringAddr, options)) {
                scoringAddr.setCloseMatch(false);
                return false;
            }
            if (this.isFirmMatchWithPoBoxStreet(scoringAddr, options)) {
                scoringAddr.setCloseMatch(false);
                return false;
            }
            if (this.checkFalsePositiveCase(scoringAddr)) {
                if (this.checkMustMatchFalsePositives(scoringAddr, parsedAddr, options, matchOptions)) {
                    AddressNumber from;
                    IConstraints constraints = options.getGeocodeConstraints();
                    if (Boolean.valueOf(constraints.getCustomString("POBOX_MATCH_IN_PROGRESS", "false")).booleanValue() && !StringUtilities.equalStrings((String)(from = scoringAddr.getRangeAt(0).getFrom()).toString(), (String)parsedAddr.getAddressNumber().toString())) {
                        scoringAddr.setCloseMatch(false);
                        return false;
                    }
                    return true;
                }
                return false;
            }
            return false;
        }
        return super.calculateCloseMatch(scoringAddr, parsedAddr, options, matchOptions);
    }

    protected boolean isTTFPCase(InternalScoringAddress scoringAddr, GeocodeOptions options) {
        boolean isType;
        int pos;
        List dataSetList = (List)options.get("allowed_datasets_list");
        boolean isTTcase = ((DataSetInfo)dataSetList.get(0)).getName().endsWith("TT") && options.getGeocodeType() == 1;
        InternalFieldValue ifv = (InternalFieldValue)scoringAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        AddressWord[] fv = null;
        if (ifv != null) {
            fv = (AddressWord[])ifv.getFieldValue();
        }
        FieldScore fscore = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        return isTTcase && scoringAddr.isCloseMatch() && fscore.m_matchedInputWords.size() == 1 && fscore.m_inputWords.length > 2 && fv.length - 1 == 1 && (pos = fscore.m_matchedInputWords.get(0)) + 1 < fscore.m_inputWords.length - 1 && !(isType = CodedWord.isThoroughfareTypeWord(fscore.m_inputWords[pos + 1].getAttributes())) && CodedWord.isThoroughfareTypeWord(fv[1].getAttributes());
    }

    protected boolean isFirmMatchWithPoBoxStreet(InternalScoringAddress scoringAddr, GeocodeOptions options) {
        AddressWord[] addrWords;
        boolean streetIsPoBox = false;
        String origPOBNum = options.getGeocodeConstraints().getCustomString("ORIGPOBOXNUM");
        InternalFieldValue streetIfv = (InternalFieldValue)scoringAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        if (streetIfv != null && (addrWords = (AddressWord[])streetIfv.getFieldValue()).length == 2 && addrWords[0].getWord().equalsIgnoreCase("PO") && addrWords[1].getWord().equalsIgnoreCase("BOX")) {
            streetIsPoBox = true;
        }
        if (origPOBNum != null && streetIsPoBox && "true".equals(scoringAddr.getAdditionalInfo("POBOX_MATCH_IN_PROGRESS")) && !"true".equals(options.getGeocodeConstraints().getCustomString("POBOX_MATCH_IN_PROGRESS"))) {
            InternalRangeAddress range = null;
            AddressNumber addrNum = null;
            InternalScoringRange matchedRange = scoringAddr.getMatchedRange();
            if (matchedRange != null) {
                range = matchedRange.getRange();
                addrNum = range.getFrom();
            }
            if (addrNum == null || origPOBNum != null && !origPOBNum.equalsIgnoreCase(addrNum.toString())) {
                return true;
            }
        }
        return false;
    }

    protected boolean checkMustMatchFalsePositives(InternalScoringAddress scoringAddress, ParsedAddress parsedAddress, GeocodeOptions options, MatchingOptions matchOptions) throws CGGEInternalException {
        IConstraints constraints = options.getGeocodeConstraints();
        if (constraints.isMustMatchPostalCode()) {
            List<PostCode> postCodes = parsedAddress.getProbablePostcodes();
            if (postCodes == null || postCodes.isEmpty()) {
                return true;
            }
            InternalFieldValue postalDistrict = (InternalFieldValue)scoringAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
            if (postalDistrict == null) {
                return true;
            }
            InternalFieldValue postalUnit = (InternalFieldValue)scoringAddress.getField(FieldType.POST_CODE_EX_FIELD_TYPE);
            StringBuilder stringBuilder = new StringBuilder(postalDistrict.toString());
            if (postalUnit != null) {
                stringBuilder.append(postalUnit.toString());
            }
            String candidatePostcode = stringBuilder.toString();
            for (PostCode postCode : postCodes) {
                if (!candidatePostcode.startsWith(postCode.toString().toUpperCase())) continue;
                return true;
            }
            scoringAddress.setCloseMatch(false);
            return false;
        }
        return true;
    }

    protected void handleFirmMatchHasPoBox(InternalCandidateList candList, GeocodeOptions options) {
        if (candList != null && candList.hasCandidates() && candList.getIndexedCandidate(0).getField(FieldType.STREET_NAME_FIELD_TYPE) != null && ((InternalFieldValue)candList.getIndexedCandidate(0).getField(FieldType.STREET_NAME_FIELD_TYPE)).toString().startsWith("PO BOX") && options.getGeocodeConstraints() != null && !"true".equalsIgnoreCase(options.getGeocodeConstraints().getCustomString("POBOX_MATCH_IN_PROGRESS"))) {
            for (InternalScoringAddress scoringAddress : candList.getCandidateList()) {
                if (scoringAddress.getField(FieldType.STREET_NAME_FIELD_TYPE) == null || !((InternalFieldValue)scoringAddress.getField(FieldType.STREET_NAME_FIELD_TYPE)).toString().startsWith("PO BOX")) continue;
                scoringAddress.setAdditionalInfo("POBOX_MATCH_IN_PROGRESS", "true");
                if (options.getGeocodeConstraints().getCustomString("DO_S3_FOR_THIS_CAND") == null) continue;
                options.getGeocodeConstraints().removeCustomObject((Object)"DO_S3_FOR_THIS_CAND");
            }
        }
    }

    @Override
    public InternalCandidateList scoreCandidates(ParsedAddress parsedAddress, InternalCandidateList candList, GeocodeOptions options, IDataManager dataManager) throws CGGEInternalException {
        this.handleFirmMatchHasPoBox(candList, options);
        candList = super.scoreCandidates(parsedAddress, candList, options, dataManager);
        if (options.getGeocodeType() == 1) {
            RelativeRangeScoreAdjuster relativeRangeScoreAdjuster = new RelativeRangeScoreAdjuster(this, options);
            relativeRangeScoreAdjuster.adjustOnRangeScores(candList);
            RelativeCandidateScoreAdjuster relativeCandidateAdjuster = new RelativeCandidateScoreAdjuster(this);
            relativeCandidateAdjuster.adjustScores(candList);
        }
        return candList;
    }

    @Override
    public void mergeCandidates(InternalCandidateList candList1, InternalCandidateList candList2) {
        try {
            RelativeRangeScoreAdjuster.BASE_ADJUSTER.adjustOnRangeScoresForMergingLists(candList1, candList2);
        }
        catch (Exception e) {
            throw new CGGERuntimeException(e);
        }
        super.mergeCandidates(candList1, candList2);
    }

    @Override
    protected void scoreRange(InternalScoringAddress scoringAddr, InternalScoringRange scoringRange, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        super.scoreRange(scoringAddr, scoringRange, pAddr, matchingOptions, scorer);
        Map<FieldType, FieldScore> rangeFieldScores = scoringRange.getFieldScores();
        for (Map.Entry<FieldType, FieldScore> scoreEn : rangeFieldScores.entrySet()) {
            this.adjustRangeFieldScore(scoringRange, scoreEn.getKey(), scoreEn.getValue(), rangeFieldScores);
        }
    }

    private void adjustRangeFieldScore(InternalScoringRange scoringRange, FieldType fieldType, FieldScore score, Map<FieldType, FieldScore> rangeFieldScores) {
        if (this.shouldAdjustRangeFieldScore(scoringRange, fieldType, score)) {
            FieldScoreAdjuster fieldScoreAdjuster = this.getFieldScoreAdjuster();
            fieldScoreAdjuster.adjustScoreForInsignificantWordMatches(score, fieldType, rangeFieldScores);
            fieldScoreAdjuster.adjustScoreForMissingWord(score, rangeFieldScores, 0.7);
        }
    }

    private boolean shouldAdjustRangeFieldScore(InternalScoringRange scoringRange, FieldType type, FieldScore score) {
        if (type.getLevel() == FieldType.FieldLevel.LEVEL_RANGE && type != ADDRESS_NUMBER_FIELD && score.m_value > 0.0 && score.matchedCandidateWordCount() > 0) {
            return (!score.m_matched || score.perfectCandidateWordCount() <= 1) && !this.possibleUnitLevelMatch(scoringRange, type, score);
        }
        return false;
    }

    private boolean possibleUnitLevelMatch(InternalScoringRange scoringRange, FieldType type, FieldScore score) {
        AddressNumberScore addrNumScore = (AddressNumberScore)scoringRange.getFieldScore(ADDRESS_NUMBER_FIELD);
        if (!(addrNumScore != null && addrNumScore.m_candidateFieldPresent || score.matchedCandidateWordCount() <= 0 || fieldMatchChecker.countMatchableWords(score.m_candWords) <= 1)) {
            return fieldMatchChecker.areAllMatchedCandidateWordsAlphaNumerics(score) && fieldMatchChecker.areAllUnMatchedCandidateWordsNonSignificant(score) && fieldMatchChecker.areAllMatchedInputWordsAlphaNumerics(score);
        }
        return false;
    }

    @Override
    protected void calculateCombinedStreetScore(InternalScoringAddress scoringAddr, ParsedAddress parsedAddress, MatchingOptions options) {
        super.calculateCombinedStreetScore(scoringAddr, parsedAddress, options);
        if (scoringAddr.getAddressType() == 1) {
            this.adjustForMissingStreet(scoringAddr, parsedAddress);
        }
    }

    private void adjustForMissingStreet(InternalScoringAddress scoringAddr, ParsedAddress parsedAddress) {
        if (!parsedAddress.isIntersectionCase() && !fieldMatchChecker.hasScoringStreetFields(scoringAddr)) {
            double currentScore = scoringAddr.getCombinedStreetScore();
            boolean candStreetFieldMissing = currentScore >= 0.9999;
            boolean bDependntStreetMatch = false;
            if (!candStreetFieldMissing && (scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE) == null || scoringAddr.getFieldScore((FieldType)FieldType.STREET_NAME_FIELD_TYPE).m_value == 0.0) && scoringAddr.getFieldScore(scoringAddr.getDataSetInfo().getMetaData().getFieldForName("DEPENDENT_STREET")) != null && scoringAddr.getFieldScore((FieldType)scoringAddr.getDataSetInfo().getMetaData().getFieldForName((String)"DEPENDENT_STREET")).m_value >= 0.9999) {
                candStreetFieldMissing = true;
                bDependntStreetMatch = true;
            }
            if (candStreetFieldMissing || fieldMatchChecker.hasPerfectMatch(scoringAddr, FieldType.POST_CODE_FIELD_TYPE) && !this.isStreetNameSearch(scoringAddr) && GBR_Utils.hasFullPostCode(scoringAddr.getInternalAddress()) && (bDependntStreetMatch || this.hasRangeMatchedOnBuildingWords(scoringAddr))) {
                this.adjustForMissingStreet(scoringAddr, parsedAddress, candStreetFieldMissing);
            }
        }
    }

    private void adjustForMissingStreet(InternalScoringAddress scoringAddr, ParsedAddress parsedAddress, boolean candStreetMissing) {
        int inputWordCount;
        AddressWord[] streetInputWords;
        double score = 0.75;
        if (candStreetMissing) {
            score += 0.05;
        }
        if ((streetInputWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE)) != null && (inputWordCount = fieldMatchChecker.countMatchableWords(streetInputWords)) > 0) {
            int matchedWordCount = fieldMatchChecker.getMatchedWordCount(scoringAddr.getFieldScores(), streetInputWords);
            score = matchedWordCount < inputWordCount ? (score += 0.2 * ((double)matchedWordCount / (double)inputWordCount)) : (score += 0.2);
        }
        scoringAddr.setCombinedStreetScore(score);
    }

    private boolean isStreetNameSearch(InternalScoringAddress scoringAddr) {
        List<AddressWord> searchWords = scoringAddr.getSearchWords();
        if (searchWords != null) {
            for (AddressWord searchWord : searchWords) {
                if (searchWord.m_wordType.getLevel() != FieldType.FieldLevel.LEVEL_STREET) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void calculateCombinedPostAddressScore(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, MatchingOptions matchOptions) {
        super.calculateCombinedPostAddressScore(scoringAddr, parsedAddr, matchOptions);
        double currPostAddressScore = scoringAddr.getCombinedPostalScore();
        if (currPostAddressScore > 0.0 && !GBR_Utils.hasFullPostCode(scoringAddr.getInternalAddress())) {
            scoringAddr.setCombinedPostalScore(currPostAddressScore * 0.98);
        }
    }

    private void reAdjustStreetScore(InternalScoringAddress cand, FieldScore savedFieldScore) {
        FieldScore currStreetScore;
        if (savedFieldScore != null && savedFieldScore.m_value > 0.0 && (currStreetScore = cand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE)) != null && currStreetScore.m_value < savedFieldScore.m_value && fieldMatchChecker.allWordsMatched(currStreetScore) && fieldMatchChecker.hasMatchingSignificantWords(currStreetScore) && currStreetScore.inputWordsMatchedInOrder()) {
            currStreetScore.m_value = Math.max(currStreetScore.m_value, savedFieldScore.m_value * 0.85);
        }
    }

    private FieldScore copyFieldScore(InternalScoringAddress cand, FieldType type) {
        FieldScore score = cand.getFieldScore(type);
        if (score != null) {
            FieldScore copyingScore = new FieldScore();
            copyingScore.copy(score);
            return copyingScore;
        }
        return null;
    }

    @Override
    protected FieldScore scorePostCode(ScoringItem addr, ParsedAddress parsedAddr, Map<FieldType, FieldScore> currentScores, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        AddressWord[] inputPC = (AddressWord[])parsedAddr.getField(FieldType.POST_CODE_FIELD_TYPE);
        FieldScore pcScore = null;
        List<AddressWord[]> candPcs = this.getCandPostCodes(addr);
        pcScore = inputPC != null ? this.scoreInputPC(inputPC, candPcs, scorer) : this.scoreProbablePCs(parsedAddr, candPcs, scorer);
        return pcScore;
    }

    private FieldScore scoreInputPC(AddressWord[] inputPC, List<AddressWord[]> candPCs, ICGGEScorer scorer) {
        int candPCCount = candPCs.size();
        FieldScore bestScore = null;
        for (int candPCNdx = 0; candPCNdx < candPCCount; ++candPCNdx) {
            FieldScore pcScore = this.scorePostCode(inputPC, candPCs.get(candPCNdx), scorer);
            if (bestScore != null && pcScore.compare(pcScore, bestScore) <= 0) continue;
            bestScore = pcScore;
            bestScore.m_matchedAltIndex = candPCNdx - 1;
        }
        return bestScore;
    }

    private FieldScore scoreProbablePCs(ParsedAddress parsedAddr, List<AddressWord[]> candPCs, ICGGEScorer scorer) {
        List<PostCode> probablePCList = parsedAddr.getProbablePostcodes();
        if (probablePCList == null || probablePCList.isEmpty()) {
            return null;
        }
        int candPCCount = candPCs.size();
        FieldScore bestScore = null;
        AddressWord[] inputWords = this.getPostAddressWords(parsedAddr);
        for (int candPCNdx = 0; candPCNdx < candPCCount; ++candPCNdx) {
            for (PostCode probablePC : probablePCList) {
                FieldScore pcScore = this.scorePostCode(probablePC, candPCs.get(candPCNdx), scorer);
                if (bestScore != null && pcScore.compare(pcScore, bestScore) <= 0) continue;
                bestScore = pcScore;
                bestScore.m_matchedAltIndex = candPCNdx - 1;
                bestScore.m_inputWords = inputWords;
            }
        }
        return bestScore;
    }

    @Override
    protected void scoreRangeAddressNumber(InternalScoringAddress scoringAddr, InternalScoringRange scoringRange, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        super.scoreRangeAddressNumber(scoringAddr, scoringRange, pAddr, matchingOptions, scorer);
        AddressNumberScore addrNumberScore = (AddressNumberScore)scoringRange.getFieldScore(ADDRESS_NUMBER_FIELD);
        if (addrNumberScore == null && pAddr.getProbableAddressNumbers() != null && this.dependStreetBeforeStreet(scoringAddr)) {
            super.scoreRangeAddressNumber(scoringAddr, scoringRange, pAddr, matchingOptions, scorer);
            addrNumberScore = (AddressNumberScore)scoringRange.getFieldScore(ADDRESS_NUMBER_FIELD);
        }
        if (addrNumberScore != null) {
            addrNumberScore.m_fieldWeight = matchingOptions.getFieldWeight(ADDRESS_NUMBER_FIELD);
            addrNumberScore.calculateAndSetScoreValue(matchingOptions);
        }
    }

    private boolean dependStreetBeforeStreet(InternalScoringAddress scorAddr) {
        FieldScore depStreetScore = scorAddr.getFieldScore(this.getDependentStreetFieldType(scorAddr));
        FieldScore streetScore = scorAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        if (depStreetScore == null || streetScore == null) {
            return false;
        }
        if (depStreetScore.m_matchedInputWords.size() == 0 || streetScore.m_matchedInputWords.size() == 0) {
            return false;
        }
        if (depStreetScore.m_matchedInputWords.get(0) == 1 && depStreetScore.m_matchedInputWords.get(0) < streetScore.m_matchedInputWords.get(0)) {
            scorAddr.setAdjustedEndValForHnr(depStreetScore.m_matchedInputWords.get(0));
            return true;
        }
        return false;
    }

    @Override
    protected AddressNumberScore scoreProbableAddressNumber(AddressNumber addrNumber, InternalScoringRange scoringRange, ParsedAddress parsedAddress) {
        AddressNumberScore addrNumberScore = super.scoreProbableAddressNumber(addrNumber, scoringRange, parsedAddress);
        addrNumberScore.m_inputWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
        return this.checkAndAdjustAddressNumberScore(addrNumberScore, scoringRange);
    }

    private AddressNumberScore checkAndAdjustAddressNumberScore(AddressNumberScore addrNumScore, InternalScoringRange scoringRange) {
        FieldScore score;
        FieldType type;
        FieldScore scoreCopy;
        Map<FieldType, FieldScore> rangeFieldScores;
        Map.Entry<FieldType, FieldScore> fieldScoresWithSameWordEn;
        if (IntArray.size(addrNumScore.m_matchedInputWords) > 0 && (fieldScoresWithSameWordEn = this.getScoreWithCommonMatchedWords(rangeFieldScores = scoringRange.getFieldScores(), addrNumScore)) != null && !this.adjustScoreForAddressNumberMatchedToOtherRangeField(addrNumScore, scoreCopy = this.copyAndAdjustScore(scoringRange, type = fieldScoresWithSameWordEn.getKey(), score = fieldScoresWithSameWordEn.getValue(), rangeFieldScores), type)) {
            this.resetFieldScore(score);
        }
        return addrNumScore;
    }

    private FieldScore copyAndAdjustScore(InternalScoringRange scoringRange, FieldType type, FieldScore score, Map<FieldType, FieldScore> rangeFieldScores) {
        FieldScore copiedScore = new FieldScore();
        copiedScore.copy(score);
        this.adjustRangeFieldScore(scoringRange, type, copiedScore, rangeFieldScores);
        return copiedScore;
    }

    private void resetFieldScore(FieldScore score) {
        boolean savedCandFieldPresentFlag = score.m_candidateFieldPresent;
        score.resetFieldMatch();
        score.m_candidateFieldPresent = savedCandFieldPresentFlag;
    }

    private boolean adjustScoreForAddressNumberMatchedToOtherRangeField(AddressNumberScore addrNumberScore, FieldScore otherScore, FieldType otherFieldType) {
        if (!this.acceptProbaleAddressNumberScore(addrNumberScore, otherScore, otherFieldType)) {
            AddressNumber savedCandAddrNum = addrNumberScore.getCandidateAddressNumber();
            this.resetFieldScore(addrNumberScore);
            addrNumberScore.setCandidateAddressNumber(savedCandAddrNum);
            return true;
        }
        return false;
    }

    @Override
    protected AddressNumber findFromProbables(List<AddressNumber> addNumList, int start, int end, boolean preferFirst) {
        AddressNumber bestProbable = null;
        if (addNumList != null) {
            for (AddressNumber probableNum : addNumList) {
                int[] numStartEnd = probableNum.getPositionInInputStreet();
                if (numStartEnd[0] <= start || numStartEnd[1] > end) continue;
                if (bestProbable == null) {
                    bestProbable = probableNum;
                    continue;
                }
                if (preferFirst) {
                    if (bestProbable.getPositionInInputStreet()[0] < numStartEnd[0]) break;
                    if (GBR_Matcher.numbersInRange(numStartEnd) <= GBR_Matcher.numbersInRange(bestProbable.getPositionInInputStreet())) continue;
                    bestProbable = probableNum;
                    continue;
                }
                if (bestProbable.getPositionInInputStreet()[1] < numStartEnd[1]) {
                    bestProbable = probableNum;
                    continue;
                }
                if (GBR_Matcher.numbersInRange(numStartEnd) <= GBR_Matcher.numbersInRange(bestProbable.getPositionInInputStreet())) continue;
                bestProbable = probableNum;
            }
        }
        return bestProbable;
    }

    private static int numbersInRange(int[] startEnd) {
        return startEnd[1] - startEnd[0];
    }

    boolean acceptProbaleAddressNumberScore(AddressNumberScore addrNumberScore, FieldScore otherMatchedScore, FieldType otherFieldType) {
        if (otherMatchedScore.m_matched && !addrNumberScore.m_matched) {
            return false;
        }
        if (!addrNumberScore.m_candidateFieldPresent) {
            return false;
        }
        if (addrNumberScore.m_matched == otherMatchedScore.m_matched) {
            int otherFieldPerfectMatchedWords = IntArray.size(otherMatchedScore.m_perfectInputWords);
            if (otherFieldPerfectMatchedWords > 1 && otherFieldPerfectMatchedWords > IntArray.size(addrNumberScore.m_perfectInputWords)) {
                return false;
            }
            if (AddressWordArray.size(otherMatchedScore.m_candWords) == 1 || otherMatchedScore.m_value > 0.5 && IntArray.size(otherMatchedScore.m_matchedCandWords) > 1) {
                return this.isFirstABetterScore(addrNumberScore, otherMatchedScore, FieldType.STREET_NAME_FIELD_TYPE, ADDRESS_NUMBER_FIELD, otherFieldType);
            }
        }
        return true;
    }

    private AddressWord[] getPostAddressWords(ParsedAddress parsedAddress) {
        return parsedAddress.isSeperatePostAddressFields() ? (AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE) : (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
    }

    private List<AddressWord[]> getCandPostCodes(ScoringItem addr) {
        ArrayList<AddressWord[]> pcWordList;
        block2: {
            InternalFieldValue pcExFv;
            InternalFieldValue pcFv;
            block3: {
                pcWordList = new ArrayList<AddressWord[]>();
                pcFv = (InternalFieldValue)addr.getField(FieldType.POST_CODE_FIELD_TYPE);
                pcExFv = (InternalFieldValue)addr.getField(FieldType.POST_CODE_EX_FIELD_TYPE);
                if (pcFv == null) break block2;
                this.addCombinedPCWords((AddressWord[])pcFv.getFieldValue(), pcExFv != null ? (AddressWord[])pcExFv.getFieldValue() : null, pcWordList);
                if (!pcFv.hasAlternates()) break block3;
                AddressWord[][] altpcWords = (AddressWord[][])pcFv.getAlternateValues();
                AddressWord[][] altPCExWords = pcExFv != null && pcExFv.hasAlternates() ? (AddressWord[][])pcExFv.getAlternateValues() : new AddressWord[][]{};
                int altSize = altpcWords.length;
                for (int altNdx = 0; altNdx < altSize; ++altNdx) {
                    this.addCombinedPCWords(altpcWords[altNdx], altNdx < altPCExWords.length ? altPCExWords[altNdx] : null, pcWordList);
                }
                break block2;
            }
            if (pcExFv == null || !pcExFv.hasAlternates()) break block2;
            AddressWord[][] altPCExWords = (AddressWord[][])pcExFv.getAlternateValues();
            for (int altNdx = 0; altNdx < altPCExWords.length; ++altNdx) {
                this.addCombinedPCWords((AddressWord[])pcFv.getFieldValue(), altPCExWords[altNdx], pcWordList);
            }
        }
        return pcWordList;
    }

    private void addCombinedPCWords(AddressWord[] pcFv, AddressWord[] pcExFv, List<AddressWord[]> pcWordList) {
        if (pcFv != null && pcFv.length > 0) {
            if (pcExFv != null && pcExFv.length > 0) {
                pcWordList.add(new AddressWord[]{pcFv[0], pcExFv[0]});
            } else {
                pcWordList.add(pcFv);
            }
        }
    }

    private FieldScore scorePostCode(PostCode inputPC, AddressWord[] candPC, ICGGEScorer scorer) {
        IntArray prefectWordsNew;
        FieldScore score = this.scorePostCode(inputPC.getWords(), candPC, scorer);
        int realInputNdx = inputPC.getPositionInInputStreet()[0];
        IntArray matchedWords = score.m_matchedInputWords;
        IntArray perfectWords = score.m_perfectInputWords;
        score.m_perfectInputWords = prefectWordsNew = new IntArray(2);
        for (int i = 0; i < matchedWords.size(); ++i) {
            matchedWords.set(i, realInputNdx);
            if (perfectWords.contains(i)) {
                prefectWordsNew.add(realInputNdx);
            }
            ++realInputNdx;
        }
        return score;
    }

    private FieldScore scorePostCode(AddressWord[] inputPCWords, AddressWord[] candPCWords, ICGGEScorer scorer) {
        double pdScore = 0.0;
        double puScore = 0.0;
        FieldScore score = this.getNewFieldScore(inputPCWords, candPCWords);
        if (inputPCWords.length > 0 && candPCWords.length > 0) {
            pdScore = this.scorePostCodeWord(inputPCWords[0], candPCWords[0], scorer);
            score.m_matchedCandWords.add(0);
            score.m_matchedInputWords.add(0);
            if (pdScore >= 1.0) {
                score.m_perfectCandWords.add(0);
                score.m_perfectInputWords.add(0);
            }
            if (inputPCWords.length > 1 && candPCWords.length > 1) {
                puScore = this.scorePostCodeWord(inputPCWords[1], candPCWords[1], scorer);
                score.m_matchedCandWords.add(1);
                score.m_matchedInputWords.add(1);
                if (puScore >= 1.0) {
                    score.m_perfectCandWords.add(1);
                    score.m_perfectInputWords.add(1);
                }
            }
            score.m_value = pdScore * 0.85 + puScore * 0.15;
        }
        score.m_matched = score.m_value >= 0.99999999;
        score.m_inputFieldPresent = inputPCWords.length > 0;
        score.m_candidateFieldPresent = candPCWords.length > 0;
        return score;
    }

    private double scorePostCodeWord(AddressWord inputPCWord, AddressWord candinputPCWord, ICGGEScorer scorer) {
        double score = scorer.scoreKeys(inputPCWord.getWordChars(), candinputPCWord.getWordChars());
        if (score > 1.0E-4 && score < 0.5) {
            score = 0.5;
        }
        return score;
    }

    private FieldScore getNewFieldScore(AddressWord[] inputWords, AddressWord[] candWords) {
        FieldScore score = new FieldScore();
        score.m_matchedCandWords = new IntArray(candWords.length);
        score.m_perfectCandWords = new IntArray(candWords.length);
        score.m_matchedInputWords = new IntArray(inputWords.length);
        score.m_perfectInputWords = new IntArray(inputWords.length);
        score.m_inputWords = inputWords;
        score.m_candWords = candWords;
        return score;
    }

    @Override
    public void calculateRangeCloseMatch(InternalScoringRange range, ParsedAddress parsedAddr, MatchingOptions matchingOptions) {
        AddressNumberScore addrNum = (AddressNumberScore)range.getFieldScore(ADDRESS_NUMBER_FIELD);
        boolean closeMatch = false;
        if (addrNum != null && addrNum.isMatched()) {
            closeMatch = true;
        }
        if (!closeMatch) {
            closeMatch = fieldMatchChecker.hasGoodRangeFieldMatch(range);
        }
        range.setCloseMatch(closeMatch);
    }

    protected FieldMatchChecker getFieldMatchChecker() {
        return fieldMatchChecker;
    }

    private boolean checkFalsePositiveCase(InternalScoringAddress scoringAddr) {
        boolean closeMatch = scoringAddr.isCloseMatch();
        if (closeMatch) {
            if (!fieldMatchChecker.hasScoringStreetFields(scoringAddr) && !fieldMatchChecker.hasUsableRangeMatch(scoringAddr)) {
                closeMatch = false;
            }
            if (closeMatch) {
                closeMatch = this.qualityCheckOfStreetAndPostCode(scoringAddr, FieldType.STREET_NAME_FIELD_TYPE);
            }
            if (!closeMatch) {
                scoringAddr.setCloseMatch(closeMatch);
            }
        }
        return closeMatch;
    }

    private boolean qualityCheckOfStreetAndPostCode(InternalScoringAddress scoringAddr, FieldType type) {
        if (fieldMatchChecker.isFieldTypePresent(scoringAddr, FieldType.POST_CODE_FIELD_TYPE) && (fieldMatchChecker.isFieldTypePresent(scoringAddr, FieldType.STREET_NAME_FIELD_TYPE) || fieldMatchChecker.isFieldTypePresent(scoringAddr, this.getDependentStreetFieldType(scoringAddr)))) {
            if (!fieldMatchChecker.hasGoodEnoughStreetMatch(scoringAddr)) {
                if (!fieldMatchChecker.hasPostDistrictMatch(scoringAddr)) {
                    return false;
                }
                if (!fieldMatchChecker.hasPerfectMatch(scoringAddr, FieldType.POST_CODE_FIELD_TYPE)) {
                    return fieldMatchChecker.hasGoodRangeFieldMatch(scoringAddr) && fieldMatchChecker.isStreetMatchAfterRangeFields(scoringAddr) && fieldMatchChecker.hasMatchingSignificantWords(scoringAddr, FieldType.STREET_NAME_FIELD_TYPE);
                }
            }
            if (!fieldMatchChecker.hasPostDistrictMatch(scoringAddr) && !fieldMatchChecker.hasGoodEnoughStreetMatch(scoringAddr)) {
                return false;
            }
        }
        return true;
    }

    private boolean isRangeHasSameStreetName(InternalScoringAddress scoringAddr) {
        InternalFieldValue streetName = (InternalFieldValue)scoringAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        InternalScoringRange range = scoringAddr.getMatchedRange();
        return streetName != null && range != null && range.toString().toLowerCase().contains(streetName.toString().toLowerCase());
    }

    FieldType getDependentStreetFieldType(InternalScoringAddress addr) {
        return addr.getDataSetInfo().getMetaData().getFieldForName("DEPENDENT_STREET");
    }

    @Override
    protected double matchedWordsScore(double unmatchedWordScore, double maxScore, double maxScoreAllowed) {
        double score = maxScore - unmatchedWordScore;
        if (maxScore > maxScoreAllowed) {
            score *= maxScoreAllowed / maxScore;
        }
        return score;
    }

    private boolean hasRangeMatchedOnBuildingWords(InternalScoringAddress addr) {
        Map<FieldType, FieldScore> rangeFieldScores;
        InternalScoringRange bestRange = addr.getRangeAt(0);
        if (bestRange != null && (rangeFieldScores = bestRange.getFieldScores()) != null) {
            for (Map.Entry<FieldType, FieldScore> scoreEn : rangeFieldScores.entrySet()) {
                FieldType type = scoreEn.getKey();
                FieldScore score = scoreEn.getValue();
                if (type.getLevel() != FieldType.FieldLevel.LEVEL_RANGE || type == ADDRESS_NUMBER_FIELD || !(score.m_value > 0.0) || score.matchedCandidateWordCount() <= 0) continue;
                return true;
            }
        }
        return false;
    }
}

