/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.GBR.matcher;

import com.mapinfo.mapmarker.GBR.matcher.FieldMatchChecker;
import com.mapinfo.mapmarker.GBR.matcher.GBR_Matcher;
import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

class RangeScoreCalculator
implements Comparable<RangeScoreCalculator> {
    static final double MISSING_RANGE_FIELD_WEIGHT = 0.3;
    private static final FieldType ADDRESS_NUMBER_FIELD = FieldType.ADDRESS_NUMBER_FIELD_TYPE;
    private static final Comparator<FieldScore> FIELD_WEIGHT_COMPARATOR = Collections.reverseOrder(new Comparator<FieldScore>(){

        @Override
        public int compare(FieldScore o1, FieldScore o2) {
            return MMUtils.compareDoubleValues(o1.m_fieldWeight, o2.m_fieldWeight);
        }
    });
    private final Map<FieldType, FieldScore> bestFieldScoreMap;
    private MatchingOptions matchingOptions;
    private double rangeFieldCutoff;
    private final GBR_Matcher matcher;
    private final FieldMatchChecker fieldMatchChecker;

    RangeScoreCalculator(GBR_Matcher matcher, MatchingOptions matchOptions) {
        this(matcher, matchOptions, new HashMap<FieldType, FieldScore>());
    }

    private RangeScoreCalculator(GBR_Matcher matcher, MatchingOptions matchOptions, Map<FieldType, FieldScore> bestRangeFieldScoreMap) {
        this.matcher = matcher;
        this.matchingOptions = matchOptions;
        this.fieldMatchChecker = matcher.getFieldMatchChecker();
        this.rangeFieldCutoff = this.matchingOptions.getRangeFieldCutoff();
        this.bestFieldScoreMap = bestRangeFieldScoreMap;
    }

    void addScoredRange(InternalScoringRange scoredRange) {
        for (Map.Entry<FieldType, FieldScore> fieldScoreEn : scoredRange.getFieldScores().entrySet()) {
            FieldScore currRangeFieldScore;
            FieldType type = fieldScoreEn.getKey();
            if (type.getLevel() != FieldType.FieldLevel.LEVEL_RANGE || !this.acceptRangeFieldScore(currRangeFieldScore = fieldScoreEn.getValue(), scoredRange)) continue;
            FieldScore bestRangeFieldScore = this.bestFieldScoreMap.get(type);
            if (bestRangeFieldScore == null) {
                this.bestFieldScoreMap.put(type, currRangeFieldScore);
                continue;
            }
            if (!this.isFirstRangeFieldScoreBetter(currRangeFieldScore, bestRangeFieldScore)) continue;
            this.bestFieldScoreMap.put(type, currRangeFieldScore);
        }
    }

    private boolean acceptRangeFieldScore(FieldScore score, InternalScoringRange scoredRange) {
        if (score != null && score.m_value > this.rangeFieldCutoff) {
            return !this.possibleFalseRangeFieldMatch(score, scoredRange);
        }
        return false;
    }

    void calculateAndSetCombinedRangeScore(InternalScoringRange scoringRange) {
        scoringRange.setCombinedScore(this.calculateCombinedRangeScore(scoringRange));
    }

    double calculateCombinedRangeScore(InternalScoringRange scoringRange) {
        double scorePossible = 0.0;
        double score = 0.0;
        int fieldsAvailable = 0;
        int fieldsMatched = 0;
        int totalCandWords = 0;
        int candWordsMatched = 0;
        boolean hasMatchedRangeField = this.containsMatchedRangeField(scoringRange);
        for (Map.Entry<FieldType, FieldScore> bestFieldScoreEn : this.bestFieldScoreMap.entrySet()) {
            FieldScore bestScore;
            FieldType rangeField = bestFieldScoreEn.getKey();
            if (this.canSkipScoreForField(rangeField, bestScore = bestFieldScoreEn.getValue(), scoringRange)) continue;
            double fieldWeight = this.matchingOptions.getFieldWeight(rangeField);
            scorePossible += fieldWeight;
            FieldScore fieldScore = scoringRange.getFieldScore(rangeField);
            if (this.hasRangeField(rangeField, fieldScore, scoringRange)) {
                ++fieldsAvailable;
            }
            if (fieldScore != null) {
                if (fieldScore.m_value >= this.rangeFieldCutoff) {
                    score += fieldScore.m_value * fieldWeight;
                    if (fieldScore.m_matched) {
                        ++fieldsMatched;
                    } else if (bestScore.m_matched) {
                        scorePossible += fieldWeight * 0.3;
                    }
                    totalCandWords += this.countPossibleCandidateWords(fieldScore, rangeField, bestScore);
                    candWordsMatched += fieldScore.perfectCandidateWordCount();
                    continue;
                }
                score += 0.3 * fieldWeight;
                continue;
            }
            if (bestScore.m_matched || !hasMatchedRangeField) continue;
            score += fieldWeight * 0.3;
        }
        if (fieldsAvailable > 0) {
            double maxFieldMatchWeight = Math.min(this.matchingOptions.getMatchedFieldWeight() * (double)fieldsAvailable, 0.15);
            scorePossible += maxFieldMatchWeight;
            score += (double)fieldsMatched / (double)fieldsAvailable * maxFieldMatchWeight;
        }
        if (totalCandWords > 0) {
            double maxMatchedWordWeight = Math.min(this.matchingOptions.getMatchedWordWeight() * (double)totalCandWords, 0.1);
            scorePossible += maxMatchedWordWeight;
            score += (double)candWordsMatched / (double)totalCandWords * maxMatchedWordWeight;
        }
        return scorePossible > 0.0 ? score / scorePossible : 0.0;
    }

    private boolean hasRangeField(FieldType type, FieldScore score, InternalScoringRange scoringRange) {
        if (score == null) {
            return !scoringRange.isEmpty(type);
        }
        return score.m_candidateFieldPresent || score.m_matched;
    }

    private int countPossibleCandidateWords(FieldScore score, FieldType rangeField, FieldScore bestScore) {
        if (score.m_value > bestScore.m_value) {
            return this.matchableCandidateWordCount(score, rangeField);
        }
        if (rangeField == ADDRESS_NUMBER_FIELD && score.m_value == bestScore.m_value && this.fieldMatchChecker.inputWordCount((AddressNumberScore)score) == 1) {
            return this.matchableCandidateWordCount(score, rangeField);
        }
        return Math.max(this.matchableCandidateWordCount(bestScore, rangeField), this.matchableCandidateWordCount(score, rangeField));
    }

    List<FieldScore> getScoredRangeFieldsSortedByFieldWeight(InternalScoringRange range) {
        ArrayList<FieldScore> rangeFieldScores = new ArrayList<FieldScore>();
        for (Map.Entry<FieldType, FieldScore> en : range.getFieldScores().entrySet()) {
            if (en.getKey().getLevel() != FieldType.FieldLevel.LEVEL_RANGE) continue;
            FieldScore score = en.getValue();
            if (!(score.m_value > this.rangeFieldCutoff)) continue;
            rangeFieldScores.add(en.getValue());
        }
        if (rangeFieldScores.size() > 1) {
            Collections.sort(rangeFieldScores, FIELD_WEIGHT_COMPARATOR);
        }
        return rangeFieldScores;
    }

    Map<FieldType, FieldScore> getBestRangeFieldScoreMap() {
        return this.bestFieldScoreMap;
    }

    private int matchableCandidateWordCount(FieldScore score, FieldType type) {
        if (type == ADDRESS_NUMBER_FIELD) {
            return score.candidateWordCount();
        }
        return this.fieldMatchChecker.countMatchableWords(score.getCandidateWords());
    }

    private boolean containsMatchedRangeField(InternalScoringRange scoringRange) {
        for (Map.Entry<FieldType, FieldScore> scoreEn : scoringRange.getFieldScores().entrySet()) {
            if (scoreEn.getKey().getLevel() != FieldType.FieldLevel.LEVEL_RANGE || !scoreEn.getValue().m_matched) continue;
            return true;
        }
        return false;
    }

    private boolean canSkipScoreForField(FieldType rangeField, FieldScore bestScore, InternalScoringRange scoredRange) {
        FieldScore rangeFieldScore = scoredRange.getFieldScore(rangeField);
        if (rangeFieldScore != bestScore && (rangeFieldScore == null || rangeFieldScore.m_value < this.rangeFieldCutoff)) {
            boolean bIsAddressNumberField;
            boolean bl = bIsAddressNumberField = rangeField == FieldType.ADDRESS_NUMBER_FIELD_TYPE;
            if (!bIsAddressNumberField && this.possibleFalseRangeFieldMatch(bestScore, scoredRange)) {
                return true;
            }
            Map.Entry<FieldType, FieldScore> entry = this.matcher.getScoreWithCommonMatchedWords(scoredRange.getFieldScores(), bestScore);
            if (entry != null) {
                FieldType matchedRangeFieldType = entry.getKey();
                FieldScore matchedRangeFieldScore = entry.getValue();
                if (rangeFieldScore != null && this.didAddressNumberMatchedInOtherFields(rangeField, rangeFieldScore, bestScore, matchedRangeFieldType, matchedRangeFieldScore) || this.didAnotherFieldMatchedWithBestAddressNumberScore(bestScore, matchedRangeFieldType, matchedRangeFieldScore)) {
                    return true;
                }
                return !bIsAddressNumberField && this.isFirstRangeScoreBetterIgnoringFieldWeight(matchedRangeFieldScore, bestScore, matchedRangeFieldType, rangeField);
            }
        }
        return false;
    }

    private boolean possibleFalseRangeFieldMatch(FieldScore rangeScore, InternalScoringRange scoredRange) {
        int streetStartsAt;
        if (rangeScore.m_value < 0.9 && IntArray.size(rangeScore.m_matchedInputWords) > 0 && (streetStartsAt = this.streetFieldsStart(scoredRange)) > -1) {
            return rangeScore.m_matchedInputWords.max() > streetStartsAt;
        }
        return false;
    }

    private int streetFieldsStart(InternalScoringRange scoredRange) {
        IntArray matchedInputWords;
        FieldScore score = scoredRange.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        if (score != null && IntArray.size(matchedInputWords = score.m_matchedInputWords) > 0) {
            return matchedInputWords.get(0);
        }
        return -1;
    }

    private boolean isFirstRangeScoreBetterIgnoringFieldWeight(FieldScore firstScore, FieldScore bestScore, FieldType matchedRangeFieldType, FieldType rangeField) {
        double savedWeight = bestScore.m_fieldWeight;
        bestScore.m_fieldWeight = firstScore.m_fieldWeight;
        boolean firstIsBetter = this.matcher.isFirstABetterScore(firstScore, bestScore, FieldType.STREET_NAME_FIELD_TYPE, matchedRangeFieldType, rangeField);
        bestScore.m_fieldWeight = savedWeight;
        return firstIsBetter;
    }

    private boolean didAddressNumberMatchedInOtherFields(FieldType currFieldType, FieldScore currScore, FieldScore bestAddrNumberScore, FieldType otherFieldType, FieldScore otherFieldScore) {
        if (currFieldType == ADDRESS_NUMBER_FIELD && currScore.m_value == 0.0 && !currScore.m_candidateFieldPresent) {
            return otherFieldScore.m_value >= bestAddrNumberScore.m_value;
        }
        return false;
    }

    private boolean didAnotherFieldMatchedWithBestAddressNumberScore(FieldScore bestScore, FieldType otherMatchedFieldType, FieldScore otherMatchedScore) {
        return otherMatchedFieldType == ADDRESS_NUMBER_FIELD && otherMatchedScore.m_value >= bestScore.m_value && otherMatchedScore.matchedCandidateWordCount() >= bestScore.matchedCandidateWordCount();
    }

    private boolean isFirstRangeFieldScoreBetter(FieldScore currRangeFieldScore, FieldScore bestRangeFieldScore) {
        return currRangeFieldScore.compareTo(bestRangeFieldScore) > 0;
    }

    int perfectFieldMatchCount() {
        int c = 0;
        for (FieldScore score : this.bestFieldScoreMap.values()) {
            if (!score.m_matched) continue;
            ++c;
        }
        return c;
    }

    @Override
    public int compareTo(RangeScoreCalculator other) {
        int c = this.maxRangeFieldsMatched() - other.maxRangeFieldsMatched();
        if (c == 0) {
            c = MMUtils.compareDoubleValues(this.getCombinedFieldWeight(), other.getCombinedFieldWeight());
        }
        return c;
    }

    double getCombinedFieldWeight() {
        double combinedWeight = 0.0;
        for (FieldScore score : this.bestFieldScoreMap.values()) {
            combinedWeight += score.m_fieldWeight;
        }
        return combinedWeight;
    }

    int maxRangeFieldsMatched() {
        return this.bestFieldScoreMap.size();
    }
}

