/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.HKG;

import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class HKG_Utils {
    private static Set<Character.UnicodeBlock> CJKSet = new HashSet<Character.UnicodeBlock>();

    public static boolean containsChineseCharacters(String addstr) {
        if (StringUtilities.isEmpty((String)addstr)) {
            return false;
        }
        for (int kj = 0; kj < addstr.length(); ++kj) {
            char ch = addstr.charAt(kj);
            if (!HKG_Utils.isChineseCharacter(ch)) continue;
            return true;
        }
        return false;
    }

    public static boolean isChineseCharacter(char ch) {
        if (CJKSet.contains(Character.UnicodeBlock.of(ch))) {
            return true;
        }
        return Character.getType(ch) == 18;
    }

    public static String zhTrim(String str) {
        int idx;
        if (StringUtilities.isEmpty((String)str)) {
            return str;
        }
        int len = str.length();
        int idx2 = len - 1;
        for (idx = 0; idx < len && str.charAt(idx) == '\u3000'; ++idx) {
        }
        while (idx2 > 0 && str.charAt(idx2) == '\u3000') {
            --idx2;
        }
        String retString = str;
        try {
            retString = str.substring(idx, idx2 + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return retString;
    }

    public static boolean isChineseLangAddress(InputAddress inaddr) {
        String mainAddr = (String)inaddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
        String postAddr = (String)inaddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
        String City2 = (String)inaddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
        String Locality = (String)inaddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE);
        return HKG_Utils.containsChineseCharacters(mainAddr) || HKG_Utils.containsChineseCharacters(postAddr) || HKG_Utils.containsChineseCharacters(City2) || HKG_Utils.containsChineseCharacters(Locality);
    }

    static {
        CJKSet.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS);
        CJKSet.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_A);
        CJKSet.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_B);
        CJKSet.add(Character.UnicodeBlock.CJK_COMPATIBILITY_FORMS);
        CJKSet.add(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS);
        CJKSet.add(Character.UnicodeBlock.CJK_RADICALS_SUPPLEMENT);
        CJKSet.add(Character.UnicodeBlock.CJK_SYMBOLS_AND_PUNCTUATION);
        CJKSet.add(Character.UnicodeBlock.ENCLOSED_CJK_LETTERS_AND_MONTHS);
        CJKSet.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_C);
        CJKSet.add(Character.UnicodeBlock.CJK_UNIFIED_IDEOGRAPHS_EXTENSION_D);
        CJKSet.add(Character.UnicodeBlock.CJK_COMPATIBILITY);
        CJKSet.add(Character.UnicodeBlock.CJK_COMPATIBILITY_IDEOGRAPHS_SUPPLEMENT);
        CJKSet.add(Character.UnicodeBlock.CJK_STROKES);
        CJKSet = Collections.unmodifiableSet(CJKSet);
    }
}

