/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.HKG.helper;

import com.mapinfo.mapmarker.HKG.HKG_Utils;
import com.mapinfo.mapmarker.HKG.address.HKG_ParsedAddress;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEStreetGeocodingHelper;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class HKG_ZH_StreetGeocodingHelper
extends CGGEStreetGeocodingHelper {
    private ParsedAddress localParsedAddrRef;
    private boolean m_searchOnStreet = true;
    private double m_minStreetSearchQuality = 1.0;
    private int altCase = 0;
    private int streetAltCase = -1;

    @Override
    protected boolean generateStreetSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        if (parsedAddress.isIntersectionCase() || parsedAddress.isNearByFeature()) {
            return this.generateStreetSubTriesForIntersection(dataManager, parsedAddress, options, candidateList);
        }
        Object searchWords = null;
        List<DictionaryAddressWord> searchWordList = null;
        if (this.m_streetTryCaseMap == null) {
            this.m_streetTryCaseMap = new HashMap(9);
        }
        switch (this.m_streetSubTryCount) {
            case 0: {
                ++this.m_streetSubTryCount;
                if (this.setSavedSearchWordForSubTry(this.m_streetSubTryCount - 1)) {
                    return true;
                }
                this.m_searchOnStreet = this.isAddressSearchableField(FieldType.STREET_NAME_FIELD_TYPE);
                if (this.m_searchOnStreet) {
                    this.m_searchOnStreet = parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE) != null;
                    AddressWord[] streetWords = (AddressWord[])parsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, true, 8);
                    List<DictionaryAddressWord> addressSearchWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    this.setAddressSearchWordList(addressSearchWords);
                    searchWordList = this.filterSearchWords(this.getAddressSearchWordList(), true, 0);
                    break;
                }
            }
            case 1: {
                ++this.m_streetSubTryCount;
                if (this.streetAltCase >= 0) {
                    if (((HKG_ParsedAddress)parsedAddress).getAltParseToUse() == -1) {
                        ((HKG_ParsedAddress)parsedAddress).setAltParseToUse(this.streetAltCase);
                    }
                    AddressWord[] streetWords = ((HKG_ParsedAddress)parsedAddress).getAltParsings().get(this.streetAltCase);
                    AddressWord[] filteredWords = this.filterSearchWords(streetWords, true, 8);
                    List<DictionaryAddressWord> searchableWords = this.getSearchableWords(filteredWords, FieldType.STREET_NAME_FIELD_TYPE, dataManager, this.m_minStreetSearchQuality, options);
                    this.setAddressSearchWordList(searchableWords);
                    searchWordList = this.getAddressSearchWordList();
                    break;
                }
            }
            default: {
                return false;
            }
        }
        this.m_streetTryCaseMap.put(this.m_streetSubTryCount - 1, searchWordList);
        this.setSearchWordList(searchWordList);
        return true;
    }

    @Override
    protected boolean generateAreaSubTries(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        int currentAreaSize;
        boolean separateAreaFields = parsedAddress.isSeparateAreaFields();
        boolean usePerfectPostcodeAreas = true;
        boolean useImPerfectPostcodeAreas = false;
        boolean pcAndAreaIntersectionFlag = this.m_pcAreaList != null;
        this.m_filterSearchedAreaItemAndWordCombo = true;
        boolean areaSearchWasLocality = false;
        List<DictionaryAreaTermItem> areaList = null;
        if (!(parsedAddress instanceof HKG_ParsedAddress)) {
            return false;
        }
        HKG_ParsedAddress hkgParsedAddress = (HKG_ParsedAddress)parsedAddress;
        int altParseCount = hkgParsedAddress.getAltParsings().size();
        switch (this.m_areaSubTryCount) {
            case 0: {
                ++this.m_areaSubTryCount;
                this.m_areaTryCaseMap = new HashMap(15);
                this.findPCAreaList(dataManager, parsedAddress, false, options);
                pcAndAreaIntersectionFlag = this.m_pcAreaList != null;
            }
            case 1: {
                ++this.m_areaSubTryCount;
                if (!this.isSacSearchableField(FieldType.AREA_NAME_4_FIELD_TYPE)) break;
                AddressWord[] lookUpAreaWords = null;
                lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 1.0, dataManager, options);
                areaSearchWasLocality = true;
                break;
            }
            case 2: {
                AddressWord[] altParseWords;
                AddressWord[] lookUpAreaWords;
                if (altParseCount > this.altCase) {
                    lookUpAreaWords = null;
                    altParseWords = null;
                    altParseWords = hkgParsedAddress.getAltParsings().get(this.altCase);
                    lookUpAreaWords = this.filterAreaWords(altParseWords);
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, 1.0, dataManager, options);
                    areaSearchWasLocality = true;
                    hkgParsedAddress.setAltParseToUse(this.altCase);
                    this.streetAltCase = this.altCase++;
                    break;
                }
                ++this.m_areaSubTryCount;
                break;
            }
            case 3: {
                AddressWord[] lookUpAreaWords;
                ++this.m_areaSubTryCount;
                if (this.isSacSearchableField(FieldType.AREA_NAME_3_FIELD_TYPE)) {
                    lookUpAreaWords = null;
                    lookUpAreaWords = separateAreaFields ? (AddressWord[])parsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE) : this.filterAreaWords((AddressWord[])parsedAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE));
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, dataManager, options);
                }
                this.altCase = -1;
                this.streetAltCase = -1;
                ((HKG_ParsedAddress)parsedAddress).setAltParseToUse(-1);
                break;
            }
            case 4: {
                AddressWord[] altParseWords;
                AddressWord[] lookUpAreaWords;
                if (this.altCase == -1) {
                    this.altCase = 0;
                }
                if (altParseCount > this.altCase) {
                    lookUpAreaWords = null;
                    altParseWords = null;
                    altParseWords = hkgParsedAddress.getAltParsings().get(this.altCase);
                    lookUpAreaWords = this.filterAreaWords(altParseWords);
                    areaList = this.findAreaList(lookUpAreaWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, dataManager, options);
                    areaSearchWasLocality = true;
                    hkgParsedAddress.setAltParseToUse(this.altCase);
                    this.streetAltCase = this.altCase++;
                    break;
                }
                ++this.m_areaSubTryCount;
                break;
            }
            default: {
                this.setSearchAreaList(null);
                return false;
            }
        }
        if (areaList != null && areaList.size() > 0) {
            ArrayList savedAreaList = new ArrayList(areaList);
            this.m_areaTryCaseMap.put(this.m_areaSubTryCount - 1, savedAreaList);
        } else {
            this.m_areaTryCaseMap.put(this.m_areaSubTryCount - 1, areaList);
        }
        int n = currentAreaSize = areaList == null ? 0 : areaList.size();
        if (this.m_pcAreaList != null && (usePerfectPostcodeAreas || useImPerfectPostcodeAreas)) {
            if (areaList == null) {
                areaList = new ArrayList<DictionaryAreaTermItem>(5);
            }
            for (DictionaryAreaTermItem pcArea : this.m_pcAreaList) {
                if (pcArea.m_quality >= 1.0) {
                    if (!usePerfectPostcodeAreas) continue;
                    areaList.add(pcArea);
                    continue;
                }
                if (!useImPerfectPostcodeAreas) continue;
                areaList.add(pcArea);
            }
        } else if (areaList != null && !usePerfectPostcodeAreas && !useImPerfectPostcodeAreas) {
            Iterator<DictionaryAreaTermItem> it = areaList.iterator();
            while (it.hasNext()) {
                DictionaryAreaTermItem dt = it.next();
                if (dt.getFieldType() != FieldType.POST_CODE_FIELD_TYPE) continue;
                it.remove();
            }
        }
        if (pcAndAreaIntersectionFlag) {
            int areaListSize = areaList == null ? 0 : areaList.size();
            boolean bl = pcAndAreaIntersectionFlag = areaListSize > currentAreaSize;
        }
        if (this.m_areaSacIntersectionFieldList == null) {
            this.m_areaSacIntersectionFieldList = new ArrayList(2);
        }
        this.m_areaSacIntersectionFieldList.clear();
        if (pcAndAreaIntersectionFlag) {
            this.m_areaSacIntersectionFieldList.add(FieldType.POST_CODE_FIELD_TYPE);
            if (areaSearchWasLocality) {
                this.m_areaSacIntersectionFieldList.add(FieldType.AREA_NAME_4_FIELD_TYPE);
            } else {
                this.m_areaSacIntersectionFieldList.add(FieldType.AREA_NAME_3_FIELD_TYPE);
            }
        }
        if (areaList != null && areaList.size() > 0) {
            this.setSearchAreaList(areaList);
        } else {
            this.setSearchAreaList(null);
        }
        return true;
    }

    @Override
    protected AddressWord[] filterSearchWords(AddressWord[] words, boolean includeNormalWords, int includeMask) {
        boolean filterNumerics;
        if (words == null) {
            return null;
        }
        boolean filterNumbers = (includeMask & 4) != 4;
        boolean bl = filterNumerics = (includeMask & 8) != 8;
        if (filterNumbers && !filterNumerics) {
            ArrayList<AddressWord> tlist = new ArrayList<AddressWord>();
            for (AddressWord wd : words) {
                if (CodedWord.isNumber(wd.getAttributes())) continue;
                tlist.add(wd);
            }
            if (tlist.size() > 0) {
                AddressWord[] wordsLoc = tlist.toArray(new AddressWord[tlist.size()]);
                return super.filterSearchWords(this.removeWordsWithoutChineseChars(wordsLoc), includeNormalWords, includeMask);
            }
        }
        return super.filterSearchWords(this.removeWordsWithoutChineseChars(words), includeNormalWords, includeMask);
    }

    protected AddressWord[] removeWordsWithoutChineseChars(AddressWord[] searchwords) {
        AddressWord[] returnWords = AddressWordArray.clone(searchwords);
        ArrayList<AddressWord> tempList = new ArrayList<AddressWord>();
        for (AddressWord word : searchwords) {
            if (!StringUtilities.isNumeric((String)word.getWord()) && !HKG_Utils.containsChineseCharacters(word.getWord())) continue;
            tempList.add(word);
        }
        if (tempList.size() > 0) {
            returnWords = tempList.toArray(new AddressWord[tempList.size()]);
        }
        return returnWords;
    }

    private boolean setSavedSearchWordForSubTry(int trycase) {
        if (this.m_streetTryCaseMap != null && this.m_streetTryCaseMap.containsKey(trycase)) {
            this.setSearchWordList((List)this.m_streetTryCaseMap.get(trycase));
            return true;
        }
        return false;
    }
}

