/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.HKG.matcher;

import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import java.util.List;

public class HKG_Matcher
extends CGGEMatcher1 {
    @Override
    protected void scoreRange(InternalScoringAddress scoringAddr, InternalScoringRange scoringRange, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        AddressNumber from = scoringRange.getFrom();
        int hnr1 = -1;
        int hnr2 = -1;
        if (from != null) {
            hnr1 = from.getHnrNumber1();
            hnr2 = from.getHnrNumber2();
            String suf1 = from.getHnrSuffix1();
            String suf2 = from.getHnrSuffix2();
            if (hnr1 == 0 && hnr2 > 0 && suf1 != null || hnr1 > 0 && hnr2 > 0 && suf1 != null && suf2 == null) {
                scoringRange.getFrom().setSeperatorType(2);
            }
        }
        super.scoreRange(scoringAddr, scoringRange, pAddr, matchingOptions, scorer);
    }

    @Override
    protected AddressNumber findFromProbables(List<AddressNumber> addNumList, int start, int end, boolean preferFirst) {
        AddressNumber bestProbable = null;
        if (addNumList != null) {
            for (AddressNumber probableNum : addNumList) {
                int[] numStartEnd = probableNum.getPositionInInputStreet();
                if (numStartEnd[0] <= start || numStartEnd[1] > end) continue;
                if (bestProbable == null) {
                    bestProbable = probableNum;
                    continue;
                }
                if (preferFirst) {
                    if (bestProbable.getPositionInInputStreet()[0] < numStartEnd[0]) break;
                    if (HKG_Matcher.numbersInRange(numStartEnd) <= HKG_Matcher.numbersInRange(bestProbable.getPositionInInputStreet())) continue;
                    bestProbable = probableNum;
                    continue;
                }
                if (bestProbable.getPositionInInputStreet()[1] < numStartEnd[1]) {
                    bestProbable = probableNum;
                    continue;
                }
                if (HKG_Matcher.numbersInRange(numStartEnd) <= HKG_Matcher.numbersInRange(bestProbable.getPositionInInputStreet())) continue;
                bestProbable = probableNum;
            }
        }
        return bestProbable;
    }

    protected static int numbersInRange(int[] startEnd) {
        return startEnd[1] - startEnd[0];
    }
}

