/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.HKG.matcher;

import com.mapinfo.mapmarker.HKG.address.HKG_ParsedAddress;
import com.mapinfo.mapmarker.HKG.matcher.HKG_Matcher;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;

public class HKG_ZH_Matcher
extends HKG_Matcher {
    @Override
    public void scoreCandidate(ParsedAddress parsedAddr, InternalScoringAddress addr, MatchingOptions matchingOptions, ICGGEScorer scorer, IDataManager dataManager) throws CGGEInternalException {
        ParsedAddress saveParsed = new ParsedAddress("HKG", "zh");
        saveParsed.copy(parsedAddr);
        HKG_ParsedAddress HKGParsed = (HKG_ParsedAddress)parsedAddr;
        if (HKGParsed.getAltParseToUse() >= 0) {
            int idx = HKGParsed.getAltParseToUse();
            AddressWord[] altWords = HKGParsed.getAltParsings().get(idx);
            saveParsed.setField(FieldType.STREET_NAME_FIELD_TYPE, altWords);
            saveParsed.setField(FieldType.POST_ADDRESS_FIELD_TYPE, altWords);
            if (saveParsed.getProbableAddressNumbers() != null && saveParsed.getProbableAddressNumbers().size() > 0) {
                int start = altWords.length - 1;
                int end = altWords.length;
                int[] newPosition = new int[]{start, end};
                saveParsed.getProbableAddressNumbers().get(0).setPositionInInputStreet(newPosition);
            }
            super.scoreCandidate(saveParsed, addr, matchingOptions, scorer, dataManager);
            HKGParsed.setAltParseToUse(-1);
        } else {
            super.scoreCandidate(parsedAddr, addr, matchingOptions, scorer, dataManager);
        }
    }

    @Override
    protected void scoreStreetFields(InternalScoringAddress scoringAddr, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        super.scoreStreetFields(scoringAddr, pAddr, matchingOptions, scorer);
        if (pAddr.getProbableAddressNumbers() != null && pAddr.getField(FieldType.STREET_NAME_FIELD_TYPE) != null && ((AddressWord[])pAddr.getField(FieldType.STREET_NAME_FIELD_TYPE)).length > 2) {
            int wordPos = pAddr.getProbableAddressNumbers().get(0).getPositionInInputStreet()[0];
            AddressWord[] streetwords = (AddressWord[])pAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
            if (wordPos > 1 && streetwords.length > 1 && streetwords[wordPos - 1].equals(streetwords[wordPos - 2])) {
                FieldScore streetScore = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
                FieldScore AN4Score = scoringAddr.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE);
                if (AN4Score != null && AN4Score.m_value != 0.0) {
                    double savedStreetWeight = streetScore.m_fieldWeight;
                    double savedAN4Weight = AN4Score.m_fieldWeight;
                    AN4Score.m_fieldWeight = savedStreetWeight;
                    scoringAddr.setFieldScore(FieldType.STREET_NAME_FIELD_TYPE, AN4Score);
                    streetScore.m_fieldWeight = savedAN4Weight;
                    scoringAddr.setFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE, streetScore);
                }
            }
        }
    }
}

