/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.IND;

import com.mapinfo.mapmarker.GeocodableAddressCreationException;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import com.mapinfo.mapmarker.IND.INDGeocoder;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.cgge.CGGEDataIntializationException;
import com.mapinfo.mapmarker.cgge.CGGEGeocodableAddressFactory;
import com.mapinfo.mapmarker.cgge.MMGeocoder;
import com.mapinfo.mapmarker.cgge.dp.DataManager;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.core.IGeocoder;

public class INDGeocodableAddressFactory
extends CGGEGeocodableAddressFactory {
    private String m_country;
    private MMGeocoder m_mmGeocoder;

    @Override
    public IGeocoder createSpecificGeocodableAddress(Address address, IGeocodeConstraints constraints) throws GeocodableAddressCreationException {
        String countryCode;
        this.m_country = countryCode = address.getCountry();
        this.m_mmGeocoder = new INDGeocoder(address, this.m_country, constraints);
        this.m_mmGeocoder.init();
        return this.m_mmGeocoder;
    }

    @Override
    protected void resetSpecificDataManager() throws MMInternalFatalException {
        if (this.m_mmGeocoder != null && this.m_mmGeocoder.getCGGEGeocoder() != null) {
            try {
                DataManager.getInstance(this.m_country).resetData();
            }
            catch (CGGEDataIntializationException e) {
                throw new FatalDataAccessException(2306, (Throwable)e);
            }
        }
    }
}

