/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.IND.convertor;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IND.IND_InternalCandidateAddress;
import com.mapinfo.mapmarker.IND.dp.binary.DataSetUtils;
import com.mapinfo.mapmarker.IND.matcher.IND_Matcher1;
import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.convertor.CGGECandidateConvertor;
import com.mapinfo.mapmarker.cgge.convertor.CGGEFormatter;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.StringWithTokens;
import java.util.HashMap;
import java.util.List;

public class IND_CandidateConvertor
extends CGGECandidateConvertor {
    public static final String SUB_LOCALITY_ADDITIONAL_FIELD = "SUB_LOCALITY";

    @Override
    protected void copyMatchFlags(CandidateAddress candAddr, InternalScoringAddress scoringAddr, boolean isIntersection) {
        super.copyMatchFlags(candAddr, scoringAddr, isIntersection);
        this.removeBadPossibleHNForS4(candAddr);
        boolean isPlaceNameMatch = this.isFieldMatched(scoringAddr.getFieldScore(FieldType.PLACE_NAME_FIELD_TYPE));
        if (isPlaceNameMatch) {
            candAddr.setPlaceNameMatched();
        }
        if (candAddr.getLocationPrecision() == 16 && isPlaceNameMatch) {
            candAddr.setAddressNumberMatched();
        }
    }

    @Override
    protected CandidateAddress convertCandidate(InternalScoringAddress scoringAddress, IDataManager dataManager, CGGEFormatter formatter, IConstraints constraints) throws Exception {
        CandidateAddress cand = super.convertCandidate(scoringAddress, dataManager, formatter, constraints);
        if (DataSetUtils.isSGDataSetItem(scoringAddress)) {
            String code = cand.getPrecisionCode();
            code = "SL" + code.substring(2);
            HashMap map = cand.getAdditionalFields();
            map.put("RESULT_CODE", code);
            this.updatedAdditionalFieldsForSG(cand);
            cand.setLocationPrecision(12);
        } else if ((DataSetUtils.isPOIDataSetItem(scoringAddress) || DataSetUtils.isStreetDataSetItem(scoringAddress)) && !StringUtilities.isEmpty((String)cand.getGenericField3())) {
            HashMap<String, String> additionalFields = cand.getAdditionalFields();
            if (null == additionalFields) {
                additionalFields = new HashMap<String, String>();
                cand.setAdditionalFields(additionalFields);
            }
            additionalFields.put(SUB_LOCALITY_ADDITIONAL_FIELD, cand.getGenericField3().trim());
            cand.setGenericField3(null);
        }
        if (1 != constraints.getGeocodeType()) {
            this.setExtendedPrecisionCode(cand, scoringAddress);
        }
        return cand;
    }

    protected boolean candPresentInInput(AddressWord cand, AddressWord[] input) {
        if (input != null) {
            for (int i = 0; i < input.length; ++i) {
                if (!input[i].getWord().equals(cand.getWord())) continue;
                return true;
            }
        }
        return false;
    }

    private void removeBadPossibleHNForS4(CandidateAddress candAddr) {
        if (candAddr.getLocationPrecision() == 2 && candAddr.getAddressNumber() != null) {
            StringWithTokens fsaToks = new StringWithTokens(candAddr.getFormattedStreetAddress());
            StringWithTokens hnToks = new StringWithTokens(candAddr.getAddressNumber());
            String HN = candAddr.getAddressNumber();
            if (hnToks.size() > 2) {
                for (int i = 0; i < hnToks.size(); ++i) {
                    fsaToks.removeFirst();
                }
                candAddr.setAddressNumber((String)null);
                candAddr.setFormattedStreetAddress(fsaToks.toString());
                return;
            }
            StringWithTokens mainAdddrToks = null;
            if (candAddr.getMainAddress() != null) {
                mainAdddrToks = new StringWithTokens(candAddr.getMainAddress());
            }
            if (mainAdddrToks != null && mainAdddrToks.size() > 0 && mainAdddrToks.getFirstToken().length() < candAddr.getAddressNumber().length() && !StringUtilities.isNumeric((String)mainAdddrToks.getFirstToken()) && candAddr.getAddressNumber().endsWith(mainAdddrToks.getFirstToken())) {
                for (int i = 0; i < hnToks.size(); ++i) {
                    fsaToks.removeFirst();
                }
                candAddr.setAddressNumber((String)null);
                candAddr.setFormattedStreetAddress(fsaToks.toString());
                return;
            }
            hnToks = new StringWithTokens(candAddr.getAddressNumber(), "-");
            if (hnToks.size() > 1) {
                StringBuilder srch = new StringBuilder(hnToks.getFirstToken() + " " + hnToks.getToken(1));
                StringBuilder srch2 = null;
                if (hnToks.getToken(1).length() > 1 && hnToks.getToken(1).startsWith("0")) {
                    srch2 = new StringBuilder(hnToks.getFirstToken() + " ");
                    srch2.append(hnToks.getToken(1).substring(1, hnToks.getToken(1).length()));
                }
                if (hnToks.size() > 1 && (candAddr.getMainAddress().contains(srch.toString()) || srch2 != null && candAddr.getMainAddress().contains(srch2.toString()))) {
                    fsaToks.removeFirst();
                    candAddr.setAddressNumber((String)null);
                    candAddr.setFormattedStreetAddress(fsaToks.toString());
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected AddressWord[] getFieldValue(InternalFieldValue fieldValue, InternalScoringAddress scoringAddress, FieldType type, CGGEFormatter formatter, String typeKey) {
        if (fieldValue == null) return null;
        boolean isInputequalCandWord = false;
        FieldScore score = scoringAddress.getFieldScore(type);
        if (score == null) return (AddressWord[])fieldValue.getFieldValue();
        if (score.m_value < 1.0 && score.m_value > 0.0) {
            return super.getFieldValue(fieldValue, scoringAddress, type, formatter, typeKey);
        }
        if (((AddressWord[])fieldValue.getFieldValue()).length != 1) return super.getFieldValue(fieldValue, scoringAddress, type, formatter, typeKey);
        if (!this.candPresentInInput(((AddressWord[])fieldValue.getFieldValue())[0], score.m_inputWords)) return super.getFieldValue(fieldValue, scoringAddress, type, formatter, typeKey);
        return (AddressWord[])fieldValue.getFieldValue();
    }

    private void setExtendedPrecisionCode(CandidateAddress cand, InternalScoringAddress scoringAddress) {
        StringBuilder extendedPrecisionCodeBuilder = new StringBuilder(IND_InternalCandidateAddress.buildExtendedPrecisionCodeFromCandidate(cand));
        double combinedSLScore = IND_Matcher1.calculateCombinedSubLocalityScore(scoringAddress);
        if (combinedSLScore >= 1.0) {
            extendedPrecisionCodeBuilder.append("M");
        } else {
            extendedPrecisionCodeBuilder.append("-");
        }
        cand.addKeyValueToAdditionalFields(IND_InternalCandidateAddress.KEY_EXTENDED_PRECISION_CODE, extendedPrecisionCodeBuilder.toString());
    }

    @Override
    protected String getMatchedAddressNumber(InternalScoringRange range, AddressNumber inputNum, AddressNumberScore addrNumScore) {
        InternalFieldValue addressNumber;
        if (addrNumScore.isMatched() && null != (addressNumber = (InternalFieldValue)range.getField(DataSetUtils.getINDAddressNumberField(range)))) {
            return addressNumber.toString();
        }
        return null;
    }

    @Override
    protected CandidateRange convertRange(InternalScoringRange range, IDataManager dataManager) throws DataFetchException {
        CandidateRange candRange = new CandidateRange();
        InternalFieldValue addressNumber = (InternalFieldValue)range.getField(DataSetUtils.getINDAddressNumberField(range));
        if (null != addressNumber) {
            String addNum = addressNumber.toString();
            candRange.setLowAddress(addNum);
            candRange.setHighAddress(addNum);
        } else {
            candRange.setLowAddress("");
            candRange.setHighAddress("");
        }
        return candRange;
    }

    @Override
    protected String buildRGResultCode(InternalStreetAddress streetAddress) {
        if (!DataSetUtils.isSGDataSetItem(streetAddress)) {
            return super.buildRGResultCode(streetAddress);
        }
        return "RSLA";
    }

    private boolean isFieldMatched(FieldScore score) {
        return score != null ? score.m_matched : false;
    }

    private void updatedAdditionalFieldsForSG(CandidateAddress cand) {
        HashMap additionalFields = cand.getAdditionalFields();
        StringBuilder additionalFieldBuilder = new StringBuilder();
        if (additionalFields != null) {
            List<String> sublocalityList = DataSetUtils.getSublocalityList();
            for (String fieldType : sublocalityList) {
                if (StringUtilities.isEmpty((String)((String)additionalFields.get(fieldType)))) continue;
                additionalFieldBuilder.append(((String)additionalFields.get(fieldType)).trim());
                additionalFieldBuilder.append(" ");
                additionalFields.remove(fieldType);
            }
            if (!StringUtilities.isEmpty((String)cand.getGenericField4())) {
                additionalFieldBuilder.append(cand.getGenericField4().trim());
                additionalFieldBuilder.append(" ");
                cand.setGenericField4(null);
            }
            if (!StringUtilities.isEmpty((String)cand.getGenericField3())) {
                additionalFieldBuilder.append(cand.getGenericField3().trim());
                additionalFieldBuilder.append(" ");
                cand.setGenericField3(null);
            }
            if (!StringUtilities.isEmpty((String)additionalFieldBuilder.toString())) {
                additionalFields.put(SUB_LOCALITY_ADDITIONAL_FIELD, additionalFieldBuilder.toString().trim());
                cand.setAdditionalFields(additionalFields);
            }
        }
    }
}

