/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.IND.dp.binary;

import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.dp.DataSetInfo;
import com.mapinfo.mapmarker.cgge.dp.IDictionaryItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DataSetUtils {
    public static final String SG_DATASET_NAME = "SG";
    public static final String POI_DATATSET_NAME = "POI";
    public static final String STREET_DATASET_NAME = "Street";
    public static final String AP_DATASET_NAME = "AP";
    public static final String GEO_DATASET_NAME = "Geo";
    public static final String BLOCK_FIELD_NAME = "block";
    public static final String SUB_LOCALITY_FIELD_NAME = "sub_locality";
    public static final String IND_ADDRESS_NUM_FIELD_NAME = "ind_addressnum";
    private static final Map<DataSetInfo, FieldType> m_addrNumFieldMap = new HashMap<DataSetInfo, FieldType>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FieldType getINDAddressNumberField(IDictionaryItem dataSetItem) {
        DataSetInfo dataSetInfo = dataSetItem.getDataSetInfo();
        FieldType addrNumType = null;
        if (m_addrNumFieldMap.containsKey(dataSetInfo)) {
            addrNumType = m_addrNumFieldMap.get(dataSetInfo);
        } else {
            Map<DataSetInfo, FieldType> map = m_addrNumFieldMap;
            synchronized (map) {
                if (!m_addrNumFieldMap.containsKey(dataSetInfo)) {
                    addrNumType = dataSetInfo.getMetaData().getFieldForName(IND_ADDRESS_NUM_FIELD_NAME);
                    m_addrNumFieldMap.put(dataSetInfo, addrNumType);
                } else {
                    addrNumType = m_addrNumFieldMap.get(dataSetInfo);
                }
            }
        }
        return addrNumType;
    }

    public static boolean isAPDataSetItem(IDictionaryItem dataSetItem) {
        return AP_DATASET_NAME.equals(dataSetItem.getDataSetInfo().getName());
    }

    public static boolean isSGDataSetItem(IDictionaryItem dataSetItem) {
        return SG_DATASET_NAME.equals(dataSetItem.getDataSetInfo().getName());
    }

    public static boolean isPOIDataSetItem(IDictionaryItem dataSetItem) {
        return POI_DATATSET_NAME.equals(dataSetItem.getDataSetInfo().getName());
    }

    public static boolean isStreetDataSetItem(IDictionaryItem dataSetItem) {
        return STREET_DATASET_NAME.equals(dataSetItem.getDataSetInfo().getName());
    }

    public static boolean isGeographicDataSetItem(IDictionaryItem dataSetItem) {
        return GEO_DATASET_NAME.equals(dataSetItem.getDataSetInfo().getName());
    }

    public static boolean isStreetGeocodingCandidate(IDictionaryItem dataSetItem) {
        return dataSetItem.getDataSetInfo().getGeocodeType() == 1;
    }

    public static boolean isSubLocalityField(FieldType type) {
        if (FieldType.GENERIC_FIELD_3_FIELD_TYPE == type || FieldType.GENERIC_FIELD_4_FIELD_TYPE == type) {
            return true;
        }
        String fieldName = type.getName();
        return BLOCK_FIELD_NAME.equalsIgnoreCase(fieldName) || SUB_LOCALITY_FIELD_NAME.equals(fieldName);
    }

    public static List<String> getSublocalityList() {
        ArrayList<String> sublocalityList = new ArrayList<String>();
        sublocalityList.add(BLOCK_FIELD_NAME);
        sublocalityList.add(SUB_LOCALITY_FIELD_NAME);
        return sublocalityList;
    }
}

