/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.IND.helper;

import com.mapinfo.mapmarker.IND.helper.INDStreetGeocodingHelper;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAddressWord;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaSacs;
import com.mapinfo.mapmarker.cgge.dp.DictionaryAreaTermItem;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEGeographicGeocodingHelper;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.AddressWordArray;
import com.mapinfo.mapmarker.cgge.utils.CharArray;
import com.mapinfo.mapmarker.cgge.utils.ListUtils;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class INDGeographicGeocodingHelper
extends CGGEGeographicGeocodingHelper {
    private double m_minAreaValue = 0.95;
    private int m_tryCount = 0;
    private List<FieldType> m_intersectionFieldtypeList = new ArrayList<FieldType>();
    private boolean m_canCheckAn3Only = true;
    private AddressWord[] m_savedPostAddress = null;
    public static final String MATCHABLE_TOWN_FOUND = "matchable_town_found";
    public static final String MATCHABLE_LOCALITY_FOUND = "matchable_locality_found";
    public static final String MATCHABLE_STATE_FOUND = "matchable_state_found";
    public static final String MATCHABLE_DISTRICT_FOUND = "matchable_district_found";
    public static final String CONSIDER_LOCALITY_RELAXATION = "CONSIDER_LOCALITY_RELAXATION";
    public static final String CONSIDER_PC_RELAXATION = "CONSIDER_PC_RELAXATION";
    public static final String WITHOUT_TOWN_CASE = "WITHOUT_TOWN_CASE";
    public static final double LOCALITY_THRESHOLD = 0.93;
    public static final double POSTCODE_THRESHOLD = 0.98;
    private List<DictionaryAreaTermItem> areaName1List = null;
    public static final String SPLIT_AREANAMES_CASE = "split_areaname_case";
    List<DictionaryAreaTermItem> areaList = null;
    private static short KNOWN_WORD_MASK = (short)3868;

    @Override
    protected List<DictionaryAddressWord> getSearchableWords(AddressWord[] inputWords, IDataManager dataManager, boolean perfectWordsOnly, GeocodeOptions options) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        List<DictionaryAddressWord> retWordList = null;
        if (inputWords != null) {
            double minQuality = perfectWordsOnly ? 1.0 : this.m_minAreaValue;
            List<FieldType> searchableFields = null;
            searchableFields = this.m_intersectionFieldtypeList != null ? this.m_intersectionFieldtypeList : this.getAddressSearchFields();
            if (searchableFields != null && !searchableFields.isEmpty()) {
                for (FieldType searchType : searchableFields) {
                    String prop;
                    if (searchType == FieldType.AREA_NAME_4_FIELD_TYPE && (null == (prop = options.getProperty(CONSIDER_LOCALITY_RELAXATION)) || "true".equals(prop))) {
                        minQuality = 0.93;
                    }
                    List<DictionaryAddressWord> curList = this.getSearchableWords(inputWords, searchType, dataManager, minQuality, options);
                    retWordList = ListUtils.addToList(retWordList, curList);
                }
            }
        }
        return retWordList;
    }

    private AddressWord[] removeUptoFirstMatchingWord(List<DictionaryAreaTermItem> areaItems, AddressWord[] searchWords, boolean isRemoveMatchWords) {
        int searchWordsLen;
        int firstMatchNdx = searchWordsLen = searchWords == null ? 0 : searchWords.length;
        if (searchWordsLen > 0 && !ListUtils.isEmpty(areaItems)) {
            for (DictionaryAreaTermItem areaItem : areaItems) {
                DictionaryAddressWord[] matchedDictWords = areaItem.getMatchedWords();
                if (matchedDictWords == null) continue;
                for (DictionaryAddressWord matchedDictWord : matchedDictWords) {
                    if (matchedDictWord == null) continue;
                    for (int ndx = 0; ndx < searchWordsLen; ++ndx) {
                        if (matchedDictWord.getSearchWord() != searchWords[ndx] || ndx >= firstMatchNdx) continue;
                        firstMatchNdx = ndx;
                    }
                }
            }
        }
        if (firstMatchNdx < searchWordsLen && firstMatchNdx > 0 && isRemoveMatchWords) {
            int newWordLen = searchWordsLen - firstMatchNdx;
            AddressWord[] newWords = new AddressWord[newWordLen];
            AddressWordArray.arraycopy(searchWords, firstMatchNdx, newWords, 0, newWordLen);
            return newWords;
        }
        return searchWords;
    }

    protected AddressWord[] adjustPostAddressWords(ParsedAddress pAddr, List<DictionaryAreaTermItem> areaList, AddressWord[] lookupWords, boolean isRemoveMatchWords) {
        if (!pAddr.isSeperatePostAddressFields()) {
            lookupWords = this.removeUptoFirstMatchingWord(areaList, lookupWords, isRemoveMatchWords);
        }
        return lookupWords;
    }

    private AddressWord[] getWordsFromAreaTerms() {
        ArrayList<AddressWord> dictWords = new ArrayList<AddressWord>();
        for (DictionaryAreaTermItem areaItem : this.areaList) {
            AddressWord[] words;
            for (AddressWord word : words = areaItem.m_areaWords) {
                dictWords.add(word);
            }
        }
        AddressWord[] words = new AddressWord[dictWords.size()];
        return dictWords.toArray(words);
    }

    @Override
    protected boolean generateCases(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        List<DictionaryAddressWord> searchWordList = null;
        boolean isSeperateAddressFieldsAwailable = parsedAddr.isSeparateAreaFields();
        if (isSeperateAddressFieldsAwailable) {
            return this.generateCasesForMultiLineInput(dataManager, parsedAddr, options, candidateList);
        }
        if (this.m_savedPostAddress == null) {
            this.m_savedPostAddress = (AddressWord[])parsedAddr.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
        }
        AddressWord[] lookupWords = this.m_savedPostAddress;
        switch (this.m_tryCount) {
            case 0: {
                if (this.getSacSearchFields() == null) {
                    this.initSacAndStreetSearchFields(dataManager);
                }
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.POST_CODE_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        this.KeepAreaNames(this.areaList, FieldType.AREA_NAME_1_FIELD_TYPE);
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 1: {
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_4_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.POST_CODE_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 2: {
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_4_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.POST_CODE_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 3: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                options.remove(MATCHABLE_DISTRICT_FOUND);
                options.remove(MATCHABLE_TOWN_FOUND);
                options.remove(MATCHABLE_LOCALITY_FOUND);
                options.remove(MATCHABLE_STATE_FOUND);
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    nonSplitFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 4: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                options.remove(MATCHABLE_DISTRICT_FOUND);
                options.remove(MATCHABLE_TOWN_FOUND);
                options.remove(MATCHABLE_LOCALITY_FOUND);
                options.remove(MATCHABLE_STATE_FOUND);
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    nonCombineFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    nonCombineFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    nonCombineFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    nonCombineFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 5: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    nonSplitFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 6: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    nonCombineFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    nonCombineFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    nonCombineFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 7: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    nonSplitFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 8: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    nonCombineFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    nonCombineFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    nonCombineFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 9: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                options.remove(MATCHABLE_DISTRICT_FOUND);
                options.remove(MATCHABLE_TOWN_FOUND);
                options.remove(MATCHABLE_LOCALITY_FOUND);
                options.remove(MATCHABLE_STATE_FOUND);
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    nonSplitFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 10: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                options.remove(MATCHABLE_DISTRICT_FOUND);
                options.remove(MATCHABLE_TOWN_FOUND);
                options.remove(MATCHABLE_LOCALITY_FOUND);
                options.remove(MATCHABLE_STATE_FOUND);
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    nonCombineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    nonCombineFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    nonCombineFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    nonCombineFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 11: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    nonSplitFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 12: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    nonCombineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    nonCombineFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    nonCombineFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 13: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    nonSplitFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 14: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    nonCombineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    nonCombineFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    nonCombineFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 15: {
                options.put(CONSIDER_PC_RELAXATION, "false");
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_4_FIELD_TYPE, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.POST_CODE_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 16: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    nonSplitFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 17: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    nonCombineFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    nonCombineFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 18: {
                options.remove(CONSIDER_PC_RELAXATION);
                if (this.getSacSearchFields() == null) {
                    this.initSacAndStreetSearchFields(dataManager);
                }
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        this.KeepAreaNames(this.areaList, FieldType.AREA_NAME_1_FIELD_TYPE);
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 19: {
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 20: {
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 21: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                options.remove(MATCHABLE_DISTRICT_FOUND);
                options.remove(MATCHABLE_TOWN_FOUND);
                options.remove(MATCHABLE_LOCALITY_FOUND);
                options.remove(MATCHABLE_STATE_FOUND);
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 22: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    nonCombineFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    nonCombineFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    nonCombineFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 23: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 24: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    nonCombineFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    nonCombineFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 25: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 26: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    nonCombineFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    nonCombineFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 27: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                options.remove(MATCHABLE_DISTRICT_FOUND);
                options.remove(MATCHABLE_TOWN_FOUND);
                options.remove(MATCHABLE_LOCALITY_FOUND);
                options.remove(MATCHABLE_STATE_FOUND);
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 28: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    nonCombineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    nonCombineFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    nonCombineFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 29: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 30: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    nonCombineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    nonCombineFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 31: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 32: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    nonCombineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    nonCombineFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 33: {
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_4_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.POST_CODE_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 34: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    nonSplitFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 35: {
                ++this.m_tryCount;
                options.put(CONSIDER_LOCALITY_RELAXATION, "false");
                options.put(WITHOUT_TOWN_CASE, "true");
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 36: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 37: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    nonCombineFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    nonCombineFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 38: {
                ++this.m_tryCount;
                options.remove(CONSIDER_LOCALITY_RELAXATION);
                options.remove(WITHOUT_TOWN_CASE);
                if (lookupWords != null && !options.isMustMatchAreaName4() && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    this.areaList = this.findAreas(lookupWords, false, dataManager, options, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.POST_CODE_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, false, options);
                        break;
                    }
                }
            }
            case 39: {
                ++this.m_tryCount;
                options.put(CONSIDER_LOCALITY_RELAXATION, "false");
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 40: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList<FieldType>();
                    nonSplitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.updateSearchableWordsWithSplitOrCombinedWords(lookupWords, splitFields, this.areaList);
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 41: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList<FieldType>();
                    nonCombineFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.updateSearchableWordsWithSplitOrCombinedWords(lookupWords, combineFields, this.areaList);
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 42: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.updateSearchableWordsWithSplitOrCombinedWords(lookupWords, splitFields, this.areaList);
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 43: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    nonCombineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, true);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.updateSearchableWordsWithSplitOrCombinedWords(lookupWords, combineFields, this.areaList);
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 44: {
                ++this.m_tryCount;
                if (lookupWords != null && this.m_canCheckAn3Only && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnTownCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_4_FIELD_TYPE, FieldType.POST_CODE_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 45: {
                options.remove(CONSIDER_LOCALITY_RELAXATION);
                options.remove(MATCHABLE_DISTRICT_FOUND);
                options.remove(MATCHABLE_TOWN_FOUND);
                options.remove(MATCHABLE_LOCALITY_FOUND);
                options.remove(MATCHABLE_STATE_FOUND);
                ++this.m_tryCount;
                if (lookupWords != null && this.m_canCheckAn3Only && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnTownCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.POST_CODE_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 46: {
                options.remove(MATCHABLE_DISTRICT_FOUND);
                options.remove(MATCHABLE_TOWN_FOUND);
                options.remove(MATCHABLE_LOCALITY_FOUND);
                options.remove(MATCHABLE_STATE_FOUND);
                ++this.m_tryCount;
                if (lookupWords != null && this.m_canCheckAn3Only && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnTownCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.POST_CODE_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 47: {
                ++this.m_tryCount;
                if (lookupWords != null && this.m_canCheckAn3Only && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnTownCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.POST_CODE_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 48: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                options.remove(MATCHABLE_DISTRICT_FOUND);
                options.remove(MATCHABLE_TOWN_FOUND);
                options.remove(MATCHABLE_LOCALITY_FOUND);
                options.remove(MATCHABLE_STATE_FOUND);
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnTownCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    nonSplitFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 49: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnTownCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    nonSplitFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 50: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnTownCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    nonSplitFields.add(FieldType.POST_CODE_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 51: {
                options.remove(MATCHABLE_DISTRICT_FOUND);
                options.remove(MATCHABLE_TOWN_FOUND);
                options.remove(MATCHABLE_LOCALITY_FOUND);
                options.remove(MATCHABLE_STATE_FOUND);
                ++this.m_tryCount;
                if (lookupWords != null && this.m_canCheckAn3Only && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnTownCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_1_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 52: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                options.remove(MATCHABLE_DISTRICT_FOUND);
                options.remove(MATCHABLE_TOWN_FOUND);
                options.remove(MATCHABLE_LOCALITY_FOUND);
                options.remove(MATCHABLE_STATE_FOUND);
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnTownCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    nonSplitFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 53: {
                options.remove(MATCHABLE_DISTRICT_FOUND);
                options.remove(MATCHABLE_TOWN_FOUND);
                options.remove(MATCHABLE_LOCALITY_FOUND);
                options.remove(MATCHABLE_STATE_FOUND);
                ++this.m_tryCount;
                if (lookupWords != null && this.m_canCheckAn3Only && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnTownCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_1_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 54: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnTownCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 55: {
                options.put(CONSIDER_LOCALITY_RELAXATION, "false");
                options.put(WITHOUT_TOWN_CASE, "true");
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 56: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.updateSearchableWordsWithSplitOrCombinedWords(lookupWords, splitFields, this.areaList);
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 57: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    nonCombineFields.add(FieldType.AREA_NAME_1_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.updateSearchableWordsWithSplitOrCombinedWords(lookupWords, combineFields, this.areaList);
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 58: {
                options.put(CONSIDER_LOCALITY_RELAXATION, "false");
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 59: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.updateSearchableWordsWithSplitOrCombinedWords(lookupWords, splitFields, this.areaList);
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 60: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    nonCombineFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    combineFields = new ArrayList();
                    combineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.updateSearchableWordsWithSplitOrCombinedWords(lookupWords, combineFields, this.areaList);
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 61: {
                ++this.m_tryCount;
                options.remove(WITHOUT_TOWN_CASE);
                if (lookupWords != null && this.m_canCheckAn3Only && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnTownCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 62: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && lookupWords.length > 1 && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnTownCandidates")) {
                    nonSplitFields = new ArrayList();
                    nonSplitFields.add(FieldType.AREA_NAME_2_FIELD_TYPE);
                    splitFields = new ArrayList();
                    splitFields.add(FieldType.AREA_NAME_3_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        options.setProperty(SPLIT_AREANAMES_CASE, "TRUE");
                        this.setAreaName1(this.areaName1List, this.areaList);
                        AddressWord[] words = this.getWordsFromAreaTerms();
                        searchWordList = this.getSearchableWords(words, dataManager, true, options);
                        break;
                    }
                }
            }
            case 63: {
                ++this.m_tryCount;
                if (lookupWords != null && this.m_canCheckAn3Only && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnTownCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.POST_CODE_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 64: {
                ++this.m_tryCount;
                if (lookupWords != null && this.m_canCheckAn3Only && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnTownCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_3_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 65: {
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    this.areaList = this.findAreas(lookupWords, true, dataManager, options, FieldType.AREA_NAME_4_FIELD_TYPE);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 66: {
                ArrayList<FieldType> splitFields;
                ArrayList<FieldType> nonSplitFields;
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonSplitFields = new ArrayList();
                    splitFields = new ArrayList<FieldType>();
                    splitFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithSplitWords(lookupWords, true, dataManager, options, nonSplitFields, splitFields);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.updateSearchableWordsWithSplitOrCombinedWords(lookupWords, splitFields, this.areaList);
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            case 67: {
                ArrayList<FieldType> combineFields;
                ArrayList<FieldType> nonCombineFields;
                ++this.m_tryCount;
                if (lookupWords != null && INDStreetGeocodingHelper.canSearchFieldType(options, "ReturnLocalityCandidates")) {
                    nonCombineFields = new ArrayList();
                    combineFields = new ArrayList<FieldType>();
                    combineFields.add(FieldType.AREA_NAME_4_FIELD_TYPE);
                    this.areaList = this.findAreasWithCombinedWords(lookupWords, true, dataManager, options, nonCombineFields, combineFields, false);
                    if (!ListUtils.isEmpty(this.areaList)) {
                        lookupWords = this.updateSearchableWordsWithSplitOrCombinedWords(lookupWords, combineFields, this.areaList);
                        lookupWords = this.adjustPostAddressWords(parsedAddr, this.areaList, lookupWords, true);
                        searchWordList = this.getSearchableWords(lookupWords, dataManager, true, options);
                        break;
                    }
                }
            }
            default: {
                return false;
            }
        }
        if (this.areaList != null && searchWordList != null) {
            this.setSearchAreaList(this.areaList);
            this.setSearchWordList(searchWordList);
        }
        return true;
    }

    private AddressWord[] updateSearchableWordsWithSplitOrCombinedWords(AddressWord[] lookupWords, List<FieldType> fields, List<DictionaryAreaTermItem> areaList) {
        if (null == lookupWords) {
            return null;
        }
        ArrayList<AddressWord> lookupWordsList = new ArrayList<AddressWord>();
        for (AddressWord word : lookupWords) {
            lookupWordsList.add(word);
        }
        for (FieldType type : fields) {
            for (DictionaryAreaTermItem areaTerm : areaList) {
                AddressWord[] areaWords;
                if (type != areaTerm.getFieldType()) continue;
                for (AddressWord word : areaWords = areaTerm.getAreaAddressWords()) {
                    lookupWordsList.add(word);
                }
            }
        }
        if (lookupWordsList.size() > 0) {
            return lookupWordsList.toArray(new AddressWord[lookupWordsList.size()]);
        }
        return lookupWords;
    }

    @Override
    public AddressWord[] getCombinedPossibles(AddressWord[] words) {
        int wordsLen;
        int n = wordsLen = words == null ? 0 : words.length;
        if (wordsLen > 1) {
            ArrayList<AddressWord> addrWordList = new ArrayList<AddressWord>(wordsLen * 3);
            ICGGEParser parser = this.getHelperParser();
            ICGGESoundex soundex = this.getHelperSoundex();
            block0: for (int wordNdx = 0; wordNdx < wordsLen - 1; ++wordNdx) {
                AddressWord word = words[wordNdx];
                if (!this.considerWordForCombining(word)) continue;
                CharArray charArray = new CharArray();
                charArray.add(word.getWordChars());
                boolean prevWordWasAKnownWord = this.isKnownWord(word);
                for (int wordNdx1 = wordNdx + 1; wordNdx1 < wordsLen; ++wordNdx1) {
                    AddressWord word1 = words[wordNdx1];
                    if (this.considerWordForCombining(word1)) {
                        boolean knownWord = this.isKnownWord(word1);
                        if (prevWordWasAKnownWord && knownWord) continue block0;
                        prevWordWasAKnownWord = knownWord;
                        charArray.add(word1.getWordChars());
                        AddressWord combinedWord = parser.convertToAddressWord(charArray.toString(), soundex);
                        addrWordList.add(combinedWord);
                        if (charArray.length() <= 15) continue;
                        continue block0;
                    }
                    if (!CodedWord.isDelimiter(word1.getAttributes())) continue block0;
                }
            }
            if (addrWordList.size() > 0) {
                return addrWordList.toArray(new AddressWord[addrWordList.size()]);
            }
        }
        return null;
    }

    private boolean isKnownWord(AddressWord word) {
        return word.getWordLength() > 1 && (word.getAttributes() & KNOWN_WORD_MASK) > 0;
    }

    private boolean considerWordForCombining(AddressWord word) {
        short attribs = word.getAttributes();
        return !CodedWord.isDelimiter(attribs);
    }

    private boolean containsArea(List<DictionaryAreaTermItem> areaList, FieldType type) {
        if (!ListUtils.isEmpty(areaList)) {
            for (DictionaryAreaTermItem area : areaList) {
                if (area.getFieldType() != type) continue;
                return true;
            }
        }
        return false;
    }

    private List<DictionaryAreaTermItem> findAreas(AddressWord[] searchWords, boolean perfect, IDataManager dataManager, GeocodeOptions options, FieldType ... types) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        ArrayList<DictionaryAreaTermItem> finalAreaList = new ArrayList<DictionaryAreaTermItem>();
        if (searchWords != null) {
            searchWords = (AddressWord[])searchWords.clone();
        }
        options.remove(MATCHABLE_DISTRICT_FOUND);
        options.remove(MATCHABLE_TOWN_FOUND);
        options.remove(MATCHABLE_LOCALITY_FOUND);
        options.remove(MATCHABLE_STATE_FOUND);
        this.m_intersectionFieldtypeList.clear();
        ArrayList<FieldType> fieldTypes = new ArrayList<FieldType>();
        for (FieldType type : types) {
            fieldTypes.add(type);
        }
        searchWords = this.populateAreaList(searchWords, perfect, dataManager, options, fieldTypes, finalAreaList);
        return finalAreaList;
    }

    private AddressWord[] populateAreaList(AddressWord[] searchWords, boolean perfect, IDataManager dataManager, GeocodeOptions options, List<FieldType> types, List<DictionaryAreaTermItem> finalAreaList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        if (null == finalAreaList) {
            return searchWords;
        }
        for (FieldType type : types) {
            List<DictionaryAreaTermItem> areaList = this.findAreaList(searchWords, type, dataManager, perfect, options);
            if (null != areaList && type == FieldType.AREA_NAME_3_FIELD_TYPE) {
                options.setProperty(MATCHABLE_TOWN_FOUND, "true");
            } else if (null != areaList && type == FieldType.AREA_NAME_4_FIELD_TYPE) {
                options.setProperty(MATCHABLE_LOCALITY_FOUND, "true");
            } else if (null != areaList && type == FieldType.AREA_NAME_2_FIELD_TYPE) {
                options.setProperty(MATCHABLE_DISTRICT_FOUND, "true");
            } else if (null != areaList && type == FieldType.AREA_NAME_1_FIELD_TYPE) {
                options.setProperty(MATCHABLE_STATE_FOUND, "true");
            }
            if (!ListUtils.isEmpty(areaList)) {
                Collections.sort(areaList, new AreaQualityComparator());
                searchWords = this.filterSearchWordOnMatchingAreaWords(searchWords, areaList);
                finalAreaList.addAll(areaList);
            }
            this.m_intersectionFieldtypeList.add(type);
        }
        return searchWords;
    }

    private List<DictionaryAreaTermItem> findAreasWithCombinedWords(AddressWord[] searchWords, boolean perfect, IDataManager dataManager, GeocodeOptions options, List<FieldType> nonCombineTypes, List<FieldType> combineTypes, boolean combinedFirst) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        ArrayList<DictionaryAreaTermItem> finalAreaList = new ArrayList<DictionaryAreaTermItem>();
        if (searchWords != null) {
            searchWords = (AddressWord[])searchWords.clone();
        }
        this.m_intersectionFieldtypeList.clear();
        if (combinedFirst) {
            AddressWord[] combinedSearchWords = this.getCombinedPossibles(searchWords);
            if (null != combinedSearchWords && combinedSearchWords.length > 0 && null != searchWords && searchWords.length > 0) {
                AddressWord[] combinedWords = new AddressWord[combinedSearchWords.length + searchWords.length];
                System.arraycopy(searchWords, 0, combinedWords, 0, searchWords.length);
                System.arraycopy(combinedSearchWords, 0, combinedWords, searchWords.length, combinedSearchWords.length);
                combinedSearchWords = combinedWords;
            }
            this.populateAreaList(combinedSearchWords, perfect, dataManager, options, combineTypes, finalAreaList);
            searchWords = this.populateAreaList(searchWords, perfect, dataManager, options, nonCombineTypes, finalAreaList);
        } else {
            AddressWord[] combinedSearchWords = this.getCombinedPossibles(searchWords = this.populateAreaList(searchWords, perfect, dataManager, options, nonCombineTypes, finalAreaList));
            if (null != combinedSearchWords && combinedSearchWords.length > 0 && null != searchWords && searchWords.length > 0) {
                AddressWord[] combinedWords = new AddressWord[combinedSearchWords.length + searchWords.length];
                System.arraycopy(searchWords, 0, combinedWords, 0, searchWords.length);
                System.arraycopy(combinedSearchWords, 0, combinedWords, searchWords.length, combinedSearchWords.length);
                combinedSearchWords = combinedWords;
            }
            this.populateAreaList(combinedSearchWords, perfect, dataManager, options, combineTypes, finalAreaList);
        }
        return finalAreaList;
    }

    private List<DictionaryAreaTermItem> findAreasWithSplitWords(AddressWord[] searchWords, boolean perfect, IDataManager dataManager, GeocodeOptions options, List<FieldType> nonSplitTypes, List<FieldType> splitTypes) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        ArrayList<DictionaryAreaTermItem> finalAreaList = new ArrayList<DictionaryAreaTermItem>();
        if (searchWords != null) {
            searchWords = (AddressWord[])searchWords.clone();
        }
        this.m_intersectionFieldtypeList.clear();
        searchWords = this.populateAreaList(searchWords, perfect, dataManager, options, nonSplitTypes, finalAreaList);
        AddressWord[] splitLocalitySearchWords = this.getSplitWords(searchWords);
        if (null != splitLocalitySearchWords && splitLocalitySearchWords.length > 0 && null != searchWords && searchWords.length > 0) {
            AddressWord[] combinedWords = new AddressWord[splitLocalitySearchWords.length + searchWords.length];
            System.arraycopy(searchWords, 0, combinedWords, 0, searchWords.length);
            System.arraycopy(splitLocalitySearchWords, 0, combinedWords, searchWords.length, splitLocalitySearchWords.length);
            splitLocalitySearchWords = combinedWords;
        }
        searchWords = this.populateAreaList(splitLocalitySearchWords, perfect, dataManager, options, splitTypes, finalAreaList);
        return finalAreaList;
    }

    private List<DictionaryAreaTermItem> findAreaList(AddressWord[] searchWords, FieldType type, IDataManager dataManager, boolean perfect, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        String prop;
        double minQuality;
        double d = minQuality = perfect ? 1.0 : this.m_minAreaValue;
        if (type == FieldType.AREA_NAME_4_FIELD_TYPE && (null == (prop = options.getProperty(CONSIDER_LOCALITY_RELAXATION)) || "true".equals(prop))) {
            minQuality = 0.93;
        }
        if (type == FieldType.POST_CODE_FIELD_TYPE && (null == (prop = options.getProperty(CONSIDER_PC_RELAXATION)) || "true".equals(prop))) {
            minQuality = 0.98;
        }
        List<DictionaryAreaTermItem> areaList = null;
        if (searchWords != null) {
            areaList = this.findAreaList(searchWords, type, minQuality, dataManager, options);
        }
        return areaList;
    }

    private int getSignificantWordCount(AddressWord[] words) {
        int c = 0;
        for (AddressWord word : words) {
            if (!AddressWord.isSignificantWord(word)) continue;
            ++c;
        }
        return c;
    }

    private AddressWord[] filterSearchWordOnMatchingAreaWords(AddressWord[] searchWords, List<DictionaryAreaTermItem> areaList) {
        return this.removeMatchingSearchWords(searchWords, areaList.get(0));
    }

    private AddressWord[] removeMatchingSearchWords(AddressWord[] searchWords, DictionaryAreaTermItem area) {
        DictionaryAddressWord[] matchedDictWords = area.getMatchedWords();
        int searchWordsLen = searchWords.length;
        int removed = 0;
        if (matchedDictWords != null) {
            for (DictionaryAddressWord matchedDictWord : matchedDictWords) {
                if (matchedDictWord == null) continue;
                for (int ndx = 0; ndx < searchWordsLen; ++ndx) {
                    if (matchedDictWord.getSearchWord() != searchWords[ndx]) continue;
                    searchWords[ndx] = null;
                    ++removed;
                }
            }
        }
        if (removed > 0) {
            int remaining = searchWordsLen - removed;
            if (remaining > 0) {
                AddressWord[] filteredWords = new AddressWord[remaining];
                int added = 0;
                for (int ndx = 0; ndx < searchWordsLen; ++ndx) {
                    AddressWord word = searchWords[ndx];
                    if (word == null) continue;
                    filteredWords[added++] = word;
                }
                searchWords = filteredWords;
            } else {
                searchWords = null;
            }
        }
        return searchWords;
    }

    private List<DictionaryAreaTermItem> findAreas(ParsedAddress pAddr, boolean perfect, IDataManager dataManager, GeocodeOptions options, FieldType ... fields) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        ArrayList<DictionaryAreaTermItem> finalAreaList = new ArrayList<DictionaryAreaTermItem>();
        for (FieldType type : fields) {
            AddressWord[] searchWords = (AddressWord[])pAddr.getField(type);
            if (searchWords == null || searchWords.length <= 0) continue;
            List<DictionaryAreaTermItem> areaList = this.findAreaList(searchWords, type, dataManager, perfect, options);
            this.m_intersectionFieldtypeList.add(type);
            if (ListUtils.isEmpty(areaList)) continue;
            finalAreaList.addAll(areaList);
        }
        return finalAreaList;
    }

    private void setSacSearchIntersectionFields(FieldType ... types) {
        this.m_intersectionFieldtypeList.clear();
        List<DictionaryAreaTermItem> areaList = this.getSearchAreaList();
        for (FieldType type : types) {
            if (!this.containsArea(areaList, type)) continue;
            this.m_intersectionFieldtypeList.add(type);
        }
    }

    private boolean initAreasForSearching(ParsedAddress parsedAddr, FieldType searchType, boolean perfectMatchesOnly, boolean updateOnly, IDataManager dataManager, GeocodeOptions options, FieldType ... sacIntersectionTypes) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        FieldType[] fieldTypeArray;
        if (updateOnly) {
            FieldType[] fieldTypeArray2 = new FieldType[1];
            fieldTypeArray = fieldTypeArray2;
            fieldTypeArray2[0] = searchType;
        } else {
            fieldTypeArray = sacIntersectionTypes;
        }
        List<DictionaryAreaTermItem> areaList = this.findAreas(parsedAddr, perfectMatchesOnly, dataManager, options, fieldTypeArray);
        this.setSearchAreaList(areaList);
        if (areaList != null && this.containsArea(areaList, searchType)) {
            AddressWord[] lookUpAreaWords = (AddressWord[])parsedAddr.getField(searchType);
            this.setSearchWordList(this.getSearchableWords(lookUpAreaWords, searchType, dataManager, perfectMatchesOnly, options));
            if (this.isValidSearchWordList()) {
                this.setSacSearchIntersectionFields(sacIntersectionTypes);
                return true;
            }
        }
        return true;
    }

    private boolean initAreasForSearching(ParsedAddress parsedAddr, AddressWord[] searchWords, FieldType searchType, boolean perfectMatchesOnly, boolean updateOnly, IDataManager dataManager, GeocodeOptions options, FieldType ... sacIntersectionTypes) throws CGGEInternalException, DataNotInitialisedException, DataFetchException {
        List<DictionaryAreaTermItem> areaList = this.findAreas(searchWords, perfectMatchesOnly, dataManager, options, searchType);
        if (sacIntersectionTypes != null) {
            FieldType[] fieldTypeArray;
            if (updateOnly) {
                FieldType[] fieldTypeArray2 = new FieldType[1];
                fieldTypeArray = fieldTypeArray2;
                fieldTypeArray2[0] = searchType;
            } else {
                fieldTypeArray = sacIntersectionTypes;
            }
            List<DictionaryAreaTermItem> areaList1 = this.findAreas(parsedAddr, perfectMatchesOnly, dataManager, options, fieldTypeArray);
            areaList = ListUtils.addToList(areaList, areaList1);
        }
        this.setSearchAreaList(areaList);
        if (areaList != null && this.containsArea(areaList, searchType)) {
            this.setSearchWordList(this.getSearchableWords(searchWords, searchType, dataManager, perfectMatchesOnly, options));
            if (this.isValidSearchWordList()) {
                this.setSacSearchIntersectionFields(sacIntersectionTypes);
                return true;
            }
        }
        return true;
    }

    protected boolean generateCasesForMultiLineInput(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        AddressWord[] lookUpAreaWords = null;
        switch (this.m_tryCount) {
            case 0: {
                ++this.m_tryCount;
                if (this.initAreasForSearching(parsedAddr, FieldType.AREA_NAME_4_FIELD_TYPE, true, false, dataManager, options, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE)) {
                    return true;
                }
            }
            case 1: {
                ++this.m_tryCount;
                if (this.containsArea(this.getSearchAreaList(), FieldType.AREA_NAME_4_FIELD_TYPE)) {
                    this.setSacSearchIntersectionFields(FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE);
                    return true;
                }
            }
            case 2: {
                ++this.m_tryCount;
                if (this.containsArea(this.getSearchAreaList(), FieldType.AREA_NAME_4_FIELD_TYPE) && !this.containsArea(this.getSearchAreaList(), FieldType.AREA_NAME_1_FIELD_TYPE)) {
                    this.setSacSearchIntersectionFields(FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE);
                    return true;
                }
            }
            case 3: {
                ++this.m_tryCount;
                if (this.initAreasForSearching(parsedAddr, FieldType.AREA_NAME_4_FIELD_TYPE, false, true, dataManager, options, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE)) {
                    return true;
                }
            }
            case 4: {
                ++this.m_tryCount;
                this.setSearchAreaList(null);
                if (this.initAreasForSearching(parsedAddr, FieldType.AREA_NAME_4_FIELD_TYPE, false, false, dataManager, options, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE, FieldType.AREA_NAME_4_FIELD_TYPE)) {
                    return true;
                }
            }
            case 5: {
                ++this.m_tryCount;
                this.setSearchAreaList(null);
                if (this.initAreasForSearching(parsedAddr, FieldType.AREA_NAME_3_FIELD_TYPE, true, false, dataManager, options, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE)) {
                    return true;
                }
            }
            case 6: {
                ++this.m_tryCount;
                this.setSearchAreaList(null);
                if (this.containsArea(this.getSearchAreaList(), FieldType.AREA_NAME_2_FIELD_TYPE)) {
                    this.setSacSearchIntersectionFields(FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE);
                    return true;
                }
            }
            case 7: {
                ++this.m_tryCount;
                this.setSearchAreaList(null);
                if (this.initAreasForSearching(parsedAddr, FieldType.AREA_NAME_4_FIELD_TYPE, false, false, dataManager, options, FieldType.AREA_NAME_1_FIELD_TYPE, FieldType.AREA_NAME_2_FIELD_TYPE, FieldType.AREA_NAME_3_FIELD_TYPE)) {
                    return true;
                }
            }
            case 8: {
                ++this.m_tryCount;
                lookUpAreaWords = (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
                if (lookUpAreaWords != null && parsedAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE) == null) {
                    if (this.initAreasForSearching(parsedAddr, lookUpAreaWords, FieldType.AREA_NAME_4_FIELD_TYPE, true, false, dataManager, options, FieldType.AREA_NAME_1_FIELD_TYPE)) {
                        // empty if block
                    }
                    return true;
                }
            }
            case 9: {
                ++this.m_tryCount;
                lookUpAreaWords = (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
                AddressWord[] splittedSearchWords = this.getCombinedPossibles(lookUpAreaWords);
                if (splittedSearchWords != null) {
                    this.setSearchAreaList(dataManager.findAreaTerms(3, splittedSearchWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, options));
                    if (this.isValidAreaList()) {
                        this.setSearchWordList(this.getSearchableWords(splittedSearchWords, FieldType.AREA_NAME_3_FIELD_TYPE, dataManager, false, options));
                        return this.isValidSearchWordList();
                    }
                }
            }
            case 10: {
                ++this.m_tryCount;
                lookUpAreaWords = (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
                AddressWord[] splittedSearchWords = this.getSplitWords(lookUpAreaWords);
                if (splittedSearchWords != null) {
                    this.setSearchAreaList(dataManager.findAreaTerms(3, splittedSearchWords, FieldType.AREA_NAME_3_FIELD_TYPE, 1.0, options));
                    if (this.isValidAreaList()) {
                        this.setSearchWordList(this.getSearchableWords(splittedSearchWords, FieldType.AREA_NAME_3_FIELD_TYPE, dataManager, false, options));
                        return this.isValidSearchWordList();
                    }
                }
            }
            case 11: {
                ++this.m_tryCount;
                lookUpAreaWords = (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
                AddressWord[] splittedSearchWords = this.getSplitWords(lookUpAreaWords);
                if (splittedSearchWords != null && parsedAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE) == null) {
                    this.setSearchAreaList(dataManager.findAreaTerms(3, splittedSearchWords, FieldType.AREA_NAME_4_FIELD_TYPE, 1.0, options));
                    if (this.isValidAreaList()) {
                        this.setSearchWordList(this.getSearchableWords(splittedSearchWords, FieldType.AREA_NAME_4_FIELD_TYPE, dataManager, false, options));
                        return this.isValidSearchWordList();
                    }
                }
            }
            case 12: {
                ++this.m_tryCount;
                options.setProperty(SPLIT_AREANAMES_CASE, "true");
                lookUpAreaWords = (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
                AddressWord[] splittedSearchWords = this.getSplitWords(lookUpAreaWords);
                if (splittedSearchWords != null) {
                    this.setSearchAreaList(dataManager.findAreaTerms(3, splittedSearchWords, FieldType.AREA_NAME_3_FIELD_TYPE, 0.9, options));
                    if (this.isValidAreaList()) {
                        this.setSearchWordList(this.getSearchableWords(splittedSearchWords, FieldType.AREA_NAME_3_FIELD_TYPE, dataManager, false, options));
                        return this.isValidSearchWordList();
                    }
                }
            }
            case 13: {
                ++this.m_tryCount;
                lookUpAreaWords = (AddressWord[])parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
                AddressWord[] splittedSearchWords = this.getSplitWords(lookUpAreaWords);
                if (splittedSearchWords == null || parsedAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE) != null) break;
                this.setSearchAreaList(dataManager.findAreaTerms(3, splittedSearchWords, FieldType.AREA_NAME_4_FIELD_TYPE, 0.9, options));
                if (!this.isValidAreaList()) break;
                this.setSearchWordList(this.getSearchableWords(splittedSearchWords, FieldType.AREA_NAME_4_FIELD_TYPE, dataManager, false, options));
                return this.isValidSearchWordList();
            }
        }
        return false;
    }

    @Override
    public InternalCandidateList searchNextCase(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList curCandList) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        if (this.generateCases(dataManager, parsedAddress, options, curCandList)) {
            return this.retrieveCandidates(dataManager, parsedAddress, this.getSearchAreaList(), this.getSearchWordList(), options);
        }
        this.finishRetries();
        return null;
    }

    private boolean isValidSearchWordList() {
        return this.getSearchWordList() != null && this.getSearchWordList().size() > 0;
    }

    private boolean isValidAreaList() {
        return this.getSearchAreaList() != null && this.getSearchAreaList().size() > 0;
    }

    @Override
    protected void initSacAndStreetSearchFields(IDataManager dataManager) throws CGGEInternalException {
        super.initSacAndStreetSearchFields(dataManager);
    }

    @Override
    protected InternalCandidateList retrieveCandidates(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        return null;
    }

    protected InternalCandidateList retrieveCandidates(IDataManager dataManager, ParsedAddress parsedAddress, List<DictionaryAreaTermItem> areaList, List<DictionaryAddressWord> searchWordList, GeocodeOptions options) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        InternalCandidateList candList = null;
        if (areaList != null && searchWordList != null) {
            Collection<InternalScoringAddress> cands;
            areaList = new ArrayList<DictionaryAreaTermItem>(areaList);
            searchWordList = new ArrayList<DictionaryAddressWord>(searchWordList);
            this.filterSearchedAreaItemAndSearchWord(areaList, searchWordList);
            List<DictionaryAreaSacs> areaSacList = dataManager.getSacsForAreas(3, areaList, options);
            if (areaSacList != null && this.m_intersectionFieldtypeList != null && this.m_intersectionFieldtypeList.size() > 1) {
                this.filterSacsForAreaIntersection(areaSacList, this.m_intersectionFieldtypeList);
            }
            if (areaSacList != null) {
                this.filterSearchedSacs(areaSacList, searchWordList);
            }
            if (areaSacList != null && (cands = dataManager.findCandidates(this.getGeocodeType(), areaSacList, searchWordList, options)) != null) {
                candList = new InternalCandidateList();
                candList.addCandidates(cands);
            }
        }
        return candList;
    }

    @Override
    public AddressWord[] getSplitWords(AddressWord[] inWords) {
        if (inWords != null) {
            ICGGEParser parser = this.getHelperParser();
            ICGGESoundex soundex = this.getHelperSoundex();
            StringBuilder sb = new StringBuilder(15);
            ArrayList<AddressWord> splitWords = new ArrayList<AddressWord>(5);
            for (AddressWord addrWord : inWords) {
                if (!AddressWord.isSignificantWord(addrWord)) continue;
                char[] ch = addrWord.getWordChars();
                int len = ch.length;
                sb.append(ch);
                for (int i = 1; i < len - 1; ++i) {
                    AddressWord splitWord2;
                    AddressWord splitWord1 = parser.convertToAddressWord(sb.substring(0, i + 1), soundex);
                    if (this.isSignificantWordWithCommonWord(splitWord1)) {
                        splitWords.add(splitWord1);
                    }
                    if (!this.isSignificantWordWithCommonWord(splitWord2 = parser.convertToAddressWord(sb.substring(i + 1), soundex))) break;
                    splitWords.add(splitWord2);
                }
                sb.delete(0, len);
            }
            if (splitWords.size() > 0) {
                return splitWords.toArray(new AddressWord[splitWords.size()]);
            }
        }
        return null;
    }

    private boolean isSignificantWordWithCommonWord(AddressWord word) {
        short wordAttribs = word.getAttributes();
        return !CodedWord.isArticleWord(wordAttribs) && !CodedWord.isNumber(wordAttribs) && !CodedWord.isNumeric(wordAttribs) && !CodedWord.isDirectionalWord(wordAttribs) && !CodedWord.isThoroughfareTypeWord(wordAttribs) && !CodedWord.isDelimiter(wordAttribs);
    }

    private void KeepAreaNames(List<DictionaryAreaTermItem> areaList, FieldType type) {
        if (!ListUtils.isEmpty(areaList)) {
            this.areaName1List = new ArrayList<DictionaryAreaTermItem>();
            for (DictionaryAreaTermItem area : areaList) {
                if (area.getFieldType() != type) continue;
                this.areaName1List.add(area);
            }
        }
    }

    private List<DictionaryAreaTermItem> setAreaName1(List<DictionaryAreaTermItem> newareaList, List<DictionaryAreaTermItem> previousAreaNameList) {
        if (!ListUtils.isEmpty(this.areaName1List)) {
            newareaList = new ArrayList<DictionaryAreaTermItem>();
            for (DictionaryAreaTermItem area : this.areaName1List) {
                previousAreaNameList.add(area);
                this.addIntersectionList(area);
            }
        }
        return previousAreaNameList;
    }

    private void addIntersectionList(DictionaryAreaTermItem area) {
        FieldType type = area.getFieldType();
        if (!this.m_intersectionFieldtypeList.contains(type)) {
            this.m_intersectionFieldtypeList.add(type);
        }
    }

    private class AreaQualityComparator
    implements Comparator<DictionaryAreaTermItem> {
        private AreaQualityComparator() {
        }

        @Override
        public int compare(DictionaryAreaTermItem o1, DictionaryAreaTermItem o2) {
            int c = MMUtils.compareDoubleValues(o1.m_quality, o2.m_quality);
            if (c == 0) {
                c = o2.getMatchedWordCount() - o1.getMatchedWordCount();
            }
            if (c == 0) {
                c = o2.m_areaWords.length - o1.m_areaWords.length;
            }
            if (c == 0) {
                c = INDGeographicGeocodingHelper.this.getSignificantWordCount(o2.m_areaWords) - INDGeographicGeocodingHelper.this.getSignificantWordCount(o1.m_areaWords);
            }
            return c;
        }
    }
}

