/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.IND.helper;

import com.mapinfo.mapmarker.IND.address.IND_ParsedAddress;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.helper.CGGEPOIGeocodingHelper;

public class INDPOIGeocodingHelper
extends CGGEPOIGeocodingHelper {
    private String m_Country;
    private String m_Language;
    private boolean m_CanTryAgain;

    @Override
    public boolean init(String country, String language) {
        this.m_Country = country;
        this.m_Language = language;
        this.m_CanTryAgain = true;
        return super.init(country, language);
    }

    @Override
    public InternalCandidateList searchNextCase(IDataManager dataManager, ParsedAddress parsedAddress, GeocodeOptions options, InternalCandidateList curCandList) throws CGGEInternalException, DataFetchException, DataNotInitialisedException {
        if (this.generateCases(dataManager, parsedAddress, options, curCandList)) {
            return super.retrieveCandidates(dataManager, parsedAddress, options);
        }
        this.finishRetries();
        IND_ParsedAddress indParsedAddress = (IND_ParsedAddress)parsedAddress;
        if (indParsedAddress.hasMorePOIS() && !this.m_CanTryAgain) {
            parsedAddress.setField(FieldType.PLACE_NAME_FIELD_TYPE, indParsedAddress.getNextPOI());
            super.init(this.m_Country, this.m_Language);
            return this.searchNextCase(dataManager, parsedAddress, options, curCandList);
        }
        return null;
    }

    @Override
    protected AddressWord[] getSearchWords(ParsedAddress parsedAddr, boolean weightedWords, int includeMask) {
        AddressWord[] inputWords = (AddressWord[])parsedAddr.getField(FieldType.PLACE_NAME_FIELD_TYPE);
        AddressWord[] searchWords = null;
        if (inputWords != null) {
            searchWords = this.filterSearchWords(inputWords, weightedWords, false, includeMask);
        }
        return searchWords;
    }
}

