/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.ISR.matcher;

import com.mapinfo.mapmarker.ISR.matcher.ISRFieldScoreAdjuster;
import com.mapinfo.mapmarker.ISR.util.ISR_Utils;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.ScoringItem;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.IntArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.Map;

public class ISR_Matcher
extends CGGEMatcher1 {
    private static final int FULL_POSTALCODE_LENGTH = 7;

    public ISR_Matcher() {
        this.m_fieldScoreAdjuster = new ISRFieldScoreAdjuster();
    }

    @Override
    protected FieldScore scorePostCode(ScoringItem addr, ParsedAddress parsedAddr, Map<FieldType, FieldScore> currentScores, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        FieldScore postalScore = super.scorePostCode(addr, parsedAddr, currentScores, matchingOptions, scorer);
        if (postalScore.m_value < 1.0 && parsedAddr.getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE) != null && addr.getField(FieldType.POST_CODE_FIELD_TYPE) != null) {
            String candidateFullPC = ISR_Utils.getStringFromAddressWordArray((AddressWord[])((InternalFieldValue)addr.getField(FieldType.POST_CODE_FIELD_TYPE)).getFieldValue());
            if (!MMUtils.isEmpty(candidateFullPC) && candidateFullPC.length() < 7) {
                AddressWord[] GF4 = (AddressWord[])parsedAddr.getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE);
                this.scorePostCode1(addr, postalScore, GF4);
            }
        } else if (postalScore.m_value == 1.0 && parsedAddr.getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE) != null && ISR_Utils.getStringFromAddressWordArray((AddressWord[])((InternalFieldValue)addr.getField(FieldType.POST_CODE_FIELD_TYPE)).getFieldValue()).length() != 7) {
            postalScore.m_value = 0.99;
            postalScore.m_matched = false;
            postalScore.m_perfectInputWords = new IntArray(1, 0);
        }
        return postalScore;
    }

    private void scorePostCode1(ScoringItem addr, FieldScore postalScore, AddressWord[] GF4) {
        String inputtedPC = ISR_Utils.getInitialFiveDigitPC(GF4);
        String candPC = ISR_Utils.getInitialFiveDigitPC((AddressWord[])((InternalFieldValue)addr.getField(FieldType.POST_CODE_FIELD_TYPE)).getFieldValue());
        if (!MMUtils.isEmpty(inputtedPC) && !MMUtils.isEmpty(candPC) && inputtedPC.equals(candPC)) {
            postalScore.m_value = 0.99;
            postalScore.m_matched = false;
            postalScore.m_perfectInputWords = new IntArray(1, 0);
        }
    }

    @Override
    protected void adjustScores(InternalScoringAddress cand, ParsedAddress pAddr, MatchingOptions matchingOptions) {
        super.adjustScores(cand, pAddr, matchingOptions);
    }
}

