/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.ISR.util;

import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ISR_Utils {
    private static final String PARTIAL_POSTALCODE_FORMAT = "\\d{5}";
    private static final Pattern PARTIAL_POSTALCODE = Pattern.compile("\\d{5}", 2);

    public static String getInitialFiveDigitPC(AddressWord[] pcAddressWordArray) {
        Matcher pcmatcher;
        String pcString = ISR_Utils.getStringFromAddressWordArray(pcAddressWordArray);
        if (!MMUtils.isEmpty(pcString) && (pcmatcher = PARTIAL_POSTALCODE.matcher(pcString)).find()) {
            pcString = pcmatcher.group(0);
        }
        return pcString;
    }

    public static String getStringFromAddressWordArray(AddressWord[] pcAddressWordArray) {
        StringBuilder builder = new StringBuilder();
        if (pcAddressWordArray != null && pcAddressWordArray.length > 0) {
            for (AddressWord addressWord : pcAddressWordArray) {
                builder.append(addressWord.getCodedWord().getWord()).append(" ");
            }
        }
        return builder.toString().trim();
    }
}

