/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.ITA.matcher;

import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.utils.IntArray;

public class ITAMatcher
extends CGGEMatcher1 {
    @Override
    protected void scoreStreetFields(InternalScoringAddress scoringAddr, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        super.scoreStreetFields(scoringAddr, pAddr, matchingOptions, scorer);
        FieldScore score = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        if (score != null && score.m_value > 0.0) {
            this.adjustScoresForMissingWordsForITA(score);
        }
    }

    private void adjustScoresForMissingWordsForITA(FieldScore fieldScore) {
        if (fieldScore != null && fieldScore.m_perfectCandWords != null && fieldScore.m_perfectCandWords.size() > 0) {
            int candWordCount;
            int n = candWordCount = fieldScore.m_candWords == null ? 0 : fieldScore.m_candWords.length;
            if (fieldScore.m_matchedCandWords.size() < candWordCount && this.haveSignificantWords(fieldScore.m_candWords) && this.inputWordsMatchedInOrder(fieldScore)) {
                double score = fieldScore.m_value;
                double missingScore = 1.0 - score;
                double w1 = this.getWeightForMissingWords(candWordCount);
                for (int wordNdx = 0; wordNdx < candWordCount; ++wordNdx) {
                    AddressWord word = fieldScore.m_candWords[wordNdx];
                    if (!((double)word.m_weight > 1.0E-4) || !word.m_wordType.equals(FieldType.STREET_NAME_FIELD_TYPE) || !fieldScore.m_perfectCandWords.contains(wordNdx) && !fieldScore.m_matchedCandWords.contains(wordNdx)) continue;
                    missingScore = 1.0 - (score += missingScore * w1);
                    if (!(w1 < 1.0)) continue;
                    w1 += 0.1;
                }
                fieldScore.m_value = score;
            }
        }
    }

    private boolean inputWordsMatchedInOrder(FieldScore score) {
        int size;
        IntArray a = score.m_matchedInputWords;
        int n = size = a == null ? 0 : a.size();
        if (size > 0) {
            int lastMatch = a.get(0);
            int ndx = 1;
            while (ndx < size) {
                int match = a.get(ndx);
                if (match < lastMatch) {
                    return false;
                }
                if (lastMatch + 1 != match) {
                    if (score.m_inputWords[lastMatch + 1].getSoundex() != 0) {
                        return false;
                    }
                    ++lastMatch;
                    continue;
                }
                lastMatch = match;
                ++ndx;
            }
            return true;
        }
        return false;
    }

    private boolean haveSignificantWords(AddressWord[] words) {
        int n = words == null ? 0 : words.length;
        for (int i = 0; i < n; ++i) {
            if (!AddressWord.isSignificantWord(words[i])) continue;
            return true;
        }
        return false;
    }

    private double getWeightForMissingWords(int numberOfCandidateWords) {
        double value = 0.48;
        switch (numberOfCandidateWords) {
            case 3: {
                value = 0.48;
                break;
            }
            case 4: {
                value = 0.58;
                break;
            }
            case 5: {
                value = 0.65;
                break;
            }
            default: {
                value = 0.48;
            }
        }
        return value;
    }
}

