/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.JPN.convertor;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.JPN.dp.JPNDataManagerSettingsProvider;
import com.mapinfo.mapmarker.JPN.utils.JapaneseNumerals;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.Address;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.InternalStreetAddress;
import com.mapinfo.mapmarker.cgge.convertor.CGGECandidateConvertor;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import com.mapinfo.mapmarker.user.IResponseCandidate;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;

public class JPNAbstractCandidateConvertor
extends CGGECandidateConvertor {
    private static final char[] checkChars = new char[]{'1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-'};
    private static final char[] replaceChars = new char[]{'\uff11', '\uff12', '\uff13', '\uff14', '\uff15', '\uff16', '\uff17', '\uff18', '\uff19', '\uff10', '\uff0d'};
    static final String CHOME_INDICATOR = "\u4e01\u76ee";
    public static final String KEY_CHOOAZA = "CHOOAZA";
    public static final String KEY_CHOMOKU = "CHOMOKU";
    public static final String KEY_BANCHI = "BANCHI";
    public static final String KEY_GO = "GO";

    @Override
    public CandidateAddress covertCandidate(InternalScoringAddress scoringAddress, IDataManager dataManager, GeocodeOptions options) throws Exception {
        InternalScoringRange range;
        FieldScore addNumScore;
        int rangeCount;
        CandidateAddress candAddr = null;
        this.adjustBeforeCreatingCandidateAddress(scoringAddress);
        boolean addrNumMatched = false;
        if (scoringAddress.getAddressType() == 1 && (rangeCount = scoringAddress.getRangeCount()) > 0 && (addNumScore = (range = scoringAddress.getRangeAt(0)).getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE)) != null && addNumScore.m_matched) {
            addrNumMatched = true;
        }
        if (JPNDataManagerSettingsProvider.transformAPI()) {
            boolean mmPref = options.getGeocodeConstraints().isMustMatchArea1();
            boolean mmCity = options.getGeocodeConstraints().isMustMatchArea3();
            boolean mmOoaza = options.getGeocodeConstraints().isMustMatchArea4();
            boolean mmChome = options.getGeocodeConstraints().isMustMatchArea4();
            boolean mmBlock = options.getGeocodeConstraints().isMustMatchArea2();
            boolean mmLot = options.getGeocodeConstraints().isMustMatchArea2();
            if (scoringAddress.getAddressType() == 1 || scoringAddress.getAddressType() == 3) {
                FieldScore fieldScore;
                if (mmPref && scoringAddress.isCloseMatch() && ((fieldScore = scoringAddress.getFieldScore(FieldType.AREA_NAME_1_FIELD_TYPE)) == null || !fieldScore.m_matched)) {
                    scoringAddress.setCloseMatch(false);
                }
                if (mmCity && scoringAddress.isCloseMatch() && ((fieldScore = scoringAddress.getFieldScore(FieldType.AREA_NAME_2_FIELD_TYPE)) == null || !fieldScore.m_matched)) {
                    scoringAddress.setCloseMatch(false);
                }
                if (mmOoaza && scoringAddress.isCloseMatch() && ((fieldScore = scoringAddress.getFieldScore(FieldType.AREA_NAME_3_FIELD_TYPE)) == null || !fieldScore.m_matched)) {
                    scoringAddress.setCloseMatch(false);
                }
                if (mmChome && scoringAddress.isCloseMatch() && ((fieldScore = scoringAddress.getFieldScore(FieldType.AREA_NAME_4_FIELD_TYPE)) == null || !fieldScore.m_matched)) {
                    scoringAddress.setCloseMatch(false);
                }
                if (mmBlock && scoringAddress.isCloseMatch() && ((fieldScore = scoringAddress.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE)) == null || !fieldScore.m_matched)) {
                    scoringAddress.setCloseMatch(false);
                }
                if (mmLot && scoringAddress.isCloseMatch() && !addrNumMatched) {
                    scoringAddress.setCloseMatch(false);
                }
            }
        }
        boolean blockOnly = false;
        if (scoringAddress.getAddressType() == 1) {
            int rangeCount2 = scoringAddress.getRangeCount();
            if (rangeCount2 > 0) {
                blockOnly = rangeCount2 == 1;
                InternalScoringRange range2 = scoringAddress.getRangeAt(0);
                InternalScoringRange blockRange = null;
                if (!addrNumMatched) {
                    for (int rangeNdx = 0; rangeNdx < rangeCount2; ++rangeNdx) {
                        range2 = scoringAddress.getRangeAt(rangeNdx);
                        if (range2.getFrom() != null) continue;
                        blockRange = range2;
                        break;
                    }
                    assert (blockRange != null);
                    if (blockRange != null) {
                        scoringAddress.setRanges(new InternalScoringRange[]{blockRange});
                    }
                }
            }
            candAddr = super.covertCandidate(scoringAddress, dataManager, options);
            if (!addrNumMatched) {
                if (blockOnly) {
                    candAddr.setLocationPrecision(17);
                } else {
                    candAddr.setLocationPrecision(1);
                }
                HashMap addFields = candAddr.getAdditionalFields();
                if (addFields != null) {
                    addFields.remove("RESULT_CODE");
                }
                this.setPrecisionCode(candAddr);
            }
        } else {
            candAddr = super.covertCandidate(scoringAddress, dataManager, options);
        }
        this.adjustOutputCandidateFields((IResponseCandidate)candAddr);
        if (addrNumMatched) {
            candAddr.setPlaceName(this.getPlaceInfo(scoringAddress, false));
        } else if (blockOnly) {
            candAddr.setPlaceName(this.getPlaceInfo(scoringAddress, true));
        } else {
            candAddr.setPlaceName(null);
        }
        return candAddr;
    }

    @Override
    public ReverseGeocodeCandidateAddress convertToReverseGeocodeCandidateAddress(InternalStreetAddress streetAddress, IDataManager dataManager, GeocodeOptions options, IReverseGeocodeConstraints constraints) {
        this.adjustBeforeCreatingCandidateAddress(streetAddress);
        ReverseGeocodeCandidateAddress result = super.convertToReverseGeocodeCandidateAddress(streetAddress, dataManager, options, constraints);
        this.adjustOutputCandidateFields((IResponseCandidate)result);
        if (StringUtilities.isEmpty((String)result.getAddressNumber())) {
            result.getAdditionalFields().put("RESULT_CODE", "RS5A");
            result.setLocationPrecision(1);
        }
        return result;
    }

    public void adjustBeforeCreatingCandidateAddress(Address address) {
        InternalFieldValue fv = (InternalFieldValue)address.getField(FieldType.AREA_NAME_4_FIELD_TYPE);
        if (fv != null) {
            AddressWord word;
            char lastCh;
            int n;
            AddressWord[] an4 = (AddressWord[])fv.getFieldValue();
            int n2 = n = an4 == null ? 0 : an4.length;
            if (n > 0 && (MMUtils.isDigit(lastCh = (word = an4[n - 1]).getWordChars()[word.getWordLength() - 1]) || JapaneseNumerals.isNumber(new char[]{lastCh}))) {
                word.setCodedWord(new CodedWord(word.getCodedWord()));
                word.setWord(word.getWord() + CHOME_INDICATOR);
            }
        }
    }

    public void adjustOutputCandidateFields(IResponseCandidate candAddr) {
        String postcode = candAddr.getPostCode1();
        if (postcode != null && postcode.length() < 7) {
            int missingZeros = 7 - postcode.length();
            StringBuilder sb = new StringBuilder(8);
            for (int i = 0; i < missingZeros; ++i) {
                sb.append('0');
            }
            sb.append(postcode);
            postcode = sb.toString();
            candAddr.setPostCode1(postcode);
            if (candAddr instanceof ReverseGeocodeCandidateAddress) {
                ((ReverseGeocodeCandidateAddress)candAddr).setFormattedLocationAddress(postcode);
            } else if (candAddr instanceof CandidateAddress) {
                ((CandidateAddress)candAddr).setFormattedLocationAddress(postcode);
            }
        }
        candAddr.setAreaName4(this.replaceToDoubleByteNumber(candAddr.getAreaName4()));
        candAddr.setAreaName2(this.replaceToDoubleByteNumber(candAddr.getAreaName2()));
        if (candAddr instanceof ReverseGeocodeCandidateAddress) {
            ((ReverseGeocodeCandidateAddress)candAddr).setFormattedLocationAddress(this.replaceToDoubleByteNumber(candAddr.getFormattedLocationAddress()));
            ((ReverseGeocodeCandidateAddress)candAddr).setFormattedStreetAddress(this.replaceToDoubleByteNumber(candAddr.getFormattedStreetAddress()));
        } else if (candAddr instanceof CandidateAddress) {
            ((CandidateAddress)candAddr).setFormattedLocationAddress(this.replaceToDoubleByteNumber(candAddr.getFormattedLocationAddress()));
            ((CandidateAddress)candAddr).setFormattedStreetAddress(this.replaceToDoubleByteNumber(candAddr.getFormattedStreetAddress()));
        }
        candAddr.setPostCode1(this.replaceToDoubleByteNumber(candAddr.getPostCode1()));
        if (JPNDataManagerSettingsProvider.transformAPI()) {
            String lot;
            String block;
            String ooaza;
            String chome;
            HashMap<String, String> addFields = candAddr.getAdditionalFields();
            if (addFields == null) {
                addFields = new HashMap<String, String>(4);
            }
            if ((chome = this.replaceToDoubleByteNumber(candAddr.getGenericField2())) != null) {
                addFields.put(KEY_CHOMOKU, chome);
                candAddr.setGenericField2(null);
            }
            if ((ooaza = this.replaceToDoubleByteNumber(candAddr.getGenericField1())) != null) {
                addFields.put(KEY_CHOOAZA, ooaza);
                candAddr.setGenericField1(null);
            }
            if ((block = this.replaceToDoubleByteNumber(candAddr.getMainAddress())) != null) {
                addFields.put(KEY_BANCHI, block);
            }
            if ((lot = this.replaceToDoubleByteNumber(candAddr.getAddressNumber())) != null) {
                addFields.put(KEY_GO, lot);
            }
            candAddr.setAdditionalFields(addFields);
        }
    }

    protected String getPlaceInfo(InternalScoringAddress scoringAddress, boolean includeAddressNumber) {
        InternalFieldValue placeInfo = (InternalFieldValue)scoringAddress.getField(FieldType.PLACE_NAME_FIELD_TYPE);
        if (placeInfo != null) {
            char[] chars;
            StringBuilder sb = new StringBuilder(20);
            AddressWord[] words = (AddressWord[])placeInfo.getFieldValue();
            if (includeAddressNumber) {
                char[] cArray = chars = words[0] != null ? words[0].getWordChars() : null;
                if (chars != null) {
                    sb.append(chars);
                }
            }
            char[] cArray = chars = words[1] != null ? words[1].getWordChars() : null;
            if (chars != null) {
                sb.append(chars);
            }
            if (sb.length() > 0) {
                return sb.toString();
            }
        }
        return null;
    }

    protected String replaceToDoubleByteNumber(String str) {
        if (str != null) {
            char[] chars = str.toCharArray();
            int count = chars.length;
            char[] newChars = new char[count];
            for (int i = 0; i < count; ++i) {
                char ch = chars[i];
                int replaceNdx = -1;
                for (int j = 0; j < checkChars.length; ++j) {
                    if (ch != checkChars[j]) continue;
                    replaceNdx = j;
                    break;
                }
                newChars[i] = replaceNdx > -1 ? replaceChars[replaceNdx] : ch;
            }
            return new String(newChars);
        }
        return null;
    }

    @Override
    public void setPrecisionCode(CandidateAddress cand) {
        StringBuffer tempGeoResult = new StringBuffer();
        if (cand.getLocationPrecision() == 3) {
            tempGeoResult.append("Z1");
        } else if (cand.getLocationPrecision() == 16) {
            tempGeoResult.append("S8HPNTSCZA");
        } else if (cand.getLocationPrecision() == 17) {
            tempGeoResult.append("S7-PNTSCZA");
        } else if (cand.getLocationPrecision() == 1) {
            tempGeoResult.append("S5-PNTSCZA");
        } else if (JPNDataManagerSettingsProvider.transformAPI()) {
            if (cand.getLocationPrecision() == 11) {
                tempGeoResult.append("S4-PNTSCZA");
            } else if (cand.getLocationPrecision() == 10) {
                tempGeoResult.append("S3-----CZA");
            } else if (cand.getLocationPrecision() == 9) {
                tempGeoResult.append("S2-----CZA");
            } else if (cand.getLocationPrecision() == 8) {
                tempGeoResult.append("S1-----CZA");
            }
        } else if (cand.getLocationPrecision() == 11) {
            tempGeoResult.append("G4");
        } else if (cand.getLocationPrecision() == 10) {
            tempGeoResult.append("G3");
        } else if (cand.getLocationPrecision() == 9) {
            tempGeoResult.append("G2");
        } else if (cand.getLocationPrecision() == 8) {
            tempGeoResult.append("G1");
        }
        cand.addKeyValueToAdditionalFields("RESULT_CODE", tempGeoResult.toString());
    }

    @Override
    public String getCountry() {
        return super.getCountry();
    }

    @Override
    public String getLanguage() {
        return super.getLanguage();
    }
}

