/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.JPN.dp.builder.reader;

import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.coordsys.factory.CoordSysFactory;
import com.mapinfo.midev.geometry.DirectPosition;
import com.mapinfo.midev.geometry.Envelope;
import com.mapinfo.midev.geometry.SpatialInfo;
import com.mapinfo.midev.util.DoubleRect;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IPCDataConvertor {
    static final Logger logger = LoggerFactory.getLogger(IPCDataConvertor.class);
    private Map<String, Pref> m_prefs;

    private void readPrefs(String inPath) throws Exception {
        String fullPath = IPCDataConvertor.appendToPath(inPath, "pref/pref.txt");
        logger.debug("Loading pref data from " + fullPath);
        InputStreamReader in = null;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(fullPath), "UTF-8");
            BufferedReader reader = new BufferedReader(in);
            String line = null;
            while ((line = reader.readLine()) != null) {
                String[] fields = line.split("\t");
                Pref pref = new Pref();
                this.fillPref(pref, fields);
                this.m_prefs.put(pref.m_prefCode, pref);
            }
            reader.close();
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    protected void fillPref(Pref pref, String[] fields) {
        pref.m_prefCode = this.formatFieldValue(fields[0].trim());
        pref.m_prefName = this.formatFieldValue(fields[1].trim());
        pref.m_prefKana = this.formatFieldValue(fields[2].trim());
        pref.m_long = Double.parseDouble(fields[8].trim());
        pref.m_lat = Double.parseDouble(fields[9].trim());
    }

    protected String formatFieldValue(String str) {
        return str.replaceAll("\u3000|\\s", "");
    }

    private void readCities(String inPath) throws Exception {
        String fullPath = IPCDataConvertor.appendToPath(inPath, "city/city.txt");
        logger.debug("Loading pref data from " + fullPath);
        InputStreamReader in = null;
        try {
            in = new InputStreamReader((InputStream)new FileInputStream(fullPath), "UTF-8");
            BufferedReader reader = new BufferedReader(in);
            String line = null;
            String lastPrefCode = "";
            Pref pref = null;
            while ((line = reader.readLine()) != null) {
                String[] fields = line.split("\t");
                String prefCode = fields[0].trim();
                if (!prefCode.equals(lastPrefCode)) {
                    pref = this.m_prefs.get(prefCode);
                    lastPrefCode = prefCode;
                }
                if (pref == null) {
                    throw new Exception("Pref with code " + prefCode + " not found for city record - " + line);
                }
                City city = new City();
                this.fillCity(city, fields, pref);
                if (pref.m_cities == null) {
                    pref.m_cities = new HashMap<String, City>(50);
                }
                pref.m_cities.put(city.m_cityCode, city);
            }
            reader.close();
        }
        catch (UnsupportedEncodingException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
    }

    protected void fillCity(City city, String[] fields, Pref pref) {
        city.m_pref = pref;
        city.m_cityCode = this.formatFieldValue(fields[1].trim());
        String cityPart1 = this.formatFieldValue(fields[2]).trim();
        String cityPart2 = this.formatFieldValue(fields[3]).trim();
        String kanaPart1 = this.formatFieldValue(fields[4]).trim();
        String kanaPart2 = this.formatFieldValue(fields[5]).trim();
        city.m_cityName = cityPart2.isEmpty() ? cityPart1 : cityPart1 + cityPart2;
        city.m_cityKana = kanaPart2.isEmpty() ? kanaPart1 : kanaPart1 + kanaPart2;
        city.m_long = Double.parseDouble(fields[16].trim());
        city.m_lat = Double.parseDouble(fields[17].trim());
    }

    private void readAddresses(String inPath) throws Exception {
        int fileCount;
        String fullPath = IPCDataConvertor.appendToPath(inPath, "addr");
        File addrFileDir = new File(fullPath);
        File[] addrFiles = addrFileDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File arg0, String arg1) {
                return arg1.startsWith("addr") && arg1.endsWith(".txt");
            }
        });
        int n = fileCount = addrFiles == null ? 0 : addrFiles.length;
        if (fileCount == 0) {
            throw new Exception("No address files found at " + fullPath);
        }
        for (int fileNum = 0; fileNum < fileCount; ++fileNum) {
            logger.debug("Loading addr data from " + addrFiles[fileNum].getName());
            InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(addrFiles[fileNum]), "UTF-8");
            BufferedReader reader = new BufferedReader(in);
            String line = null;
            String lastCityCode = "";
            City city = null;
            int lineCount = 1;
            while ((line = reader.readLine()) != null) {
                String ooazaCode;
                Ooaza ooaza;
                String[] fields = this.makeFields(line);
                String prefCode = fields[0].trim();
                Pref pref = null;
                pref = city == null || !city.m_pref.m_prefCode.equals(prefCode) ? this.m_prefs.get(prefCode) : city.m_pref;
                String cityCode = fields[1].trim();
                if (!lastCityCode.equals(cityCode)) {
                    city = pref.m_cities.get(cityCode);
                    lastCityCode = cityCode;
                }
                if (city == null) {
                    throw new Exception("City with code " + cityCode + " not found for addr record - " + line);
                }
                if (city.m_ooazas == null) {
                    city.m_ooazas = new HashMap<String, Ooaza>(10);
                }
                if ((ooaza = city.m_ooazas.get(ooazaCode = fields[2].trim())) == null) {
                    ooaza = new Ooaza();
                    ooaza.m_city = city;
                    ooaza.m_ooazaCode = ooazaCode;
                    String name = this.getOoazaName(fields);
                    if (name != null) {
                        ooaza.m_ooazaName = name.trim();
                        name = fields[6];
                        if (name != null) {
                            ooaza.m_ooazaKana = name.trim();
                        }
                    }
                    city.m_ooazas.put(ooaza.m_ooazaCode, ooaza);
                }
                Chome chome = new Chome();
                chome.m_ooaza = ooaza;
                chome.m_chomeCode = fields[3].trim();
                String name = this.getChomeName(fields);
                if (name != null) {
                    name = name.trim();
                    boolean useOoazaKana = false;
                    if (IPCDataConvertor.isNumber(name)) {
                        chome.m_chomeName = "" + Integer.parseInt(name);
                    } else {
                        int chomeCode = Integer.parseInt(chome.m_chomeCode);
                        if (chomeCode >= 900) {
                            if (name.equals(ooaza.m_ooazaName)) {
                                String street;
                                String string = street = this.getOoazaName(fields) == null ? null : this.getOoazaName(fields);
                                if (ooaza.m_streets == null) {
                                    ooaza.m_streets = new ArrayList<String>(10);
                                }
                                ooaza.m_streets.add(street);
                                useOoazaKana = true;
                            } else {
                                logger.debug("Probale special case encountered at line " + lineCount + " , but don't know how to handle it");
                                System.err.println("Probale special case encountered at line " + lineCount + " , but don't know how to handle it in file " + addrFiles[fileNum] + ", name is: " + name + " and does not equal to ooazaName: " + ooaza.m_ooazaName);
                            }
                        }
                        chome.m_chomeName = name;
                    }
                    name = fields[7];
                    if (name != null) {
                        if (IPCDataConvertor.isNumber(name = name.trim())) {
                            chome.m_chomeKana = "" + Integer.parseInt(name);
                        } else if (useOoazaKana) {
                            String streetKana;
                            String string = streetKana = fields[6] == null ? null : fields[6].trim();
                            if (ooaza.m_streetsKana == null) {
                                ooaza.m_streetsKana = new ArrayList<String>(10);
                            }
                            ooaza.m_streetsKana.add(streetKana);
                        } else {
                            chome.m_chomeKana = name;
                        }
                    }
                }
                chome.m_postcode = Integer.parseInt(this.getPostCodeField(fields));
                chome.m_long = Double.parseDouble(this.getLongitudeField(fields));
                chome.m_lat = Double.parseDouble(this.getLatitudeField(fields));
                if (ooaza.m_chomes == null) {
                    ooaza.m_chomes = new HashMap<String, Chome>(10);
                }
                ooaza.m_chomes.put(chome.m_chomeCode, chome);
                ++lineCount;
            }
            reader.close();
        }
    }

    String[] makeFields(String line) {
        String[] fields = line.split("\t", -1);
        for (int i = 0; i < fields.length; ++i) {
            if (fields[i].length() <= 0) continue;
            if (fields[i].charAt(0) == '\"') {
                fields[i] = fields[i].substring(1);
            }
            if (fields[i].charAt(fields[i].length() - 1) != '\"') continue;
            fields[i] = fields[i].substring(0, fields[i].length() - 1);
        }
        return fields;
    }

    String getOoazaName(String[] fields) {
        return fields[4].trim();
    }

    String getChomeName(String[] fields) {
        return fields[5].trim();
    }

    String getPostCodeField(String[] fields) {
        return fields[18].trim();
    }

    String getLongitudeField(String[] fields) {
        return fields[19].trim();
    }

    String getLatitudeField(String[] fields) {
        return fields[20].trim();
    }

    private void writeAddresses(String outPath) throws Exception {
        String fullPath = IPCDataConvertor.appendToPath(outPath, "geo.txt");
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(fullPath), "UTF-8");
        BufferedWriter writer = new BufferedWriter(out);
        writer.write("PREFCODE;PREFNAME;PREFKANA;CITYCODE;CITYNAME;CITYKANA;OOAZACODE;OOAZANAME;OOAZA_ALT;OOAZAKANA;OOAZAKANA_ALT;CHOMECODE;CHOMENAME;CHOMEKANA;POSTCODE;LONG;LAT\r\n");
        ArrayList<Pref> prefs = new ArrayList<Pref>(this.m_prefs.values());
        Collections.sort(prefs);
        Iterator prefIt = prefs.iterator();
        StringBuilder sb = new StringBuilder(200);
        while (prefIt.hasNext()) {
            Pref pref = (Pref)prefIt.next();
            this.fillPrefRecord(pref, sb);
            writer.write(sb.toString());
            ArrayList<City> cities = new ArrayList<City>(pref.m_cities.values());
            Collections.sort(cities);
            for (City city : cities) {
                assert (city.m_pref == pref);
                this.fillCityRecord(city, sb);
                writer.write(sb.toString());
                if (city.m_ooazas == null) {
                    logger.debug("No sub city levels found for pref code9=" + pref.m_prefCode + " and city code=" + city.m_cityCode);
                    continue;
                }
                ArrayList<Ooaza> ooazas = new ArrayList<Ooaza>(city.m_ooazas.values());
                Collections.sort(ooazas);
                for (Ooaza ooaza : ooazas) {
                    ArrayList<Chome> chomes = new ArrayList<Chome>(ooaza.m_chomes.values());
                    Collections.sort(chomes);
                    for (Chome chome : chomes) {
                        assert (ooaza == chome.m_ooaza);
                        this.fillAddressRecord(chome, sb);
                        writer.write(sb.toString());
                    }
                }
            }
        }
        writer.close();
        this.createPostInfoData(outPath);
    }

    private void createPostInfoData(String outputPath) throws Exception {
        String record;
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(IPCDataConvertor.appendToPath(outputPath, "geo.txt")), "UTF-8");
        BufferedReader reader = new BufferedReader(in);
        OutputStreamWriter postOut = new OutputStreamWriter((OutputStream)new FileOutputStream(IPCDataConvertor.appendToPath(outputPath, "post.txt")), "UTF-8");
        BufferedWriter postWriter = new BufferedWriter(postOut);
        HashMap postalRecords = new HashMap();
        boolean bFirstRecord = true;
        while ((record = reader.readLine()) != null) {
            if (bFirstRecord) {
                bFirstRecord = false;
                postWriter.write(record);
                postWriter.write("\r\n");
                continue;
            }
            String postalCode = this.parsePostalcode(record);
            if (StringUtilities.isEmpty((String)postalCode)) continue;
            List prev = (List)postalRecords.get(postalCode);
            if (prev != null) {
                prev.add(record);
                continue;
            }
            ArrayList<String> temp = new ArrayList<String>();
            temp.add(record);
            postalRecords.put(postalCode, temp);
        }
        Set postalSet = postalRecords.entrySet();
        for (Map.Entry e : postalSet) {
            String outputRecord = this.consolidatePostalRecords((List)e.getValue());
            postWriter.write(outputRecord);
            postWriter.write("\r\n");
        }
        postWriter.close();
        reader.close();
    }

    private String consolidatePostalRecords(List<String> records) {
        if (records.size() == 1) {
            return records.get(0);
        }
        String baseRecord = records.get(0);
        SpatialInfo SPATIAL_INFO = new SpatialInfo(CoordSysFactory.getDefaultCoordSysFactory().getCoordSys("epsg:4301"));
        Envelope bounds = null;
        for (String record : records) {
            DirectPosition pos = this.parseCoords(record);
            if (bounds == null) {
                bounds = new Envelope(new DoubleRect(pos, pos), SPATIAL_INFO);
                continue;
            }
            if (bounds.contains(pos)) continue;
            bounds.extend(pos);
        }
        DirectPosition finalPos = bounds.getCenter();
        return this.updateCoords(baseRecord, finalPos);
    }

    private String updateCoords(String record, DirectPosition coord) {
        int pos = record.lastIndexOf(59);
        pos = record.lastIndexOf(59, pos - 1);
        String updatedRecord = record.substring(0, pos);
        updatedRecord = updatedRecord + ';' + coord.getY() + ';' + coord.getX();
        return updatedRecord;
    }

    private DirectPosition parseCoords(String record) {
        String[] fields = record.split(";");
        return new DirectPosition(Double.parseDouble(fields[16]), Double.parseDouble(fields[15]));
    }

    private String parsePostalcode(String record) {
        String[] fields = record.split(";");
        return fields[14];
    }

    private List<Banchi> readBanchies(File pntFile, City city) throws Exception {
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(pntFile), "UTF-8");
        BufferedReader pntReader = new BufferedReader(in);
        String line = null;
        Chome chome = null;
        ArrayList<Banchi> banchies = new ArrayList<Banchi>(1000);
        while ((line = pntReader.readLine()) != null) {
            Ooaza ooaza;
            String[] fields = line.split("\t");
            String prefCode = fields[0].trim();
            String cityCode = fields[1].trim();
            String ooazaCode = fields[2].trim();
            String chomeCode = fields[3].trim();
            boolean searchChome = true;
            if (chome != null && chome.m_chomeCode.equals(chomeCode)) {
                ooaza = chome.m_ooaza;
                if (ooaza.m_ooazaCode.equals(ooazaCode)) {
                    City city1 = ooaza.m_city;
                    if (city1.m_cityCode.equals(cityCode)) {
                        Pref pref = city1.m_pref;
                        if (pref.m_prefCode.equals(prefCode)) {
                            searchChome = false;
                        }
                    }
                }
            }
            if (searchChome) {
                if (!cityCode.equals(city.m_cityCode) && !prefCode.equals(city.m_pref.m_prefCode)) {
                    throw new Exception("Expected pnt file " + pntFile.getName() + " to contain addresses from city code=" + city.m_cityCode + " and pref code=" + city.m_pref.m_prefCode + ". Line = " + line);
                }
                Ooaza ooaza2 = ooaza = city.m_ooazas == null ? null : city.m_ooazas.get(ooazaCode);
                if (ooaza == null) {
                    throw new Exception("Cannot find ooaza with code=" + ooazaCode + " for record " + line);
                }
                Chome chome2 = chome = ooaza.m_chomes == null ? null : ooaza.m_chomes.get(chomeCode);
                if (chome == null) {
                    throw new Exception("Cannot find chome with code=" + chomeCode + " for record " + line);
                }
            }
            Banchi banchi = new Banchi();
            banchi.m_chome = chome;
            banchi.m_banchiCode = Integer.parseInt(fields[4].trim());
            String name = fields[5].trim();
            if (IPCDataConvertor.isNumber(name)) {
                banchi.m_banchiName = "" + Integer.parseInt(name);
            }
            if (name.equals(fields[6].trim())) {
                banchi.m_banchiKana = banchi.m_banchiName;
            } else {
                name = fields[6].trim();
                if (IPCDataConvertor.isNumber(name)) {
                    banchi.m_banchiKana = "" + Integer.parseInt(name);
                }
            }
            banchi.m_long = Double.parseDouble(fields[12].trim());
            banchi.m_lat = Double.parseDouble(fields[13].trim());
            banchies.add(banchi);
        }
        return banchies.size() > 0 ? banchies : null;
    }

    private Map<Banchi, List<Gou>> readGous(File gouFile, List<Banchi> banchies, City city) throws Exception {
        InputStreamReader in = new InputStreamReader((InputStream)new FileInputStream(gouFile), "UTF-8");
        BufferedReader gouReader = new BufferedReader(in);
        String line = null;
        Banchi banchi = null;
        HashMap<Banchi, List<Gou>> banchiGous = new HashMap<Banchi, List<Gou>>(banchies.size());
        ArrayList<Gou> gous = new ArrayList<Gou>(100);
        while ((line = gouReader.readLine()) != null) {
            String[] fields = line.split("\t");
            String prefCode = fields[0].trim();
            String cityCode = fields[1].trim();
            String ooazaCode = fields[2].trim();
            String chomeCode = fields[3].trim();
            int banchiCode = Integer.parseInt(fields[4].trim());
            int gouCode = Integer.parseInt(fields[5].trim());
            boolean search = true;
            if (banchi != null && banchi.m_banchiCode == banchiCode) {
                Chome chome = banchi.m_chome;
                if (chome.m_chomeCode.equals(chomeCode)) {
                    Ooaza ooaza = chome.m_ooaza;
                    if (ooaza.m_ooazaCode.equals(ooazaCode)) {
                        City city1 = ooaza.m_city;
                        if (city1.m_cityCode.equals(cityCode)) {
                            Pref pref = city1.m_pref;
                            if (pref.m_prefCode.equals(prefCode)) {
                                search = false;
                            }
                        }
                    }
                }
            }
            if (search) {
                Chome chome;
                Ooaza ooaza;
                if (banchi != null) {
                    banchiGous.put(banchi, gous);
                    gous = new ArrayList(100);
                    banchi = null;
                }
                if (!cityCode.equals(city.m_cityCode) && !prefCode.equals(city.m_pref.m_prefCode)) {
                    throw new Exception("Expected gou file " + gouFile.getName() + " to contain addresses from city code=" + city.m_cityCode + " and pref code=" + city.m_pref.m_prefCode + ". Line = " + line);
                }
                Ooaza ooaza2 = ooaza = city.m_ooazas == null ? null : city.m_ooazas.get(ooazaCode);
                if (ooaza == null) {
                    throw new Exception("Cannot find ooaza with code=" + ooazaCode + " for record " + line);
                }
                Chome chome2 = chome = ooaza.m_chomes == null ? null : ooaza.m_chomes.get(chomeCode);
                if (chome == null) {
                    throw new Exception("Cannot find chome with code=" + chomeCode + " for record " + line);
                }
                Banchi searchKey = new Banchi();
                searchKey.m_chome = chome;
                searchKey.m_banchiCode = banchiCode;
                int ndx = Collections.binarySearch(banchies, searchKey);
                if (ndx > -1) {
                    banchi = banchies.get(ndx);
                } else {
                    throw new Exception("Cannot find banchi with code=" + banchiCode + "for record " + line);
                }
            }
            Gou gou = new Gou();
            gou.m_gouCode = gouCode;
            gou.m_banchi = banchi;
            String name = fields[6].trim();
            if (IPCDataConvertor.isNumber(name)) {
                gou.m_gouName = "" + Integer.parseInt(name);
            }
            if (name.equals(fields[7].trim())) {
                gou.m_gouKana = gou.m_gouName;
            } else {
                name = fields[7].trim();
                if (IPCDataConvertor.isNumber(name)) {
                    gou.m_gouKana = "" + Integer.parseInt(name);
                }
            }
            gou.m_long = Double.parseDouble(fields[13].trim());
            gou.m_lat = Double.parseDouble(fields[14].trim());
            gous.add(gou);
        }
        if (banchi != null) {
            banchiGous.put(banchi, gous);
            gous = new ArrayList(100);
        }
        return banchiGous.size() > 0 ? banchiGous : null;
    }

    private void processFullAddresses(String inPath, String outPath) throws Exception {
        int pntFileCount;
        String pathToPnts = IPCDataConvertor.appendToPath(inPath, "pnt");
        String pathToGou = IPCDataConvertor.appendToPath(inPath, "gou");
        File pntDir = new File(pathToPnts);
        File[] pntFiles = pntDir.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith("pnt") && name.endsWith(".txt");
            }
        });
        int n = pntFileCount = pntFiles == null ? 0 : pntFiles.length;
        if (pntFileCount == 0) {
            throw new Exception("No point files found at " + pathToPnts);
        }
        String fullOutPath = IPCDataConvertor.appendToPath(outPath, "JPN.txt");
        OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(fullOutPath), "UTF-8");
        BufferedWriter writer = new BufferedWriter(out);
        StringBuilder sb = new StringBuilder(200);
        sb.append("PREFCODE;PREFNAME;PREFKANA;CITYCODE;CITYNAME;CITYKANA;OOAZACODE;OOAZANAME;OOAZANAME_ALT;OOAZAKANA;OOAZAKANA_ALT;CHOMECODE;CHOMENAME;CHOMEKANA;POSTCODE");
        sb.append(";BANCHICODE;BANCHINAME;BANCHIKANA");
        sb.append(";GOUCODE;GOUNAME;GOUKANA");
        sb.append(";LONG;LAT\r\n");
        writer.write(sb.toString());
        int recordsWritten = 0;
        int totalPointRecords = 0;
        int totalGouRecords = 0;
        for (int pntFileNdx = 0; pntFileNdx < pntFileCount; ++pntFileNdx) {
            File pntFile = pntFiles[pntFileNdx];
            String fileName = pntFile.getName();
            assert (fileName.length() > 7);
            String prefCity = fileName.substring(3);
            prefCity = prefCity.substring(0, prefCity.length() - 4);
            String prefCode = prefCity.substring(0, 2);
            String cityCode = prefCity.substring(2);
            Pref pref = this.m_prefs.get(prefCode);
            if (pref == null) {
                throw new Exception("Cannot find pref with code " + prefCode + " parsed from file name " + fileName);
            }
            City city = pref.m_cities.get(cityCode);
            if (city == null) {
                throw new Exception("Cannot find city with code " + cityCode + " parsed from file name " + fileName);
            }
            logger.debug("Reading pnt records from " + pntFile.getPath());
            List<Banchi> banchies = this.readBanchies(pntFile, city);
            Collections.sort(banchies);
            totalPointRecords += banchies.size();
            sb.delete(0, sb.length());
            sb.append("gou");
            sb.append(prefCity);
            sb.append(".txt");
            String gouFilePath = IPCDataConvertor.appendToPath(pathToGou, sb.toString());
            File gouFile = new File(gouFilePath);
            Map<Banchi, List<Gou>> banchiGous = null;
            if (!gouFile.exists()) {
                logger.debug("File " + gouFilePath + " does not exist");
                gouFile = null;
            } else {
                logger.debug("Reading gou records from " + gouFile.getPath());
                banchiGous = this.readGous(gouFile, banchies, city);
            }
            for (Banchi banchi : banchies) {
                List<Gou> gous;
                sb.delete(0, sb.length());
                this.fillBanchiRecord(banchi, sb);
                writer.write(sb.toString());
                ++recordsWritten;
                if (banchiGous == null || (gous = banchiGous.get(banchi)) == null) continue;
                totalGouRecords += gous.size();
                Collections.sort(gous);
                Iterator<Gou> gouIt = gous.iterator();
                while (gouIt.hasNext()) {
                    sb.delete(0, sb.length());
                    this.fillBanchiGouRecord(gouIt.next(), sb);
                    writer.write(sb.toString());
                    if (++recordsWritten % 100000 != 0) continue;
                    logger.debug("Wrote " + recordsWritten + " records");
                }
            }
            writer.flush();
        }
        logger.debug("Wrote " + recordsWritten + " records");
        logger.debug("Total pnt records=" + totalPointRecords);
        logger.debug("Total gou records=" + totalGouRecords);
    }

    private void fillBanchiRecord(Banchi banchi, StringBuilder sb) {
        String str;
        int i;
        int n;
        Chome chome = banchi.m_chome;
        Ooaza ooaza = chome.m_ooaza;
        City city = ooaza.m_city;
        Pref pref = city.m_pref;
        sb.delete(0, sb.length());
        sb.append(pref.m_prefCode);
        sb.append(";");
        sb.append(pref.m_prefName);
        sb.append(";");
        sb.append(pref.m_prefKana);
        sb.append(";");
        sb.append(city.m_cityCode);
        sb.append(";");
        sb.append(city.m_cityName);
        sb.append(";");
        sb.append(city.m_cityKana);
        sb.append(";");
        sb.append(ooaza.m_ooazaCode);
        sb.append(";");
        sb.append(ooaza.m_ooazaName);
        sb.append(";");
        if (ooaza.m_streets != null) {
            n = ooaza.m_streets.size();
            for (i = 0; i < n; ++i) {
                str = ooaza.m_streets.get(i);
                sb.append(str);
                if (i >= n - 1) continue;
                sb.append("|");
            }
        }
        sb.append(";");
        sb.append(ooaza.m_ooazaKana);
        sb.append(";");
        if (ooaza.m_streetsKana != null) {
            n = ooaza.m_streetsKana.size();
            for (i = 0; i < n; ++i) {
                str = ooaza.m_streetsKana.get(i);
                sb.append(str);
                if (i >= n - 1) continue;
                sb.append("|");
            }
        }
        sb.append(";");
        sb.append(chome.m_chomeCode);
        sb.append(";");
        sb.append(chome.m_chomeName);
        sb.append(";");
        sb.append(chome.m_chomeKana);
        sb.append(";");
        sb.append(chome.m_postcode);
        sb.append(";");
        sb.append(banchi.m_banchiCode);
        sb.append(";");
        sb.append(banchi.m_banchiName);
        sb.append(";");
        sb.append(banchi.m_banchiKana);
        sb.append(";;;;");
        sb.append(banchi.m_long);
        sb.append(";");
        sb.append(banchi.m_lat);
        sb.append("\r\n");
    }

    private void fillBanchiGouRecord(Gou gou, StringBuilder sb) {
        String str;
        int i;
        int n;
        Banchi banchi = gou.m_banchi;
        Chome chome = banchi.m_chome;
        Ooaza ooaza = chome.m_ooaza;
        City city = ooaza.m_city;
        Pref pref = city.m_pref;
        sb.delete(0, sb.length());
        sb.append(pref.m_prefCode);
        sb.append(";");
        sb.append(pref.m_prefName);
        sb.append(";");
        sb.append(pref.m_prefKana);
        sb.append(";");
        sb.append(city.m_cityCode);
        sb.append(";");
        sb.append(city.m_cityName);
        sb.append(";");
        sb.append(city.m_cityKana);
        sb.append(";");
        sb.append(ooaza.m_ooazaCode);
        sb.append(";");
        sb.append(ooaza.m_ooazaName);
        sb.append(";");
        if (ooaza.m_streets != null) {
            n = ooaza.m_streets.size();
            for (i = 0; i < n; ++i) {
                str = ooaza.m_streets.get(i);
                sb.append(str);
                if (i >= n - 1) continue;
                sb.append("|");
            }
        }
        sb.append(";");
        sb.append(ooaza.m_ooazaKana);
        sb.append(";");
        if (ooaza.m_streetsKana != null) {
            n = ooaza.m_streetsKana.size();
            for (i = 0; i < n; ++i) {
                str = ooaza.m_streetsKana.get(i);
                sb.append(str);
                if (i >= n - 1) continue;
                sb.append("|");
            }
        }
        sb.append(";");
        sb.append(chome.m_chomeCode);
        sb.append(";");
        sb.append(chome.m_chomeName);
        sb.append(";");
        sb.append(chome.m_chomeKana);
        sb.append(";");
        sb.append(chome.m_postcode);
        sb.append(";");
        sb.append(banchi.m_banchiCode);
        sb.append(";");
        sb.append(banchi.m_banchiName);
        sb.append(";");
        sb.append(banchi.m_banchiKana);
        sb.append(";");
        sb.append(gou.m_gouCode);
        sb.append(";");
        sb.append(gou.m_gouName);
        sb.append(";");
        sb.append(gou.m_gouKana);
        sb.append(";");
        sb.append(gou.m_long);
        sb.append(";");
        sb.append(gou.m_lat);
        sb.append("\r\n");
    }

    private void fillPrefRecord(Pref pref, StringBuilder sb) {
        sb.delete(0, sb.length());
        sb.append(pref.m_prefCode);
        sb.append(";");
        sb.append(pref.m_prefName);
        sb.append(";");
        sb.append(pref.m_prefKana);
        sb.append(";;;;;;;;;;;;;");
        sb.append(pref.m_long);
        sb.append(";");
        sb.append(pref.m_lat);
        sb.append("\r\n");
    }

    private void fillCityRecord(City city, StringBuilder sb) {
        sb.delete(0, sb.length());
        sb.append(city.m_pref.m_prefCode);
        sb.append(";");
        sb.append(city.m_pref.m_prefName);
        sb.append(";");
        sb.append(city.m_pref.m_prefKana);
        sb.append(";");
        sb.append(city.m_cityCode);
        sb.append(";");
        sb.append(city.m_cityName);
        sb.append(";");
        sb.append(city.m_cityKana);
        sb.append(";;;;;;;;;;");
        sb.append(city.m_long);
        sb.append(";");
        sb.append(city.m_lat);
        sb.append("\r\n");
    }

    private void fillAddressRecord(Chome chome, StringBuilder sb) {
        String str;
        int i;
        int n;
        Ooaza ooaza = chome.m_ooaza;
        City city = ooaza.m_city;
        Pref pref = city.m_pref;
        sb.delete(0, sb.length());
        sb.append(pref.m_prefCode);
        sb.append(";");
        sb.append(pref.m_prefName);
        sb.append(";");
        sb.append(pref.m_prefKana);
        sb.append(";");
        sb.append(city.m_cityCode);
        sb.append(";");
        sb.append(city.m_cityName);
        sb.append(";");
        sb.append(city.m_cityKana);
        sb.append(";");
        sb.append(ooaza.m_ooazaCode);
        sb.append(";");
        sb.append(ooaza.m_ooazaName);
        sb.append(";");
        if (ooaza.m_streets != null) {
            n = ooaza.m_streets.size();
            for (i = 0; i < n; ++i) {
                str = ooaza.m_streets.get(i);
                sb.append(str);
                if (i >= n - 1) continue;
                sb.append("|");
            }
        }
        sb.append(";");
        sb.append(ooaza.m_ooazaKana);
        sb.append(";");
        if (ooaza.m_streetsKana != null) {
            n = ooaza.m_streetsKana.size();
            for (i = 0; i < n; ++i) {
                str = ooaza.m_streetsKana.get(i);
                sb.append(str);
                if (i >= n - 1) continue;
                sb.append("|");
            }
        }
        sb.append(";");
        sb.append(chome.m_chomeCode);
        sb.append(";");
        sb.append(chome.m_chomeName);
        sb.append(";");
        sb.append(chome.m_chomeKana);
        sb.append(";");
        sb.append(chome.m_postcode);
        sb.append(";");
        sb.append(chome.m_long);
        sb.append(";");
        sb.append(chome.m_lat);
        sb.append("\r\n");
    }

    public void convertIPCData(String inPath, String outPath) throws Exception {
        this.m_prefs = new HashMap<String, Pref>(47);
        try {
            this.readPrefs(inPath);
            this.readCities(inPath);
            this.readAddresses(inPath);
            this.writeAddresses(outPath);
            this.processFullAddresses(inPath, outPath);
        }
        catch (Exception e) {
            logger.debug("Conversion failed!");
            e.printStackTrace();
            throw e;
        }
    }

    public static final String appendToPath(String path, String name) {
        String fileSep = System.getProperty("file.separator");
        if (name == null) {
            return path;
        }
        if (path != null) {
            StringBuilder builder = new StringBuilder();
            builder.append(path);
            if (!path.endsWith("\\") && !path.endsWith("/")) {
                builder.append(fileSep);
            }
            builder.append(name);
            return builder.toString();
        }
        StringBuilder builder = new StringBuilder();
        builder.append(".");
        builder.append(fileSep);
        builder.append(name);
        return builder.toString();
    }

    public static final boolean isNumber(String str) {
        int n;
        int n2 = n = str == null ? 0 : str.length();
        if (n > 0) {
            char[] chars = str.toCharArray();
            for (int i = 0; i < n; ++i) {
                char ch = chars[i];
                if (Character.isDigit((int)ch) || i == 0 && n > 1 && ch == '-') continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static void main(String[] args) throws Exception {
        IPCDataConvertor convertor = new IPCDataConvertor();
        convertor.convertIPCData(args[0], args[1]);
    }

    private class Gou
    implements Comparable<Gou> {
        int m_gouCode;
        String m_gouName;
        String m_gouKana;
        Banchi m_banchi;
        double m_lat;
        double m_long;

        private Gou() {
        }

        @Override
        public int compareTo(Gou o) {
            int comp = this.m_banchi.compareTo(o.m_banchi);
            if (comp == 0) {
                comp = this.m_gouCode - o.m_gouCode;
            }
            return comp;
        }
    }

    private class Banchi
    implements Comparable<Banchi> {
        int m_banchiCode;
        String m_banchiName;
        String m_banchiKana;
        Chome m_chome;
        double m_lat;
        double m_long;

        private Banchi() {
        }

        @Override
        public int compareTo(Banchi other) {
            Ooaza ooaza2;
            Ooaza ooaza1;
            City city2;
            City city1;
            Pref pref1 = this.m_chome.m_ooaza.m_city.m_pref;
            Pref pref2 = other.m_chome.m_ooaza.m_city.m_pref;
            int comp = pref1.compareTo(pref2);
            if (comp == 0 && (comp = (city1 = this.m_chome.m_ooaza.m_city).compareTo(city2 = other.m_chome.m_ooaza.m_city)) == 0 && (comp = (ooaza1 = this.m_chome.m_ooaza).compareTo(ooaza2 = other.m_chome.m_ooaza)) == 0 && (comp = this.m_chome.compareTo(other.m_chome)) == 0) {
                comp = this.m_banchiCode - other.m_banchiCode;
            }
            return comp;
        }

        public int hashCode() {
            int prime = 31;
            int hash = 1;
            hash = 31 * hash + this.m_chome.m_ooaza.m_city.m_pref.hashCode();
            hash = 31 * hash + this.m_chome.m_ooaza.m_city.hashCode();
            hash = 31 * hash + this.m_chome.m_ooaza.hashCode();
            hash = 31 * hash + this.m_chome.hashCode();
            hash = 31 * hash + this.m_banchiCode;
            return hash;
        }

        public boolean equals(Object obj) {
            return this.compareTo((Banchi)obj) == 0;
        }
    }

    private class Chome
    implements Comparable<Chome> {
        String m_chomeCode;
        Ooaza m_ooaza;
        String m_chomeName;
        String m_chomeKana;
        int m_postcode;
        double m_lat;
        double m_long;

        private Chome() {
        }

        public int hashCode() {
            return new Integer(this.m_chomeCode).hashCode();
        }

        public boolean equals(Object obj) {
            return this.m_chomeCode.equals(((Chome)obj).m_chomeCode);
        }

        @Override
        public int compareTo(Chome o) {
            return this.m_chomeCode.compareTo(o.m_chomeCode);
        }
    }

    static class Ooaza
    implements Comparable<Ooaza> {
        String m_ooazaCode;
        City m_city;
        String m_ooazaName;
        String m_ooazaKana;
        List<String> m_streets;
        List<String> m_streetsKana;
        Map<String, Chome> m_chomes;

        Ooaza() {
        }

        public int hashCode() {
            return this.m_ooazaCode.hashCode();
        }

        public boolean equals(Object obj) {
            return this.m_ooazaCode == ((Ooaza)obj).m_ooazaCode;
        }

        @Override
        public int compareTo(Ooaza o) {
            return this.m_ooazaCode.compareTo(o.m_ooazaCode);
        }
    }

    static class City
    implements Comparable<City> {
        String m_cityCode;
        Pref m_pref;
        String m_cityName;
        String m_cityKana;
        double m_lat;
        double m_long;
        Map<String, Ooaza> m_ooazas;

        City() {
        }

        public int hashCode() {
            return new Integer(this.m_cityCode).hashCode();
        }

        public boolean equals(Object obj) {
            return this.m_cityCode.equals(((City)obj).m_cityCode);
        }

        @Override
        public int compareTo(City o) {
            return this.m_cityCode.compareTo(o.m_cityCode);
        }
    }

    static class Pref
    implements Comparable<Pref> {
        String m_prefCode;
        String m_prefName;
        String m_prefKana;
        double m_lat;
        double m_long;
        Map<String, City> m_cities;

        Pref() {
        }

        public int hashCode() {
            return new Integer(this.m_prefCode).hashCode();
        }

        public boolean equals(Object obj) {
            return this.m_prefCode.equals(((Pref)obj).m_prefCode);
        }

        @Override
        public int compareTo(Pref o) {
            return this.m_prefCode.compareTo(o.m_prefCode);
        }
    }
}

