/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.JPN.dp.builder.reader;

import com.mapinfo.mapmarker.JPN.dp.builder.reader.IPCDataConvertor;

public class LatinIPCDataConvertor
extends IPCDataConvertor {
    public static void main(String[] args) throws Exception {
        LatinIPCDataConvertor convertor = new LatinIPCDataConvertor();
        convertor.convertIPCData(args[0], args[1]);
    }

    @Override
    protected void fillPref(IPCDataConvertor.Pref pref, String[] fields) {
        pref.m_prefCode = this.formatFieldValue(fields[0].trim());
        if (pref.m_prefCode.length() == 1) {
            pref.m_prefCode = '0' + pref.m_prefCode;
        }
        pref.m_prefName = this.formatFieldValue(fields[3].trim());
        pref.m_prefKana = this.formatFieldValue(fields[2].trim());
        pref.m_long = Double.parseDouble(fields[8].trim());
        pref.m_lat = Double.parseDouble(fields[9].trim());
    }

    @Override
    protected void fillCity(IPCDataConvertor.City city, String[] fields, IPCDataConvertor.Pref pref) {
        city.m_pref = pref;
        city.m_cityCode = this.formatFieldValue(fields[1].trim());
        String cityPart1 = this.formatFieldValue(fields[6]).trim();
        String cityPart2 = this.formatFieldValue(fields[7]).trim();
        String kanaPart1 = this.formatFieldValue(fields[4]).trim();
        String kanaPart2 = this.formatFieldValue(fields[5]).trim();
        city.m_cityName = cityPart2.isEmpty() ? cityPart1 : cityPart1 + " " + cityPart2;
        city.m_cityKana = kanaPart2.isEmpty() ? kanaPart1 : kanaPart1 + " " + kanaPart2;
        city.m_long = Double.parseDouble(fields[16].trim());
        city.m_lat = Double.parseDouble(fields[17].trim());
    }

    @Override
    protected String formatFieldValue(String str) {
        return str;
    }

    @Override
    String getOoazaName(String[] fields) {
        return fields[8].trim();
    }

    @Override
    String getChomeName(String[] fields) {
        return fields[9].trim();
    }

    @Override
    String getPostCodeField(String[] fields) {
        return fields[18].trim();
    }

    @Override
    String getLongitudeField(String[] fields) {
        return fields[19].trim();
    }

    @Override
    String getLatitudeField(String[] fields) {
        return fields[20].trim();
    }
}

