/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.JPN.helper;

import com.mapinfo.mapmarker.JPN.helper.JPNAbstractHelper;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.DataFetchException;
import com.mapinfo.mapmarker.cgge.dp.DataNotInitialisedException;
import com.mapinfo.mapmarker.cgge.dp.IDataManager;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParser;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import java.util.ArrayList;
import java.util.List;

public class JPNStreetGeocodingHelper
extends JPNAbstractHelper {
    private int m_tryCount;
    protected ParsedAddress m_savedFormattedParsedAddress;
    private List<Integer> m_subTryList = new ArrayList<Integer>(10);
    private int m_previousSearchResultStackSize = 0;

    @Override
    public boolean init(String country, String language) {
        super.init(country, language);
        this.setGeocodeType(1);
        this.m_tryCount = 0;
        this.setAddressSearchField(FieldType.STREET_NAME_FIELD_TYPE);
        return true;
    }

    @Override
    protected boolean generateCases(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        boolean supportOldAPI = false;
        if (supportOldAPI) {
            options.getGeocodeConstraints().setFallbackToGeographic(true);
        }
        options.getGeocodeConstraints().setMustMatchAddressNumber(false);
        if (parsedAddr.isCustomFlagSet(0x1000000)) {
            return this.generateCasesForSingleLine(dataManager, parsedAddr, options, candidateList);
        }
        switch (this.m_tryCount) {
            case 0: {
                JPNAbstractHelper.DictSearchResult sr;
                ++this.m_tryCount;
                ParsedAddress savedParsedAddress = this.getSavedParsedAddress();
                if (savedParsedAddress == null) {
                    savedParsedAddress = new ParsedAddress(parsedAddr.getCountry(), parsedAddr.getLanguage());
                    savedParsedAddress.copy(parsedAddr);
                    this.setSavedParsedAddress(savedParsedAddress);
                }
                AddressWord[] an1 = null;
                AddressWord[] an2 = null;
                AddressWord[] an3 = null;
                AddressWord[] an4 = null;
                AddressWord[] pc = null;
                AddressWord[] main = null;
                AddressWord[] blockAndLot = null;
                AddressWord[] lot = null;
                if (supportOldAPI) {
                    pc = (AddressWord[])savedParsedAddress.getField(FieldType.POST_CODE_FIELD_TYPE);
                    an1 = (AddressWord[])savedParsedAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE);
                    an2 = (AddressWord[])savedParsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
                    an4 = (AddressWord[])savedParsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE);
                    blockAndLot = (AddressWord[])savedParsedAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE);
                    main = (AddressWord[])savedParsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                } else {
                    an1 = (AddressWord[])savedParsedAddress.getField(FieldType.AREA_NAME_1_FIELD_TYPE);
                    an2 = (AddressWord[])savedParsedAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE);
                    an3 = (AddressWord[])savedParsedAddress.getField(FieldType.AREA_NAME_3_FIELD_TYPE);
                    an4 = (AddressWord[])savedParsedAddress.getField(FieldType.AREA_NAME_4_FIELD_TYPE);
                    blockAndLot = (AddressWord[])savedParsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                    lot = (AddressWord[])savedParsedAddress.getField(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
                }
                ICGGESoundex soundex = this.getSoundex();
                ICGGEParser parser = this.getParser();
                parsedAddr.setField(FieldType.AREA_NAME_1_FIELD_TYPE, null);
                parsedAddr.setField(FieldType.AREA_NAME_2_FIELD_TYPE, null);
                parsedAddr.setField(FieldType.AREA_NAME_3_FIELD_TYPE, null);
                parsedAddr.setField(FieldType.AREA_NAME_4_FIELD_TYPE, null);
                parsedAddr.setField(FieldType.STREET_NAME_FIELD_TYPE, null);
                if (pc != null && pc.length == 1) {
                    sr = this.searchFieldInData(pc[0].getWordChars(), FieldType.POST_CODE_FIELD_TYPE, soundex, parser, dataManager, options, false);
                    this.addSearchFieldResult(FieldType.POST_CODE_FIELD_TYPE, sr);
                }
                if (an1 != null && an1.length == 1) {
                    sr = this.searchFieldInData(an1[0].getWordChars(), FieldType.AREA_NAME_1_FIELD_TYPE, soundex, parser, dataManager, options, false);
                    this.addSearchFieldResult(FieldType.AREA_NAME_1_FIELD_TYPE, sr);
                }
                if (an2 != null && an2.length == 1) {
                    sr = this.searchFieldInData(an2[0].getWordChars(), FieldType.AREA_NAME_2_FIELD_TYPE, soundex, parser, dataManager, options, false);
                    this.addSearchFieldResult(FieldType.AREA_NAME_3_FIELD_TYPE, sr);
                }
                if (an3 != null && an3.length == 1) {
                    sr = this.searchFieldInData(an3[0].getWordChars(), FieldType.AREA_NAME_3_FIELD_TYPE, soundex, parser, dataManager, options, false);
                    this.addSearchFieldResult(FieldType.AREA_NAME_3_FIELD_TYPE, sr);
                }
                if (supportOldAPI) {
                    if (an4 != null && an4.length > 0) {
                        List<char[]> ooazaAndChomeCharList = this.getAddressWordCharList(an4);
                        this.separateAreasAndBlockFromSingleLine(ooazaAndChomeCharList, null, parsedAddr, dataManager, options, FieldType.AREA_NAME_3_FIELD_TYPE, null);
                    }
                } else if (an4 != null && an4.length == 1) {
                    sr = this.searchFieldInData(an4[0].getWordChars(), FieldType.AREA_NAME_4_FIELD_TYPE, soundex, parser, dataManager, options, false);
                    this.addSearchFieldResult(FieldType.AREA_NAME_4_FIELD_TYPE, sr);
                }
                if (lot != null && lot.length > 0) {
                    sr = this.findAddressNumber(lot[0].getWordChars(), soundex, parser, dataManager, options);
                    this.addSearchFieldResult(FieldType.ADDRESS_NUMBER_FIELD_TYPE, sr);
                }
                if (blockAndLot != null && blockAndLot.length > 0) {
                    List<char[]> blockAndLotChars = this.getAddressWordCharList(blockAndLot);
                    if (lot == null) {
                        this.separateAreasAndBlockFromSingleLine(blockAndLotChars, null, parsedAddr, dataManager, options, FieldType.STREET_NAME_FIELD_TYPE, null);
                    } else {
                        JPNAbstractHelper.DictSearchResult sr2 = this.searchFieldInData(blockAndLot[0].getWordChars(), FieldType.STREET_NAME_FIELD_TYPE, soundex, parser, dataManager, options, false);
                        this.addSearchFieldResult(FieldType.STREET_NAME_FIELD_TYPE, sr2);
                    }
                }
                return true;
            }
            case 1: {
                ++this.m_tryCount;
                if (parsedAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE) != null) break;
                ParsedAddress savedParsedAddress = this.getSavedParsedAddress();
                AddressWord[] an2 = (AddressWord[])savedParsedAddress.getField(FieldType.AREA_NAME_2_FIELD_TYPE);
                AddressWord[] main = (AddressWord[])savedParsedAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
                AddressWord[] blockAndLot = null;
                blockAndLot = an2 != null && an2.length > 0 ? an2 : main;
                if (blockAndLot != null && blockAndLot != null && blockAndLot.length > 0) {
                    List<char[]> blockAndLotChars = this.getAddressWordCharList(blockAndLot);
                    this.separateAreasAndBlockFromSingleLine(blockAndLotChars, null, parsedAddr, dataManager, options, CHOME_FIELD, null);
                }
                return true;
            }
        }
        return false;
    }

    protected boolean generateCasesForSingleLine(IDataManager dataManager, ParsedAddress parsedAddr, GeocodeOptions options, InternalCandidateList candidateList) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        if (this.getSavedParsedAddress() == null) {
            ParsedAddress savedParsedAddress = new ParsedAddress(parsedAddr.getCountry(), parsedAddr.getLanguage());
            savedParsedAddress.copy(parsedAddr);
            this.setSavedParsedAddress(savedParsedAddress);
        }
        if (this.m_subTryList.size() > 0) {
            for (int size = this.getSearchResultStackSize(); size > this.m_previousSearchResultStackSize; --size) {
                this.restoreLastSearchResult();
            }
            if (this.generateSubTry(this.m_subTryList, parsedAddr, dataManager, options)) {
                return true;
            }
        }
        switch (this.m_tryCount) {
            case 0: {
                ++this.m_tryCount;
                AddressWord[] inputStreetWords = (AddressWord[])parsedAddr.getField(FieldType.STREET_NAME_FIELD_TYPE);
                inputStreetWords = this.findPCAreaAndRemoveProbablePcsFromWords(inputStreetWords, parsedAddr, dataManager, options);
                inputStreetWords = this.removeDelimiterWords(inputStreetWords);
                List<char[]> streetWordChars = this.getAddressWordCharList(inputStreetWords);
                this.setSingleLineInputList(streetWordChars);
                parsedAddr.setField(FieldType.STREET_NAME_FIELD_TYPE, null);
                if (streetWordChars != null) {
                    this.separateAreasAndBlockFromSingleLine(streetWordChars, parsedAddr, dataManager, options);
                    this.m_savedFormattedParsedAddress = new ParsedAddress(parsedAddr.getCountry(), parsedAddr.getLanguage());
                    this.m_savedFormattedParsedAddress.copy(parsedAddr);
                    this.saveDefaultSearchResult();
                    this.m_previousSearchResultStackSize = this.getSearchResultStackSize();
                    this.m_subTryList.add(1);
                    return true;
                }
                return false;
            }
            case 1: {
                ++this.m_tryCount;
                this.restoreDefaultSearchResult();
                boolean tryThisCase = this.generateCaseForIncorrectChomeBlockSplit(dataManager, options);
                if (tryThisCase) {
                    this.saveCurrentSearchResult();
                    this.m_previousSearchResultStackSize = this.getSearchResultStackSize();
                    this.m_subTryList.add(1);
                    return true;
                }
            }
            case 2: {
                ++this.m_tryCount;
                this.restoreDefaultSearchResult();
                boolean tryThisCase = this.generateCaseForIncorrectCityOoazaSplit(parsedAddr, dataManager, options);
                if (tryThisCase) {
                    this.saveCurrentSearchResult();
                    this.m_previousSearchResultStackSize = this.getSearchResultStackSize();
                    this.m_subTryList.add(1);
                    this.m_subTryList.add(2);
                    this.m_subTryList.add(5);
                    this.m_subTryList.add(8);
                    return true;
                }
            }
            case 3: {
                ++this.m_tryCount;
                this.restoreDefaultSearchResult();
                boolean tryThisCase = this.generateCaseForPartialCityName(parsedAddr, dataManager, options);
                if (tryThisCase) {
                    this.saveCurrentSearchResult();
                    this.m_previousSearchResultStackSize = this.getSearchResultStackSize();
                    this.m_subTryList.add(1);
                    return true;
                }
            }
            case 4: {
                ++this.m_tryCount;
                this.restoreDefaultSearchResult();
                boolean tryThisCase = this.generateCaseForIngoredChome(parsedAddr, dataManager, options);
                if (tryThisCase) {
                    this.saveCurrentSearchResult();
                    this.m_previousSearchResultStackSize = this.getSearchResultStackSize();
                    this.m_subTryList.add(1);
                    return true;
                }
            }
            case 5: {
                ++this.m_tryCount;
            }
            case 6: {
                ++this.m_tryCount;
                this.restoreDefaultSearchResult();
                boolean tryThisCase = this.generateCaseForIncorrectOoazaChomeSplit(parsedAddr, dataManager, options);
                if (tryThisCase) {
                    this.saveCurrentSearchResult();
                    this.m_previousSearchResultStackSize = this.getSearchResultStackSize();
                    this.m_subTryList.add(1);
                    this.m_subTryList.add(2);
                    this.m_subTryList.add(4);
                    this.m_subTryList.add(5);
                    this.m_subTryList.add(6);
                    return true;
                }
            }
            case 7: {
                ++this.m_tryCount;
                this.restoreDefaultSearchResult();
                boolean tryThisCase = this.generateSubOoazaCase(parsedAddr, dataManager, options);
                if (tryThisCase) {
                    this.saveCurrentSearchResult();
                    this.m_previousSearchResultStackSize = this.getSearchResultStackSize();
                    this.m_subTryList.add(1);
                    this.m_subTryList.add(2);
                    this.m_subTryList.add(4);
                    this.m_subTryList.add(5);
                    this.m_subTryList.add(6);
                    this.m_subTryList.add(9);
                    this.m_subTryList.add(10);
                    return true;
                }
                ++this.m_tryCount;
            }
            case 8: {
                ++this.m_tryCount;
                this.restoreDefaultSearchResult();
                boolean tryThisCase = this.generateCaseForFullySkippedOoaza(parsedAddr, dataManager, options);
                if (tryThisCase) {
                    this.saveCurrentSearchResult();
                    this.m_previousSearchResultStackSize = this.getSearchResultStackSize();
                    this.m_subTryList.add(1);
                    this.m_subTryList.add(2);
                    this.m_subTryList.add(4);
                    this.m_subTryList.add(5);
                    this.m_subTryList.add(6);
                    this.m_subTryList.add(10);
                    return true;
                }
                ++this.m_tryCount;
            }
            case 9: {
                ++this.m_tryCount;
                this.restoreDefaultSearchResult();
                boolean tryThisCase = this.generatePartialOoazaCases(parsedAddr, dataManager, options);
                if (!tryThisCase) break;
                this.saveCurrentSearchResult();
                this.m_previousSearchResultStackSize = this.getSearchResultStackSize();
                this.m_subTryList.add(1);
                this.m_subTryList.add(2);
                this.m_subTryList.add(4);
                this.m_subTryList.add(5);
                this.m_subTryList.add(6);
                this.m_subTryList.add(10);
                return true;
            }
        }
        return false;
    }

    private boolean generateSubTry(List<Integer> subTries, ParsedAddress parsedAddr, IDataManager dataManager, GeocodeOptions options) throws DataFetchException, CGGEInternalException, DataNotInitialisedException {
        int size;
        int n = size = subTries == null ? 0 : subTries.size();
        if (size > 0) {
            int tryCase = subTries.get(0);
            subTries.remove(0);
            switch (tryCase) {
                case 1: {
                    if (!this.generateCaseForChomeBlockSubstition(dataManager, options)) break;
                    return true;
                }
                case 2: {
                    if (!this.generateCaseForIncorrectChomeBlockSplit(dataManager, options)) break;
                    return true;
                }
                case 3: {
                    if (!this.generateCaseForIncorrectCityOoazaSplit(parsedAddr, dataManager, options)) break;
                    return true;
                }
                case 4: {
                    if (!this.generateCaseForPartialCityName(parsedAddr, dataManager, options)) break;
                    return true;
                }
                case 5: {
                    if (!this.generateCaseForIngoredChome(parsedAddr, dataManager, options)) break;
                    return true;
                }
                case 6: {
                    break;
                }
                case 7: {
                    if (!this.generateCaseForFullySkippedOoaza(parsedAddr, dataManager, options)) break;
                    return true;
                }
                case 8: {
                    if (!this.generateCaseForIncorrectOoazaChomeSplit(parsedAddr, dataManager, options)) break;
                    return true;
                }
                case 9: {
                    if (!this.generateSubOoazaCase(parsedAddr, dataManager, options)) break;
                    this.saveCurrentSearchResult();
                    this.m_previousSearchResultStackSize = this.getSearchResultStackSize();
                    this.m_subTryList.add(1);
                    this.m_subTryList.add(2);
                    this.m_subTryList.add(4);
                    this.m_subTryList.add(5);
                    this.m_subTryList.add(6);
                    this.m_subTryList.add(9);
                    this.m_subTryList.add(10);
                    return true;
                }
                case 10: {
                    if (!this.generatePartialOoazaCases(parsedAddr, dataManager, options)) break;
                    this.saveCurrentSearchResult();
                    this.m_previousSearchResultStackSize = this.getSearchResultStackSize();
                    this.m_subTryList.add(1);
                    this.m_subTryList.add(2);
                    this.m_subTryList.add(4);
                    this.m_subTryList.add(5);
                    this.m_subTryList.add(6);
                    this.m_subTryList.add(10);
                    return true;
                }
            }
            return this.generateSubTry(subTries, parsedAddr, dataManager, options);
        }
        return false;
    }
}

