/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.JPN.parser;

import com.mapinfo.mapmarker.JPN.utils.JapaneseNumerals;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.WordAlternate;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.parser.ICGGEParserTerms;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.cgge.soundex.ICGGESoundex;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;

public class JPNParser
extends CGGEParser1 {
    public static final int SINGLE_LINE_INPUT = 0x1000000;

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        ParsedAddress[] parsedAddresses = super.parse(inputAddress, scorer);
        if (parsedAddresses != null) {
            ParsedAddress parsedAddr = parsedAddresses[0];
            if (parsedAddr.isSeparateAreaFields()) {
                if (parsedAddr.getField(FieldType.AREA_NAME_1_FIELD_TYPE) == null && parsedAddr.getField(FieldType.AREA_NAME_2_FIELD_TYPE) == null && parsedAddr.getField(FieldType.AREA_NAME_3_FIELD_TYPE) == null && parsedAddr.getField(FieldType.AREA_NAME_4_FIELD_TYPE) == null) {
                    parsedAddr.setCustomFlag(0x1000000);
                }
            } else {
                parsedAddr.setCustomFlag(0x1000000);
            }
        }
        return parsedAddresses;
    }

    @Override
    protected String cleanString(String str) {
        if (str != null && str.length() > 0) {
            ICGGEParserTerms parserTerms = this.getParserTerms();
            StringBuilder sb = new StringBuilder(str.length());
            char[] chars = str.toCharArray();
            boolean lastWasDelimiter = false;
            for (int i = 0; i < chars.length; ++i) {
                char ch = chars[i];
                if (parserTerms.isDelimiter(ch)) {
                    if (lastWasDelimiter || this.isSpaceChar(ch) && i >= 1 && !JapaneseNumerals.isDigit(chars[i - 1]) && !MMUtils.isDigit(chars[i - 1]) && i != chars.length - 1 && !JapaneseNumerals.isDigit(chars[i + 1]) && !MMUtils.isDigit(chars[i + 1])) continue;
                    lastWasDelimiter = true;
                } else {
                    lastWasDelimiter = false;
                }
                sb.append(ch);
            }
            str = sb.toString();
        }
        return str;
    }

    private boolean isSpaceChar(char ch) {
        return Character.isWhitespace(ch) || ch == '\u3000';
    }

    @Override
    public AddressWord convertToAddressWord(String word, ICGGESoundex soundex) {
        AddressWord addrWord = super.convertToAddressWord(word, soundex);
        if (addrWord != null && JapaneseNumerals.isNumber(word)) {
            int n = JapaneseNumerals.toNumber(word);
            CodedWord altCodedWord = this.convertToCodedWord(Integer.toString(n), soundex);
            addrWord.addAlternate(new WordAlternate(new AddressWord(altCodedWord), WordAlternate.ALT_TYPE.SINGLE_WORD_ABBREVIATION));
        }
        return addrWord;
    }
}

