/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.JPN.utils;

import com.mapinfo.mapmarker.cgge.utils.CharArray;
import com.mapinfo.mapmarker.cgge.utils.MMUtils;
import java.util.Arrays;

public class JapaneseNumerals {
    private static final char[] charDigits = new char[]{'\u96f6', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d'};
    private static final char[] charTens = new char[]{'\u5341', '\u767e', '\u5343', '\u4e07'};
    private static final char[] charReplace = new char[]{'\u3007', '\u30cb', '\u306b', '\u62fe'};
    private static final char[] charReplacement = new char[]{'\u96f6', '\u4e8c', '\u4e8c', '\u5341'};
    private static final char[] allDigits = CharArray.addArrays(charDigits, charTens, charReplace);

    public static final int toNumber(String numeric) {
        return JapaneseNumerals.toNumber(numeric.toCharArray());
    }

    public static final int toNumber(char[] numeric) {
        if (JapaneseNumerals.isNumber(numeric)) {
            int len = numeric.length;
            int num = 0;
            int prevDigit = -1;
            int n1 = 0;
            for (int i = 0; i < len; ++i) {
                char ch = numeric[i];
                int digit = JapaneseNumerals.getDigit(ch);
                if (digit > 9) {
                    num = prevDigit > 0 ? (num += prevDigit * digit) : (num += digit);
                    prevDigit = -1;
                    n1 = 0;
                    continue;
                }
                if (prevDigit > -1) {
                    n1 *= 10;
                    n1 += prevDigit;
                }
                prevDigit = digit;
            }
            if (n1 > 0) {
                num += (n1 *= 10);
            }
            if (prevDigit > -1) {
                num += prevDigit;
            }
            return num;
        }
        throw new NumberFormatException("Not a number");
    }

    public static final String substituteJapaneseNumeral(char[] chars) {
        if (chars != null) {
            int len = chars.length;
            StringBuilder buf = new StringBuilder(len);
            boolean numberFound = false;
            for (int i = 0; i < len; ++i) {
                char ch = chars[i];
                if (JapaneseNumerals.isDigit(ch)) {
                    CharArray charArray = new CharArray(len - i);
                    charArray.add(ch);
                    numberFound = true;
                    ++i;
                    while (i < len) {
                        ch = chars[i];
                        if (!JapaneseNumerals.isDigit(ch)) {
                            --i;
                            break;
                        }
                        charArray.add(ch);
                        ++i;
                    }
                    int n = JapaneseNumerals.toNumber(charArray.asArray());
                    buf.append(n);
                    continue;
                }
                buf.append(ch);
            }
            if (numberFound) {
                return buf.toString();
            }
            return null;
        }
        return null;
    }

    public static final String substituteJapaneseNumeral(String str) {
        if (str != null) {
            return JapaneseNumerals.substituteJapaneseNumeral(str.toCharArray());
        }
        return str;
    }

    private static final int getDigit(char ch) {
        int i;
        for (i = 0; i < charReplace.length; ++i) {
            if (ch != charReplace[i]) continue;
            ch = charReplacement[i];
        }
        for (i = 0; i < charDigits.length; ++i) {
            if (ch != charDigits[i]) continue;
            return i;
        }
        for (i = 0; i < charTens.length; ++i) {
            if (ch == '\u62fe') {
                return 10;
            }
            if (ch != charTens[i]) continue;
            return (int)Math.pow(10.0, i + 1);
        }
        int d = Character.getNumericValue(ch);
        return d > 0 ? d : 0;
    }

    public static final boolean isNumber(char[] str) {
        int len;
        int n = len = str == null ? 0 : str.length;
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                if (JapaneseNumerals.isDigit(str[i])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final boolean isNumber(String n) {
        int len;
        int n2 = len = n == null ? 0 : n.length();
        if (len > 0) {
            for (int i = 0; i < len; ++i) {
                if (JapaneseNumerals.isDigit(n.charAt(i))) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static final boolean isKanjiDigit(char ch) {
        return Arrays.binarySearch(allDigits, ch) > -1;
    }

    public static final boolean isDigit(char ch) {
        return JapaneseNumerals.isKanjiDigit(ch) || Character.isDigit(ch);
    }

    public static final boolean containsNumericDigits(char[] chars) {
        for (char ch : chars) {
            if (!JapaneseNumerals.isDigit(ch)) continue;
            return true;
        }
        return false;
    }

    public static final String getStartingJapanesNumeral(String str) {
        int n = str == null ? 0 : str.length();
        int digitCount = 0;
        for (int i = 0; i < n && JapaneseNumerals.isDigit(str.charAt(i)); ++i) {
            ++digitCount;
        }
        if (digitCount > 0) {
            return "" + JapaneseNumerals.toNumber(str.substring(0, digitCount));
        }
        return null;
    }

    public static final String getStartingDigits(String str) {
        int n = str == null ? 0 : str.length();
        int digitCount = 0;
        for (int i = 0; i < n && Character.isDigit(str.charAt(i)); ++i) {
            ++digitCount;
        }
        if (digitCount > 0) {
            return "" + JapaneseNumerals.toNumber(str.substring(0, digitCount));
        }
        return null;
    }

    public static final String toJapanesNumerals(int num) {
        if (num > 999) {
            return null;
        }
        char[] digitChars = MMUtils.getDigits(num);
        int digitLen = digitChars.length;
        StringBuilder sb = new StringBuilder(5);
        if (digitLen == 1) {
            int digit = Character.digit(digitChars[0], 10);
            sb.insert(0, charDigits[digit]);
        } else {
            for (int i = 1; i <= digitLen; ++i) {
                int digitNdx = digitLen - i;
                int digit = Character.digit(digitChars[digitNdx], 10);
                if (digit == 0) {
                    if (digitLen != 1) continue;
                    sb.insert(0, charDigits[digit]);
                    continue;
                }
                if (i > 1) {
                    sb.insert(0, charTens[i - 2]);
                }
                if (digit <= 1 && digitNdx <= 0) continue;
                sb.insert(0, charDigits[digit]);
            }
        }
        return sb.toString();
    }

    static {
        Arrays.sort(allDigits);
    }
}

