/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.KOR.matcher;

import com.mapinfo.mapmarker.cgge.AddressNumberScore;
import com.mapinfo.mapmarker.cgge.FieldScore;
import com.mapinfo.mapmarker.cgge.MatchingOptions;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.InternalScoringRange;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.matcher.CGGEMatcher1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Map;

public class KOR_Matcher
extends CGGEMatcher1 {
    private static final String LANDLOT_CODE = "LANDLOT_CODE";
    private static final String HYPHEN = "-";

    @Override
    public void scoreRanges(InternalScoringAddress scoringAddr, ParsedAddress parsedAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        FieldScore streetScore = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        super.scoreRanges(scoringAddr, parsedAddr, matchingOptions, scorer);
        double streetCutOff = matchingOptions.getStreetFieldCutoff();
        InternalScoringRange range = scoringAddr.getRangeAt(0);
        if (streetScore != null) {
            if (range.isCloseMatch() && streetScore.m_value < streetCutOff) {
                this.promoteScore(streetScore);
            } else if (!range.isCloseMatch() && streetScore.m_value > streetCutOff) {
                this.demoteScore(streetScore);
            }
            scoringAddr.setFieldScore(FieldType.STREET_NAME_FIELD_TYPE, streetScore);
        }
    }

    @Override
    protected void scoreRangeAddressNumber(InternalScoringAddress scoringAddr, InternalScoringRange scoringRange, ParsedAddress pAddr, MatchingOptions matchingOptions, ICGGEScorer scorer) {
        super.scoreRangeAddressNumber(scoringAddr, scoringRange, pAddr, matchingOptions, scorer);
        FieldScore streetScore = scoringAddr.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        AddressNumberScore addrNum = (AddressNumberScore)scoringRange.getFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE);
        String landLotNumberInRange = this.getLandLotValueFromRange(scoringRange);
        if (!StringUtilities.isEmpty((String)landLotNumberInRange)) {
            double streetCutOff = matchingOptions.getStreetFieldCutoff();
            this.checkWhetherHouseNumberMatchesExactly(scoringRange, pAddr, streetScore, addrNum, landLotNumberInRange, streetCutOff);
        }
    }

    private void checkWhetherHouseNumberMatchesExactly(InternalScoringRange scoringRange, ParsedAddress pAddr, FieldScore streetScore, AddressNumberScore addrNum, String landLotNumberInRange, double streetCutOff) {
        if (addrNum != null && addrNum.isMatched() && streetScore.m_value > streetCutOff) {
            String houseNumberInRange = scoringRange.getFrom().toString();
            String houseNumberInParsedAddress = "";
            if (pAddr.getAddressNumber() != null) {
                houseNumberInParsedAddress = pAddr.getAddressNumber().toString();
            } else {
                String string = houseNumberInParsedAddress = pAddr.getProbableAddressNumbers() != null ? pAddr.getProbableAddressNumbers().get(0).toString() : "";
            }
            if (!(StringUtilities.isEmpty((String)houseNumberInRange) || StringUtilities.isEmpty((String)houseNumberInParsedAddress) || houseNumberInRange.equals(houseNumberInParsedAddress))) {
                addrNum.setMatched(false);
            }
        } else if (streetScore.m_value < streetCutOff) {
            if (addrNum == null) {
                addrNum = new AddressNumberScore();
            }
            addrNum.setMatched(false);
            String landLotInParsedAddress = this.addressWordArrayToString((AddressWord[])pAddr.getField(FieldType.GENERIC_FIELD_4_FIELD_TYPE));
            if (!StringUtilities.isEmpty((String)landLotInParsedAddress) && landLotInParsedAddress.equals(landLotNumberInRange)) {
                addrNum.setMatched(true);
            }
        }
        scoringRange.setFieldScore(FieldType.ADDRESS_NUMBER_FIELD_TYPE, addrNum != null ? addrNum : new AddressNumberScore());
    }

    private String getLandLotValueFromRange(InternalScoringRange scoringRange) {
        Map fields = scoringRange.getFields();
        String landLotNumberInRange = "";
        for (Map.Entry entry : fields.entrySet()) {
            FieldType type = entry.getKey();
            if (!LANDLOT_CODE.equalsIgnoreCase(type.getName())) continue;
            landLotNumberInRange = this.addressWordArrayToString((AddressWord[])((InternalFieldValue)scoringRange.getField(type)).getFieldValue());
            break;
        }
        return landLotNumberInRange;
    }

    @Override
    protected void adjustScores(InternalScoringAddress cand, ParsedAddress pAddr, MatchingOptions matchingOptions) {
        boolean adjustScores = true;
        double combinedStreetScore = cand.getCombinedStreetScore();
        FieldScore streetScore = cand.getFieldScore(FieldType.STREET_NAME_FIELD_TYPE);
        if (streetScore != null && streetScore.m_value == 1.0 && combinedStreetScore < 0.3) {
            adjustScores = false;
        }
        if (adjustScores) {
            super.adjustScores(cand, pAddr, matchingOptions);
        }
    }

    private String addressWordArrayToString(AddressWord[] wordArray) {
        String value;
        StringBuilder builder = new StringBuilder();
        if (wordArray != null && wordArray.length > 0) {
            if (wordArray.length > 1) {
                for (int i = 0; i < wordArray.length; ++i) {
                    if (HYPHEN.equals(wordArray[i].getWord())) continue;
                    builder.append(wordArray[i].getWord()).append(HYPHEN);
                }
            } else {
                builder.append(wordArray[0].getWord());
            }
        }
        if (!StringUtilities.isEmpty((String)(value = builder.toString())) && value.endsWith(HYPHEN)) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }

    private void promoteScore(FieldScore fs) {
        if (fs != null) {
            fs.m_value = 1.0;
        }
    }

    private void demoteScore(FieldScore fs) {
        if (fs != null) {
            fs.m_value = 0.01;
        }
    }
}

