/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.KOR.parser;

import com.mapinfo.mapmarker.cgge.address.AddressNumber;
import com.mapinfo.mapmarker.cgge.address.AddressWord;
import com.mapinfo.mapmarker.cgge.address.CodedWord;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InputAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.address.PostCode;
import com.mapinfo.mapmarker.cgge.parser.CGGEParser1;
import com.mapinfo.mapmarker.cgge.scorer.ICGGEScorer;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class KOR_Parser
extends CGGEParser1 {
    static Pattern postcodePattern = null;
    static Pattern subStreetPattern = null;
    private static final String HYPHEN = "-";

    @Override
    public ParsedAddress[] parse(InputAddress inputAddress, ICGGEScorer scorer) {
        String probablePostCode = this.findProbablePostcode(inputAddress);
        ParsedAddress[] parsedAddresses = super.parse(inputAddress, scorer);
        this.cleanseProbablePostCodeNumbers(parsedAddresses[0], probablePostCode);
        this.cleanseProbableAddressNumbers(parsedAddresses[0], probablePostCode);
        List<AddressNumber> probableAddressNumbers = parsedAddresses[0].getProbableAddressNumbers();
        if (null != probableAddressNumbers && probableAddressNumbers.size() > 0) {
            parsedAddresses[0].setField(FieldType.GENERIC_FIELD_4_FIELD_TYPE, this.getAddressWordForLandLot(probableAddressNumbers.get(0).toString()));
        }
        return parsedAddresses;
    }

    @Override
    public AddressWord[] splitIntoWeightedWords(String str, FieldType type) {
        if (type != null && "LANDLOT_CODE".equalsIgnoreCase(type.getName()) && !StringUtilities.isEmpty((String)str)) {
            return this.getAddressWordForLandLot(str, type);
        }
        return super.splitIntoWeightedWords(str, type);
    }

    private AddressWord[] getAddressWordForLandLot(String landLot, FieldType type) {
        ArrayList<AddressWord> retWords = new ArrayList<AddressWord>(1);
        CodedWord landLotCodedWord = this.convertToCodedWord(landLot, this.getSoundex());
        AddressWord landLotAddressWord = new AddressWord(landLotCodedWord);
        if (type != null) {
            landLotAddressWord.m_wordType = type;
            landLotAddressWord.m_weight = (byte)100;
        }
        retWords.add(landLotAddressWord);
        return retWords.toArray(new AddressWord[retWords.size()]);
    }

    private AddressWord[] getAddressWordForLandLot(String landLot) {
        return this.getAddressWordForLandLot(landLot, null);
    }

    private String findProbablePostcode(InputAddress inputAddress) {
        boolean isSingleline = false;
        String probablePostCode = null;
        String postcodeStr = null;
        if (null != inputAddress.getField(FieldType.POST_CODE_FIELD_TYPE)) {
            inputAddress.setField(FieldType.POST_CODE_FIELD_TYPE, ((String)inputAddress.getField(FieldType.POST_CODE_FIELD_TYPE)).replace(HYPHEN, ""));
            return null;
        }
        if (null != inputAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE)) {
            postcodeStr = (String)inputAddress.getField(FieldType.POST_ADDRESS_FIELD_TYPE);
        } else if (null != inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE)) {
            postcodeStr = (String)inputAddress.getField(FieldType.STREET_NAME_FIELD_TYPE);
            isSingleline = true;
        }
        if (postcodeStr != null && postcodeStr.trim().length() > 0) {
            String[] postcodeStrTokens = postcodeStr.split("[\\s;]+");
            int arrayLength = postcodeStrTokens.length;
            int midPos = arrayLength % 2 == 0 ? arrayLength / 2 : arrayLength / 2 + 1;
            for (int j = arrayLength - 1; j >= midPos - 1; --j) {
                Matcher postcodeStrMatcher = postcodePattern.matcher(postcodeStrTokens[j]);
                if (!postcodeStrMatcher.find()) continue;
                probablePostCode = postcodeStrTokens[j].replace(HYPHEN, "");
                postcodeStr = postcodeStr.replace(postcodeStrTokens[j], probablePostCode);
                if (isSingleline) {
                    inputAddress.setField(FieldType.STREET_NAME_FIELD_TYPE, postcodeStr);
                    break;
                }
                inputAddress.setField(FieldType.POST_ADDRESS_FIELD_TYPE, postcodeStr);
                break;
            }
        }
        return probablePostCode;
    }

    private void cleanseProbablePostCodeNumbers(ParsedAddress parsedAddress, String probablePostCode) {
        List<PostCode> probablePostCodeNumbers = parsedAddress.getProbablePostcodes();
        if (probablePostCodeNumbers == null || probablePostCodeNumbers.size() == 0) {
            return;
        }
        ArrayList<PostCode> tempProbablePostCodeNumbers = new ArrayList<PostCode>();
        if (!StringUtilities.isEmpty((String)probablePostCode)) {
            for (PostCode probablePostCodeNumber : probablePostCodeNumbers) {
                if (!probablePostCodeNumber.toString().replaceAll(" ", "").equals(probablePostCode)) continue;
                tempProbablePostCodeNumbers.add(probablePostCodeNumber);
            }
            if (tempProbablePostCodeNumbers.size() > 0) {
                parsedAddress.setProbablePostcodes(tempProbablePostCodeNumbers);
            }
        } else {
            parsedAddress.setProbablePostcodes(null);
        }
    }

    private void cleanseProbableAddressNumbers(ParsedAddress parsedAddress, String probablePostCode) {
        List<AddressNumber> probableAddressNumbers = parsedAddress.getProbableAddressNumbers();
        if (probableAddressNumbers == null || probableAddressNumbers.size() == 0) {
            return;
        }
        this.removePostCodeFromProbableAddressNumber(parsedAddress, probablePostCode, probableAddressNumbers);
        probableAddressNumbers = parsedAddress.getProbableAddressNumbers();
        this.removeNumericStreetFromProbableAddressNumber(parsedAddress, probableAddressNumbers);
        probableAddressNumbers = parsedAddress.getProbableAddressNumbers();
        if (probableAddressNumbers.size() == 0) {
            return;
        }
        this.keepHyphenatedAndNonBlankNumbersOnly(parsedAddress, probableAddressNumbers);
    }

    private void keepHyphenatedAndNonBlankNumbersOnly(ParsedAddress parsedAddress, List<AddressNumber> probableAddressNumbers) {
        ArrayList<AddressNumber> hyphenatedProbableAddressNumbers = new ArrayList<AddressNumber>();
        ArrayList<AddressNumber> nonBlankProbableAddressNumbers = new ArrayList<AddressNumber>();
        boolean hyphenatedNumberFound = false;
        for (AddressNumber addressNumber : probableAddressNumbers) {
            if (addressNumber.toString().contains(HYPHEN)) {
                if (addressNumber.toString().startsWith(HYPHEN)) continue;
                hyphenatedNumberFound = true;
                hyphenatedProbableAddressNumbers.add(addressNumber);
                continue;
            }
            if (StringUtilities.isEmpty((String)addressNumber.toString())) continue;
            nonBlankProbableAddressNumbers.add(addressNumber);
        }
        if (hyphenatedNumberFound) {
            parsedAddress.setProbableAddressNumbers(hyphenatedProbableAddressNumbers);
        } else if (nonBlankProbableAddressNumbers.size() < 2) {
            parsedAddress.setProbableAddressNumbers(nonBlankProbableAddressNumbers);
        } else {
            parsedAddress.setProbableAddressNumbers(null);
        }
    }

    private void removeNumericStreetFromProbableAddressNumber(ParsedAddress parsedAddress, List<AddressNumber> probableAddressNumbers) {
        ArrayList<AddressNumber> streetNumProbableAddressNumbers = new ArrayList<AddressNumber>();
        String street = (String)parsedAddress.getInputAddress().getField(FieldType.STREET_NAME_FIELD_TYPE);
        Matcher subStreetMatcher = subStreetPattern.matcher(street);
        if (subStreetMatcher.find()) {
            String found = subStreetMatcher.group(1);
            String[] founds = null;
            boolean floatingNoInStreet = false;
            if (found.contains(".")) {
                founds = found.split("\\.");
                floatingNoInStreet = true;
            }
            for (AddressNumber addressNumber : probableAddressNumbers) {
                if (!floatingNoInStreet) {
                    if (addressNumber.toString().equals(found)) continue;
                    streetNumProbableAddressNumbers.add(addressNumber);
                    continue;
                }
                boolean toAdd = true;
                if (addressNumber.toString().equals(founds[0]) || addressNumber.toString().equals(founds[1])) {
                    toAdd = false;
                }
                if (!toAdd) continue;
                streetNumProbableAddressNumbers.add(addressNumber);
            }
            parsedAddress.setProbableAddressNumbers(streetNumProbableAddressNumbers);
        }
    }

    private void removePostCodeFromProbableAddressNumber(ParsedAddress parsedAddress, String probablePostCode, List<AddressNumber> probableAddressNumbers) {
        ArrayList<AddressNumber> nonProbablePostCodeNumber = new ArrayList<AddressNumber>();
        if (null != probablePostCode) {
            for (AddressNumber addressNumber : probableAddressNumbers) {
                if (addressNumber.toString().replaceAll(" ", "").equals(probablePostCode)) continue;
                nonProbablePostCodeNumber.add(addressNumber);
            }
            parsedAddress.setProbableAddressNumbers(nonProbablePostCodeNumber);
        }
    }

    static {
        postcodePattern = Pattern.compile("\\b(\\d{4,6}|\\d{3}-\\d{3})\\b");
        subStreetPattern = Pattern.compile("(\\d{1,4}(.\\d{1,2})?)-?(ro|gil)", 2);
    }
}

