/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.MYS.dp.binary;

import com.mapinfo.mapmarker.cgge.address.AddressFieldValue;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.RawAddress;
import com.mapinfo.mapmarker.cgge.dp.builder.reader.jdbc.oracle.Oracle_Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class MYS_OracleReader
extends Oracle_Reader {
    public static final String SG_DATASET_NAME = "SG";
    public static final String POI_DATATSET_NAME = "POI";
    public static final String STREET_DATASET_NAME = "Street";
    public static final String AP_DATASET_NAME = "AP";
    public static final String GEO_DATASET_NAME = "Geo";
    private Map<String, String> m_sacMap = new HashMap<String, String>(1000);
    private int m_nextSAC = 1000;
    private boolean m_overrideSAC = false;
    private boolean m_isGeoTable = false;

    @Override
    public RawAddress getNextRecord() {
        RawAddress addr = super.getNextRecord();
        if (this.m_overrideSAC && addr != null) {
            addr.setSac(this.buildSAC(addr));
        }
        return addr;
    }

    @Override
    public boolean isSacFromFile() {
        if (this.m_overrideSAC) {
            return true;
        }
        return super.isSacFromFile();
    }

    @Override
    public boolean loadData(Properties prop) throws Exception {
        if (super.loadData(prop)) {
            if (AP_DATASET_NAME.equalsIgnoreCase((String)prop.get("dataName"))) {
                this.m_overrideSAC = true;
            }
            return true;
        }
        return false;
    }

    private String buildSAC(RawAddress addr) {
        String sacString = this.buildSACString(addr);
        String sac = this.m_sacMap.get(sacString);
        if (sac == null) {
            sac = "" + new Integer(++this.m_nextSAC);
            this.m_sacMap.put(sacString, sac);
        }
        return sac;
    }

    private String buildSACString(RawAddress addr) {
        StringBuilder sb = new StringBuilder(20);
        String pc = this.getFieldValue(addr, FieldType.POST_CODE_FIELD_TYPE);
        sb.append(pc);
        sb.append(this.getFieldValue(addr, FieldType.GENERIC_FIELD_1_FIELD_TYPE));
        return sb.toString();
    }

    private String getFieldValue(RawAddress addr, FieldType type) {
        String fvStr;
        AddressFieldValue fv = (AddressFieldValue)addr.getField(type);
        String v = "";
        if (fv != null && !fv.isEmpty() && (fvStr = (String)fv.getFieldValue()) != null) {
            v = fvStr;
        }
        return v;
    }
}

