/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.NLD;

import com.mapinfo.mapmarker.cgge.CGGECandidateFilter;
import com.mapinfo.mapmarker.cgge.CGGEInternalException;
import com.mapinfo.mapmarker.cgge.CGGERuntimeException;
import com.mapinfo.mapmarker.cgge.GeocodeOptions;
import com.mapinfo.mapmarker.cgge.address.FieldType;
import com.mapinfo.mapmarker.cgge.address.InternalFieldValue;
import com.mapinfo.mapmarker.cgge.address.InternalScoringAddress;
import com.mapinfo.mapmarker.cgge.address.ParsedAddress;
import com.mapinfo.mapmarker.cgge.dp.InternalCandidateList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;

public class NLD_CandidateFilter
extends CGGECandidateFilter {
    @Override
    public void filterCandidates(InternalCandidateList candList, ParsedAddress addr, GeocodeOptions options) throws CGGERuntimeException, CGGEInternalException {
        super.filterCandidates(candList, addr, options);
        this.filterDuplicateCandidates(candList);
    }

    private void filterDuplicateCandidates(InternalCandidateList candList) {
        int closeMatchCount;
        int candCount = candList == null ? 0 : candList.getCandidateCount();
        int n = closeMatchCount = candList == null ? 0 : candList.getNumberOfCloseMatches();
        if (candCount > 0) {
            Iterator<InternalScoringAddress> candidateListIterator = candList.getCandidateList().iterator();
            InternalScoringAddress bestCandiateScoringAddr = candidateListIterator.next();
            Map<FieldType, InternalFieldValue> bestCandiadateScoringFieldsMap = bestCandiateScoringAddr.getInternalAddress().getFields();
            while (candidateListIterator.hasNext()) {
                InternalScoringAddress otherCandiateScoringAddr = candidateListIterator.next();
                if (!this.shouldRemoveCandidate(bestCandiadateScoringFieldsMap, otherCandiateScoringAddr.getInternalAddress().getFields())) continue;
                candidateListIterator.remove();
                if (!otherCandiateScoringAddr.isCloseMatch()) continue;
                --closeMatchCount;
            }
            candList.setNumberOfCloseMatches(closeMatchCount);
        }
    }

    private boolean shouldRemoveCandidate(Map<FieldType, InternalFieldValue> bestCandiadateScoringFieldsMap, Map<FieldType, InternalFieldValue> otherCandiadateScoringFieldsMap) {
        boolean canRemoveCandidate = true;
        for (FieldType temp : bestCandiadateScoringFieldsMap.keySet()) {
            InternalFieldValue otherCandFieldValue;
            InternalFieldValue bestCandFieldValue = bestCandiadateScoringFieldsMap.get(temp);
            if (this.compareFieldValues(bestCandFieldValue, otherCandFieldValue = otherCandiadateScoringFieldsMap.get(temp))) continue;
            canRemoveCandidate = false;
            break;
        }
        return canRemoveCandidate;
    }

    private boolean compareFieldValues(InternalFieldValue value1, InternalFieldValue value2) {
        if (value1 != null && value2 != null) {
            if (value1.getFieldValue() == null && value2.getFieldValue() != null) {
                return false;
            }
            if (value1.getFieldValue() != null && value2.getFieldValue() == null) {
                return false;
            }
            if (value1.getFieldValue() != null && value2.getFieldValue() != null) {
                return Arrays.equals((Object[])value1.getFieldValue(), (Object[])value2.getFieldValue());
            }
        }
        return false;
    }
}

